<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.VideoSearchMessages">
	<!-- Modal -->
	<div id="myModal" class="modal fade modal-margin" role="dialog">
		<div class="modal-dialog">

			<!-- Modal content-->
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal">&times;</button>
					<h4 class="modal-title">
						<fmt:message key="Upload_Modal_Header" />
					</h4>
				</div>
				<div class="modal-body">
					<div id="actions" class="row">

						<div class="col-lg-12">
							<!-- The fileinput-button span is used to style the file input field as button -->
							<span class="btn btn-success fileinput-button"> <i
								class="glyphicon glyphicon-plus"></i> <span>Add files...</span>
							</span>
							<button type="submit" class="btn btn-primary start">
								<i class="glyphicon glyphicon-upload"></i> <span>Start
									upload</span>
							</button>
							<button type="reset" class="btn btn-warning cancel">
								<i class="glyphicon glyphicon-ban-circle"></i> <span>Cancel
									upload</span>
							</button>
						</div>

						<div class="col-lg-12 hidden">
							<!-- The global file processing state -->
							<span class="fileupload-process">
								<div id="total-progress"
									class="progress progress-striped active" role="progressbar"
									aria-valuemin="0" aria-valuemax="100" aria-valuenow="0">
									<div class="progress-bar progress-bar-success"
										style="width: 0%;" data-dz-uploadprogress></div>
								</div>
							</span>
						</div>

					</div>


					<div class="dropzone-table table-striped" class="files"
						id="previews">

						<div id="template" class="file-row">
							<!-- This is used as the file preview template -->
							<div>
								<span class="preview"><img data-dz-thumbnail /></span>
								<div>
									<p class="name" data-dz-name></p>
								</div>
							</div>

							<div>
								<p class="size" data-dz-size></p>
								<div class="progress progress-striped active" role="progressbar"
									aria-valuemin="0" aria-valuemax="100" aria-valuenow="0">
									<div class="progress-bar progress-bar-success"
										style="width: 0%;" data-dz-uploadprogress></div>
								</div>
								<strong class="error text-danger" data-dz-errormessage></strong>
							</div>
							<div>
								<button class="btn btn-primary btn-margin-top start">
									<i class="glyphicon glyphicon-upload"></i> <span>Start</span>
								</button>
								<button data-dz-remove
									class="btn btn-warning btn-margin-top cancel">
									<i class="glyphicon glyphicon-ban-circle"></i> <span>Cancel</span>
								</button>
							</div>
						</div>

					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
				</div>
			</div>

		</div>
	</div>
	<script nonce="${sessionScope.cspNonce}" src="videosearch/thirdparty/js/dropzone.js"></script>
	<script nonce="${sessionScope.cspNonce}" src="videosearch/js/dropzone.js"></script>
</fmt:bundle>