<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>

<fmt:bundle basename="localization.VideoSearchMessages">
	<fmt:message key="Video_Search_Head" var="Video_Search_Head"
		scope="request" />
	<jsp:include page="../common/header.jsp">
		<jsp:param value="true" name="includeJqueryUI" />
		<jsp:param value="true" name="includeHistory" />
		<jsp:param value="true" name="bootstrapped" />
		<jsp:param value="../common/css/headerstyles.css" name="css" />
		<jsp:param value="false" name="includeSecHeader" />
		<jsp:param value="${Video_Search_Head}" name="titleLocalized" />
	</jsp:include>
	<link rel="stylesheet"
		href="./videosearch/css/searchStyles.css?${applicationScope.BUILD_TS}" />
	<script nonce="${sessionScope.cspNonce}" >
		var vsearch = {};
		var videoSearchDataSource = "${requestScope.videoSearchDataSource}";
		if (videoSearchDataSource!=null)
			vsearch.videoSearchDataSource = videoSearchDataSource;
		var videoSearchEmailTo = "${requestScope.videoSearchEmailTo}";
		if (videoSearchEmailTo!=null)
			vsearch.videoSearchEmailTo = videoSearchEmailTo;
	</script>
	<jsp:include page="./localization.jsp" />
	<div class="intro-header">
		<div class="row">
			<div class="col-lg-12">
				<div class="search_promo">
					<div class="input-group">
						<input id="videoSearchInput" type="text" class="form-control"
							placeholder="<fmt:message key='Search_Placeholder'/>">

						<div class="input-group-btn btn_promo_search" id="videoSearchSubmitButton">
							<button type="button" class="btn btn-primary">
								<span class="glyphicon glyphicon-search"></span>
							</button>
						</div>
					</div>
				</div>
				<hgroup class="mb20 search-result-header">
					<h2><fmt:message key='SearchResults'/></h2>
					<a href="./videosearch.do" class="btn pull-right btn-primary btn-sm"><span class="glyphicon glyphicon-home"></span> </a>
					<button type="button" class="btn send-email pull-right btn-warning btn-sm"><span class="glyphicon glyphicon-envelope"></span> <fmt:message key='ContactUs'/></button>
					<h3 class="lead">
						<strong class="text-danger num-results-found"></strong> <fmt:message key='Videos_Found_Text'/> <strong
							class="text-danger video-search-query"></strong>
					</h3>
				</hgroup>

				<section class="col-xs-12 col-sm-12 col-md-12" id="videoSearchResults">
					
				</section>
			</div>
		</div>
		<!-- Modal -->
	<div id="myModal" class="modal fade modal-margin" role="dialog">
	  <div class="modal-dialog">

		<!-- Modal content-->
		<div class="modal-content">
		  <div class="modal-header">
			<button type="button" class="close" data-dismiss="modal">&times;</button>
			<h4 class="modal-title">Video</h4>
		  </div>
		  <div class="modal-body">
			<video width="100%" height="100%" id="modalVideo" src="" controls  preload="none" poster="./videosearch/images/video_poster.jpg" onclick="this.play();">
					<fmt:message key='VideoNotSupported'/>
			</video>
		  </div>
		</div>

	  </div>
	</div>
	</div>
	<div class="search-result-template" id="searchResultsTemplate">
		<article class="search-result row">
			<div class="col-xs-12 col-sm-4 col-md-3 border-right">
				<video width="100%" height="100%" controls preload="none" poster="./videosearch/images/video_poster.jpg" onclick="this.play();">
					<source src="" type="video/mp4">
					<fmt:message key='VideoNotSupported'/>
				</video>
				<p class="video-name"></p>
			</div>
			<div class="col-xs-12 col-sm-8 col-md-9">
				<ul class="search-result-item">
					
				</ul>
			</div>
		</article>
		<hr>
	</div>
	<script nonce="${sessionScope.cspNonce}" src="./videosearch/js/vsearch.js"></script>
	<script nonce="${sessionScope.cspNonce}" src="./videosearch/js/vsearchConfig.js"></script>
	<script nonce="${sessionScope.cspNonce}" src="./videosearch/js/services.js"></script>
</fmt:bundle>
<jsp:include page="../common/footer.jsp">
	<jsp:param value="true" name="bootstrapped" />
</jsp:include>