<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>

<fmt:bundle basename="localization.VideoSearchMessages">
	<fmt:message key="Video_Search_Head" var="Video_Search_Head" scope="request" />
	<jsp:include page="../common/header.jsp">
		<jsp:param value="true" name="includeJqueryUI" />
		<jsp:param value="true" name="includeHistory" />
		<jsp:param value="true" name="bootstrapped" />
		<jsp:param value="../common/css/headerstyles.css" name="css" />
		<jsp:param value="false" name="includeSecHeader" />
		<jsp:param value="${Video_Search_Head}" name="titleLocalized" />
	</jsp:include>
	<link rel="stylesheet"
		href="videosearch/css/appstyles.css?${applicationScope.BUILD_TS}" />
	<script nonce="${sessionScope.cspNonce}" >
		var vsearch = {};
		var videoSearchSuggestions = "${requestScope.videoSearchSuggestions}";
		if (videoSearchSuggestions!=null)
			vsearch.videoSearchSuggestions = videoSearchSuggestions;
	</script>
	<jsp:include page="./localization.jsp" />
	<div class="intro-header">
            <div class="row">
                <div class="col-lg-12">
                    <div class="intro-message">
                        <h1><fmt:message key="Video_Search_Head" /></h1>
                        <h3><fmt:message key="Video_Search_Text" /></h3>
                        <hr class="intro-divider">
						<div class="search_promo">
							<div class="input-group">
								<input type="text" id="videoSearchInput" class="form-control"
									placeholder="<fmt:message key='Search_Placeholder'/>">
								<%-- <c:if test="${requestScope.disableVideoSearchDemo}">
									<span class="input-group-addon background-white cursor-pointer" data-toggle="modal" data-target="#myModal">
										<i class="sprite icon-upload"></i>
							</span>
								</c:if> --%>
							<div class="input-group-btn btn_promo_search" id="videoSearchSubmitButton">
									<button type="button" class="btn btn-primary">
										<span class="glyphicon glyphicon-search"></span>
									</button>
								</div>
							</div>
						</div>
					</div>
                </div>
            </div>
    </div>
    <script nonce="${sessionScope.cspNonce}" src="videosearch/js/vsearchConfig.js"></script>
    <script nonce="${sessionScope.cspNonce}" src="videosearch/js/vsearchhome.js"></script>
</fmt:bundle>
<jsp:include page="../common/footer.jsp">
	<jsp:param value="true" name="bootstrapped" />
</jsp:include>
<jsp:include page="./uploadModal.jsp" />