/**
 * Factory responsible for holiday related operations
 */
(function() {
	'use strict';
	app
			.factory('timesheetServices',
					[
							"Utils",
							"employeeServices",
							"$filter",
							"i8nConstants",
							"holidayService",
							"TIMESHEET_CONSTANTS",
							"timeCalculationServices",
							function(Utils, employeeServices, $filter, i8nConstants, holidayService,
									TIMESHEET_CONSTANTS, timeCalculationServices) {

								//grey out the holidays
								var allRegionBasedHolidays = holidayService.getRegionSortedHolidays();
								var regionHolidays = {};
								var timeoff = {};

								function isHoliday(date) {
									date = new Date(date).setHours(0, 0, 0, 0);
									if (regionHolidays) {
										for (var i = 0; i < regionHolidays.length; i++) {
											regionHolidays[i].startDate = new Date(regionHolidays[i].startDate)
													.setHours(0, 0, 0, 0);
											regionHolidays[i].endDate = new Date(regionHolidays[i].endDate).setHours(0,
													0,
													0,
													0);

											if ((new Date(regionHolidays[i].startDate).getTime() <= new Date(date)
													.getTime()) &&
													(new Date(regionHolidays[i].endDate).getTime() >= new Date(date)
															.getTime())) {
												return true;
											}
										}
									}
									return false;
								}

								function isTimeoffDay(date) {
									date = new Date(date).setHours(0, 0, 0, 0);
									if (timeoff) {
										for (var i = 0; i < timeoff.length; i++) {
											timeoff[i].dateStart = new Date(timeoff[i].dateStart).setHours(0, 0, 0, 0);
											timeoff[i].dateEnd = new Date(timeoff[i].dateEnd).setHours(0, 0, 0, 0);

											if ((new Date(timeoff[i].dateStart).getTime() <= new Date(date).getTime()) &&
													(new Date(timeoff[i].dateEnd).getTime() >= new Date(date).getTime()) &&
													(timeoff[i].sRequestStatus !== "Cancelled") &&
													(timeoff[i].sRequestStatus !== "Rejected")) {
												return true;
											}
										}
									}
									return false;
								}

								function createNewTimesheet(timesheet, params) {
									timesheet = {
										"data" : [],
										"overtimeHours" : 0,
										"totalHours" : 0,
										"sAction" : [],
										"regularHours" : 0,
										"doubleOvertimeHours" : 0,
										"weekStart" : params.weekStart,
										"weekEnd" : params.weekEnd,
										"submitFlag" : false,
										"sComments" : "",
										"sRequestStatus" : "",
										"isSubmitted" : false,
										"disableSubmitUntilSaved" : true,
										"sickDayList" : [ 0, 0, 0, 0, 0, 0, 0 ],
										"sickDays" : 0
									};

									timesheet.data = [];

									//timesheet day wise details
									var nextDate = new Date(params.weekStart);
									var endDate = new Date(params.weekEnd);
									while (nextDate <= endDate) {
										var date = new Date(nextDate.setHours(0, 0, 0, 0));
										timesheet.data.push({
											date : date,
											breakTime : 0,
											NoOfHours : 0,
											startTime : 0,
											endTime : 0,
										});
										nextDate = new Date(nextDate.setDate(nextDate.getDate() + 1));

									}
									return timesheet;
								}

								function getTimesheetDetails(response, data, statusDetails, regionName) {
									timeoff = {};
									regionHolidays = {};
									regionHolidays = allRegionBasedHolidays[regionName];
									var timesheet = null;
									var id = null;
									var submitFlag = null;
									if (response) {
										if (response.Timeoff) {
											if (response.Timeoff[0].timeOffs) {
												timeoff = response.Timeoff[0].timeOffs;
											}
										}
										if (response.data) {
											//if timesheet present, find the latest submitted record.
											timesheet = {};
											var latestRecordPos = 0;
											var latestSubmittedDate = new Date(new Date(response.data[0].submittedOn)
													.setHours(0, 0, 0, 0));
											for (var k = 1; k < response.data.length; k += 1) {
												response.data[k].submittedOn = new Date(new Date(
														response.data[k].submittedOn).setHours(0, 0, 0, 0));
												if (latestSubmittedDate.getTime() < response.data[k].submittedOn
														.getTime()) {
													latestSubmittedDate = response.data[k].submittedOn;
													latestRecordPos = k;
												}
											}
											timesheet = response.data[latestRecordPos];
											timesheet.totalHours = timesheet.regularHours + timesheet.overtimeHours +
													timesheet.doubleOvertimeHours;

											if (timesheet.sRequestStatus === "Saved") {
												timesheet.disableSubmitUntilSaved = false;
											} else if ((timesheet.sRequestStatus === "Approved") ||
													(timesheet.sRequestStatus === "Submitted") ||
													(timesheet.sRequestStatus === "Submitted to Payroll")) {
												timesheet.isSubmitted = true;
											} else if (timesheet.sRequestStatus === "Cancelled") {
												id = timesheet.nID;
												submitFlag = timesheet.submitFlag;
											}
										}
									}
									if (!timesheet || (timesheet.sRequestStatus === "Cancelled")) {
										timesheet = createNewTimesheet(timesheet, data);
										if (id) {
											timesheet.nID = id;
											timesheet.submitFlag = submitFlag;
										}
									}
									processTimesheetData(timesheet, data, statusDetails);
									return timesheet;
								}

								function processTimesheetData(timesheet, params, statusDetails) {
									timesheet.sickDayList = [ 0, 0, 0, 0, 0, 0, 0 ];
									let k = 6;
									while (timesheet.sickDays > 0) {
										timesheet.sickDayList[k] = timesheet.sickDays & 1;
										timesheet.sickDays = timesheet.sickDays >> 1;
										k--;
									}
									var weekDays = [
											"Sunday",
											"Monday",
											"Tuesday",
											"Wednesday",
											"Thursday",
											"Friday",
											"Saturday" ];

									timesheet.weekStart = new Date(params.weekStart);
									timesheet.weekEnd = new Date(params.weekEnd);
									timesheet.week = $filter('date')(timesheet.weekStart, "dd-MMM-yyyy") + " " +
											i8nConstants.to + " " + $filter('date')(timesheet.weekEnd, "dd-MMM-yyyy");

									for (var i = 0; i < timesheet.data.length; i++) {
										timesheet.data[i].date = new Date(new Date(timesheet.data[i].date).setHours(0,
												0,
												0,
												0));
										timesheet.data[i].day = weekDays[new Date(timesheet.data[i].date).getDay()];
										timesheet.data[i].color = TIMESHEET_CONSTANTS.DEFAULT_COLOR;
										timesheet.data[i].selectColor = TIMESHEET_CONSTANTS.DEFAULT_COLOR;
										timesheet.data[i].cursor = TIMESHEET_CONSTANTS.CURSOR_DEFAULT;
										timesheet.data[i].disable = false;
										timesheet.data[i].showCheckbox = false;
										timesheet.data[i].checkboxValue = false;
										timesheet.data[i].sickDay = false;
										timesheet.data[i].disableChkbx = false;
										timesheet.data[i].dayName = "Working Day";
										timesheet.data[i].isOffDay = false;
										timesheet.data[i].invalidTime = false;

										var isNotAuthorizedDate = false;
										if (statusDetails.isAuthorized === false) {
											if (statusDetails.status) {
												if (statusDetails.status.dateOfChange) {
													statusDetails.status.dateOfChange = new Date(new Date(
															statusDetails.status.dateOfChange).setHours(0, 0, 0, 0));

													if ((timesheet.data[i].date).getTime() >= (statusDetails.status.dateOfChange)
															.getTime()) {
														isNotAuthorizedDate = true;
													}
												}
											}
										}

										if ((timesheet.data[i].date > new Date()) || (isNotAuthorizedDate === true) ||
												(timesheet.sRequestStatus === "Approved") ||
												(timesheet.sRequestStatus === "Submitted") ||
												(timesheet.sRequestStatus === "Submitted to Payroll")) {
											timesheet.data[i].disableChkbx = true;
											timesheet.data[i].disable = true;
											timesheet.data[i].selectColor = TIMESHEET_CONSTANTS.DISABLED_COLOR;
											timesheet.data[i].cursor = TIMESHEET_CONSTANTS.CURSOR_DISABLED;
										}
										if ((isHoliday(timesheet.data[i].date)) ||
												(isTimeoffDay(timesheet.data[i].date))) {
											timesheet.data[i].isOffDay = true;
											timesheet.data[i].disable = true;
											timesheet.data[i].showCheckbox = true;
											timesheet.data[i].checkboxValue = false;
											timesheet.data[i].sickDay = false;
											timesheet.data[i].color = TIMESHEET_CONSTANTS.DISABLED_COLOR;
											timesheet.data[i].selectColor = TIMESHEET_CONSTANTS.DISABLED_COLOR;
											timesheet.data[i].cursor = TIMESHEET_CONSTANTS.CURSOR_DISABLED;
											timesheet.data[i].dayName = "Holiday";
										}

										if (isTimeoffDay(timesheet.data[i].date)) {
											timesheet.data[i].dayName = "Timeoff Day";
										}

										//calcuate hrs from minutes
										timesheet.data[i].startHour = parseInt(timesheet.data[i].startTime / 60)
												.toString();
										timesheet.data[i].startMinute = (timesheet.data[i].startTime - parseInt(timesheet.data[i].startHour) * 60)
												.toString();
										timesheet.data[i].startDayHalf = "AM";

										if (timesheet.data[i].startTime > 12 * 60 - 1) {
											if (parseInt(timesheet.data[i].startHour) !== 12) {
												timesheet.data[i].startHour = (parseInt(timesheet.data[i].startHour) - 12)
														.toString();
											}
											timesheet.data[i].startDayHalf = "PM";
										}

										timesheet.data[i].endHour = parseInt(timesheet.data[i].endTime / 60).toString();
										timesheet.data[i].endMinute = (timesheet.data[i].endTime - parseInt(timesheet.data[i].endHour) * 60)
												.toString();
										timesheet.data[i].endDayHalf = "AM";
										if (timesheet.data[i].endTime > 12 * 60 - 1) {
											if (parseInt(timesheet.data[i].endHour) !== 12) {
												timesheet.data[i].endHour = (parseInt(timesheet.data[i].endHour) - 12)
														.toString();
											}
											timesheet.data[i].endDayHalf = "PM";
										}

										var breakTimeToreduce = timesheet.data[i].breakTime > 15 ? timesheet.data[i].breakTime
												: 0;
										timesheet.data[i].NoOfHours = (timesheet.data[i].endTime -
												timesheet.data[i].startTime - breakTimeToreduce) / 60;
										timesheet.data[i].breakTime = timesheet.data[i].breakTime > 0 ? timesheet.data[i].breakTime
												.toString()
												: timesheet.data[i].breakTime;

										//if worked holiday, change color
										if (timesheet.data[i].NoOfHours && timesheet.data[i].isOffDay) {
											timesheet.data[i].checkboxValue = true;
											timesheet.data[i].sickDay = false;
											timesheet.data[i].color = TIMESHEET_CONSTANTS.WORKED_HOLIDAY_COLOR;
											if ((timesheet.sRequestStatus === "Approved") ||
													(timesheet.sRequestStatus === "Submitted") ||
													(timesheet.sRequestStatus === "Submitted to Payroll")) {
												timesheet.data[i].disableChkbx = true;
												timesheet.data[i].disable = true;
												timesheet.data[i].selectColor = TIMESHEET_CONSTANTS.DISABLED_COLOR;
												timesheet.data[i].cursor = TIMESHEET_CONSTANTS.CURSOR_DISABLED;
											} else {
												timesheet.data[i].disable = false;
												timesheet.data[i].selectColor = TIMESHEET_CONSTANTS.DEFAULT_COLOR;
												timesheet.data[i].cursor = TIMESHEET_CONSTANTS.CURSOR_DEFAULT;
											}
										}
										//if sick day, change color
										if (timesheet.sickDayList[i] === 1) {
											timesheet.data[i].checkboxValue = false;
											timesheet.data[i].sickDay = true;
											timesheet.data[i].disable = true;
											timesheet.data[i].color = TIMESHEET_CONSTANTS.SICK_DAY_COLOR;
											timesheet.data[i].selectColor = TIMESHEET_CONSTANTS.DISABLED_COLOR;
											timesheet.data[i].cursor = TIMESHEET_CONSTANTS.CURSOR_DISABLED;
											if ((timesheet.sRequestStatus === "Approved") ||
													(timesheet.sRequestStatus === "Submitted") ||
													(timesheet.sRequestStatus === "Submitted to Payroll")) {
												timesheet.data[i].disableChkbx = true;

											}
										}
									}
									//return timesheet;
								}

								function enableSickDayRow(timesheet, disableRowPos) {
									timesheet.sickDayList[disableRowPos] = 1;
									timesheet.data[disableRowPos].disable = true;
									timesheet.data[disableRowPos].sickDay = true;
									timesheet.data[disableRowPos].checkboxValue = false;
									timesheet.data[disableRowPos].color = TIMESHEET_CONSTANTS.SICK_DAY_COLOR;
									timesheet.data[disableRowPos].cursor = TIMESHEET_CONSTANTS.CURSOR_DISABLED;
									timesheet.data[disableRowPos].selectColor = TIMESHEET_CONSTANTS.DISABLED_COLOR;

									timesheet.data[disableRowPos].startHour = "9";
									timesheet.data[disableRowPos].startMinute = "0";
									timesheet.data[disableRowPos].startDayHalf = "AM";
									timesheet.data[disableRowPos].endHour = "5";
									timesheet.data[disableRowPos].endMinute = "0";
									timesheet.data[disableRowPos].endDayHalf = "PM";
									timesheet.data[disableRowPos].breakTime = "00";
									timesheet.data[disableRowPos].startTime = 0;
									timesheet.data[disableRowPos].endTime = 0;
									timesheet.sComments = "";
									for (var i = 0; i < timesheet.data.length; i++) {
										if (timesheet.data[i].checkboxValue === true) {
											timesheet.sComments = timesheet.sComments + "\n" +
													i8nConstants.WORKED_HOLIDAY + ": " +
													Utils.convertDateString(timesheet.data[i].date);
										}
										if (timesheet.data[i].sickDay === true) {
											timesheet.sComments = timesheet.sComments + "\n" + i8nConstants.SICK_DAY +
													": " + Utils.convertDateString(timesheet.data[i].date);
										}
									}
								}

								function disableSickDayRow(timesheet, disableRowPos) {
									timesheet.sickDayList[disableRowPos] = 0;
									timesheet.data[disableRowPos].disable = false;
									timesheet.data[disableRowPos].invalidTime = false;
									timesheet.data[disableRowPos].checkboxValue = false;
									timesheet.data[disableRowPos].sickDay = false;
									timesheet.data[disableRowPos].color = TIMESHEET_CONSTANTS.DEFAULT_COLOR;
									timesheet.data[disableRowPos].cursor = TIMESHEET_CONSTANTS.CURSOR_DEFAULT;
									timesheet.data[disableRowPos].selectColor = TIMESHEET_CONSTANTS.DEFAULT_COLOR;

									timesheet.data[disableRowPos].startHour = "0";
									timesheet.data[disableRowPos].startMinute = "0";
									timesheet.data[disableRowPos].startDayHalf = "AM";
									timesheet.data[disableRowPos].endHour = "0";
									timesheet.data[disableRowPos].endMinute = "0";
									timesheet.data[disableRowPos].endDayHalf = "AM";
									timesheet.data[disableRowPos].breakTime = "00";
									timesheet.data[disableRowPos].startTime = 0;
									timesheet.data[disableRowPos].endTime = 0;
									timesheet.sComments = "";
									for (var i = 0; i < timesheet.data.length; i++) {
										if (timesheet.data[i].checkboxValue === true) {
											timesheet.sComments = timesheet.sComments + "\n" +
													i8nConstants.WORKED_HOLIDAY + ": " +
													Utils.convertDateString(timesheet.data[i].date);
										}
										if (timesheet.data[i].sickDay === true) {
											timesheet.sComments = timesheet.sComments + "\n" + i8nConstants.SICK_DAY +
													": " + Utils.convertDateString(timesheet.data[i].date);
										}
									}
									if (isTimeoffDay(timesheet.data[disableRowPos].date)) {
										disableOffDayRow(timesheet, disableRowPos);
									}
								}

								function enableOffDayRow(timesheet, disableRowPos) {
									timesheet.sickDayList[disableRowPos] = 0;
									timesheet.data[disableRowPos].sickDay = false;
									timesheet.data[disableRowPos].disable = false;
									timesheet.data[disableRowPos].checkboxValue = true;
									timesheet.data[disableRowPos].color = TIMESHEET_CONSTANTS.WORKED_HOLIDAY_COLOR;
									timesheet.data[disableRowPos].cursor = TIMESHEET_CONSTANTS.CURSOR_DEFAULT;
									timesheet.data[disableRowPos].selectColor = TIMESHEET_CONSTANTS.DEFAULT_COLOR;
									timesheet.sComments = timesheet.sComments + "\n" + i8nConstants.WORKED_HOLIDAY +
											": " + Utils.convertDateString(timesheet.data[disableRowPos].date);
									timesheet.sComments = "";
									for (var i = 0; i < timesheet.data.length; i++) {
										if (timesheet.data[i].checkboxValue === true) {
											timesheet.sComments = timesheet.sComments + "\n" +
													i8nConstants.WORKED_HOLIDAY + ": " +
													Utils.convertDateString(timesheet.data[i].date);
										}
										if (timesheet.data[i].sickDay === true) {
											timesheet.sComments = timesheet.sComments + "\n" + i8nConstants.SICK_DAY +
													": " + Utils.convertDateString(timesheet.data[i].date);
										}
									}
								}

								function disableOffDayRow(timesheet, disableRowPos) {
									timesheet.sickDayList[disableRowPos] = 0;
									timesheet.data[disableRowPos].sickDay = false;
									timesheet.data[disableRowPos].disable = true;
									timesheet.data[disableRowPos].invalidTime = false;
									timesheet.data[disableRowPos].checkboxValue = false;
									timesheet.data[disableRowPos].color = TIMESHEET_CONSTANTS.DISABLED_COLOR;
									timesheet.data[disableRowPos].cursor = TIMESHEET_CONSTANTS.CURSOR_DISABLED;
									timesheet.data[disableRowPos].selectColor = TIMESHEET_CONSTANTS.DISABLED_COLOR;

									timesheet.data[disableRowPos].startHour = "0";
									timesheet.data[disableRowPos].startMinute = "0";
									timesheet.data[disableRowPos].startDayHalf = "AM";
									timesheet.data[disableRowPos].endHour = "0";
									timesheet.data[disableRowPos].endMinute = "0";
									timesheet.data[disableRowPos].endDayHalf = "AM";
									timesheet.data[disableRowPos].breakTime = "00";
									timesheet.data[disableRowPos].startTime = 0;
									timesheet.data[disableRowPos].endTime = 0;
									timesheet.sComments = "";
									for (var i = 0; i < timesheet.data.length; i++) {
										if (timesheet.data[i].checkboxValue === true) {
											timesheet.sComments = timesheet.sComments + "\n" +
													i8nConstants.WORKED_HOLIDAY + ": " +
													Utils.convertDateString(timesheet.data[i].date);
										}
									}
									if (timesheet.data[i].sickDay === true) {
										timesheet.sComments = timesheet.sComments + "\n" + i8nConstants.SICK_DAY +
												": " + Utils.convertDateString(timesheet.data[i].date);
									}
								}

								function sickDayRowEnableDisable(timesheet, disableRowPos, statusDetails, value) {
									if (value === true) {
										enableSickDayRow(timesheet, disableRowPos);
									} else {
										disableSickDayRow(timesheet, disableRowPos);
									}
									timeCalculationServices
											.updateTimesheetTime(disableRowPos, timesheet, statusDetails);
								}

								function submitTimesheet(timesheet, type, requestor) {
									var data = [];
									var url = employeeServices.getUrlObj().saveTimeSheet;
									for (var i = 0; i < timesheet.data.length; i += 1) {
										data.push({
											"date" : Utils.respDateFormat(timesheet.data[i].date, true),
											"startTime" : timesheet.data[i].startTime,
											"endTime" : timesheet.data[i].endTime,
											"breakTime" : parseInt(timesheet.data[i].breakTime),
											"noOfHours" : parseFloat(timesheet.data[i].NoOfHours)
										});
									}

									var sickDays = 0;
									if(angular.isDefined(timesheet.sickDayList)){
										timesheet.sickDayList.map((x)=>{
											sickDays = sickDays<<1 | x;
										});
									}else{
										sickDays = timesheet.sickDays;
									}

									var params = {
										weekStart : Utils.respDateFormat(timesheet.weekStart, true),
										weekEnd : Utils.respDateFormat(timesheet.weekEnd, true),
										data : data,
										regularHours : timesheet.regularHours,
										overtimeHours : timesheet.overtimeHours,
										doubleOvertimeHours : timesheet.doubleOvertimeHours,
										totalHours : timesheet.totalHours,
										sComments : timesheet.sComments,
										sRequestor : requestor,
										sickDays: sickDays
									};
									if (timesheet.nID) {//edit mode : PUT
										params.nID = timesheet.nID;
										url = employeeServices.getUrlObj().submitTimeSheet;
									}
									if (type === "Submit") {
										params.submitFlag = true;
									} else if (type === "Save") {
										params.submitFlag = false;
									}
									return {
										params: params,
										url: url
									}
								}

								return {
									"getTimesheetDetails" : getTimesheetDetails,
									"enableOffDayRow" : enableOffDayRow,
									"disableOffDayRow" : disableOffDayRow,
									"sickDayRowEnableDisable" : sickDayRowEnableDisable,
									"submitTimesheet" : submitTimesheet
								};
							} ]);
})();