/**
 * Factory responsible for holiday related operations
 */
(function() {
	'use strict';
	app
			.factory('messagesAndPopupServices',
					[
							"Utils",
							"i8nConstants",
							"TIMESHEET_CONSTANTS",
							function(Utils, i8nConstants, TIMESHEET_CONSTANTS) {

								function displayTimeSheetDetails(displayData) {
									var weekDays = [
											"Sunday",
											"Monday",
											"Tuesday",
											"Wednesday",
											"Thursday",
											"Friday",
											"Saturday" ];

									var info = {
										name : displayData.sRequestorName,
										startDate : displayData.weekStart,
										endDate : displayData.weekEnd,
										regularHours : displayData.regularHours,
										overtimeHours : displayData.overtimeHours,
										doubleOvertimeHours : displayData.doubleOvertimeHours,
										totalHours : displayData.regularHours + displayData.overtimeHours +
												displayData.doubleOvertimeHours,
										comments : displayData.sComments,
										sSubmittedBy : displayData.sSubmittedBy,
										sApprovedBy : displayData.sApprovedBy,
										sApproverComments : displayData.sApproverComments,
										sUploadedBy : displayData.sPayrollProcessedByName,
										actions : displayData.sAction,
										id : displayData.nID,
										overtimeStatus : displayData.overtimeStatus,
										workState : displayData.workState,
										sRequestStatus : displayData.sRequestStatus,
										displayDetails : [],
										sickDay : [ 0, 0, 0, 0, 0, 0, 0 ]
									};
									let sickDates = displayData.sickDays;
									let k = 6;
									while (sickDates > 0) {
										info.sickDay[k] = sickDates & 1;
										sickDates = sickDates >> 1;
										k--;
									}

									if (displayData.datePayrollProcessed) {
										info.uploadedOn = new Date(displayData.datePayrollProcessed);
									}
									if (displayData.approvedOn) {
										info.approvedOn = new Date(displayData.approvedOn);
									}
									if (displayData.submittedOn) {
										info.submittedOn = new Date(displayData.submittedOn);
									}
									showPopupOvertimeMessages(info, displayData);

									var data = displayData.data;
									var nextDate = angular.copy(displayData.weekStart);
									var weekEnd = displayData.weekEnd;

									while (nextDate <= weekEnd) {
										var date = new Date(nextDate.setHours(0, 0));
										for (var i = 0; i < data.length; i++) {

											var responseDate = new Date(data[i].date);
											responseDate = new Date(responseDate.setHours(0, 0));

											if (date.getTime() === responseDate.getTime()) {
												var startHour = parseInt(data[i].startTime / 60).toString();
												var startMinute = (data[i].startTime - parseInt(startHour) * 60)
														.toString();
												var startDayHalf = "AM";
												if (data[i].startTime > 12 * 60 - 1) {
													if (parseInt(startHour) !== 12) {
														startHour = (parseInt(startHour) - 12).toString();
													}
													startDayHalf = "PM";
												}
												var endHour = parseInt(data[i].endTime / 60).toString();
												var endMinute = (data[i].endTime - parseInt(endHour) * 60).toString();
												var endDayHalf = "AM";
												if (data[i].endTime > 12 * 60 - 1) {
													if (parseInt(endHour) !== 12) {
														endHour = (parseInt(endHour) - 12).toString();
													}
													endDayHalf = "PM";
												}

												var breakTimeToreduce = data[i].breakTime > 15 ? data[i].breakTime : 0;
												var timeForBreak = (data[i].breakTime > 45) ? parseInt(data[i].breakTime / 60) +
														" hr " +
														(data[i].breakTime - parseInt(data[i].breakTime / 60) * 60) +
														" min"
														: parseInt(data[i].breakTime) + " min";
												var color = TIMESHEET_CONSTANTS.DEFAULT_COLOR;
												var cursor = TIMESHEET_CONSTANTS.CURSOR_DEFAULT;
												//if sick day, change color
												if (info.sickDay[i] === 1) {
													color = TIMESHEET_CONSTANTS.SICK_DAY_COLOR;
													cursor = TIMESHEET_CONSTANTS.CURSOR_DISABLED;
												}
												info.displayDetails
														.push({
															Day : weekDays[date.getDay()],
															date : date,
															startHour : startHour < 10 ? "0" + startHour : startHour,
															startMinute : startMinute < 10 ? "0" + startMinute
																	: startMinute,
															startDayHalf : startDayHalf,
															endHour : endHour < 10 ? "0" + endHour : endHour,
															endMinute : endMinute < 10 ? "0" + endMinute : endMinute,
															endDayHalf : endDayHalf,
															timeForBreak : timeForBreak,
															NoOfHours : (data[i].endTime - data[i].startTime - breakTimeToreduce) / 60,
															startTime : data[i].startTime,
															endTime : data[i].endTime,
															color : color,
															cursor : cursor
														});
												break;
											}
										}
										nextDate = new Date(nextDate.setDate(nextDate.getDate() + 1));
									}
									return info;
								}

								function showPopupOvertimeMessages(info, displayData) {
									info.showRegularHours = true;
									info.workStateCA = false;
									if (displayData.overtimeStatus === TIMESHEET_CONSTANTS.OVETTIME) {
										info.overtimeOnlyAlertMsg = "*" + i8nConstants.SUBMIT_OVERTIME_HOURS_ONLY;
										info.showRegularHours = false;
									}
									if (displayData.workState === TIMESHEET_CONSTANTS.TYPE_CA) {
										info.workStateCA = true;
									}
									if (displayData.status) {
										if (displayData.status.dateOfChange) {
											var lastPrevStatusDate = new Date(new Date(displayData.status.dateOfChange)
													.setDate(new Date(displayData.status.dateOfChange).getDate() - 1));
											displayData.status.dateOfChange = new Date(new Date(
													displayData.status.dateOfChange).setHours(0, 0, 0, 0));
											if (displayData.weekStart.getTime() < displayData.status.dateOfChange
													.getTime()) {
												info.overtimeOnlyAlertMsg = "";
												info.showRegularHours = true;
												info.workStateCA = false;
												info.overtimeStatus = displayData.status.prevOvertimeStatus;
												info.workState = displayData.status.prevWorkState;

												if (displayData.status.prevOvertimeStatus === TIMESHEET_CONSTANTS.OVETTIME) {
													info.overtimeOnlyAlertMsg = "*" +
															i8nConstants.SUBMITTED_OVERTIME_HOURS_ONLY;
													info.showRegularHours = false;
												}
												if (displayData.status.prevWorkState === TIMESHEET_CONSTANTS.TYPE_CA) {
													info.workStateCA = true;
												}

												if (displayData.weekEnd.getTime() >= displayData.status.dateOfChange
														.getTime()) {
													info.showRegularHours = false;
													//in between week change
													if (displayData.status.prevOvertimeStatus !== displayData.overtimeStatus) {
														//overtime status change

														if (displayData.status.prevOvertimeStatus === TIMESHEET_CONSTANTS.OVETTIME) {
															info.overtimeOnlyAlertMsg = "*" +
																	i8nConstants.SUBMITTED_OVERTIME_HOURS_ONLY + ' ' +
																	i8nConstants.FROM + ' ' +
																	Utils.convertDateString(displayData.weekStart) +
																	' ' + i8nConstants.TILL + ' ' +
																	Utils.convertDateString(lastPrevStatusDate);
														} else if (displayData.status.prevOvertimeStatus === TIMESHEET_CONSTANTS.REGULAR ||
																displayData.status.prevOvertimeStatus === TIMESHEET_CONSTANTS.DEV) {
															info.showRegularHours = true;
															info.overtimeOnlyAlertMsg = "*" +
																	i8nConstants.SUBMITTED_REGULAR_WORKING_HOURS_FROM +
																	' ' +
																	Utils.convertDateString(displayData.weekStart) +
																	' ' + i8nConstants.TILL + ' ' +
																	Utils.convertDateString(lastPrevStatusDate);
														}
														if (displayData.isAuthorized === true) {
															if (displayData.overtimeStatus === TIMESHEET_CONSTANTS.OVETTIME) {
																info.overtimeOnlyAlertMsg = info.overtimeOnlyAlertMsg +
																		"<br/>" +
																		i8nConstants.SUBMITTED_OVERTIME_HOURS_ONLY +
																		' ' +
																		i8nConstants.FROM +
																		' ' +
																		Utils
																				.convertDateString(displayData.status.dateOfChange) +
																		' ' + i8nConstants.TILL + ' ' +
																		Utils.convertDateString(displayData.weekEnd);
															} else if (displayData.overtimeStatus === TIMESHEET_CONSTANTS.REGULAR ||
																	displayData.overtimeStatus === TIMESHEET_CONSTANTS.DEV) {
																info.showRegularHours = true;
																info.overtimeOnlyAlertMsg = info.overtimeOnlyAlertMsg +
																		"<br/>" +
																		i8nConstants.SUBMITTED_REGULAR_WORKING_HOURS_FROM +
																		' ' +
																		Utils
																				.convertDateString(displayData.status.dateOfChange) +
																		' ' + i8nConstants.TILL + ' ' +
																		Utils.convertDateString(displayData.weekEnd);
															}

														}
													}
													if (displayData.workState !== displayData.status.prevWorkState) {
														//location change
														if (displayData.workState === TIMESHEET_CONSTANTS.TYPE_CA ||
																displayData.status.prevWorkState === TIMESHEET_CONSTANTS.TYPE_CA) {
															info.workStateCA = true;
														}
													}
												}
											}
										}
									}
								}

								function showSubmitPageMessages(weekDetails, statusInfo) {

									var showStatusParams = {
										overtimeOnlyAlertMsg : "",
										showRegularHours : true,
										workStateCA : false
									};

									if (statusInfo.overtimeStatus === TIMESHEET_CONSTANTS.OVETTIME) {
										showStatusParams.overtimeOnlyAlertMsg = "*" +
												i8nConstants.SUBMIT_OVERTIME_HOURS_ONLY;
										showStatusParams.showRegularHours = false;
									}
									if (statusInfo.workState === TIMESHEET_CONSTANTS.TYPE_CA) {
										showStatusParams.workStateCA = true;
									}

									if (statusInfo.status) {
										if (statusInfo.status.dateOfChange) {
											var lastPrevStatusDate = new Date(new Date(statusInfo.status.dateOfChange)
													.setDate(new Date(statusInfo.status.dateOfChange).getDate() - 1));
											statusInfo.status.dateOfChange = new Date(new Date(
													statusInfo.status.dateOfChange).setHours(0, 0, 0, 0));

											if (weekDetails.weekStart.getTime() < statusInfo.status.dateOfChange
													.getTime()) {
												showStatusParams = {
													overtimeOnlyAlertMsg : "",
													showRegularHours : true,
													workStateCA : false
												};

												if (statusInfo.status.prevOvertimeStatus === TIMESHEET_CONSTANTS.OVETTIME) {
													showStatusParams.overtimeOnlyAlertMsg = "*" +
															i8nConstants.SUBMIT_OVERTIME_HOURS_ONLY;
													showStatusParams.showRegularHours = false;
												}
												if (statusInfo.status.prevWorkState === TIMESHEET_CONSTANTS.TYPE_CA) {
													showStatusParams.workStateCA = true;
												}

												if (weekDetails.weekEnd.getTime() >= statusInfo.status.dateOfChange
														.getTime()) {
													//in between week change
													if (statusInfo.status.prevOvertimeStatus !== statusInfo.overtimeStatus) {
														showStatusParams.showRegularHours = false;
														//get message
														if (statusInfo.status.prevOvertimeStatus === TIMESHEET_CONSTANTS.OVETTIME) {
															showStatusParams.overtimeOnlyAlertMsg = "*" +
																	i8nConstants.SUBMIT_OVERTIME_HOURS_ONLY + ' ' +
																	i8nConstants.FROM + ' ' +
																	Utils.convertDateString(weekDetails.weekStart) +
																	' ' + i8nConstants.TILL + ' ' +
																	Utils.convertDateString(lastPrevStatusDate);
														} else if (statusInfo.status.prevOvertimeStatus === TIMESHEET_CONSTANTS.REGULAR ||
																statusInfo.status.prevOvertimeStatus === TIMESHEET_CONSTANTS.DEV) {
															showStatusParams.showRegularHours = true;
															showStatusParams.overtimeOnlyAlertMsg = "*" +
																	i8nConstants.SUBMIT_REGULAR_WORKING_HOURS_FROM +
																	' ' +
																	Utils.convertDateString(weekDetails.weekStart) +
																	' ' + i8nConstants.TILL + ' ' +
																	Utils.convertDateString(lastPrevStatusDate);
														}
														if (statusInfo.isAuthorized === true) {
															if (statusInfo.overtimeStatus === TIMESHEET_CONSTANTS.REGULAR ||
																	statusInfo.overtimeStatus === TIMESHEET_CONSTANTS.DEV) {
																showStatusParams.showRegularHours = true;
																showStatusParams.overtimeOnlyAlertMsg = showStatusParams.overtimeOnlyAlertMsg +
																		"<br/>" +
																		i8nConstants.SUBMIT_REGULAR_WORKING_HOURS_FROM +
																		' ' +
																		Utils
																				.convertDateString(statusInfo.status.dateOfChange) +
																		' ' +
																		i8nConstants.TILL +
																		' ' +
																		Utils.convertDateString(weekDetails.weekEnd);

															} else if (statusInfo.overtimeStatus === TIMESHEET_CONSTANTS.OVETTIME) {
																showStatusParams.overtimeOnlyAlertMsg = showStatusParams.overtimeOnlyAlertMsg +
																		"<br/>" +
																		i8nConstants.SUBMIT_OVERTIME_HOURS_ONLY +
																		' ' +
																		i8nConstants.FROM +
																		' ' +
																		Utils
																				.convertDateString(statusInfo.status.dateOfChange) +
																		' ' +
																		i8nConstants.TILL +
																		' ' +
																		Utils.convertDateString(weekDetails.weekEnd);
															}
														}
													}
													if (statusInfo.status.prevWorkState !== statusInfo.workState) {
														if (statusInfo.status.prevWorkState === TIMESHEET_CONSTANTS.TYPE_CA ||
																statusInfo.workState === TIMESHEET_CONSTANTS.TYPE_CA) {
															showStatusParams.workStateCA = true;
														}
													}
												}

											}
										}
									}
									return showStatusParams;
								}

								return {
									"displayTimeSheetDetails" : displayTimeSheetDetails,
									"showSubmitPageMessages" : showSubmitPageMessages
								};

							} ]);
})();