/**
 * Factory responsible for holiday related operations
 */
(function() {
	'use strict';
	app.factory('holidayService', [
			"Utils",
			function(Utils) {

				var regionYearMonthHolidays;
				var regionSortedHolidays = {};
				var regionList = [];
				var yearList = [];

				var monthNames = [
						"January",
						"February",
						"March",
						"April",
						"May",
						"June",
						"July",
						"August",
						"September",
						"October",
						"November",
						"December" ];

				//pre-process the holiday page details

				function setYearList() {
					var j = -1;
					var dateObj = new Date();
					yearList = [];
					for (var i = 0; j <= 1; i++, j++) {
						yearList[i] = dateObj.getFullYear() + j;
					}

				}

				function setRegionSortedHolidays(holiday, locationList) {
					regionSortedHolidays = {};
					regionList = [];
					//var holiday = employeeDetails.Holidays;
					if ((holiday)) {
						for ( var key in holiday) {
							var parent = false;
							var locationPos = -1;
							var LocationId = holiday[key].nLocationID;
							for (var i = 0; i < locationList.length; i += 1) {
								if (locationList[i].nParentLocID === LocationId) {
									parent = true;
									if (!regionSortedHolidays[locationList[i].sRegionName]) {
										regionList.push(locationList[i].sRegionName);
										regionSortedHolidays[locationList[i].sRegionName] = [];
									}
									regionSortedHolidays[locationList[i].sRegionName].push(holiday[key]);
								}
								if (locationList[i].nLocationID === LocationId) {
									locationPos = i;
								}
							}
							//if (parent === false) {
							if (locationPos !== -1) {
								if (!regionSortedHolidays[locationList[locationPos].sRegionName]) {
									regionList.push(locationList[locationPos].sRegionName);
									regionSortedHolidays[locationList[locationPos].sRegionName] = [];
								}
								regionSortedHolidays[locationList[locationPos].sRegionName].push(holiday[key]);
							}
							//}
						}
					}
				}

				function getRegionSortedHolidays() {
					return regionSortedHolidays;
				}

				function getYearList() {
					return yearList;
				}

				function getHolidayRegionList() {
					return regionList;
				}

				//for holiday page
				function getMonthNames() {
					return monthNames;
				}
				function sortByRegionYearMonth() {
					regionYearMonthHolidays = {};
					var color;
					var holidays;
					if (regionSortedHolidays) {
						for ( var region in regionSortedHolidays) {
							holidays = regionSortedHolidays[region];
							if (holidays) {
								for (var i = 0; i < holidays.length; i++) {
									var startDate = new Date(holidays[i].startDate);
									var endDate = new Date(holidays[i].endDate);
									var daysDiff = Utils
											.calculateDays(startDate.toDateString(), endDate.toDateString());
									var k = 0;
									var holidayDate = new Date(holidays[i].startDate);
									do {
										var date = new Date(holidayDate);
										var year = date.getFullYear();
										var month = monthNames[date.getMonth()];
										if (!regionYearMonthHolidays[region]) {
											regionYearMonthHolidays[region] = {};
										}
										if (!regionYearMonthHolidays[region][year]) {
											regionYearMonthHolidays[region][year] = {};
										}
										if (!regionYearMonthHolidays[region][year][month]) {
											regionYearMonthHolidays[region][year][month] = [];
										}
										if (holidays[i].nIsOptional === true) {
											color = '#344c67';
										} else {
											color = 'white';
										}
										regionYearMonthHolidays[region][year][month].push({
											'month' : month,
											'date' : date,
											'name' : holidays[i].sName,
											'country' : holidays[i].sCountry,
											'region' : holidays[i].sRegion,
											'color' : color
										});
										regionYearMonthHolidays[region][year][month] = Utils
												.sortArrayBasedOnDates(regionYearMonthHolidays[region][year][month]);
										holidayDate.setDate(holidayDate.getDate() + 1);
										k++;
									} while (k < daysDiff);
								}
							}
						}
					}
				}
				function getRegionYearMonthHolidays(regionList, yearList) {
					var finalHolidays;
					if ((regionList) && (yearList)) {
						for ( var key in regionList) {
							var region = regionList[key];
							if (regionYearMonthHolidays[region]) {
								for ( var indx in yearList) {
									var year = yearList[indx];
									if (regionYearMonthHolidays[region][year]) {
										if (!finalHolidays) {
											finalHolidays = {};
										}
										if (!finalHolidays[region]) {
											finalHolidays[region] = {};
										}
										if (!finalHolidays[region][year]) {
											finalHolidays[region][year] = {};
										}
										finalHolidays[region][year] = regionYearMonthHolidays[region][year];
									}
								}
							}
						}
						return finalHolidays;
					}
					return null;
				}

				return {
					"getMonthNames" : getMonthNames,
					"sortByRegionYearMonth" : sortByRegionYearMonth,
					"getRegionYearMonthHolidays" : getRegionYearMonthHolidays,
					"getRegionSortedHolidays" : getRegionSortedHolidays,
					"getYearList" : getYearList,
					"getHolidayRegionList" : getHolidayRegionList,
					"setYearList" : setYearList,
					"setRegionSortedHolidays" : setRegionSortedHolidays
				};
			} ]);
})();