/**
 * Factory responsible for holiday related operations
 */
(function() {
	'use strict';
	app.factory('apiServices', [
			"$q",
			"Restangular",
			"Utils",
			"employeeServices",
			function($q, Restangular, Utils, employeeServices) {

				function getListingObjArray(moduleName) {
					var URL = employeeServices.getUrlObj();

					var deferred = $q.defer();
					Restangular.all(URL["get" + moduleName]).getList().then(function(resp) {
						if (resp) {
							if (resp[0]) {
								if (resp[0].data === null) {
									resp[0].data = [];
								}
								if (Utils.isValidResponse(resp)) {
									resp.printError = false;
									deferred.resolve(resp[0].data);
								} else {
									deferred.reject(resp);
								}
							} else {
								resp.printError = true;
								deferred.reject(resp);
							}
						} else {
							resp = {};
							resp.printError = true;
							deferred.reject(resp);
						}
					}, function(resp) {
						if (!resp) {
							resp = {};
						}
						resp.printError = true;
						deferred.reject(resp);
					});
					return deferred.promise;
				}

				// used for all create , update and delete API's
				function cudAPI(url, requestParams) {
					var deferred = $q.defer();
					var urlObj = Restangular.all(url);
					urlObj.post(requestParams, "get").then(function(resp) {
						if (resp) {
							//to handle error within crendial modal popup
							if (url === employeeServices.getUrlObj().getTimesheetsHistory) {
								if (resp.success === false) {
									resp.printError = true;
									deferred.reject(resp);
								} else {
									deferred.resolve(resp);
								}
							} else {
								if (Utils.isValidResponse(resp)) {
									resp.printError = false;
									deferred.resolve(resp);
								} else {
									deferred.reject(resp);
								}
							}
						} else {
							resp = {};
							resp.printError = true;
							deferred.reject(resp);
						}
					}, function(resp) {
						if (!resp) {
							resp = {};
						}
						resp.printError = true;
						deferred.reject(resp);
					});
					return deferred.promise;
				}

				return {
					"getListingObjArray" : getListingObjArray,
					"cudAPI" : cudAPI
				};
			} ]);
})();