(function() {
	app.factory('Utils', [
			"$timeout",
			"$rootScope",
			"i8nConstants",
			function($timeout, $rootScope, i8nConstants) {

				function escapeHtml(unsafe) {
					if (typeof unsafe == "number") {
						return unsafe;
					}
					return unsafe.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g,
							"&quot;").replace(/'/g, "&#039;");
				}

				function unescapeHtml(safeHtml) {
					if (typeof safeHtml == "string") {
						return safeHtml.replace(/&amp;/g, "&").replace(/&lt;/g, "<").replace(/&gt;/g, ">")
								.replace(/&quot;/g, '"').replace(/&#039;/g, "'");
					}
					return safeHtml;
				}

				function respDateFormat(rawDateString, leadingZeroFlag) {
					return (((new Date(rawDateString).getMonth() < 9) && (leadingZeroFlag === true)) ? "0" : "") +
							(new Date(rawDateString).getMonth() + 1) + "/" +
							((new Date(rawDateString).getDate() < 10) ? "0" : "") + new Date(rawDateString).getDate() +
							"/" + new Date(rawDateString).getFullYear();
				}

				function convertDateString(dateData) {
					var monthShortNames = [
							"Jan",
							"Feb",
							"Mar",
							"Apr",
							"May",
							"Jun",
							"Jul",
							"Aug",
							"Sept",
							"Oct",
							"Nov",
							"Dec" ];
					var dateObj = "";
					if (dateData instanceof Date) {
						return dateData.getDate() + " " + monthShortNames[dateData.getMonth()] + " " +
								dateData.getFullYear();
					} else {
						if (dateData) {
							dateData = dateData.replace(/\//g, "-");
						}
						var dateString = dateData.split("-");
						if ((dateString) && (dateString.length) > 0) {
							dateObj = new Date(dateString[2], dateString[0] - 1, dateString[1]);
						}
						return dateObj.getDate() + " " + monthShortNames[dateObj.getMonth()] + " " +
								dateObj.getFullYear();
					}
				}

				function calculateDays(startDateStr, endDateStr) {
					var startDate = new Date(startDateStr.replace(/-/g, "/"));
					var endDate = new Date(endDateStr.replace(/-/g, "/"));
					var millisecondsPerDay = 86400 * 1000;
					startDate.setHours(0, 0, 0, 1);
					endDate.setHours(23, 59, 59, 999);
					var diff = endDate - startDate;
					var days = Math.ceil(diff / millisecondsPerDay);
					return days;
				}

				function sortArrayBasedOnDates(objArr) {
					var temp = {};
					for (var i = 0; i < objArr.length - 1; i++) {
						for (var d = 0; d < objArr.length - i - 1; d++) {
							var date1 = new Date(objArr[d].date).getDate();
							var date2 = new Date(objArr[d + 1].date).getDate();
							if (date1 > date2) {
								temp = objArr[d];
								objArr[d] = objArr[d + 1];
								objArr[d + 1] = temp;
							}
						}
					}
					return objArr;
				}

				function isValidResponse(response) {
					if (response[0]) {
						if ((response[0].error !== null) && (response[0].error !== undefined)) {
							response.printError = false;
							$(".alert-msg").hide();
							if (response[0].error !== "") {
								$rootScope.errorMsg = response[0].error;
								$rootScope.showError = true;
								$timeout(function() {
									$rootScope.showError = false;
									$rootScope.errorMsg = i8nConstants.SOMETHING_WENT_WRONG;
								}, 3000);
							} else {
								response.printError = true;
							}
						} else if (response[0].success === true) {
							response.printError = false;
							return true;
						} else {
							response.printError = false;
							displayError();
						}
					} else {
						response.printError = true;
					}
					return false;
				}

				function displayError() {
					$rootScope.showError = true;
					$timeout(function() {
						$rootScope.showError = false;
					}, 3000);
				}

				function getCsrfToken() {
					function readCookie(name) {
						var nameEQ = name + "=";
						var ca = document.cookie.split(';');
						for (var i = 0; i < ca.length; i++) {
							var c = ca[i];
							while (c.charAt(0) === ' ') {
								c = c.substring(1, c.length);
							}
							if (c.indexOf(nameEQ) === 0) {
								return c.substring(nameEQ.length, c.length);
							}
						}
						return null;
					}

					return readCookie("csrf");
				}

				return {
					"calculateDays" : calculateDays,
					"sortArrayBasedOnDates" : sortArrayBasedOnDates,
					"convertDateString" : convertDateString,
					"respDateFormat" : respDateFormat,
					"getCsrfToken" : getCsrfToken,
					"isValidResponse" : isValidResponse,
					"displayError" : displayError,
					"escapeHtml" : escapeHtml,
					"unescapeHtml" : unescapeHtml
				};

			} ]);
})();