(function() {
	app.controller("pastTimesheetOnlyCtrl", [
			"$scope",
			"$location",
			"$timeout",
			"$anchorScroll",
			"Utils",
			"employeeServices",
			"apiServices",
			"timesheetServices",
			"timeCalculationServices",
			"messagesAndPopupServices",
			"TIMESHEET_CONSTANTS",
			"i8nConstants",
			function($scope, $location, $timeout, $anchorScroll, Utils, employeeServices, apiServices,
					timesheetServices, timeCalculationServices, messagesAndPopupServices, TIMESHEET_CONSTANTS,
					i8nConstants) {

				$scope.TIMESHEET_CONSTANTS = TIMESHEET_CONSTANTS;

				// to fill dropdown
				$scope.dateInfo = [];
				$scope.timesheet = {};
				$scope.excessTimeEntered = {};
				$scope.noData = true;
				$scope.editFlag = false;
				$scope.loadingFlag = false;
				$scope.checkValidTime = false;
				$scope.noDataEnteredMsg = false;
				$scope.dateOfDisabledRow = "";
				$scope.showLists = {
					showWeekList : false,
				};
				var statusDetails = {};
				var disableRowPos = "";

				$scope.closeAlertMessage = function() {
					$scope.noDataEnteredMsg = false;
				};

				$scope.initData = function() {
					statusDetails = employeeServices.getStatusDetails();
					if (statusDetails.status) {
						if (statusDetails.status.weeks) {
							if (statusDetails.status.weeks.length !== 0) {
								for (var i = 0; i < statusDetails.status.weeks.length; i++) {
									var startDate = new Date(statusDetails.status.weeks[i]);
									var endDate = startDate.getDate() + 6;
									var weekEnd = new Date(new Date(startDate).setDate(endDate));
									$scope.dateInfo.push({
										"weekStart" : startDate,
										"weekEnd" : weekEnd
									});
								}
								$scope.weekChanged($scope.dateInfo[0]);
							}
						}
					}
				};

				$scope.weekChanged = function(data) {

					var params = {
						"alias" : employeeServices.getProdcertName(),
						"startdate" : Utils.respDateFormat(new Date(data.weekStart), true),
						"enddate" : Utils.respDateFormat(new Date(data.weekEnd), true)
					};
					var url = employeeServices.getUrlObj().getTimesheetsHistory;
					$scope.loadingFlag = true;
					$scope.noData = true;
					$scope.timesheet = {};
					apiServices.cudAPI(url, params).then(function(response) {
						$scope.loadingFlag = false;
						$scope.timesheet = timesheetServices.getTimesheetDetails(response, data, statusDetails);
						$scope.statusInfo = messagesAndPopupServices.showSubmitPageMessages(data, statusDetails);
						if ($scope.timesheet) {
							$scope.noData = false;
						}
					}, function(resp) {
						$scope.loadingFlag = false;
						if (resp.printError === true) {
							Utils.displayError();
						}
						$scope.timesheet = null;
					});
				};

				$scope.getDisabledRowData = function(pos) {
					$scope.dateOfDisabledRow = $scope.timesheet.data[pos].date;
					disableRowPos = pos;
					if ($scope.timesheet.data[pos].checkboxValue === true) {
						angular.element("#worked_offDay").modal("show");
					} else {
						$scope.disableOffDayRow();
					}
				};

				$scope.enableOffDayRow = function() {
					timesheetServices.enableOffDayRow($scope.timesheet, disableRowPos);
				};

				$scope.disableOffDayRow = function() {
					timesheetServices.disableOffDayRow($scope.timesheet, disableRowPos);
					timeCalculationServices.updateTimesheetTime(disableRowPos, $scope.timesheet, statusDetails);
				};

				$scope.getSickDayRowData = function(pos) {
					$scope.dateOfDisabledRow = $scope.timesheet.data[pos].date;
					$scope.timesheet.data[pos].checkboxValue = false;
					disableRowPos = pos;
					if ($scope.timesheet.data[pos].sickDay === true) {
						angular.element("#worked_sickDay").modal("show");
					} else {
						$scope.disableSickDayRow();
					}
				};

				$scope.enableSickDayRow = function() {
					timesheetServices.sickDayRowEnableDisable($scope.timesheet, disableRowPos, statusDetails, true);
				};

				$scope.disableSickDayRow = function() {
					timesheetServices.sickDayRowEnableDisable($scope.timesheet, disableRowPos, statusDetails, false);
				};

				$scope.updateTime = function(pos) {
					timeCalculationServices.updateTimesheetTime(pos, $scope.timesheet, statusDetails);
				};

				$scope.saveTimesheet = function() {
					var i = 0;
					$scope.checkValidTime = true;
					for (i = 0; i < $scope.timesheet.data.length; i += 1) {
						if ($scope.timesheet.data[i].invalidTime === true) {
							break;
						}
					}
					if (i < $scope.timesheet.data.length) {
						angular.element("#invalid_hours_entered").modal("show");
					} else if ($scope.timesheet.totalHours === 0) {
						$anchorScroll();
						$scope.noDataEnteredMsg = true;
						$timeout(function() {
							$scope.noDataEnteredMsg = false;
						}, 3000);
						return;
					} else if ($scope.timesheet.overtimeHours > 20) {
						$scope.excessTimeEntered = {
							hours : $scope.timesheet.overtimeHours,
							category : i8nConstants.OVERTIME
						};
						angular.element("#excessTime").modal("show");
					} else if ($scope.timesheet.doubleOvertimeHours > 20) {
						$scope.excessTimeEntered = {
							hours : $scope.timesheet.doubleOvertimeHours,
							category : i8nConstants.DOUBLE_TIME
						};
						angular.element("#excessTime").modal("show");
					} else {
						$scope.commitTimesheet("Save");
					}
				};

				$scope.commitTimesheet = function(type) {
					$scope.checkValidTime = false;
					let results = timesheetServices.submitTimesheet($scope.timesheet, type, employeeServices
							.getProdcertName());
					apiServices.cudAPI(results.url, results.params).then(function(response) {
						$scope.timesheet.nID = response[0].data;
						if (type === "Submit") {
							$scope.timesheet.isSubmitted = true;
							$scope.timesheet.sRequestStatus = "Submitted";
							angular.element("#timesheet_submitted").modal("show");
							for (var i = 0; i < $scope.timesheet.data.length; i++) {
								$scope.timesheet.data[i].selectColor = TIMESHEET_CONSTANTS.DISABLED_COLOR;
								$scope.timesheet.data[i].cursor = TIMESHEET_CONSTANTS.CURSOR_DISABLED;
							}
						} else if (type === "Save") {
							$scope.timesheet.disableSubmitUntilSaved = false;
							angular.element("#timesheet_saved").modal("show");
						}
					}, function(resp) {
						if (resp.printError === true) {
							Utils.displayError();
						}
					});
				};
				$scope.clickonWeeksList = function(event) {
					if (!angular.element(event.target.parentElement).hasClass('open')) {
						$scope.showLists.showWeekList = false;
						$timeout(function() {
							$scope.showLists.showWeekList = true;
						});
					}
				};

			} ]);
})();