(function() {
	app.controller("timeSheetHistoryCtrl", [
			"$scope",
			"$filter",
			"Utils",
			"apiServices",
			"holidayService",
			"employeeServices",
			"messagesAndPopupServices",
			"i8nConstants",
			"TIMESHEET_CONSTANTS",
			"timesheetServices",
			function($scope, $filter, Utils, apiServices, holidayService, employeeServices, messagesAndPopupServices,
					i8nConstants, TIMESHEET_CONSTANTS, timesheetServices) {

				$scope.TIMESHEET_CONSTANTS = TIMESHEET_CONSTANTS;
				$scope.weekDays = [ "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" ];
				$scope.Msg = {
					monthFilterMsg : i8nConstants.FILTER_BY_MONTH,
					yearFilterMsg : i8nConstants.FILTER_BY_YEAR,
					statusFilterMsg : i8nConstants.FILTER_BY_STATUS
				};
				$scope.timeoffFilter = {
					requestStatus : "",
					requestMonth : "",
					requestYear : new Date().getFullYear()
				};
				$scope.dropDownCtrl = {
					year : false,
					month : false,
					status : false
				};
				$scope.reason = "";
				$scope.timesheetsHistory = [];
				$scope.filteredData = [];
				$scope.filterContents = {
					yearFilterContents : [],
					monthFilterContents : [],
					statusFilterContents : []
				};
				$scope.loadingFlag = true;
				$scope.showMore = false;
				var currentTimesheetDetails = {};
				var reloadData = false;

				$scope.getData = function() {
					$scope.timesheetsHistory = [];
					$scope.filteredData = [];
					$scope.loadingFlag = true;
					var yearList = holidayService.getYearList();
					//$scope.filterContents.yearFilterContents = yearList;
					var data = {
						"alias" : employeeServices.getProdcertName(),
						"startdate" : Utils.respDateFormat("01/01/" + yearList[0], true),
						"enddate" : Utils.respDateFormat("12/31/" + yearList[yearList.length - 1], true)
					};
					employeeServices.getHistory(data, reloadData).then(function(response) {
						$scope.loadingFlag = false;
						reloadData = false;
						$scope.timesheetsHistory = response;
						processTimesheetsHistory();
					}, function(resp) {
						if (resp.printError === true) {
							Utils.displayError();
						}
						$scope.timesheetsHistory = [];
						$scope.loadingFlag = false;
					});

				};

				function processTimesheetsHistory() {
					var monthname = [
							'January',
							'February',
							'March',
							'April',
							'June',
							'July',
							'August',
							'September',
							'October',
							'November',
							'December' ];

					if ($scope.timesheetsHistory) {
						for (var i = 0; i < $scope.timesheetsHistory.length; i++) {
							var nextDate = new Date($scope.timesheetsHistory[i].weekStart);
							var weekEnd = angular.copy(nextDate);
							weekEnd.setDate(weekEnd.getDate() + 6);
							$scope.timesheetsHistory[i].weekEnd = weekEnd;
							$scope.timesheetsHistory[i].weekStart = new Date($scope.timesheetsHistory[i].weekStart);

							var year = new Date($scope.timesheetsHistory[i].weekStart).getFullYear();
							if ($scope.filterContents.yearFilterContents.indexOf(year) === -1) {
								$scope.filterContents.yearFilterContents.push(year);
							}

							var status = $scope.timesheetsHistory[i].sRequestStatus;
							if ($scope.filterContents.statusFilterContents.indexOf(status) === -1) {
								$scope.filterContents.statusFilterContents.push(status);
							}
							var month = monthname[new Date($scope.timesheetsHistory[i].weekStart).getMonth()];
							if ($scope.filterContents.monthFilterContents.indexOf(month) === -1) {
								$scope.filterContents.monthFilterContents.push(month);
							}
							month = monthname[new Date($scope.timesheetsHistory[i].weekEnd).getMonth()];
							if ($scope.filterContents.monthFilterContents.indexOf(month) === -1) {
								$scope.filterContents.monthFilterContents.push(month);
							}
						}

						$scope.filterContents.statusFilterContents.sort();
						$scope.filterContents.monthFilterContents.sort();
						$scope.filterContents.yearFilterContents.sort();
						$scope.filteredData = $filter('timeSheetHistoryFilter')($scope.timesheetsHistory,
								$scope.timeoffFilter);
					}
				}

				$scope.preventPropagation = function(event) {
					event.stopPropagation();
				};

				$scope.statusFilter = function(status) {
					$scope.Msg.statusFilterMsg = status;
					$scope.timeoffFilter.requestStatus = (status === i8nConstants.ALL ? "" : status);
					$scope.filteredData = $filter('timeSheetHistoryFilter')($scope.timesheetsHistory,
							$scope.timeoffFilter);
					$scope.dropDownCtrl.status = false;
				};

				$scope.monthFilter = function(month) {
					$scope.Msg.monthFilterMsg = month;
					$scope.timeoffFilter.requestMonth = (month === i8nConstants.ALL ? "" : month);
					$scope.filteredData = $filter('timeSheetHistoryFilter')($scope.timesheetsHistory,
							$scope.timeoffFilter);
					$scope.dropDownCtrl.month = false;
				};

				$scope.yearFilter = function(year) {
					$scope.Msg.yearFilterMsg = year;
					$scope.timeoffFilter.requestYear = (year === i8nConstants.ALL ? "" : year);
					$scope.filteredData = $filter('timeSheetHistoryFilter')($scope.timesheetsHistory,
							$scope.timeoffFilter);
					$scope.dropDownCtrl.year = false;
				};

				$scope.displayTimeSheetDetails = function(displayData) {
					//to enable submit from popup
					currentTimesheetDetails = displayData;
					$scope.info = messagesAndPopupServices.displayTimeSheetDetails(displayData);
					$scope.showMore = false;
				};

				$scope.displayConfirmation = function(data) {
					currentTimesheetDetails = data;
				};
				$scope.moreInfo = function() {
					$scope.showMore = !$scope.showMore;
				};
				$scope.submitTimesheet = function() {
					//submit data
					currentTimesheetDetails.totalHours = currentTimesheetDetails.regularHours +
							currentTimesheetDetails.overtimeHours + currentTimesheetDetails.doubleOvertimeHours;
					let results = timesheetServices.submitTimesheet(currentTimesheetDetails, "Submit", employeeServices
							.getProdcertName());
					apiServices.cudAPI(results.url, results.params).then(function(response) {
						angular.element("#timesheet_submitted").modal("show");
						reloadData = true;
						$scope.getData();
					}, function(resp) {
						if (resp.printError === true) {
							Utils.displayError();
						}
					});

				};
				$scope.cancelTimesheet = function() {
					//id of timesheet to cancel
					var url = employeeServices.getUrlObj().deleteTimesheet;
					var params = {
						sComments : $scope.reason,
						nID : currentTimesheetDetails.nID,
						sRequestor : employeeServices.getProdcertName()
					};
					apiServices.cudAPI(url, params).then(function(response) {
						$scope.reason = "";
						angular.element("#timesheet_cancelled").modal("show");
						reloadData = true;
						$scope.getData();
					}, function(resp) {
						if (resp.printError === true) {
							Utils.displayError();
						}
					});

				};

			} ]);
})();