(function() {
	app.controller("submitTimeSheetForOthersCtrl", [
			"$scope",
			"$timeout",
			"$anchorScroll",
			"$filter",
			"Utils",
			"employeeServices",
			"apiServices",
			"timesheetServices",
			"timeCalculationServices",
			"messagesAndPopupServices",
			"TIMESHEET_CONSTANTS",
			"i8nConstants",
			function($scope, $timeout, $anchorScroll, $filter, Utils, employeeServices, apiServices, timesheetServices,
					timeCalculationServices, messagesAndPopupServices, TIMESHEET_CONSTANTS, i8nConstants) {

				$scope.TIMESHEET_CONSTANTS = TIMESHEET_CONSTANTS;

				// to fill dropdown
				$scope.empList = [];
				$scope.dateInfo = [];
				$scope.timesheet = {};
				$scope.excessTimeEntered = {};
				$scope.noData = true;
				$scope.editFlag = false;
				$scope.loadingFlag = false;
				$scope.checkValidTime = false;
				$scope.noDataEnteredMsg = false;
				$scope.dateOfDisabledRow = "";
				var regionNameOfEmp = "";
				var statusDetails = {};
				var disableRowPos = "";
				var empProdcertname = "";
				$scope.showLists = {
					showWeekList : false,
					showEmpList : false,
					employeeName : ""
				};
				$scope.closeAlertMessage = function() {
					$scope.noDataEnteredMsg = false;
				};

				$scope.preventPropagation = function(event) {
					event.stopPropagation();
				};

				$scope.initData = function() {
					$scope.empList = [];
					apiServices.getListingObjArray("EmployeeNames").then(function(response) {
						$scope.empList = response;
						$scope.filteredEmpList = angular.copy(response);
						$scope.filteredEmpList = $filter('orderBy')($scope.filteredEmpList, 'sEmpName');
					}, function(resp) {
						if (resp.printError === true) {
							Utils.displayError();
						}
						$scope.empList = [];
						$scope.filteredEmpList = [];
					});
				};

				$scope.employeeChanged = function(employeeDetails) {
					$scope.noData = true;
					$scope.dateInfo = [];
					$scope.timesheet = {};
					$scope.showLists.showEmpList = false;
					$scope.showLists.employeeName = employeeDetails.sEmpName;
					empProdcertname = employeeDetails.ProdcertName;
					regionNameOfEmp = employeeServices.getLocationName(employeeDetails.nLocationID);
					statusDetails = {
						"status" : employeeDetails.status,
						"overtimeStatus" : employeeDetails.overtimeStatus,
						"workState" : employeeDetails.workState,
						"isAuthorized" : employeeDetails.isAuthorized
					};

					if (employeeDetails.isAuthorized === true) {
						var date = new Date();
						var startDate = date.getDate() - ((date.getDay() + 1) % 7); //find the saturday date from current day

						for (var i = 0; i < TIMESHEET_CONSTANTS.NO_OF_WEEKS_TO_SUBMIT; i++) {
							var endDate = startDate + 6;
							var weekStart = new Date(new Date(date).setDate(startDate));
							var weekEnd = new Date(new Date(date).setDate(endDate));
							$scope.dateInfo.push({
								"weekStart" : weekStart,
								"weekEnd" : weekEnd,
								"name" : employeeDetails.ProdcertName
							});
							date = new Date(weekStart);
							date.setDate(weekStart.getDate() - 7);
							startDate = date.getDate();
						}
						$scope.weekChanged($scope.dateInfo[0]);
					} else if (employeeDetails.status) {
						if (employeeDetails.status.weeks) {
							for (var i = 0; i < employeeDetails.status.weeks.length; i++) {
								var startDate = new Date(employeeDetails.status.weeks[i]);
								var endDate = startDate.getDate() + 6;
								var weekEnd = new Date(new Date(startDate).setDate(endDate));
								$scope.dateInfo.push({
									"weekStart" : startDate,
									"weekEnd" : weekEnd,
									"name" : employeeDetails.ProdcertName
								});
							}
							$scope.weekChanged($scope.dateInfo[0]);
						}
					}
				};

				$scope.weekChanged = function(data) {
					$scope.showLists.showWeekList = false;
					var params = {
						"alias" : data.name,
						"startdate" : Utils.respDateFormat(new Date(data.weekStart), true),
						"enddate" : Utils.respDateFormat(new Date(data.weekEnd), true)
					};
					var url = employeeServices.getUrlObj().getTimesheetsHistory;
					$scope.loadingFlag = true;
					$scope.noData = true;
					$scope.timesheet = {};

					apiServices.cudAPI(url, params).then(function(response) {
						$scope.loadingFlag = false;
						$scope.timesheet = timesheetServices.getTimesheetDetails(response,
								data,
								statusDetails,
								regionNameOfEmp);
						$scope.statusInfo = messagesAndPopupServices.showSubmitPageMessages(data, statusDetails);
						if ($scope.timesheet) {
							$scope.noData = false;
						}
					},
							function(resp) {
								$scope.loadingFlag = false;
								if (resp.printError === true) {
									Utils.displayError();
								}
								$scope.timesheet = null;
							});

				};

				$scope.getDisabledRowData = function(pos) {
					$scope.dateOfDisabledRow = $scope.timesheet.data[pos].date;
					disableRowPos = pos;
					if ($scope.timesheet.data[pos].checkboxValue === true) {
						angular.element("#worked_offDay").modal("show");
					} else {
						$scope.disableOffDayRow();
					}
				};

				$scope.enableOffDayRow = function() {
					timesheetServices.enableOffDayRow($scope.timesheet, disableRowPos);
				};

				$scope.disableOffDayRow = function() {
					timesheetServices.disableOffDayRow($scope.timesheet, disableRowPos);
					timeCalculationServices.updateTimesheetTime(disableRowPos, $scope.timesheet, statusDetails);
				};

				$scope.getSickDayRowData = function(pos) {
					$scope.dateOfDisabledRow = $scope.timesheet.data[pos].date;
					$scope.timesheet.data[pos].checkboxValue = false;
					disableRowPos = pos;
					if ($scope.timesheet.data[pos].sickDay === true) {
						angular.element("#worked_sickDay").modal("show");
					} else {
						$scope.disableSickDayRow();
					}
				};

				$scope.enableSickDayRow = function() {
					timesheetServices.sickDayRowEnableDisable($scope.timesheet, disableRowPos, statusDetails, true);
				};

				$scope.disableSickDayRow = function() {
					timesheetServices.sickDayRowEnableDisable($scope.timesheet, disableRowPos, statusDetails, false);
				};

				$scope.updateTime = function(pos) {
					timeCalculationServices.updateTimesheetTime(pos, $scope.timesheet, statusDetails);
				};

				$scope.saveTimesheet = function() {
					var i = 0;
					$scope.checkValidTime = true;
					if ($scope.timesheet) {
						if ($scope.timesheet.data) {
							for (i = 0; i < $scope.timesheet.data.length; i += 1) {
								if ($scope.timesheet.data[i].invalidTime === true) {
									break;
								}
							}
							if (i < $scope.timesheet.data.length) {
								angular.element("#invalid_hours_entered").modal("show");
							} else if ($scope.timesheet.totalHours === 0) {
								$anchorScroll();
								$scope.noDataEnteredMsg = true;
								$timeout(function() {
									$scope.noDataEnteredMsg = false;
								}, 3000);
								return;
							} else if ($scope.timesheet.overtimeHours > 20) {
								$scope.excessTimeEntered = {
									hours : $scope.timesheet.overtimeHours,
									category : i8nConstants.OVERTIME
								};
								angular.element("#excessTime").modal("show");
							} else if ($scope.timesheet.doubleOvertimeHours > 20) {
								$scope.excessTimeEntered = {
									hours : $scope.timesheet.doubleOvertimeHours,
									category : i8nConstants.DOUBLE_TIME
								};
								angular.element("#excessTime").modal("show");
							} else {
								$scope.commitTimesheet("Save");
							}
						} else {
							$scope.noDataEnteredMsg = true;
							$timeout(function() {
								$scope.noDataEnteredMsg = false;
							}, 3000);
							return;
						}
					} else {
						$scope.noDataEnteredMsg = true;
						$timeout(function() {
							$scope.noDataEnteredMsg = false;
						}, 3000);
						return;
					}
				};

				$scope.commitTimesheet = function(type) {
					$scope.checkValidTime = false;
					let results = timesheetServices.submitTimesheet($scope.timesheet, type, empProdcertname);
					apiServices.cudAPI(results.url, results.params).then(function(response) {
						$scope.timesheet.nID = response[0].data;
						if (type === "Submit") {
							$scope.timesheet.isSubmitted = true;
							$scope.timesheet.sRequestStatus = "Submitted";
							angular.element("#timesheet_submitted").modal("show");
							for (var i = 0; i < $scope.timesheet.data.length; i++) {
								$scope.timesheet.data[i].selectColor = TIMESHEET_CONSTANTS.DISABLED_COLOR;
								$scope.timesheet.data[i].cursor = TIMESHEET_CONSTANTS.CURSOR_DISABLED;
							}
						} else if (type === "Save") {
							$scope.timesheet.disableSubmitUntilSaved = false;
							angular.element("#timesheet_saved").modal("show");
						}
					}, function(resp) {
						if (resp.printError === true) {
							Utils.displayError();
						}
					});
				};
				$scope.clickonWeeksList = function(event) {
					if (!angular.element(event.target.parentElement).hasClass('open')) {
						$scope.showLists.showWeekList = false;
						$timeout(function() {
							$scope.showLists.showWeekList = true;
						});
					}
				};
				$scope.clickonEmpNameList = function(event) {
					if (!angular.element(event.target.parentElement).hasClass('open')) {
						$scope.showLists.showEmpList = false;
						$timeout(function() {
							$scope.showLists.showEmpList = true;
						});
					}
					$scope.filteredEmpList = $filter('orderBy')($scope.empList, 'sEmpName');
				};
				$scope.keypressEmpNameList = function(event) {
					$scope.noData = true;
					empProdcertname = "";
					$scope.timesheet = {};
					$scope.dateInfo = [];
					$scope.filteredEmpList = $filter('filter')($scope.empList, {
						"sEmpName" : $scope.showLists.employeeName
					});
					$scope.filteredEmpList = $filter('orderBy')($scope.filteredEmpList, 'sEmpName');
					if (!angular.element(event.target.parentElement).hasClass('open')) {
						$scope.showLists.showEmpList = false;
						$timeout(function() {
							$scope.showLists.showEmpList = true;
						});
					}
					event.stopPropagation();
				};

			} ]);
})();