(function() {
	app.controller("dateCtrl", [ "$scope", function($scope) {

		$scope.format = 'dd-MMMM-yyyy';
		$scope.dateOptions = {
			formatYear : 'yy',
			startingDay : 6
		};

		$scope.startDate = {
			opened : false
		};

		$scope.endDate = {
			opened : false
		};

		$scope.$on('editDates', function(event, startDate, endDate) {
			$scope.startdate = startDate !== "" ? new Date(startDate) : "";
			$scope.enddate = endDate !== "" ? new Date(endDate) : "";
			if ($scope.startdate && $scope.enddate) {
				$scope.minDate = $scope.startdate;
			}
		});

		$scope.openStartDate = function($event) {
			if (!$scope.startdate) {
				$scope.startdate = new Date(new Date().toDateString() + " 00:00:00");
				$scope.minDate = $scope.startdate;
				$scope.$emit('startDateChanged', $scope.startdate);
			}
			$scope.startDate.opened = true;
			$scope.endDate.opened = false;
			if ($scope.enddate) {
				if ($scope.startdate && $scope.startdate > $scope.enddate) {
					$scope.enddate = $scope.startdate;
					$scope.$emit('endDateChanged', $scope.enddate);
				}
			} else {
				$scope.enddate = undefined;
			}
		};

		$scope.openEndDate = function($event) {
			$scope.minDate = $scope.startdate;
			$scope.endDate.opened = true;
			$scope.startDate.opened = false;
			if (!$scope.enddate && $scope.startdate) {
				$scope.enddate = $scope.startdate;
				$scope.$emit('endDateChanged', $scope.enddate);
			}
		};

		$scope.selStartDate = function() {
			$scope.minDate = $scope.startdate;
			$scope.startDate.opened = false;
			$scope.$emit('startDateChanged', $scope.startdate);
			if (($scope.startdate && $scope.startdate > $scope.enddate) || (!$scope.enddate)) {
				$scope.enddate = $scope.startdate;
				$scope.$emit('endDateChanged', $scope.enddate);
			}
		};

		$scope.selEndDate = function() {
			$scope.$emit('endDateChanged', $scope.enddate);
			$scope.endDate.opened = false;
			if (($scope.enddate && $scope.startdate > $scope.enddate) || (!$scope.startdate)) {
				$scope.startdate = $scope.enddate;
				$scope.minDate = $scope.startdate;
				$scope.$emit('startDateChanged', $scope.startdate);
			}
		};
	} ])
}());