(function() {
	app.controller("autoApproveCtrl",
			[
					"$scope",
					"$routeParams",
					"$rootScope",
					"employeeServices",
					"i8nConstants",
					"apiServices",
					function($scope, $routeParams, $rootScope, employeeServices, i8nConstants, apiServices) {
						$scope.i8nConstants = i8nConstants;
						var url = "";
						var requestBody = {};

						$scope.initData = function() {
							$scope.heading = i8nConstants.APPROVE_TIMESHEETS;
							requestBody = {
								nID : $routeParams.id,
								sApproverComments : ""
							};
							if ($routeParams.action === "Approve") {
								$scope.alertMessage = i8nConstants.TIMESHEET_IS_BEING_PROCESSED_PLEASE_WAIT;
								$scope.heading = i8nConstants.APPROVE_TIMESHEETS;
								requestBody.sApproverComments = "Approved Via Email";
								url = employeeServices.getUrlObj().approveTimesheet;
								processTimesheet();
							} else if ($routeParams.action === "Reject") {
								$scope.heading = i8nConstants.REJECT_TIMESHEETS;
								requestBody.sApproverComments = "Rejected Via Email";
								url = employeeServices.getUrlObj().rejectTimesheet;
								angular.element("#timesheet_reject").modal("show");
							} else {
								$scope.alertMessage = i8nConstants.INVALID_OPERATION_ON_TIMESHEET;
								return;
							}

						};

						$scope.rejectTimesheetCheck = function() {
							if (!$scope.rejectReason) {
								$scope.error = true;
							} else {
								requestBody.sApproverComments = requestBody.sApproverComments + '. ' +
										$scope.rejectReason;
								$scope.alertMessage = i8nConstants.TIMESHEET_IS_BEING_PROCESSED_PLEASE_WAIT;
								angular.element("#timesheet_reject").modal("hide");
								processTimesheet();
							}

						};

						$scope.cancelRejectAction = function() {
							$scope.alertMessage = i8nConstants.UNABLE_TO_REJECT_TIMESHEET + ' ' +
									i8nConstants.PLEASE_TRY_AGAIN;
						};

						function processTimesheet() {
							apiServices.cudAPI(url, requestBody).then(function(response) {
								$rootScope.basicAuthInfo = {};
								if (response) {
									if (response[0].sEmpName) {
										$rootScope.basicAuthInfo.empName = response[0].sEmpName;
									}
								}
								angular.element("#approvingTimesheet").modal("hide");
								if ($routeParams.action === 'Approve') {
									$scope.alertMessage = i8nConstants.TIMESHEET_APPROVED_SUCCESSFULLY;
								} else if ($routeParams.action === 'Reject') {
									$scope.alertMessage = i8nConstants.TIMESHEET_REJECTED_SUCCESSFULLY;
								}
							},
									function(response) {
										$rootScope.basicAuthInfo = {};
										if (response) {
											if (response[0].sEmpName) {
												$rootScope.basicAuthInfo.empName = response[0].sEmpName;
											}
										}
										if ($routeParams.action === 'Approve') {
											$scope.alertMessage = i8nConstants.UNABLE_TO_APPROVE_TIMESHEET + ' ' +
													i8nConstants.PLEASE_TRY_AGAIN;
										} else if ($routeParams.action === 'Reject') {
											$scope.alertMessage = i8nConstants.UNABLE_TO_REJECT_TIMESHEET + ' ' +
													i8nConstants.PLEASE_TRY_AGAIN;
										}
									});
						}
					} ]);
})();