(function() {
	app.controller("approveTimeSheetsCtrl", [
			"$scope",
			"TIMESHEET_CONSTANTS",
			"i8nConstants",
			"$timeout",
			"$filter",
			"$anchorScroll",
			"employeeServices",
			"Utils",
			"$location",
			"apiServices",
			"messagesAndPopupServices",
			function($scope, TIMESHEET_CONSTANTS, i8nConstants, $timeout, $filter, $anchorScroll, employeeServices,
					Utils, $location, apiServices, messagesAndPopupServices) {
				$scope.TIMESHEET_CONSTANTS = TIMESHEET_CONSTANTS;
				$scope.Msg = {
					locationFilterMsg : i8nConstants.FILTER_BY_LOCATION
				};

				var prodcertName = employeeServices.getProdcertName();

				$scope.weekDays = [ "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" ];

				$scope.pendingTimesheets = [];
				$scope.approvedTimesheets = [];
				$scope.rejectedTimesheets = [];
				$scope.filteredpendingTimesheets = [];
				$scope.filteredapprovedTimesheets = [];
				$scope.filteredrejectedTimesheets = [];

				$scope.filteredCountryName = [];
				$scope.filterCountriesId = [];
				$scope.filteredEmpName = [];
				$scope.filterEmpId = [];
				$scope.excessTimeEntered = {};
				$scope.showApprovedListTab = true;

				$scope.locationsList = {
					show : false,
					name : "",
					filteredData : ""
				};
				$scope.empList = {
					show : false,
					name : "",
					filteredData : ""
				};

				$scope.alertMessage = "";
				$scope.pageSizeList = [ 'All', 5, 10, 20, 50 ];
				var currentTimesheetDetails = {};
				$scope.closeAlertMessage = function() {
					$scope.alerts = {
						success : false,
						failure : false
					};
				};
				$scope.showMore = false;
				$scope.regionList = employeeServices.getLocationsList();

				$scope.initData = function() {
					$scope.employeeList = [];
					apiServices.getListingObjArray("ManagersEmployee").then(function(response) {
						$scope.employeeList = response;
						$scope.clickOnAllEmpCheckbox(true);
						$scope.clickOnAllLocationsChkbx(true);
					}, function(resp) {
						if (resp.printError === true) {
							Utils.displayError();
						}
						$scope.employeeList = [];
					});
					$scope.fetchAllList();
					$scope.closeAlertMessage();
				};

				$scope.fetchAllList = function() {
					$scope.currentPage = {
						pending : 1,
						approved : 1,
						rejected : 1
					};
					$scope.pageSize = {
						pending : 10,
						approved : 10,
						rejected : 10
					};
					$scope.paginationPageSize = {
						pending : 10,
						approved : 10,
						rejected : 10
					};
					$scope.pageChangedPending(1);
					$scope.approvedPageChanged(1);
					$scope.rejectedPageChanged(1);
				};

				$scope.valueChanged = function(type) {
					if (type === 'Pending') {
						if ($scope.pageSize.pending === 'All') {
							$scope.paginationPageSize.pending = $scope.pendingListCount;
						} else {
							$scope.paginationPageSize.pending = $scope.pageSize.pending;
						}
					} else if (type === 'Approved') {
						if ($scope.pageSize.approved === 'All') {
							$scope.paginationPageSize.approved = $scope.approvedListCount;
						} else {
							$scope.paginationPageSize.approved = $scope.pageSize.approved;
						}
					} else if (type === 'Rejected') {
						if ($scope.pageSize.rejected === 'All') {
							$scope.paginationPageSize.rejected = $scope.rejectedListCount;
						} else {
							$scope.paginationPageSize.rejected = $scope.pageSize.rejected;
						}
					}
				};

				$scope.pageChangedPending = function(newPage) {
					$scope.pendingTimesheets = [];
					$scope.filteredpendingTimesheets = [];
					$scope.pendingListCount = -1;

					var params = {
						"alias" : prodcertName,
						"status" : "submitted",
						"pageno" : newPage,
						"pageSize" : $scope.paginationPageSize.pending
					};
					if ($scope.filterCountriesId.length && $scope.filterCountriesId.length < $scope.regionList.length) {
						params.locations = $scope.filterCountriesId;
					}
					if ($scope.filterEmpId.length && $scope.filterEmpId.length < $scope.employeeList.length) {
						params.empIds = $scope.filterEmpId.toString();
					}

					var url = employeeServices.getUrlObj().pendingTimesheets;
					apiServices.cudAPI(url, params).then(function(response) {
						if (response[0].data === null) {
							response[0].data = [ {
								"MyTimesheetApprovals" : [],
								"TotalTimesheetCount" : 0
							} ];
						}

						response = response[0].data[0];
						$scope.pendingTimesheets = response.MyTimesheetApprovals;
						$scope.pendingListCount = response.TotalTimesheetCount;
						for ( var indx in $scope.pendingTimesheets) {
							var nextDate = new Date($scope.pendingTimesheets[indx].weekStart);
							var weekEnd = angular.copy(nextDate);
							weekEnd.setDate(weekEnd.getDate() + 6);
							$scope.pendingTimesheets[indx].weekEnd = weekEnd;
							$scope.pendingTimesheets[indx].weekStart = new Date(
									$scope.pendingTimesheets[indx].weekStart);
							$scope.pendingTimesheets[indx].totalHours = $scope.pendingTimesheets[indx].regularHours +
									$scope.pendingTimesheets[indx].overtimeHours +
									$scope.pendingTimesheets[indx].doubleOvertimeHours;

							$scope.pendingTimesheets[indx].error = false;
						}

						if ($scope.pageSize.pending === 'All') {
							$scope.paginationPageSize.pending = $scope.pendingListCount;
						}
					},
							function(resp) {
								if (resp.printError === true) {
									Utils.displayError();
								}
							});

				};
				$scope.approvedPageChanged = function(newPage) {

					$scope.approvedTimesheets = [];
					$scope.filteredapprovedTimesheets = [];
					$scope.approvedListCount = -1;

					var params = {
						"alias" : employeeServices.getProdcertName(),
						"status" : "approved",
						"pageno" : newPage,
						"pageSize" : $scope.paginationPageSize.approved
					};
					if ($scope.filterCountriesId.length && $scope.filterCountriesId.length < $scope.regionList.length) {
						params.locations = $scope.filterCountriesId;
					}
					if ($scope.filterEmpId.length && $scope.filterEmpId.length < $scope.employeeList.length) {
						params.empIds = $scope.filterEmpId.toString();
					}

					var url = employeeServices.getUrlObj().pendingTimesheets;
					apiServices.cudAPI(url, params).then(function(response) {
						if (response[0].data === null) {
							response[0].data = [ {
								"MyTimesheetApprovals" : [],
								"TotalTimesheetCount" : 0
							} ];
						}
						response = response[0].data[0];
						$scope.approvedTimesheets = response.MyTimesheetApprovals;
						$scope.approvedListCount = response.TotalTimesheetCount;
						for ( var indx in $scope.approvedTimesheets) {
							var nextDate = new Date($scope.approvedTimesheets[indx].weekStart);
							var weekEnd = angular.copy(nextDate);
							weekEnd.setDate(weekEnd.getDate() + 6);
							$scope.approvedTimesheets[indx].weekEnd = weekEnd;
							$scope.approvedTimesheets[indx].weekStart = new Date(
									$scope.approvedTimesheets[indx].weekStart);
							$scope.approvedTimesheets[indx].totalHours = $scope.approvedTimesheets[indx].regularHours +
									$scope.approvedTimesheets[indx].overtimeHours +
									$scope.approvedTimesheets[indx].doubleOvertimeHours;
							$scope.approvedTimesheets[indx].error = false;
						}

						if ($scope.pageSize.approved === 'All') {
							$scope.paginationPageSize.approved = $scope.approvedListCount;
						}

					},
							function(resp) {
								if (resp.printError === true) {
									Utils.displayError();
								}
							});

				};
				$scope.rejectedPageChanged = function(newPage) {

					$scope.rejectedTimesheets = [];
					$scope.filteredrejectedTimesheets = [];
					$scope.rejectedListCount = -1;

					var params = {
						"alias" : employeeServices.getProdcertName(),
						"status" : "rejected",
						"pageno" : newPage,
						"pageSize" : $scope.paginationPageSize.rejected
					};
					if ($scope.filterCountriesId.length && $scope.filterCountriesId.length < $scope.regionList.length) {
						params.locations = $scope.filterCountriesId;
					}
					if ($scope.filterEmpId.length && $scope.filterEmpId.length < $scope.employeeList.length) {
						params.empIds = $scope.filterEmpId.toString();
					}

					var url = employeeServices.getUrlObj().pendingTimesheets;
					apiServices.cudAPI(url, params).then(function(response) {
						if (response[0].data === null) {
							response[0].data = [ {
								"TimeSheets" : [],
								"TotalTimesheetCount" : 0
							} ];
						}
						response = response[0].data[0];
						$scope.rejectedTimesheets = response.MyTimesheetApprovals;
						$scope.rejectedListCount = response.TotalTimesheetCount;
						for ( var indx in $scope.rejectedTimesheets) {
							var nextDate = new Date($scope.rejectedTimesheets[indx].weekStart);
							var weekEnd = angular.copy(nextDate);
							weekEnd.setDate(weekEnd.getDate() + 6);
							$scope.rejectedTimesheets[indx].weekEnd = weekEnd;
							$scope.rejectedTimesheets[indx].weekStart = new Date(
									$scope.rejectedTimesheets[indx].weekStart);
							$scope.rejectedTimesheets[indx].error = false;
						}
						if ($scope.pageSize.rejected === 'All') {
							$scope.paginationPageSize.rejected = $scope.rejectedListCount;
						}

					},
							function(resp) {
								if (resp.printError === true) {
									Utils.displayError();
								}
							});

				};

				$scope.preventPropagation = function(event) {
					event.stopPropagation();
				};

				$scope.displayTimeSheetDetails = function(displayData) {
					//to enable submit from popup
					currentTimesheetDetails = displayData;
					$scope.info = messagesAndPopupServices.displayTimeSheetDetails(displayData);
					$scope.info.error = false;
					$scope.showMore = false;
				};

				$scope.updateCommentsOnClose = function() {
					currentTimesheetDetails.sApproverComments = $scope.info.sApproverComments;
				};

				$scope.approveFromTable = function(data) {
					data.error = false;
					currentTimesheetDetails = data;
					ifExcessOT(currentTimesheetDetails);
				};

				$scope.approveFromDetailsPopup = function() {
					$scope.info.error = false;
					currentTimesheetDetails.sApproverComments = $scope.info.sApproverComments;
					ifExcessOT(currentTimesheetDetails);
				};

				function ifExcessOT(data) {
					if (data.overtimeHours > 20) {
						$scope.excessTimeEntered = {
							hours : data.overtimeHours,
							category : "Overtime"
						};
						angular.element("#excessTime").modal("show");
					} else if (data.doubleOvertimeHours > 20) {
						$scope.excessTimeEntered = {
							hours : data.doubleOvertimeHours,
							category : "Double Overtime"
						};
						angular.element("#excessTime").modal("show");
					} else {
						angular.element("#timesheet_approval").modal("show");
					}
				}

				$scope.rejectFromTable = function(data) {
					if (data.sApproverComments) {
						data.error = false;
						currentTimesheetDetails = data;
						$("#timesheet_reject").modal("show");
					} else {
						data.error = true;
					}
				};

				$scope.rejectFromDetailsPopup = function() {
					if (!$scope.info.sApproverComments) {
						$scope.info.error = true;
					} else {
						$scope.info.error = false;
						currentTimesheetDetails.sApproverComments = $scope.info.sApproverComments;
						$("#timesheet_info").modal("hide");
						$("#timesheet_reject").modal("show");
					}
				};

				$scope.rejectApprovedFromTable = function(data) {
					$scope.error = false;
					currentTimesheetDetails = data;
					$scope.rejectReason = data.sApproverComments;
				};

				$scope.rejectApprovedFromDetailsPopup = function() {
					$scope.error = false;
					$scope.rejectReason = currentTimesheetDetails.sApproverComments;
				};

				$scope.rejectApprovedTimesheet = function() {
					if ($scope.rejectReason) {
						$scope.error = false;
						currentTimesheetDetails.sApproverComments = $scope.rejectReason;
						$("#timesheet_rejectApproved").modal("hide");
						$scope.processTimesheet("Reject");
					} else {
						$scope.error = true;
					}
				};

				$scope.processTimesheet = function(type) {

					var url = "";
					var requestBody = {
						nID : currentTimesheetDetails.nID,
						sApproverComments : currentTimesheetDetails.sApproverComments
					};
					if (type === "Approve") {
						url = employeeServices.getUrlObj().approveTimesheet;
					} else if (type === "Reject") {
						url = employeeServices.getUrlObj().rejectTimesheet;
					}
					apiServices.cudAPI(url, requestBody).then(function() {
						$scope.rejectReason = "";
						if (type === 'Approve') {
							$scope.alertMessage = i8nConstants.TIMESHEET_APPROVED_SUCCESSFULLY;
						} else {
							$scope.alertMessage = i8nConstants.TIMESHEET_REJECTED_SUCCESSFULLY;
						}
						$scope.alerts.success = true;
						$anchorScroll();
						$scope.fetchAllList();
						$timeout(function() {
							$scope.alerts.success = false;
						}, 3000);
					},
							function(response) {
								if (response) {
									if (response[0].error === null && response.printError === true) {
										if (type === 'Approve') {
											$scope.alertMessage = i8nConstants.UNABLE_TO_APPROVE_TIMESHEET + ' ' +
													i8nConstants.PLEASE_TRY_AGAIN;
										} else {
											$scope.alertMessage = i8nConstants.UNABLE_TO_REJECT_TIMESHEET + ' ' +
													i8nConstants.PLEASE_TRY_AGAIN;
										}
										$scope.alerts.failure = true;
										$anchorScroll();
										$timeout(function() {
											$scope.alerts.failure = false;
										}, 3000);
									}
								}
							});
				};

				$scope.clickonLocationsList = function(event) {
					if (!angular.element(event.target.parentElement).hasClass('open')) {
						$scope.locationsList.show = false;
						$timeout(function() {
							$scope.locationsList.show = true;
						});
					}
					$scope.locationsList.filteredData = $scope.regionList;
				};

				$scope.keypressLocationsList = function(event) {
					$scope.locationsList.filteredData = $filter('filter')($scope.regionList, {
						'sRegionName' : $scope.locationsList.name
					});
					$scope.locationsList.filteredData = $filter('orderBy')($scope.locationsList.filteredData,
							'sRegionName');
					if (!angular.element(event.target.parentElement).hasClass('open')) {
						$scope.locationsList.show = false;
						$timeout(function() {
							$scope.locationsList.show = true;
						});
					}
				};

				$scope.addLocation = function(region, event) {
					$scope.locationsList.name = "";
					if ($scope.filterCountriesId.indexOf(region.nLocationID) === -1) {
						$scope.filterCountriesId.push(region.nLocationID);
						$scope.filteredCountryName.push(region.sRegionName);
					} else {
						$scope.filterCountriesId.splice($scope.filterCountriesId.indexOf(region.nLocationID), 1);
						$scope.filteredCountryName.splice($scope.filteredCountryName.indexOf(region.sRegionName), 1);
					}
					event.stopPropagation();
				};

				$scope.removeLocation = function(index) {
					$scope.filterCountriesId.splice(index, 1);
					$scope.filteredCountryName.splice(index, 1);
				};

				$scope.clickOnAllLocationsChkbx = function(value, event) {
					$scope.filterCountriesId = [];
					if (value === true) {
						for (var i = 0; i < $scope.regionList.length; i++) {
							$scope.filterCountriesId.push($scope.regionList[i].nLocationID);
						}
					}
					if (event) {
						event.stopPropagation();
					}
				};

				$scope.clickonEmpList = function(event) {
					if (!angular.element(event.target.parentElement).hasClass('open')) {
						$scope.empList.show = false;
						$timeout(function() {
							$scope.empList.show = true;
						});
					}
					$scope.empList.filteredData = $filter('orderBy')($scope.employeeList, 'sEmpName');
				};

				$scope.keypressEmployeesList = function(event) {
					$scope.empList.filteredData = $filter('filter')($scope.employeeList, {
						'sEmpName' : $scope.empList.name
					});
					$scope.empList.filteredData = $filter('orderBy')($scope.empList.filteredData, 'sEmpName');
					if (!angular.element(event.target.parentElement).hasClass('open')) {
						$scope.empList.show = false;
						$timeout(function() {
							$scope.empList.show = true;
						});
					}
				};

				$scope.addEmployee = function(employee, event) {
					$scope.empList.name = "";
					if ($scope.filterEmpId.indexOf(employee.sEmpID) === -1) {
						$scope.filterEmpId.push(employee.sEmpID);
						$scope.filteredEmpName.push(employee.sEmpName);
					} else {
						$scope.filterEmpId.splice($scope.filterEmpId.indexOf(employee.sEmpID), 1);
						$scope.filteredEmpName.splice($scope.filteredEmpName.indexOf(employee.sEmpName), 1);
					}
					if (event) {
						event.stopPropagation();
					}
				};

				$scope.removeEmployee = function(index) {
					$scope.filterEmpId.splice(index, 1);
					$scope.filteredEmpName.splice(index, 1);
				};

				$scope.clickOnAllEmpCheckbox = function(value, event) {
					$scope.filterEmpId = [];
					$scope.filteredEmpName = [];
					if (value === true) {
						for (var j = 0; j < $scope.employeeList.length; j++) {
							$scope.filteredEmpName.push($scope.employeeList[j].ProdcertName);
							$scope.filterEmpId.push($scope.employeeList[j].sEmpID);
						}
					}
					if (event) {
						event.stopPropagation();
					}
				};

				$scope.filteredEmpName = [];
				$scope.filterEmpId = [];

				$scope.moreInfo = function() {
					$scope.showMore = !$scope.showMore;
				};

			} ]);
})();