
/**
 * Factory responsible for validation of all forms present in all modules
 */
(function() {
	'use strict';
	angular
			.module('timeOffCommvaultApp.validateObjectServices', [ 'restangular' ])
			.factory('validateObjectService',
					[
							"parameterService",
							"adminServices",
							"configService",
							"$route",
							"$rootScope",
							"assignProxyServices",
							"Utils",
							"$location",
							"i8nConstants",
							function(parameterService, adminServices, configService, $route, $rootScope,
									assignProxyServices, Utils, $location, i8nConstants) {
								var moduleList = [];

								function getValidateObj(moduleName) {
									var formFieldsObj = {};
									if (moduleName == "EntitlementPolicy") {
										formFieldsObj = {
											ignore : ':hidden, [readonly=readonly]',
											rules : {
												sPolicyName : {
													required : true
												},
												nMaxAllowed : {
													required : true,
													number : true
												},
												nDuration : {
													required : true,
													number : true
												},
												nMaxContAllowed : {
													required : true,
													number : true
												},
												nMaxCountAllowed : {
													required : true,
													number : true
												},
												nAccruedPerMonth : {
													required : true,
													number : true
												},
												startdate : {
													required : true
												},
												nCarryFwdAllowed : {
													required : true
												}
											},
											messages : {
												sPolicyName : {
													required : i8nConstants.ENTER_VALID_POLICY_NAME
												},
												nMaxAllowed : {
													required : i8nConstants.ENTER_VALID_MAXIMUM_DAYS,
													number : i8nConstants.ENTER_VALID_MAXIMUM_DAYS
												},
												nDuration : {
													required : i8nConstants.ENTER_VALID_MONTHS,
													number : i8nConstants.ENTER_VALID_MONTHS
												},
												nMaxContAllowed : {
													required : i8nConstants.ENTER_VALID_DATA,
													number : i8nConstants.ENTER_VALID_DATA
												},
												nMaxCountAllowed : {
													required : i8nConstants.ENTER_VALID_DATA,
													number : i8nConstants.ENTER_VALID_DATA
												},
												nAccruedPerMonth : {
													required : i8nConstants.ENTER_VALID_DATA,
													number : i8nConstants.ENTER_VALID_DATA
												},
												startdate : {
													required : i8nConstants.SELECT_VALID_DATE
												},
												nCarryFwdAllowed : {
													required : i8nConstants.ENTER_VALID_DATA,
													number : i8nConstants.ENTER_VALID_DATA
												}
											},
											validateOnInit : false
										};
									}
									if (moduleName == "AssignProxy" || moduleName == "ManagerProxy") {
										formFieldsObj = {
											rules : {
												sUser : {
													required : true
												},
												sProxy : {
													required : true
												},
												dValidFrom : {
													required : true
												},
												dExpiryDate : {
													required : true
												}
											},
											messages : {
												sUser : {
													required : i8nConstants.ENTER_CURRENT_MANAGER_NAME
												},
												sProxy : {
													required : i8nConstants.ENTER_TEMPORARY_MANAGER_NAME
												},
												dValidFrom : {
													required : i8nConstants.ENTER_START_DATE
												},
												dExpiryDate : {
													required : i8nConstants.ENTER_END_DATE
												}
											}
										}
									}
									if (moduleName == "NotificationPolicy") {
										formFieldsObj = {
											ignore : ':hidden, [readonly=readonly]',
											rules : {
												notification_policy_name : {
													required : true
												},
												first_text_0 : {
													required : true
												},
												second_text_0 : {
													required : true
												},
												total_first_text_0 : {
													required : true
												},
												total_second_text_0 : {
													required : true
												}
											},
											messages : {
												notification_policy_name : {
													required : i8nConstants.ENTER_VALID_POLICY_NAME
												},
												first_text_0 : {
													required : i8nConstants.INVALID_DATA
												},
												second_text_0 : {
													required : i8nConstants.INVALID_DATA
												},
												total_first_text_0 : {
													required : i8nConstants.INVALID_DATA
												},
												total_second_text_0 : {
													required : i8nConstants.INVALID_DATA
												}
											},
											validateOnInit : false
										};
									}
									if (moduleName == "TimeOffEmployee") {
										formFieldsObj = {
											ignore : '',
											rules : {
												nTimeOffID : {
													required : true
												},
												nEntitlementID : {
													required : true
												},
												nNotificationID : {
													required : true
												}
											},
											messages : {
												nTimeOffID : {
													required : i8nConstants.SELECT_VALID_TIME_OFF
												},
												nEntitlementID : {
													required : i8nConstants.SELECT_VALID_POLICY
												},
												nNotificationID : {
													required : i8nConstants.SELECT_VALID_POLICY
												}
											},
											validateOnInit : false
										};
									}
									if (moduleName == "Holiday") {
										formFieldsObj = {
											ignore : '',
											rules : {
												startDate : {
													required : true
												},
												endDate : {
													required : true
												},
												sCountry : {
													required : true
												},
												sName : {
													required : true
												},
												sRegion : {
													required : true
												}
											},
											messages : {
												startDate : {
													required : i8nConstants.INVALID_START_DATE
												},
												endDate : {
													required : i8nConstants.INVALID_END_DATE
												},
												sCountry : {
													required : i8nConstants.INVALID_COUNTRY
												},
												sName : {
													required : i8nConstants.INVALID_HOLIDAY_NAME
												},
												sRegion : {
													required : i8nConstants.INVALID_REGION
												}
											},
											validateOnInit : false
										};
									}
									if (moduleName == "Title") {
										formFieldsObj = {
											ignore : '',
											rules : {
												sTitleName : {
													required : true
												}
											},
											messages : {
												sTitleName : {
													required : i8nConstants.INVALID_TITLE
												}
											},
											validateOnInit : false
										};
									}
									if (moduleName == "Department") {
										formFieldsObj = {
											ignore : '',
											rules : {
												sDeptName : {
													required : true
												}
											},
											messages : {
												sDeptName : {
													required : i8nConstants.INVALID_DEPARTMENT_NAME
												}
											},
											validateOnInit : false
										};
									}
									if (moduleName == "Team") {
										formFieldsObj = {
											ignore : '',
											rules : {
												sTeamName : {
													required : true
												}
											},
											messages : {
												sTeamName : {
													required : i8nConstants.INVALID_TEAM_NAME
												}
											},
											validateOnInit : false
										};
									}
									if (moduleName == "Event") {
										formFieldsObj = {
											ignore : '',
											rules : {
												startdate : {
													required : true
												},
												enddate : {
													required : true
												},
												sEventName : {
													required : true
												},
												sVenue : {
													required : true
												},
												sRegion : {
													required : true
												},
												sDetails : {
													required : true
												}
											},
											messages : {
												startdate : {
													required : i8nConstants.INVALID_START_DATE
												},
												enddate : {
													required : i8nConstants.INVALID_END_DATE
												},
												sEventName : {
													required : i8nConstants.ENTER_EVENT_NAME
												},
												sVenue : {
													required : i8nConstants.VENUE_NAME_REQUIRED
												},
												sRegion : {
													required : i8nConstants.INVALID_REGION
												},
												sDetails : {
													required : i8nConstants.DETIALS_ARE_REQUIRED
												}
											},
											validateOnInit : false
										};
									}
									if (moduleName == "Location") {
										formFieldsObj = {
											ignore : '',
											rules : {
												sCountryName : {
													required : true
												},
												sRegionName : {
													required : true
												},
												sTimeZone : {
													required : true
												}
											},
											messages : {
												sCountryName : {
													required : i8nConstants.INVALID_COUNTRY_NAME
												},
												sRegionName : {
													required : i8nConstants.INVALID_REGION_NAME
												},
												sTimeZone : {
													required : i8nConstants.INVALID_TIMEZONE_SELECTED
												}
											},
											validateOnInit : false
										};
									}
									if (moduleName == "Employee") {
										formFieldsObj = {
											ignore : '',
											rules : {
												sEmpID : {
													required : true
												},
												sEmployeeID : {
													required : true
												},
												sEmpName : {
													required : true
												},
												nTitleID : {
													required : true
												},
												dDateHired : {
													required : true
												},
												nDeptID : {
													required : true
												},
												nTeamID : {
													required : true
												},
												Manager : {
													required : true
												},
												sMobileNumber : {
													required : true
												},
												sEmail : {
													required : true,
													email : true
												},
												nLocationID : {
													required : true
												}
											},
											messages : {
												sEmployeeID : {
													required : i8nConstants.ENTER_HR_EMPLOYEE_ID
												},
												sEmpID : {
													required : i8nConstants.ENTER_EMPLOYEE_ID
												},
												sEmpName : {
													required : i8nConstants.ENTER_EMPLOYEE_NAME
												},
												nTitleID : {
													required : i8nConstants.SELECT_TITLE_NAME
												},
												dDateHired : {
													required : i8nConstants.ENTER_DATE_HIRED
												},
												nDeptID : {
													required : i8nConstants.SELECT_DEPARTMENT_NAME
												},
												nTeamID : {
													required : i8nConstants.SELECT_TEAM_NAME
												},
												Manager : {
													required : i8nConstants.SELECT_MANAGER_NAME
												},
												sMobileNumber : {
													required : i8nConstants.ENTER_CONTACT_NUMBER
												},
												sEmail : {
													required : i8nConstants.ENTER_EMAIL_ADDRESS,
													email : i8nConstants.ENTER_VALID_EMAIL_ADDRESS
												},
												nLocationID : {
													required : i8nConstants.SELECT_LOCATION
												},
												selectedTimeOff : {
													required : ""
												},
												selectedEntitlement : {
													required : ""
												},
												selectedApproverNotification : {
													required : ""
												}
											},
											validateOnInit : false
										}
									}
									formFieldsObj.submitHandler = function(form) {
										Utils.clearFormValidations();
										if (moduleName == "Employee") {
											if ($('#AssignTimeOff:checked').length > 0) {
												var timeoffList = [ $("#selectedTimeOff").val() ];
												var entitlementList = [ $("#selectedEntitlement").val() ];
												var approverList = [ $("#selectedApproverNotification").val() ];
											}
										}
										if (moduleName == "TimeOffEmployee") {
											var id = $("#nTimeOffID").val();
											//$scope.$apply(function () {
											//    $scope.selectedTimeOffType = $("#selectedTimeOff").val()+$("#nTimeOffID").val()+",";
											//});
											$("#selectedTimeOff").val($("#selectedTimeOff").val() +
													$("#nTimeOffID").val() + ",");
											$("#dummyTimeOff").clone().appendTo("#timeOffsApplicable");
											$("#timeOffsApplicable").find("div").last().addClass("real")
													.removeClass("hide");
											$("#timeOffsApplicable").find("span").last()
													.html('<a href="javascript:void(0)" ng-click="displayTimeOff("' +
															id + '","' + $(".selTimeOff").html() + '")" >' +
															$(".selTimeOff").html() + '</a><i class="icon close"></i>');
											$("#nTimeOffID").val("");
											$("#nEntitlementID").val("");
											$("#nNotificationID").val("");
											$(".selTimeOff").html("Select Time Off");
											$(".selEntitlement").html("Select Policy");
											$(".selNotification").html("Select Policy");
											$(".error").removeClass("error");
										} else {
											var moduleArray = [ "EntitlementPolicy", "NotificationPolicy" ];
											var requestParams = eval("parameterService.get" +
													moduleName +
													'("' +
													(($("#editFlag").val() == "0") ? ""
															: ((($("#duplicateAddFlag").length > 0) && (moduleArray
																	.indexOf(moduleName) != -1)) ? "" : $("#editFlag")
																	.val())) + '")');
											var editFlag = ($("#editFlag").val() == "0") ? "0"
													: ((($("#duplicateAddFlag").length > 0) && (moduleArray
															.indexOf(moduleName) != -1)) ? "0" : $("#editFlag").val());
											$(".alert-msg").hide();
											if (moduleName == "Event") {
												if (requestParams.sVenue == "Others") {
													requestParams.sVenue = $("#sVenueOthers").val();
												}
											}
											adminServices
													.cudAPI(requestParams,
															(($("#editFlag").val() == "0") ? eval("adminServices.getUrlObj().add" +
																	moduleName)
																	: ((($("#duplicateAddFlag").length > 0) && (moduleArray
																			.indexOf(moduleName) != -1)) ? eval("adminServices.getUrlObj().add" +
																			moduleName)
																			: eval("adminServices.getUrlObj().update" +
																					moduleName)))).then(function(resp) {
														if (moduleName == "AssignProxy" && editFlag == "0") {
															$('.new-proxy').show();
															$('.new-proxy').fadeOut(5000);
															$('html, body').animate({
																scrollTop : 0
															}, 800);
														} else if (moduleName == "AssignProxy" && editFlag != "0") {
															$('.edited-proxy').show();
															$('.edited-proxy').fadeOut(5000);
															$('html, body').animate({
																scrollTop : 0
															}, 800);
														} else if (moduleName == "ManagerProxy" && editFlag == "0") {
															$('.new-proxy').show();
															$('.new-proxy').fadeOut(5000);
															$('html, body').animate({
																scrollTop : 0
															}, 800);
														} else if (moduleName == "ManagerProxy" && editFlag != "0") {
															$('.edited-proxy').show();
															$('.edited-proxy').fadeOut(5000);
															$('html, body').animate({
																scrollTop : 0
															}, 800);
														} else if (moduleName == "EntitlementPolicy") {
															$("#addPolicyModal").modal("hide");

															if (editFlag != "0") {
																$(".entitlement-edit-success-msg").fadeIn()
																		.fadeOut(3000);
															} else {
																$("#duplicateAddFlag").val("-1");
																$("#nEntitlementID").val(resp[0].data);
																$("#leave_policy").val(resp[0].data);
																$(".selected_entitlement-policy")
																		.html(requestParams.sPolicyName);
																$(".selEntitlement").html(requestParams.sPolicyName);
																$(".entitlement-success-msg").fadeIn().fadeOut(3000);
															}
															$('html, body').animate({
																scrollTop : 0
															}, 800);
														} else if (moduleName == "NotificationPolicy") {
															$("#notificationPolicyModal").modal("hide");
															if (editFlag != "0") {
																$(".notification-edit-success-msg").fadeIn()
																		.fadeOut(3000);
															} else {
																$("#duplicateAddFlag").val("-1");
																$("#nNotificationID").val(resp[0].data);
																$(".selNotification").html(requestParams.sPolicyName);
																$(".selected_approval-policy")
																		.html(requestParams.sPolicyName);
																$("#approval_policy").val(resp[0].data);
																$(".notification-success-msg").fadeIn().fadeOut(3000);
															}
															$('html, body').animate({
																scrollTop : 0
															}, 800);
														} else {
															if (editFlag == "0") {
																$(".success-msg").fadeIn().fadeOut(3000);
															} else {
																$(".edit-success-msg").fadeIn().fadeOut(3000);
															}
															$('html, body').animate({
																scrollTop : 0
															}, 800);
														}
														if (moduleName != "Employee") {
															if (moduleName == 'ManagerProxy') {
																assignProxyServices.getAllManagersProxies()
																		.then(function(response) {
																			adminServices.clearFields(moduleName);
																			moduleList = response;
																			$rootScope.$broadcast('user:updated',
																					response);
																		});
															} else {
																adminServices.getListingObjArray(moduleName)
																		.then(function(response) {
																			adminServices.clearFields(moduleName);
																			moduleList = response;
																			$rootScope.$broadcast('user:updated',
																					response);
																		});
															}
														} else {
															$("#duplicateAddFlag").val("0");
															if ($("#editFlag").val() == "0") {
																$("#Manager").val("");
																$("#btn_Manager").val("");
																$("#sManager").val("");
																$("#btn_sManager").val("");
																$("#sEmpID").val("");
																$("#dDateHired").val("");
																$("#nDeptID").val("");
																$("#btn_nDeptID").val("");
																$("#nTeamID").val("");
																$("#btn_nTeamID").val("");
																$("#nTitleID").val("");
																$("#btn_nTitleID").val("");
																$("#sEmail").val("");
																$("#sEmpID").val("");
																$("#sEmpName").val("");
																$("#sMobileNumber").val("");
																$("#sPhoneNumber").val("");
																$("#selectedTimeOff").val("");
																$("#selectedEntitlement").val("");
																$("#selectedApproverNotification").val("");
																$("#nLocationID").val("");
																$("#btn_nLocationID").val("");
																if ($('#AssignTimeOff:checked').length > 0) {
																	$('#AssignTimeOff:checked').trigger("click");
																}
																$("#Male").trigger("click");
																$("#timeOffsApplicable span:not(:first)").remove();
															}
														}
													},
															function(resp) {
																if (moduleName == "AssignProxy" && editFlag == "0") {
																	if (resp[0].error == null) {
																		$('.error-danger-msg').show();
																	}
																	$('.error-danger-msg').fadeOut(3000);
																	$('html, body').animate({
																		scrollTop : 0
																	}, 800);
																} else if (moduleName == "AssignProxy" &&
																		editFlag != "0") {
																	if (resp[0].error == null) {
																		$('.edited-proxy-error-danger-msg').show();
																	}
																	$('.edited-proxy-error-danger-msg').fadeOut(3000);
																	$('html, body').animate({
																		scrollTop : 0
																	}, 800);
																} else if (moduleName == "EntitlementPolicy") {
																	$("#addPolicyModal").modal("hide");
																	if (resp[0].error == null) {
																		if (editFlag != "0") {
																			$(".entitlement-edit-error-danger-msg")
																					.fadeIn().fadeOut(3000);
																		} else {
																			$(".entitlement-error-danger-msg").fadeIn()
																					.fadeOut(3000);
																		}
																	}
																	$('html, body').animate({
																		scrollTop : 0
																	}, 800);
																} else if (moduleName == "NotificationPolicy") {
																	$("#notificationPolicyModal").modal("hide");
																	if (resp[0].error == null) {
																		if (editFlag != "0") {
																			$(".notification-edit-error-danger-msg")
																					.fadeIn().fadeOut(3000);
																		} else {
																			$(".notification-error-danger-msg")
																					.fadeIn().fadeOut(3000);
																		}
																	}
																	$('html, body').animate({
																		scrollTop : 0
																	}, 800);
																} else {
																	if (resp[0].error == null) {
																		if (editFlag == "0") {
																			$(".error-danger-msg").fadeIn()
																					.fadeOut(3000);
																		} else {
																			$(".edit-error-danger-msg").fadeIn()
																					.fadeOut(3000);
																		}
																	}
																	$('html, body').animate({
																		scrollTop : 0
																	}, 800);
																}
																// adminServices.clearFields(moduleName);
															});
										}
									}
									return formFieldsObj;
								}

								return {
									"getValidateObj" : getValidateObj,
									"moduleList" : moduleList
								}
							} ])
})();