/**
 * Factory responsible for global place for API urls
 */
(function() {
	'use strict';
	angular.module('timeOffCommvaultApp.urlsServices', [ 'restangular' ]).factory('configService', function() {
		var DEV_URL = {
			"teamMembersTimeoff" : "json/editLeave.json",
			"editTimeOffUrl" : "timeoff/timeOffDetail.do",
			"mainPage" : "json/employeeResponse.json",
			"updateTimeOff" : "",
			"applyTimeOff" : "",
			"getTimeoffs" : "json/timeoffs.json",
			"holidayList" : "data/countriesHoliday.json",
			"timeOffinfo" : "data/employeeLeaveDetails.json",
			"deleteTimeoff" : "",
			"getListOfTimeOffs" : "data/timeoffList.json",
			"getTimeOff" : "data/timeoffList.json",
			"getDepartment" : "json/department.json",
			"getTeam" : "json/team.json",
			"getTimezone" : "json/timezone.json",
			"getEvent" : "json/events.json",
			"getTitle" : "json/title.json",
			"getLocation" : "json/location.json",
			"deleteTitle" : "timeOff/deleteTitle.do",
			"updateEntitlementPolicy" : "json/addEntitlementPolicyResponse.json",
			"addEntitlementPolicy" : "json/addEntitlementPolicyResponse.json",
			"addNotificationPolicy" : "json/addEntitlementPolicyResponse.json",
			"deleteEntitlementPolicy" : "json/addEntitlementPolicyResponse.json",
			"deleteNotificationPolicy" : "json/asfasfsdf.json",
			"updateNotificationPolicy" : "timeOff/updateLeaveApprovalPolicy.do",
			"getEntitlementList" : "data/leaveEntitlementPolicy.json",
			"getEntitlementPolicy" : "data/leaveEntitlementPolicy.json",
			"getApprovalList" : "data/leaveApprovalPolicy.json",
			"getNotificationPolicy" : "data/leaveApprovalPolicy.json",
			"addNewTimeOffType" : "timeOff/applyTimeOff.do",//change url
			"editTimeOffType" : "timeOff/updateTimeOff.do",//change url
			"getEmployees" : "json/individualEmployee.json",
			"deleteTimeOffType" : "timeOff/deleteTimeOffType.do",
			"getManager" : "json/manager.json",
			"getManagerDetails" : "data/listManagersAndDept.json",
			"getAssignProxy" : "timeOff/newProxy.do",
			"addAssignProxy" : "data/assignedProxies.json",
			"updateAssignProxy" : "timeOff/updateProxy.do",
			"deleteAssignProxy" : "timeOff/deleteProxy.do",
			"updateEvent" : "timeOff/updateEvent.do",
			"addEvent" : "timeOff/addEvent.do",
			"deleteEvent" : "timeOff/deleteEvent.do",
			"getEmployeeId" : "timeOff/deleteEvent.do",
			"getEmployeeById" : "json/individualEmployee.json",
			"updateEmployee" : "timeOff/updateEmployee.do", // change url
			"addEmployee" : "timeOff/addEmployee.do", // change url
			"deleteEmployee" : "timeOff/deleteEmployee.do", // change url
			"addDepartment" : "timeOff/addDepartment.do",
			"updateDepartment" : "timeOff/updateDepartment.do",
			"deleteDepartment" : "timeOff/deleteDepartment.do",
			"addTeam" : "timeOff/addTeam.do",
			"updateTeam" : "timeOff/updateTeam.do",
			"deleteTeam" : "timeOff/deleteTeam.do",
			"addTitle" : "timeOff/addTitle.do",
			"updateTitle" : "timeOff/updateTitle.do",
			"addHoliday" : "timeOff/addHoliday.do",
			"updateHoliday" : "timeOff/updateHoliday.do",
			"deleteHoliday" : "timeOff/deleteHoliday.do",
			"addLocation" : "timeOff/addLocation.do",
			"updateLocation" : "timeOff/updateLocation.do",
			"deleteLocation" : "timeOff/deleteLocation.do",
			"setRank" : "timeOff/updateRank.do",
			"getEmployeeByToken" : "json/employee.json",
			"getManagerProxy" : "data/assignedProxies.json",
			"addManagerProxy" : "data/assignedProxies.json",
			"updateManagerProxy" : "timeOff/updateProxy.do",
			"deleteManagerProxy" : "timeOff/deleteProxy.do",
			"pendingTimeOff" : "data/pendingTimeOff.json",
			"approvedTimeOff" : "data/approvedList.json",
			"rejectedTimeOff" : "",
			"sendEmail" : "timeOff/sendEmail.do",//need to change thios
			"approveTimeOff" : "timeOff/approve.do",//need to change thios
			"rejectTimeOff" : "timeOff/reject.do",//need to change thios
			"managerReports" : "data/report.json",//need to change thios
			"getTimeOffsApplicableForOthers" : "timeoff/getTimeOffsApplicableForOthers.do"
		};
		var PROD_URL = {
			"teamMembersTimeoff" : "timeoff/getTeamMembersTimeOffDetails.do",
			"editTimeOffUrl" : "timeoff/timeOffDetail.do",
			"getEmployees" : "timeOff/employeeDetailsPagination.do",
			"getNotificationPolicy" : "timeOff/getLeaveApprovalPolicies.do",
			"getEntitlementPolicy" : "timeOff/getLeaveEntitlementPolicies.do",
			"addNotificationPolicy" : "timeOff/newLeaveApprovalPolicy.do",
			"deleteNotificationPolicy" : "timeOff/deleteLeaveApprovalPolicy.do",
			"getTimeOff" : "timeOff/getListOfTimeOffs.do",
			"mainPage" : "timeoff/mainPageDetails.do",
			"getTimezone" : "timeoff/ListOfTimezones.do",
			"deleteTitle" : "timeOff/deleteTitle.do",
			"getManager" : "timeOff/getListOfManagers.do",
			"getTeam" : "timeOff/ListOfTeams.do",
			"getTitle" : "timeOff/ListOfTitles.do",
			"getLocation" : "timeOff/ListOfLocations.do",
			"getEvent" : "timeOff/ListOfEvents.do",
			"updateTimeOff" : "timeOff/updateTimeOff.do",
			"applyTimeOff" : "timeOff/applyTimeOff.do",
			"deleteTimeoff" : "timeOff/deleteTimeOff.do",
			"getDepartment" : "timeOff/ListOfDepartments.do",
			"timeOffinfo" : "timeOff/getTimeOffHistoryDetails.do",
			"getListOfTimeOffs" : "timeOff/getListOfTimeOffs.do",
			"updateEntitlementPolicy" : "timeOff/updateLeaveEntitlementPolicy.do",
			"updateNotificationPolicy" : "timeOff/updateLeaveApprovalPolicy.do",
			"addEntitlementPolicy" : "timeOff/newLeaveEntitlementPolicy.do",
			"deleteEntitlementPolicy" : "timeOff/deleteLeaveEntitlementPolicy.do",
			"getEntitlementList" : "timeOff/getLeaveEntitlementPolicies.do",
			"getApprovalList" : "timeOff/getLeaveApprovalPolicies.do",
			"addNewTimeOffType" : "timeOff/newTimeOffType.do", //change url
			"editTimeOffType" : "timeOff/updateTimeOffType.do",//change url
			"deleteTimeOffType" : "timeOff/deleteTimeOffType.do",
			"getManagerDetails" : "timeOff/getListOfManagers.do",
			"getAssignProxy" : "timeOff/getAllAssignedProxy.do",
			"holidayList" : "timeOff/getAllHolidays.do",
			"addAssignProxy" : "timeOff/newProxy.do",
			"updateAssignProxy" : "timeOff/updateProxy.do",
			"deleteAssignProxy" : "timeOff/deleteProxy.do",
			"updateEmployee" : "timeOff/updateEmployee.do", // change url
			"addEmployee" : "timeOff/addEmployee.do", // change url
			"deleteEmployee" : "timeOff/deleteEmployee.do", // change url
			"updateEvent" : "timeOff/updateEvent.do",
			"addEvent" : "timeOff/addEvent.do",
			"deleteEvent" : "timeOff/deleteEvent.do",
			"addDepartment" : "timeOff/addDepartment.do",
			"updateDepartment" : "timeOff/updateDepartment.do",
			"deleteDepartment" : "timeOff/deleteDepartment.do",
			"addTeam" : "timeOff/addTeam.do",
			"updateTeam" : "timeOff/updateTeam.do",
			"deleteTeam" : "timeOff/deleteTeam.do",
			"addTitle" : "timeOff/addTitle.do",
			"updateTitle" : "timeOff/updateTitle.do",
			"addHoliday" : "timeOff/addHoliday.do",
			"updateHoliday" : "timeOff/updateHoliday.do",
			"deleteHoliday" : "timeOff/deleteHoliday.do",
			"getEmployeeId" : "timeOff/deleteEvent.do",
			"getEmployeeById" : "timeOff/getEmployeeByToken.do",
			"getEmployeeByToken" : "timeOff/getEmployeeByToken.do",
			"addLocation" : "timeOff/addLocation.do",
			"updateLocation" : "timeOff/updateLocation.do",
			"deleteLocation" : "timeOff/deleteLocation.do",
			"setRank" : "timeOff/updateRank.do",
			"getManagerProxy" : "timeOff/getListOfAssignedProxy.do", // change this url
			"addManagerProxy" : "timeOff/newProxy.do",
			"updateManagerProxy" : "timeOff/updateProxy.do",
			"deleteManagerProxy" : "timeOff/deleteProxy.do",
			"pendingTimeOff" : "timeOff/listOfApprovals.do",
			"approvedTimeOff" : "timeOff/listOfApprovals.do",
			"rejectedTimeOff" : "timeOff/listOfApprovals.do",
			"sendEmail" : "timeOff/sendEmail.do",//need to change thios
			"approveTimeOff" : "timeOff/approveTimeOffs.do",//need to change thios
			"rejectTimeOff" : "timeOff/denyTimeOffs.do",//need to change thios
			"managerReports" : "timeOff/managerReports.do",//need to change thios
			"getTimeOffsApplicableForOthers" : "timeoff/getTimeOffsApplicableForOthers.do",
			"authenticateCredentials" : "timeoff/authenticateCredential.do"
		};
		var halfDayParameters = {
			firstHalfStartTime : " 09:30:00",
			firstHalfEndTime : " 13:30:00",
			secondHalfStartTime : " 14:00:00",
			secondHalfEndTime : " 18:30:00"
		};
		function returnDevUrl() {
			return DEV_URL;
		}

		function returnProdUrl() {
			return PROD_URL;
		}

		return {
			'returnDevUrl' : returnDevUrl,
			'returnProdUrl' : returnProdUrl,
			'halfDayParameters' : halfDayParameters
		};
	});
})();