/**
 * Factory responsible for operations related to time off info page
 */
(function() {
	angular
			.module('timeOffCommvaultApp.timeoffinfoService', [ 'restangular' ])
			.factory('timeoffInfoService',
					[
							"Restangular",
							"Utils",
							"$q",
							"$timeout",
							"employeeServices",
							function(Restangular, Utils, $q, $timeout, employeeServices) {
								var timeoffDataList = {};
								var statusFilterContent = [];
								var typeFilterContent = [];
								var dataYearArray = employeeServices.getYearList();
								var URL = employeeServices.getUrlObj();

								function processTimeOffHistory() {
									return timeoffDataList.timeOffs;
								}

								function processTimeOffInfo() {
									return timeoffDataList.HistoryDetails;
								}

								function getStatusFilterContents() {
									return statusFilterContent;
								}

								function getTypeFilterContents() {
									return typeFilterContent;
								}

								function populateFilters() {
									var j = 0, k = 0;
									statusFilterContent = [];
									typeFilterContent = [];
									if (timeoffDataList.timeOffs) {
										for (var i = 0; i < timeoffDataList.timeOffs.length; i++) {
											if (statusFilterContent.indexOf(timeoffDataList.timeOffs[i].sRequestStatus) === -1) {
												statusFilterContent[j] = timeoffDataList.timeOffs[i].sRequestStatus;
												j++;
											}
											if (typeFilterContent.indexOf(timeoffDataList.timeOffs[i].sRequestType) === -1) {
												typeFilterContent[k] = timeoffDataList.timeOffs[i].sRequestType;
												k++;
											}
										}
									}
								}

								function timeOffInfoDetails() {
									var data = {
										"alias" : employeeServices.getProdcertName(),//employeeServices.getProdcertName() abhinawkumar
										"startdate" : Utils.respDateFormat("01/01/" + dataYearArray[0], true),
										"enddate" : Utils.respDateFormat("12/31/" +
												dataYearArray[dataYearArray.length - 1], true),
										"year" : new Date().getFullYear()
									};

									var deferred = $q.defer();
									var timeoffInfoObj = Restangular.all(URL.timeOffinfo);
									timeoffInfoObj.post(data, "get").then(function(response) {
										if (response) {
											if (response[0]) {
												if (response[0].data[0].timeOffs === null) {
													response[0].data[0].timeOffs = [];
												}
												if (Utils.isValidResponse(response)) {
													response.printError = false;
													timeoffDataList = response[0].data[0];
													deferred.resolve(timeoffDataList);
												} else {
													deferred.reject(response);
												}
											} else {
												response.printError = true;
												deferred.reject(response);
											}
										} else {
											response = {};
											response.printError = true;
											deferred.reject(response);
										}
									}, function(resp) {
										if (!resp) {
											resp = {};
										}
										resp.printError = true;
										deferred.reject(resp);
									});
									return deferred.promise;
								}

								return {
									'timeOffInfoDetails' : timeOffInfoDetails,
									'processTimeOffHistory' : processTimeOffHistory,
									'processTimeOffInfo' : processTimeOffInfo,
									'populateFilters' : populateFilters,
									'getTypeFilterContents' : getTypeFilterContents,
									'getStatusFilterContents' : getStatusFilterContents
								};
							} ]);
})();