/**
 * Factory responsible for timeOff operations
 */
/**
 * 
 */
(function() {
	'use strict';
	angular
			.module('timeOffCommvaultApp.timeOffDateDiffServices', [ 'restangular' ])
			.factory('timeOffDateDiffService',
					[
							"Restangular",
							"Utils",
							"$http",
							"configService",
							"employeeServices",
							"TIMEOFF_CONSTANTS",
							function(Restangular, Utils, $http, configService, employeeServices, TIMEOFF_CONSTANTS) {
								var timeoffStartDate = null;
								var timeOffEndDate = null;
								var holidays = employeeServices.getHolidays();
								var optionalHolidays = [];
								var middleHolidays = [];
								var daysOfAbsence = 0;

								return {
									setTimeOffStartDate : function(date) {
										timeoffStartDate = date;
									},
									setTimeOffEndDate : function(date) {
										timeOffEndDate = date;
									},
									getTimeOffStartDate : function() {
										return timeoffStartDate;
									},
									getTimeOffEndDate : function() {
										return timeOffEndDate;
									},
									setDaysOfAbsence : function(days) {
										daysOfAbsence = days;
									},
									getDaysOfAbsence : function() {
										return daysOfAbsence;
									},
									getBetweenHolidaysList : function() {
										return middleHolidays;
									},
									getOptionalLeaveDetails : function() {
										return optionalHolidays;
									},
									calculateDays : function(calForTeamMember) {
										optionalHolidays = [];
										Date.prototype.addDays = function(days) {
											var dat = new Date(this.valueOf())
											dat.setDate(dat.getDate() + days);
											return dat;
										}
										function getDates(startDate, stopDate) {
											var dateArray = new Array();
											var currentDate = startDate;
											while (currentDate <= stopDate) {
												dateArray.push(new Date(currentDate))
												currentDate = currentDate.addDays(1);
											}
											return dateArray;
										}

										function calculateDaysDiff(startDateStr, endDateStr, hstartDate, hendDate,
												holidayObj) {
											var start = new Date(startDateStr.replace(/-/g, "/")), end = new Date(
													endDateStr.replace(/-/g, "/")), holiday = getDates(hstartDate,
													hendDate), i = holiday.length, n_days = 0;
											var flag = false;
											var optionalHolidayDuplicate = [];
											var locationID = calForTeamMember ? employeeServices
													.getTeamMemberLocationID() : employeeServices.getLocationId();
											while (i--) { // loop over holidays
												if (holiday[i] >= start) {
													if (holiday[i] <= end) {
														// day holiday within dates
														if (holidayObj.nLocationID == locationID) {
															if (holidayObj.nIsOptional) {
																if (optionalHolidayDuplicate.indexOf(holiday[i]
																		.toDateString()) == -1) {
																	optionalHolidays.push({
																		"name" : holidayObj.sName,
																		"date" : holiday[i].toDateString()
																	});
																	optionalHolidayDuplicate.push(holiday[i]
																			.toDateString());
																}
															} else {
																if (holiday[i].getDay() != 0 &&
																		holiday[i].getDay() != 6) {
																	n_days = n_days - 1; // not sunday and saturday
																}
															}
															flag = true;
														}
													}
												}
											}

											return {
												"diff" : n_days,
												"flag" : flag,
												"holidays" : optionalHolidays
											};
										}

										if (typeof (timeoffStartDate) == "string") {
											var startDate = new Date(timeoffStartDate.replace(/-/g, "/") + " 00:00:00");
										} else {
											var startDate = new Date(timeoffStartDate.toDateString() + " 00:00:00");
										}
										var endDate = new Date(timeOffEndDate.toDateString() + " 00:00:00");
										var millisecondsPerDay = 86400 * 1000;
										startDate.setHours(0, 0, 0, 1);
										endDate.setHours(23, 59, 59, 999);
										var diff = endDate - startDate;
										var days = Math.ceil(diff / millisecondsPerDay);
										// Subtract two weekend days for every week in between
										var weeks = Math.floor(days / 7);
										days = days - (weeks * 2);
										// Handle special cases
										var startDay = startDate.getDay();
										var endDay = endDate.getDay();
										// Remove weekend not previously removed.
										if (startDay - endDay > 1) {
											days = days - 2;
										}
										// Remove start day if span starts on Sunday but ends before Saturday
										if (startDay === 0 && endDay != 6) {
											days = days - 1;
										}
										// Remove end day if span ends on Saturday but starts after Sunday
										if (endDay === 6 && startDay !== 0) {
											days = days - 1;
										}
										var totalHolidays = 0;
										var j = 0;
										var diffDays = 0;
										for (var i = 0; i < holidays.length; i++) {
											if (holidays[i].nLocationID == employeeServices.getLocationId()) {
												startDate.setMilliseconds(0);
												endDate.setMilliseconds(0);
												var holidayDate = new Date(holidays[i].startDate + " 00:00:00");
												holidayDate.setMilliseconds(0);
												var holidayEndDate = new Date(holidays[i].endDate + " 00:00:00");
												holidayEndDate.setMilliseconds(0);
												var holidayMonth = new Date(holidays[i].startDate).getMonth();
												var d = new Date(holidayDate).getDay();//Make sure holiday is not a weekendday!
												var startDayObj = holidayDate;
												var daysDiff = calculateDaysDiff(startDate.toDateString(), endDate
														.toDateString(), holidayDate, holidayEndDate, holidays[i]);
												if (daysDiff.flag == true) {
													diffDays = diffDays + daysDiff.diff;
												} else {
													var maxDiff = daysDiff.diff;
												}
											}
											//console.log(holidayDate.toDateString()+"="+startDate.toDateString()+"="+holidayEndDate.toDateString()+"="+endDate.toDateString());
										}
										var n_days = 0;
										while (startDate <= endDate) {
											if (startDate.getDay() != 0 && startDate.getDay() != 6) {
												n_days = n_days + 1; // not sunday and saturday
											}
											startDate.setHours(24); // add a day
										}
										//console.log(totalHolidays);
										if (diffDays == 0) {
											return n_days + maxDiff;
										} else {
											return n_days + diffDays;
										}
										//return days - totalHolidays;
									}
								}
							} ]);
})();