/**
 * Factory responsible for all operations related to reports
 */
(function() {
	angular.module('timeOffCommvaultApp.reportsService', [ 'restangular' ]).factory('reportsService',
			[
					"Restangular",
					"Utils",
					"$q",
					"$timeout",
					"$http",
					"employeeServices",
					"configService",
					function(Restangular, Utils, $q, $timeout, $http, employeeServices, configService) {
						var URL = (employeeServices.getEnvironment() == 'dev') ? configService.returnDevUrl()
								: configService.returnProdUrl();
						var environment = employeeServices.getEnvironment();

						function setURL() {
						}

						function retrieveReports(pageNo, pageSize, startDate, endDate, employeeName, locationId,
								timeOffTypeId) {
							var deferred = $q.defer();
							var requestParams = constructBody(pageNo,
									pageSize,
									startDate,
									endDate,
									employeeName,
									locationId,
									timeOffTypeId);
							var urlObj = Restangular.all(URL.managerReports);
							if (environment == 'dev') {
								urlObj.getList().then(function(resp) {
									if (Utils.isValidResponse(resp[0])) {
										deferred.resolve(resp[0].data[0]);
									} else {
										deferred.reject(resp);
									}
								});
							} else {
								urlObj.post(requestParams, "get", {
									csrf : Utils.getCsrfToken()
								}).then(function(resp) {
									if (Utils.isValidResponse(resp[0])) {
										if (resp[0].data == null) {
											deferred.resolve({
												"MyTimeOffApprovals" : [],
												"TotalTimeOffCount" : 0
											});
										} else {
											deferred.resolve(resp[0].data[0]);
										}
									} else {
										deferred.resolve({
											"MyTimeOffApprovals" : [],
											"TotalTimeOffCount" : 0
										});
									}
								});
							}
							return deferred.promise;
						}

						function constructBody(pageNo, pageSize, startDate, endDate, employeeName, locationId,
								timeOffTypeId) {
							var body = {};
							body.alias = employeeServices.getProdcertName();
							if (pageNo != '' && pageNo != undefined) {
								body.pageno = pageNo;
							} else {
								body.pageno = 1;
							}
							if (pageSize != '' && pageSize != undefined) {
								body.pageSize = pageSize;
							}
							if (startDate != '' && startDate != undefined) {
								body.startdate = startDate;
							}
							if (endDate != '' && endDate != undefined) {
								body.enddate = endDate;
							}
							if (employeeName != '' && employeeName != undefined) {
								body.employee = employeeName;
							}
							if (locationId != '' && locationId != undefined) {
								body.location = locationId;
							}
							if (timeOffTypeId != '' && timeOffTypeId != undefined) {
								body.reqType = timeOffTypeId;
							}
							return body;
						}

						return {
							'retrieveReports' : retrieveReports
						}
					} ]);
})();