/**
 * Factory responsible for creating JSON request for all modules
 */
(function() {
	'use strict';
	angular.module('timeOffCommvaultApp.parameterServices', [ 'restangular' ]).factory('parameterService',
			[ function() {
				function getTitleParams() {
					return {
						"sTitleName" : "",
						"nRank" : "",
						"nTitleID" : ""
					};
				}
				function getDepartmentParams() {
					return {
						"sDeptName" : "",
						"nDeptID" : ""
					};
				}
				function getTeamParams() {
					return {
						"sTeamName" : "",
						"nTeamID" : ""
					};
				}
				function getLocationParams() {
					return {
						"sCountryName" : "",
						"sRegionName" : "",
						"nLocationID" : "",
						"sTimeZone" : "",
						"nParentLocID" : 0,
						"setAsParent" : false
					};
				}
				function getAddLeaveTypeParams() {
					return {
						"bIsDeductible" : true,
						"bIsHalfDayAllowed" : false,
						"bIsOverlapAllowed" : false,
						"bIsVisibleToAll" : true,
						"nApprovalPolicyID" : "",
						"nEntitlementPolicyID" : "",
						"nLocationID" : "",
						"OverlapRequestTypeID" : [],
						"sRequestType" : "",
						"bIsOptionalType" : false,
						"DeptID" : [],
						"nOverridingReqID" : 0
					};
				}
				function getApproveParams() {
					return {
						"nCntCountEscalationList" : [],
						"nDefaultApprover" : 0,
						"nTotalCountEscalationList" : [],
						"sPolicyName" : "",
					};
				}
				function getEntitlementParams() {
					return {
						"sPolicyName" : "",
						"nMaxAllowed" : "",
						"nDuration" : "",
						"RenewedOn" : "",
						"nMaxContAllowed" : "",
						"nMaxCountAllowed" : "",
						"nAccruedPerMonth" : "",
						"nCarryFwdAllowed" : ""
					};
				}
				function getProxyParams() {
					return {
						"dExpiryDate" : "",
						"dValidFrom" : "",
						"sProxy" : "",
						"sProxyDept" : "",
						"sProxyName" : "",
						"sUser" : "",
						"nID" : "",
						"sUserDept" : "",
						"sUserName" : ""
					};
				}
				function getEmployeeParams() {
					return {
						"Manager" : "",
						"ProdcertName" : "",
						"bIsDeleted" : false,
						"dDateHired" : "",
						"dDateTerminated" : "",
						"gender" : "",
						"nDeptID" : "",
						"nID" : "",
						"nLocationID" : "",
						"nTeamID" : "",
						"nTitleID" : "",
						"sEmail" : "",
						"sEmpID" : "",
						"sEmpName" : "",
						"sMobileNumber" : "",
						"sPhoneNumber" : "",
						"sRole" : "Employee"
					};
				}
				function getHolidayParams() {
					return {
						"startDate" : "",
						"endDate" : "",
						"sRegion" : "",
						"sCountry" : "",
						"sName" : "",
						"nIsOptional" : false,
						"nLocationID" : "",
						"nID" : ""
					};
				}
				function getEventParams() {
					return {
						"dEndDate" : "",
						"dStartDate" : "",
						"nID" : "",
						"nLocationID" : "",
						"sAlias" : "",
						"sDetails" : "",
						"sEventName" : "",
						"sVenue" : ""
					};
				}
				function getApplyLeaveParams() {
					return {
						"leaveType" : "",
						"leaveId" : "",
						"leaveHalf" : "fullDay",
						"startDate" : undefined,
						"endDate" : undefined,
						"deptName" : "",
						"daysOfAbsence" : 0,
						"reason" : "",
						"searchName" : "",
						"halfDayAllowed" : false,
						"secondHalf" : false,
						"halfDayFlag" : false,
						"markOutOfOffice" : false,
						"outOfOfficeAllowed" : false,
						"bIsOutlookInviteAllowed" : false,
						"bIsOptionalType" : false,
						"bSendOutlookInvite" : false,
						"username" : "",
						"password" : "",
						"message" : ""
					};
				}
				return {
					"getTitleParams" : getTitleParams,
					"getDepartmentParams" : getDepartmentParams,
					"getLocationParams" : getLocationParams,
					"getTeamParams" : getTeamParams,
					"getAddLeaveTypeParams" : getAddLeaveTypeParams,
					"getApproveParams" : getApproveParams,
					"getEntitlementParams" : getEntitlementParams,
					"getHolidayParams" : getHolidayParams,
					"getEventParams" : getEventParams,
					"getEmployeeParams" : getEmployeeParams,
					"getProxyParams" : getProxyParams,
					"getApplyLeaveParams" : getApplyLeaveParams
				};
			} ]);
})();