/**
 * Factory responsible for holiday related operations
 */
(function() {
	'use strict';
	angular
			.module('timeOffCommvaultApp.holidayServices', [ 'restangular' ])
			.factory('holidayService',
					[
							"Restangular",
							"$q",
							"Utils",
							"employeeServices",
							function(Restangular, $q, Utils, employeeServices) {
								var URL = employeeServices.getUrlObj();
								var holiday = employeeServices.getHolidays();
								var regionYearMonthHolidays;
								var monthNames = [
										"January",
										"February",
										"March",
										"April",
										"May",
										"June",
										"July",
										"August",
										"September",
										"October",
										"November",
										"December" ];

								//for add holiday page load
								function getHolidaysList() {
									var countryHoliday = {};
									for ( var i in holiday) {
										if (!countryHoliday[holiday[i].sRegion]) {
											countryHoliday[holiday[i].sRegion] = [];
										}
										countryHoliday[holiday[i].sRegion].push(holiday[i]);
									}
									return countryHoliday;
								}
								//for add holiday
								function getAllHoliday() {
									var deferred = $q.defer();
									Restangular.all(URL.holidayList).getList().then(function(resp) {
										if (resp) {
											if (Utils.isValidResponse(resp)) {
												resp.printError = false;
												if (resp[0].data === null) {
													resp[0].data = [];
												}
												holiday = resp[0].data;
												employeeServices.setHolidays(holiday);
												deferred.resolve(getHolidaysList());
											} else {
												deferred.reject(resp);
											}

										} else {
											resp = {};
											resp.printError = true;
											deferred.reject(resp);
										}

									}, function(resp) {
										if (!resp) {
											resp = {};
										}
										resp.printError = true;
										deferred.reject(resp);
									});
									return deferred.promise;
								}

								//for holiday page
								function getMonthNames() {
									return monthNames;
								}
								function sortByRegionYearMonth() {
									regionYearMonthHolidays = {};
									var color;
									var holidays;
									var regionHolidays = employeeServices.getRegionSortedHolidays();
									if (regionHolidays) {
										for ( var region in regionHolidays) {
											holidays = regionHolidays[region];
											if (holidays) {
												for (var i = 0; i < holidays.length; i++) {
													var startDate = new Date(holidays[i].startDate);
													var endDate = new Date(holidays[i].endDate);
													var daysDiff = Utils.calculateDays(startDate.toDateString(),
															endDate.toDateString());
													var k = 0;
													var holidayDate = new Date(holidays[i].startDate);
													do {
														var date = new Date(holidayDate);
														var year = date.getFullYear();
														var month = monthNames[date.getMonth()];
														if (!regionYearMonthHolidays[region]) {
															regionYearMonthHolidays[region] = {};
														}
														if (!regionYearMonthHolidays[region][year]) {
															regionYearMonthHolidays[region][year] = {};
														}
														if (!regionYearMonthHolidays[region][year][month]) {
															regionYearMonthHolidays[region][year][month] = [];
														}
														if (holidays[i].nIsOptional === true) {
															color = '#344c67';
														} else {
															color = 'white';
														}
														regionYearMonthHolidays[region][year][month].push({
															'month' : month,
															'date' : date,
															'name' : holidays[i].sName,
															'country' : holidays[i].sCountry,
															'region' : holidays[i].sRegion,
															'color' : color
														});
														regionYearMonthHolidays[region][year][month] = Utils
																.sortArrayBasedOnDates(regionYearMonthHolidays[region][year][month]);
														holidayDate.setDate(holidayDate.getDate() + 1);
														k++;
													} while (k < daysDiff);
												}
											}
										}
									}
								}
								function getRegionYearMonthHolidays(regionList, yearList) {
									var finalHolidays;
									if ((regionList) && (yearList)) {
										for ( var key in regionList) {
											var region = regionList[key];
											if (regionYearMonthHolidays[region]) {
												for ( var indx in yearList) {
													var year = yearList[indx];
													if (regionYearMonthHolidays[region][year]) {
														if (!finalHolidays) {
															finalHolidays = {};
														}
														if (!finalHolidays[region]) {
															finalHolidays[region] = {};
														}
														if (!finalHolidays[region][year]) {
															finalHolidays[region][year] = {};
														}
														finalHolidays[region][year] = regionYearMonthHolidays[region][year];
													}
												}
											}
										}
										return finalHolidays;
									}
									return null;
								}
								return {
									"getHolidaysList" : getHolidaysList,
									"getAllHoliday" : getAllHoliday,
									"getMonthNames" : getMonthNames,
									"sortByRegionYearMonth" : sortByRegionYearMonth,
									"getRegionYearMonthHolidays" : getRegionYearMonthHolidays
								};
							} ]);
})();