/**
 * Factory responsible for all employee related operations
 */

(function() {
	angular.module('timeOffCommvaultApp.employeeServices', [ 'restangular' ]).factory('employeeServices',
			[ "Restangular", "Utils", "$q", "configService", "TIMEOFF_CONSTANTS",
			function(Restangular, Utils, $q, configService, timeoffConstants) {
				var levelFlag = "";
				var empName = "";
				var managerName = '';
				var locationId = "";
				var environment = "dev";
				var regionSortedHolidays = {};
				var teamMembers = {};
				var employeeDetails = {};
				var microsoftAuthData = {};
				var locationList = [];
				var optionalLeaves = [];
				var yearList = [];
				var regionList = [];
				var emailId = "";
				var reportsURL = "";
				//required for apply page

				function setOptionalLeavesArray(leaveArray) {
					optionalLeaves = leaveArray;
				}

				function getOptionalLeavesArray() {
					return optionalLeaves;
				}

				function getDisabledHolidays(date, mode, applicableHolidays) {
					if (mode === "day") {
						var checkDate = new Date(date.toDateString() + " 00:00:00");
						var dateArray = [];
						for ( var index in applicableHolidays) {
							if (applicableHolidays[index].nIsOptional !== true) {
								var holidayStart = new Date(applicableHolidays[index].startDate);
								var holidayEnd = new Date(applicableHolidays[index].endDate);
								if (checkDate >= holidayStart && checkDate <= holidayEnd) {
									dateArray.push(date.getDate() + "-" + (date.getMonth()) + "-" + date.getYear());
								}
							}
						}
						var dateString = date.getDate() + "-" + date.getMonth() + "-" + date.getYear();
						return (($.inArray(dateString, dateArray) !== -1));
					}
					return false;
				}

				function findCommonData(dataArray1, dataArray2) {
					var finalDataArray = [];
					angular.forEach(dataArray1, function(value, index) {
						angular.forEach(dataArray2, function(object, index1) {
							if (value.nID === object.nID) {
								finalDataArray.push(object);
							}
						});
					});
					return finalDataArray;
				}

				function getSelectedTeamMembersManagerName(addedTeamMember) {
					var teamMemberwithManager = {};
					var manager = valueOfAnotherMember(teamMembers, addedTeamMember, "Manager", "sEmpName");
					teamMemberwithManager = {
						"teamMemberName" : addedTeamMember,
						"manager" : manager
					};
					return teamMemberwithManager;
				}

				//Used

				function setEnvironment(envType) {
					environment = envType;
					URL = (environment === "dev") ? configService.returnDevUrl() : configService.returnProdUrl();
				}

				function getUrlObj() {
					return URL;
				}

				function getEmployeeDetails() {
					return Restangular.all(URL.mainPage).getList();
				}

				function preserveData() {
					var deferred = $q.defer();
					if (empName === "") {
						getEmployeeDetails().then(function(resp) {
							if (resp) {
								if (Utils.isValidResponse(resp)) {
									setEmployeeDetails(resp[0]);
									var rootScope = {
										empName : getEmpName(),
										levelFlag : getLevelFlag(),
										reportsURL : reportsURL
									};
									deferred.resolve(rootScope);
								} else {
									deferred.reject(resp);
								}
							} else {
								resp = {};
								resp.printError = true;
								deferred.reject(resp);
							}
						}, function(resp) {
							if (!resp) {
								resp = {};
							}
							resp.printError = true;
							deferred.reject(resp);
						});
					} else {
						var rootScope = {
							empName : getEmpName(),
							levelFlag : getLevelFlag(),
							reportsURL : reportsURL
						};
						deferred.resolve(rootScope);
					}
					return deferred.promise;
				}

				function setEmployeeDetails(data) {
					reportsURL = data.reportsURL;
					employeeDetails = data.data[0];
					levelFlag = employeeDetails.sRole;
					empName = employeeDetails.sEmpName;
					managerName = employeeDetails.Manager;
					teamMembers = employeeDetails.TeamMembers;
					locationId = employeeDetails.nLocationID;
					locationList = employeeDetails.LocationsList;
					emailId = employeeDetails.sEmail;
					setMicrosoftAuthData();
					setYearList();
					setRegionSortedHolidays();
				}

				function getLevelFlag() {
					return levelFlag;
				}

				function getEmpName() {
					return employeeDetails.sEmpName;
				}

				function getLocationId() {
					return locationId;
				}

				function getHolidays() {
					return employeeDetails.Holidays;
				}

				function getEnvironment() {
					return environment;
				}

				function getDepartmentName() {
					return employeeDetails.DeptName;
				}
				function getManagerName() {
					return employeeDetails.Manager;
				}

				function getLeaveTypes() {
					return employeeDetails.empLeaveType;
				}

				function getProdcertName() {
					return employeeDetails.ProdcertName;
				}

				function getTeamMembers() {
					return teamMembers;
				}

				function getEmployeeObj() {
					return employeeDetails;
				}
				function getEmailId() {
					return emailId;
				}
				function getMicrosoftAuthData() {
					return microsoftAuthData;
				}

				function isOutOfOfficeEnabled() {
					if(microsoftAuthData && microsoftAuthData.bEnableOutOfOffice) {
						if(microsoftAuthData.bEnableOutOfOffice.toString() === "1" || microsoftAuthData.bEnableOutOfOffice.toString() === "true") {
							return true;
						}
					}
					return false;
				}
				function getLocationList() {
					return locationList;
				}
				function getOthersId(locList) {
					var id = 0;
					for (var i = 0; i < locList.length; i++) {
						if (locList[i].sRegionName === "OTHER") {
							id = locList[i].nLocationID;
						}
					}
					return id;
				}

				function getListingObjArray(moduleName) {
					var deferred = $q.defer();
					Restangular.all(URL["get" + moduleName]).getList().then(function(resp) {
						if (resp) {
							if (resp[0]) {
								if (resp[0].data === null) {
									resp[0].data = [];
								}
								if (Utils.isValidResponse(resp)) {
									resp.printError = false;
									deferred.resolve(resp[0].data);
								} else {
									deferred.reject(resp);
								}
							} else {
								resp.printError = true;
								deferred.reject(resp);
							}
						} else {
							resp = {};
							resp.printError = true;
							deferred.reject(resp);
						}
					}, function(resp) {
						if (!resp) {
							resp = {};
						}
						resp.printError = true;
						deferred.reject(resp);
					});
					return deferred.promise;
				}

				// used for all create , update and delete API's
				function cudAPI(requestParams, url) {
					var deferred = $q.defer();
					var urlObj = Restangular.all(url);
					urlObj.post(requestParams, "get").then(function(resp) {
						if (resp) {
							if (Utils.isValidResponse(resp)) {
								resp.printError = false;
								deferred.resolve(resp);
							} else {
								deferred.reject(resp);
							}
						} else {
							resp = {};
							resp.printError = true;
							deferred.reject(resp);
						}
					}, function(resp) {
						if (!resp) {
							resp = {};
						}
						resp.printError = true;
						deferred.reject(resp);
					});
					return deferred.promise;
				}

				function valueOfAnotherMember(obj, valueOfField, requireValueOfanotherField, keyFieldName) {
					//If part can be removed once displayLeaveDetailsInDiv() in apply page removed
					if (!keyFieldName) {
						for ( var index in obj) {
							for ( var objkey in obj[index]) {
								if ((obj[index][objkey] === valueOfField)) {
									if ((requireValueOfanotherField === "")) {
										return obj[index];
									} else {
										return obj[index][requireValueOfanotherField];
									}
								}
							}
						}
					} else {
						for ( var index in obj) {
							if ((obj[index][keyFieldName] === valueOfField)) {
								if ((requireValueOfanotherField === "")) {
									return obj[index];
								} else {
									return obj[index][requireValueOfanotherField];
								}
							}
						}
					}
					return null;
				}

				function setMicrosoftAuthData() {
					microsoftAuthData = employeeDetails.microsoftAuthData;
					// set default values
					if(microsoftAuthData) {
						// Set authority if not available
						if(!microsoftAuthData.AzureLoginEndpoint) {
							microsoftAuthData.AzureLoginEndpoint = timeoffConstants.MSAL_CONFIG.authority;
						}
					}
					// Check wheter required fields are available
					if(microsoftAuthData &&
					   microsoftAuthData.AzureADClientID &&
					   microsoftAuthData.AzureADTenantID &&
					   microsoftAuthData.AzureLoginEndpoint) {}
					else {
						microsoftAuthData.bEnableOutOfOffice = "0";
					}
				}

				function setYearList() {
					var j = -1;
					var dateObj = new Date();
					yearList = [];
					for (var i = 0; j <= 1; i++, j++) {
						yearList[i] = dateObj.getFullYear() + j;
					}

				}

				function getRegionName(regionId) {
					if (!regionId) {
						regionId = locationId;
					}
					return (valueOfAnotherMember(locationList, regionId, "sRegionName", "nLocationID"));
				}
				function setRegionSortedHolidays() {
					regionSortedHolidays = {};
					regionList = [];
					var holiday = employeeDetails.Holidays;
					if ((holiday)) {
						for ( var key in holiday) {
							var parent = false;
							var LocationId = holiday[key].nLocationID;
							for (var i = 0; i < locationList.length; i += 1) {
								if (locationList[i].nParentLocID === LocationId) {
									parent = true;
									if (!regionSortedHolidays[locationList[i].sRegionName]) {
										regionList.push(locationList[i].sRegionName);
										regionSortedHolidays[locationList[i].sRegionName] = [];
									}
									regionSortedHolidays[locationList[i].sRegionName].push(holiday[key]);
								}
							}
							//if (parent === false) {
							if (!regionSortedHolidays[holiday[key].sRegion]) {
								regionList.push(holiday[key].sRegion);
								regionSortedHolidays[holiday[key].sRegion] = [];
							}
							regionSortedHolidays[holiday[key].sRegion].push(holiday[key]);
							//}
						}
					}
				}
				function setHolidays(newHolidays) {
					employeeDetails.Holidays = newHolidays;
					setRegionSortedHolidays();
				}

				function getRegionSortedHolidays() {
					return regionSortedHolidays;
				}

				function getYearList() {
					return yearList;
				}

				function getHolidayRegionList() {
					return regionList;
				}
				function getHolidaysForApplyPage() {
					var holidaysList = {};
					var holiday = employeeDetails.Holidays;
					if ((holiday)) {
						for ( var key in holiday) {
							var parent = false;
							var LocationId = holiday[key].nLocationID;
							for (var i = 0; i < locationList.length; i += 1) {
								if (locationList[i].nParentLocID === LocationId) {
									parent = true;
									if (!holidaysList[locationList[i].sRegionName]) {
										holidaysList[locationList[i].sRegionName] = [];
									}
									holidaysList[locationList[i].sRegionName].push(holiday[key]);
								}
							}
							//if (parent === false) {
							if (!holidaysList[holiday[key].sRegion]) {
								holidaysList[holiday[key].sRegion] = [];
							}
							holidaysList[holiday[key].sRegion].push(holiday[key]);
							//}
						}
					}
					return holidaysList;
				}
				return {
					"cudAPI" : cudAPI,
					"findCommonData" : findCommonData,
					"getLeaveTypes" : getLeaveTypes,
					"getLocationId" : getLocationId,
					"getLevelFlag" : getLevelFlag,
					"getEmpName" : getEmpName,
					"getHolidays" : getHolidays,
					"getDisabledHolidays" : getDisabledHolidays,
					"getEmployeeDetails" : getEmployeeDetails,
					"getProdcertName" : getProdcertName,
					"getEnvironment" : getEnvironment,
					"getManagerName" : getManagerName,
					"getTeamMembers" : getTeamMembers,
					"getDepartmentName" : getDepartmentName,
					"getSelectedTeamMembersManagerName" : getSelectedTeamMembersManagerName,
					"getOptionalLeavesArray" : getOptionalLeavesArray,
					"getLocationList" : getLocationList,
					"getEmployeeObj" : getEmployeeObj,
					"getOthersId" : getOthersId,
					"getRegionName" : getRegionName,
					"getHolidayRegionList" : getHolidayRegionList,
					"getRegionSortedHolidays" : getRegionSortedHolidays,
					"getYearList" : getYearList,
					"getUrlObj" : getUrlObj,
					"getListingObjArray" : getListingObjArray,
					"getHolidaysForApplyPage" : getHolidaysForApplyPage,
					"preserveData" : preserveData,
					"setHolidays" : setHolidays,
					"setEnvironment" : setEnvironment,
					"setEmployeeDetails" : setEmployeeDetails,
					"setOptionalLeavesArray" : setOptionalLeavesArray,
					"valueOfAnotherMember" : valueOfAnotherMember,
					"getEmailId" : getEmailId,
					"getMicrosoftAuthData": getMicrosoftAuthData,
					"isOutOfOfficeEnabled": isOutOfOfficeEnabled

				};
			} ]);
})();