/**
 * Factory responsible for calendar operations
 */

(function() {
	'use strict';
	angular.module('timeOffCommvaultApp.calendarServices', [ 'restangular' ]).factory('calenderService',
			[
					"Restangular",
					"Utils",
					"employeeServices",
					"configService",
					function(Restangular, Utils, employeeServices, configService) {

						return {
							getRegionHolidays : function(region) {
								var regionHolidays = employeeServices.getRegionSortedHolidays();
								if (regionHolidays) {
									for ( var key in regionHolidays) {
										if (key == region) {
											return regionHolidays[key];
										}
									}
								}
								return null;
							},
							createEventsList : function(data, type) {
								var eventArray = [];
								if (data) {
									for ( var index in data) {
										eventArray.push({
											type : type,
											title : Utils.unescapeHtml(data[index].sName),
											start : new Date(data[index].startDate),
											end : new Date(new Date(data[index].endDate).getTime() + (60 * 60)),
											allDay : true
										});
									}
								}
								return eventArray;
							},
							createCompanyEvents : function(data) {
								var eventsArray = [];
								if (data) {
									for ( var index in data) {
										eventsArray.push({
											type : 'companyEvents',
											venue : data[index].sVenue,
											title : Utils.unescapeHtml(data[index].sEventName),
											start : new Date(data[index].dStartDate +
													configService.halfDayParameters.secondHalfStartTime),
											end : new Date(data[index].dEndDate +
													configService.halfDayParameters.secondHalfEndTime),
											allDay : true
										});
									}
								}
								return eventsArray;
							},
							getEventsArray : function(data, memberName) {
								if (memberName === undefined) {
									memberName = "";
								}
								var datestart, dateend, fullDay;
								var eventArray = [];
								if (data) {
									for ( var index in data) {
										var currData = data[index];
										if ((currData.sRequestStatus != "Cancelled") &&
												(currData.sRequestStatus != "Rejected")) {
											if (currData.bIsHalfDay) {
												if (currData.bHalfDayType) {
													datestart = currData.dateStart.replace(/-/g, "/") +
															configService.halfDayParameters.secondHalfStartTime;
													dateend = currData.dateEnd.replace(/-/g, "/") +
															configService.halfDayParameters.secondHalfEndTime;
												} else {
													datestart = currData.dateStart.replace(/-/g, "/") +
															configService.halfDayParameters.firstHalfStartTime;
													dateend = currData.dateEnd.replace(/-/g, "/") +
															configService.halfDayParameters.firstHalfEndTime;
												}
												fullDay = false;
											} else {
												datestart = currData.dateStart.replace(/-/g, "/") +
														configService.halfDayParameters.firstHalfStartTime;
												dateend = currData.dateEnd.replace(/-/g, "/") +
														configService.halfDayParameters.secondHalfEndTime;
												fullDay = true;
											}
											eventArray.push({
												type : "timeOff",
												title : Utils.unescapeHtml(memberName + " " +
														(currData.sRequestType || '')),
												status : (currData.sRequestStatus || ''),
												requestor : currData.sRequestor,
												leaveTypeId : currData.nRequestTypeID,
												leaveid : currData.nID,
												action : currData.sAction,
												start : datestart,
												end : dateend,
												allDay : fullDay
											});
										}
									}
								}
								return eventArray;
							},
							getTableData : function(timeOffArray, currentMonth, currentYear, empData, empIndex) {
								var tableTimeOffArray = [];
								var currData;
								if (timeOffArray) {
									for ( var index in timeOffArray) {
										currData = timeOffArray[index];
										if ((currData.sRequestStatus != "Cancelled") &&
												(currData.sRequestStatus != "Rejected")) {
											if (((currentMonth == new Date(currData.dateStart.replace(/-/g, "/"))
													.getMonth()) && (currentYear == new Date(currData.dateStart
													.replace(/-/g, "/")).getFullYear())) ||
													((currentMonth == new Date(currData.dateEnd.replace(/-/g, "/"))
															.getMonth()) && (currentYear == new Date(currData.dateEnd
															.replace(/-/g, "/")).getFullYear()))) {
												currData.color = empData.color;
												currData.empName = empData.empName;
												currData.prodCertName = empData.prodCertName;
												currData.location = empData.location;
												currData.empIndex = empIndex;
												tableTimeOffArray.push(currData);
											}
										}
									}
								}
								return tableTimeOffArray;
							}
						}
					} ]);
})();