/**
 * Factory responsible for operations used in assign proxy and manager proxy page
 */
(function() {
	angular.module('timeOffCommvaultApp.assignProxyServices', [ 'restangular' ]).factory('assignProxyServices',
			[
					"Restangular",
					"Utils",
					"$q",
					"$timeout",
					"configService",
					"employeeServices",
					function(Restangular, Utils, $q, $timeout, configService, employeeServices) {
						var URL = {};
						var managerList;
						var assignedProxy;

						function setURL() {
							URL = (employeeServices.getEnvironment() == 'dev') ? configService.returnDevUrl()
									: configService.returnProdUrl();
						}

						function getAllManagersData() {
							var deffered = $q.defer();
							Restangular.all(URL.getManagerDetails).getList().then(function(resp) {
								if (resp[0].data == null) {
									resp[0].data = [];
								}
								if (Utils.isValidResponse(resp[0])) {
									managerList = resp[0].data;
									deffered.resolve(managerList);
								} else {
									deffered.reject(resp);
								}
							}, function(resp) {
								deffered.reject(resp);
								Utils.displayError();
							});
							return deffered.promise;
						}

						function getManagerNameDept(certName) {
			                var temp = {};
			                if(managerList){
				                for (var i = 0; i < managerList.length; i++) {
				                    if (managerList[i].ProdcertName == certName) {
				                    	temp = {
												"sEmpName" : managerList[i].sEmpName,
												"sDeptName" : managerList[i].sDeptName
											}
				                    }
				                }
			                }
			                return temp;
			            }

						function getManagersList() {
							return managerList;
						}

						function getAllAssignedProxies() {
							//return makeGetRequest(URL.getAssignedProxy).then(function (){
							//    return managerList;
							//})
							var defered = $q.defer();
							Restangular.all(URL.getAssignProxy).getList().then(function(resp) {
								if (resp[0].data == null) {
									resp[0].data = [];
								}
								if (Utils.isValidResponse(resp[0])) {
									assignedProxy = resp[0].data;
									defered.resolve(assignedProxy);
								} else {
									defered.reject(resp);
								}
							}, function(resp) {
								defered.reject(resp);
								Utils.displayError();
							});
							return defered.promise;
						}

						function getAllManagersProxies() {
							var deferred = $q.defer();
							var requestUrl;
							var leaveParams = {
								"alias" : employeeServices.getProdcertName()
							};
							if (employeeServices.getEnvironment() == "prod") {
								requestUrl = Restangular.all(URL.getManagerProxy)
								requestUrl.post(leaveParams, "get", {
									csrf : Utils.getCsrfToken()
								}).then(function(data) {
									if (!Utils.isValidResponse(data[0])) {
										if (data[0].data == null) {
											data[0].data = [];
										}
										deferred.reject(data);
									} else {
										if (data[0].data == null) {
											data[0].data = [];
										}
										deferred.resolve(data[0].data);
									}
								}, function(data) {
									deferred.reject(data);
								})
								return deferred.promise;
							} else {
								requestUrl = Restangular.all(URL.getManagerProxy).getList().then(function(resp) {
									if (resp[0].data == null) {
										resp[0].data = [];
									}
									if (Utils.isValidResponse(resp[0])) {
										assignedProxy = resp[0].data;
										deferred.resolve(assignedProxy);
									} else {
										deferred.reject(resp);
									}
								})
								//deferred.resolve({'success': true});
								return deferred.promise;
							}
						}

						function postNewProxy() {
						}

						return {
							"getAllManagersData" : getAllManagersData,
							"setURL" : setURL,
							"getAllAssignedProxies" : getAllAssignedProxies,
							"getManagerNameDept" : getManagerNameDept,
							"getAllManagersProxies" : getAllManagersProxies
						}
					} ]);
})();