/**
 * Factory used for operations related to approve time off page
 */
(function() {
	'use strict';
	angular.module('timeOffCommvaultApp.approveTimeOffService', [ 'restangular' ]).factory('approveTimeOffService',
			[
					"Restangular",
					"$q",
					"$http",
					"Utils",
					"configService",
					"employeeServices",
					function(Restangular, $q, $http, Utils, configService, employeeServices) {
						var URL = (employeeServices.getEnvironment() === 'dev') ? configService.returnDevUrl()
								: configService.returnProdUrl();
						var environment = employeeServices.getEnvironment();

						function retrieveTimeOffs(pageNo, pageSize, location, status) {
							var deferred = $q.defer();
							var requestParams = {
								"alias" : employeeServices.getProdcertName(),
								"status" : status,
								"pageno" : pageNo,
								"pageSize" : pageSize,
								'locations' : location
							};
							var urlObj = Restangular.all(URL.pendingTimeOff);
							if (environment === 'dev') {
								urlObj.getList().then(function(resp) {
									if (Utils.isValidResponse(resp[0])) {
										deferred.resolve(resp[0].data[0]);
									} else {
										deferred.reject(resp);
									}
								}, function(resp) {
									deferred.reject(resp);
								});
							} else {
								urlObj.post(requestParams, "get", {
									csrf : Utils.getCsrfToken()
								}).then(function(resp) {
									if (resp[0].data === null) {
										resp[0].data = [ {
											"MyTimeOffApprovals" : [],
											"TotalTimeOffCount" : 0
										} ];
									}
									if (Utils.isValidResponse(resp[0])) {
										deferred.resolve(resp[0].data[0]);
									} else {
										deferred.reject(resp);
									}
								}, function(resp) {
									deferred.reject(resp);
								});
							}
							return deferred.promise;
						}

						function sendDetailsRequest(type, body) {
							var deferred = $q.defer();
							var url;
							if (type === "Email") {
								url = URL.sendEmail;
							} else if (type === "Approve") {
								url = URL.approveTimeOff;
							} else if (type === "Reject") {
								url = URL.rejectTimeOff;
							}
							var requestParams = body;
							var urlObj = Restangular.all(url);
							urlObj.post(requestParams, "get", {
								csrf : Utils.getCsrfToken()
							}).then(function(resp) {
								if (resp[0].data === null) {
									resp[0].data = [ {
										"MyTimeOffApprovals" : [],
										"TotalTimeOffCount" : 0
									} ];
								}
								if (Utils.isValidResponse(resp[0])) {
									deferred.resolve(resp[0].data[0]);
								} else {
									deferred.reject(resp);
								}
							}, function(resp) {
								deferred.reject(resp);
							});
							return deferred.promise;
						}

						return {
							"retrieveTimeOffs" : retrieveTimeOffs,
							"sendDetailsRequest" : sendDetailsRequest
						};
					} ]);
})();