/**
 * Factory used for admin related operations
 */
(function() {
	angular.module('timeOffCommvaultApp.adminServices', [ 'restangular' ]).factory('adminServices',
			[
					"Restangular",
					"Utils",
					"$q",
					"$timeout",
					"configService",
					"employeeServices",
					"holidayService",
					"i8nConstants",
					function(Restangular, Utils, $q, $timeout, configService, employeeServices, holidayService,
							i8nConstants) {
						var URL = {};
						var moduleList = [];
						var approvalId = -1;
						var entitlementId = -1;

						function getApprovalId() {
							return approvalId;
						}
						function setApprovalId(approvalID) {
							approvalId = approvalID;
						}
						function getEntitlementId() {
							return entitlementId;
						}
						function setEntitlementId(entitlementID) {
							entitlementId = entitlementID;
						}
						function addRules() {
							if ($("#selectedTimeOff").val() == "") {
								$("#nTimeOffID").rules("add", {
									required : true
								});
								$("#nEntitlementID").rules("add", {
									required : true
								});
								$("#nNotificationID").rules("add", {
									required : true
								});
							}
						}

						function removeRules() {
							$("#nTimeOffID").rules("remove");
							$("#nEntitlementID").rules("remove");
							$("#nNotificationID").rules("remove");
						}

						function setURL() {
							URL = (employeeServices.getEnvironment() == 'dev') ? configService.returnDevUrl()
									: configService.returnProdUrl();
						}

						function getUrlObj() {
							var UrlObj = (employeeServices.getEnvironment() == 'dev') ? configService.returnDevUrl()
									: configService.returnProdUrl();
							return UrlObj;
						}

						function getCountries(locationList) {
							var countryList = [];
							var completeList = [];
							for ( var index in locationList) {
								if (locationList[index].sCountryName != "") {
									if (countryList.indexOf(locationList[index].sCountryName) == -1) {
										countryList.push(locationList[index].sCountryName);
										completeList.push([]);
									}
									completeList[countryList.indexOf(locationList[index].sCountryName)]
											.push(locationList[index].sRegionName);
								}
							}
							var obj = {
								"countries" : countryList,
								"completeList" : completeList
							}
							return obj;
						}

						function populateForm(parameterObj, actualParams) {
							if (parameterObj == "") {
								for ( var key in actualParams) {
									var dateCheck = eval("actualParams." + key);
									if ($.isArray(dateCheck)) {
										$("#" + eval("actualParams." + key + "[0]")).val("");
									} else {
										var obj = eval("actualParams." + key);
										if (obj === Object(obj) &&
												Object.prototype.toString.call(obj) !== '[object Array]') {
											for ( var objKey in obj) {
												if (obj[objKey] != "array") {
													$("#" + obj[objKey] + "_0").val("");
												} else {
													$("#" + obj[objKey]).val("");
												}
											}
										} else {
											$("#" + key).val("");
										}
									}
								}
							} else {
								for ( var key in actualParams) {
									var dateCheck = eval("actualParams." + key);
									if ($.isArray(dateCheck)) {
										$("#" + eval("actualParams." + key + "[0]")).val(Utils
												.defaultFormateDate(eval("parameterObj." + key)));
									} else {
										var obj = eval("actualParams." + key);
										if (obj === Object(obj) &&
												Object.prototype.toString.call(obj) !== '[object Array]') {
											for ( var objKey in obj) {
												if (obj[objKey] == "array") {
													var dataArray = eval("parameterObj." + key);
													if (key == "nCntCountEscalationList") {
														for (var i = 0; i < dataArray.length; i++) {
															if (i != 0) {
																$("#first_text_" + i).closest(".row")
																		.find(".plus-sign").trigger("click");
															}
															$("#first_text_" + i).val(dataArray[i].key);
															$("#second_text_" + i).val(dataArray[i].value);
														}
													}
													if (key == "nTotalCountEscalationList") {
														for (var i = 0; i < dataArray.length; i++) {
															if (i != 0) {
																$("#total_first_text_" + i).closest(".row")
																		.find(".plus-sign").trigger("click");
															}
															$("#total_first_text_" + i).val(dataArray[i].key);
															$("#total_second_text_" + i).val(dataArray[i].value);
														}
													}
												} else {
													if (typeof eval("parameterObj." + key) == 'number')
														$("#" + objKey).val(eval("parameterObj." + key));
													else
														$("#" + objKey).val(Utils.unescapeHtml(eval("parameterObj." +
																key)));
												}
											}
										} else {
											if (typeof eval("parameterObj." + key) == 'number')
												$("#" + key).val(eval("parameterObj." + key));
											else
												$("#" + key).val(Utils.unescapeHtml(eval("parameterObj." + key)));
										}
									}
								}
							}
						}

						// ised for all create , update and delete API's
						function cudAPI(requestParams, url) {
							setURL();
							var deferred = $q.defer();
							var urlObj = Restangular.all(url);
							urlObj.post(requestParams, "get", {
								csrf : Utils.getCsrfToken()
							}).then(function(resp) {
								if (Utils.isValidResponse(resp[0])) {
									deferred.resolve(resp);
								} else {
									deferred.reject(resp);
								}
							}, function(resp) {
								//deferred.resolve({"success": true});
								deferred.reject(resp);
							});
							return deferred.promise;
						}

						function getListingObjArray(moduleName) {
							setURL();
							moduleList = [];
							if (moduleName == "Holiday") {
								return holidayService.getAllHoliday();
							}
							var deferred = $q.defer();
							Restangular.all(eval("URL.get" + moduleName)).getList().then(function(resp) {
								if (resp[0].data == null) {
									resp[0].data = [];
								}
								if (Utils.isValidResponse(resp[0])) {
									deferred.resolve(resp[0].data);
								} else {
									deferred.reject(resp);
								}
							}, function(resp) {
								deferred.reject(resp);
							})
							return deferred.promise;
						}

						function clearFields(module) {
							if (module != "Employee") {
								$("#editFlag").val("0");
							}
							if (module == "AssignProxy") {
								$("#btn_sProxy").val("");
								$("#btn_sUser").val("");
								$("#sProxy").val("");
								$("#sUser").val("");
								$("#currDept").val("");
								$("#tempDept").val("");
								$("#dValidFrom").val("");
								$("#dExpiryDate").val("");
							}
							if (module == "ManagerProxy") {
								$("#btn_sProxy").val("");
								$("#sProxy").val("");
								$("#tempDept").val("");
								$("#dValidFrom").val("");
								$("#dExpiryDate").val("");
							}
							if (module == "Title") {
								$("#sTitleName").val('');
							}
							if (module == "Team") {
								$("#sTeamName").val('');
							}
							if (module == "Department") {
								$("#sDeptName").val('');
							}
							if (module == "Location") {
								$("#sCountryName").val('');
								$("#sRegionName").val('');
								$("#btn_sTimeZone .selVal").html(i8nConstants.SELECT_TIMEZONE);
								$("#sTimeZone").val('');
							}
							if (module == "Holiday") {
								$(".selRegion").html(i8nConstants.SELECT_REGION_STATE);
								$("#sRegion").val('');
								$(".selCountry").html(i8nConstants.SELECT_COUNTRY);
								$("#sCountry").val('');
								$('#CompensatoryH').attr("checked", false);
								$('#nIsOptional').attr("checked", false);
								$("#startDate").val('');
								$("#endDate").val('');
								$("#sName").val('');
								$("#nLocationID").val('');
							}
							if (module == "Event") {
								$('#startdate').val('');
								$('#enddate').val('');
								$('#sVenue').val('');
								$("#sEventName").val('');
								$("#btn_sVenue").val('');
								$('#sDetails').val('');
								$("#sVenueOthers").val('');
								$(".other-venue").hide();
							}
							if (module == "EntitlementPolicy") {
								$('#sPolicyName').val('');
								$('#nMaxAllowed').val('');
								$('#nDuration').val('');
								$("#startdate").val('');
								$("#nMaxContAllowed").val('');
								$('#nMaxCountAllowed').val('')
								$('#nAccruedPerMonth').val('')
								$('#nCarryFwdAllowed').val('')
							}
							if (module == "NotificationPolicy") {
								$('#notification_policy_name').val('');
								$('.first-text').val('');
								$('.second-text').val('');
								$(".total-first-text").val('');
								$(".total-second-text").val('');
							}
						}

						return {
							"cudAPI" : cudAPI,
							"getUrlObj" : getUrlObj,
							"populateForm" : populateForm,
							"getListingObjArray" : getListingObjArray,
							"getCountries" : getCountries,
							"moduleList" : moduleList,
							"addRules" : addRules,
							"removeRules" : removeRules,
							"clearFields" : clearFields,
							"setApprovalId" : setApprovalId,
							"getApprovalId" : getApprovalId,
							"setEntitlementId" : setEntitlementId,
							"getEntitlementId" : getEntitlementId
						}
					} ]);
})();