/**
 * Factory used for page add time off
 */
(function() {
	'use strict';
	angular.module('timeOffCommvaultApp.addLeaveTypeServices', [ 'restangular' ])
			.factory('addLeaveTypeServices',
					[
							"employeeServices",
							"configService",
							"$q",
							"Utils",
							"Restangular",
							function(employeeServices, configService, $q, Utils, Restangular) {
								var environment = employeeServices.getEnvironment();
								var URL = (environment == 'dev') ? configService.returnDevUrl() : configService
										.returnProdUrl();
								var timeOffList = [];
								var entitlementList = [];
								var approvalList = [];

								function fetchListOfTimeOffs() {
									var deferred = $q.defer();
									if (environment == "dev") {
										Restangular.all(URL.getListOfTimeOffs).getList().then(function(resp) {
											if (resp[0].data == null) {
												resp[0].data = [];
											}
											if (Utils.isValidResponse(resp[0])) {
												timeOffList = resp[0].data;
												deferred.resolve(resp);
											} else {
												deferred.reject(resp);
											}
										}, function(resp) {
											Utils.displayError();
											deferred.reject(resp);
										});
									} else {

										// test on server
										Restangular.all(URL.getListOfTimeOffs).getList().then(function(resp) {
											if (resp[0].data == null) {
												resp[0].data = [];
											}
											if (Utils.isValidResponse(resp[0])) {
												timeOffList = resp[0].data;
												// var timeoffListObj = employeeServices.giveValueOfAnotherMemberInArrayOfObjects(resp[0].data[0].timeOffs, leaveId, "");
												deferred.resolve(resp);
											} else {
												deferred.reject(resp);
											}
										}, function(resp) {
											deferred.reject(resp);
										});
									}
									return deferred.promise;
								}

								function fetchEntitlementPolicyList() {
									var deferred = $q.defer();
									Restangular.all(URL.getEntitlementList).getList().then(function(resp) {
										if (resp[0].data == null) {
											resp[0].data = [];
										}
										if (Utils.isValidResponse(resp[0])) {
											entitlementList = resp[0].data;
											deferred.resolve(resp);
										} else {
											deferred.reject(resp);
										}
									}, function(resp) {
										Utils.displayError();
										deferred.reject(resp);
									});
									return deferred.promise;
								}

								function fetchApprovalPolicyList() {
									var deferred = $q.defer();
									Restangular.all(URL.getApprovalList).getList().then(function(resp) {
										if (resp[0].data == null) {
											resp[0].data = [];
										}
										if (Utils.isValidResponse(resp[0])) {
											approvalList = resp[0].data;
											deferred.resolve(resp);
										} else {
											deferred.reject(resp);
										}
									}, function(resp) {
										Utils.displayError();
										deferred.reject(resp);
									});
									return deferred.promise;
								}

								function getTimeOffList(location) {
					            	var timeoffs = [];
					            	if(location){
					            		if(timeOffList){
					            			for(var i=0; i< timeOffList.length ; i++){
					            				if(timeOffList[i].nLocationID == location)
					            					timeoffs.push(timeOffList[i]);
					            			}
					            			return timeoffs;
					            		}
					            	}
					            	else
					            		return timeOffList;
					            }

								function getEntitlementPolicyList() {
									return entitlementList;
								}

								function getApprovalPolicyList() {
									return approvalList;
								}

								function getTimeOffObj(timeOffId) {
									var timeOffObj;
									for (var i = 0; i < timeOffList.length; i++) {
										if (timeOffId == timeOffList[i].nID) {
											timeOffObj = timeOffList[i];
										}
									}
									;
									return timeOffObj;
								}

								function addNewTimeOffType(name, isDeductable, entitlementId, approvalId, canOverlap,
										overlapWith, halfdayAllowed, regionId, bIsOptionalType) {
									// var timeoffId = (typeof timeOffId === undefined) ? -1 : timeOffId;
									var postObj = postConstructBody(name,
											isDeductable,
											entitlementId,
											approvalId,
											canOverlap,
											overlapWith,
											halfdayAllowed,
											regionId,
											bIsOptionalType,
											-1);
									var timeOff = Restangular.all(URL.addNewTimeOffType);
									var deferred = $q.defer();
									if (environment == 'prod') {
										timeOff.post(postObj, "get", {
											csrf : Utils.getCsrfToken()
										}).then(function(resp) {
											if (Utils.isValidResponse(resp[0])) {
												// var timeoffListObj = employeeServices.giveValueOfAnotherMemberInArrayOfObjects(resp[0].data[0].timeOffs, leaveId, "");
												deferred.resolve(resp);
											} else {
												deferred.reject(resp);
											}
										}, function(resp) {
											deferred.reject(resp);
										});
									} else {
										deferred.resolve({
											"success" : true
										});
									}
									return deferred.promise;
								}

								function editTimeOffType(name, isDeductable, entitlementId, approvalId, canOverlap,
										overlapWith, halfdayAllowed, regionId, bIsOptionalType, timeOffId) {
									var postObj = postConstructBody(name,
											isDeductable,
											entitlementId,
											approvalId,
											canOverlap,
											overlapWith,
											halfdayAllowed,
											regionId,
											bIsOptionalType,
											timeOffId);
									var timeOff = Restangular.all(URL.editTimeOffType);
									var deferred = $q.defer();
									if (environment == 'prod') {
										timeOff.post(postObj, "get", {
											csrf : Utils.getCsrfToken()
										}).then(function(resp) {
											if (Utils.isValidResponse(resp[0])) {

												// var timeoffListObj = employeeServices.giveValueOfAnotherMemberInArrayOfObjects(resp[0].data[0].timeOffs, leaveId, "");
												deferred.resolve(resp);
											} else {
												deferred.reject(resp);
											}
										}, function(resp) {
											deferred.reject(resp);
										});
									} else {
										timeOff.post(postObj, "get", {
											csrf : Utils.getCsrfToken()
										}).then(function(resp) {
											if (Utils.isValidResponse(resp[0])) {

												// var timeoffListObj = employeeServices.giveValueOfAnotherMemberInArrayOfObjects(resp[0].data[0].timeOffs, leaveId, "");
												deferred.resolve(resp);
											} else {
												deferred.reject(resp);
											}
										}, function(resp) {
											deferred.reject(resp);
										});
										deferred.resolve({
											"success" : true
										});
									}
									return deferred.promise;
								}

								function deleteTimeOffType(nid) {
									var timeOff = Restangular.all(URL.deleteTimeOffType);
									var deferred = $q.defer();
									var postObj = {
										"nID" : nid
									};
									if (environment == 'prod') {
										timeOff.post(postObj, "get", {
											csrf : Utils.getCsrfToken()
										}).then(function(resp) {
											if (Utils.isValidResponse(resp[0])) {

												// var timeoffListObj = employeeServices.giveValueOfAnotherMemberInArrayOfObjects(resp[0].data[0].timeOffs, leaveId, "");
												deferred.resolve(resp);
											} else {
												deferred.reject(resp);
											}
										}, function(resp) {
											deferred.reject(resp);
										});
									} else {
										timeOff.post(postObj, "get", {
											csrf : Utils.getCsrfToken()
										}).then(function(resp) {
											if (Utils.isValidResponse(resp[0])) {

												// var timeoffListObj = employeeServices.giveValueOfAnotherMemberInArrayOfObjects(resp[0].data[0].timeOffs, leaveId, "");
												deferred.resolve(resp);
											} else {
												deferred.reject(resp);
											}
										}, function(resp) {
											//deferred.reject(resp);
											deferred.resolve({
												"success" : true
											});
										});
									}
									return deferred.promise;
								}

								function postConstructBody(name, isDeductable, entitlementId, approvalId, canOverlap,
										overlapWith, halfdayAllowed, regionId, bIsOptionalType, timeOffId) {
									var postObj = {
										"bIsDeductible" : isDeductable,
										"bIsHalfDayAllowed" : halfdayAllowed,
										"bIsOverlapAllowed" : canOverlap,
										"bIsVisibleToAll" : true,
										"nApprovalPolicyID" : approvalId,
										"nEntitlementPolicyID" : entitlementId,
										"nLocationID" : regionId,
										"OverlapRequestTypeID" : overlapWith,
										"sRequestType" : name,
										"bIsOptionalType" : bIsOptionalType
									}
									if (timeOffId != -1) {
										postObj.nID = timeOffId;
									}
									return postObj;
								}

								function getEntitlementPolicyName(entitlementId) {
									var entitlementObj;
									for (var i = 0; i < entitlementList.length; i++) {
										if (entitlementId == entitlementList[i].nID) {
											entitlementObj = entitlementList[i];
											break;
										}
									}
									;
									return entitlementObj.sPolicyName;
								}

								function getApprovalPolicyName(approvalId) {
									var approvalObj;
									for (var i = 0; i < approvalList.length; i++) {
										if (approvalId == approvalList[i].nID) {
											approvalObj = approvalList[i];
											break;
										}
									}
									;
									return approvalObj.sPolicyName;
								}

								return {
									'fetchListOfTimeOffs' : fetchListOfTimeOffs,
									'getTimeOffList' : getTimeOffList,
									'fetchEntitlementPolicyList' : fetchEntitlementPolicyList,
									'getEntitlementPolicyList' : getEntitlementPolicyList,
									'fetchApprovalPolicyList' : fetchApprovalPolicyList,
									'getApprovalPolicyList' : getApprovalPolicyList,
									'addNewTimeOffType' : addNewTimeOffType,
									'getTimeOffObj' : getTimeOffObj,
									'getEntitlementPolicyName' : getEntitlementPolicyName,
									'getApprovalPolicyName' : getApprovalPolicyName,
									'editTimeOffType' : editTimeOffType,
									'deleteTimeOffType' : deleteTimeOffType
								}
							} ]);
})();
