/**
 * It has Utils factory for common functionality operations
 */

(function() {
	angular
			.module('timeOffCommvaultApp.services', [])
			.factory('Utils',
					[
							"$timeout",
							"$rootScope",
							function($timeout, $rootScope) {
								var monthNames = [
										"January",
										"February",
										"March",
										"April",
										"May",
										"June",
										"July",
										"August",
										"September",
										"October",
										"November",
										"December" ];

								function defaultFormateDate(rawDateString) {
									return (((new Date(rawDateString).getDate() < 10)) ? "0" : "") +
											new Date(rawDateString).getDate() + "-" +
											monthNames[(new Date(rawDateString).getMonth())] + "-" +
											new Date(rawDateString).getFullYear();
								}

								function respDateFormat(rawDateString, leadingZeroFlag) {
									return (((new Date(rawDateString).getMonth() < 9) && (leadingZeroFlag === true)) ? "0"
											: "") +
											(new Date(rawDateString).getMonth() + 1) +
											"/" +
											((new Date(rawDateString).getDate() < 10) ? "0" : "") +
											new Date(rawDateString).getDate() +
											"/" +
											new Date(rawDateString).getFullYear();
								}

								function calculateDays(startDateStr, endDateStr) {
									var startDate = new Date(startDateStr.replace(/-/g, "/"));
									var endDate = new Date(endDateStr.replace(/-/g, "/"));
									var millisecondsPerDay = 86400 * 1000;
									startDate.setHours(0, 0, 0, 1);
									endDate.setHours(23, 59, 59, 999);
									var diff = endDate - startDate;
									var days = Math.ceil(diff / millisecondsPerDay);
									return days;
								}

								function sortArrayBasedOnDates(objArr) {
									var temp = {};
									for (var i = 0; i < objArr.length - 1; i++) {
										for (var d = 0; d < objArr.length - i - 1; d++) {
											var date1 = new Date(objArr[d].date).getDate();
											var date2 = new Date(objArr[d + 1].date).getDate();
											if (date1 > date2) {
												temp = objArr[d];
												objArr[d] = objArr[d + 1];
												objArr[d + 1] = temp;
											}
										}
									}
									return objArr;
								}

								function convertDateString(dateData) {
									var monthShortNames = [
											"Jan",
											"Feb",
											"Mar",
											"Apr",
											"May",
											"Jun",
											"Jul",
											"Aug",
											"Sept",
											"Oct",
											"Nov",
											"Dec" ];
									var dateObj = "";
									if (dateData instanceof Date) {
										return dateData.getDate() + " " + monthShortNames[dateData.getMonth()] + " " +
												dateData.getFullYear();
									} else {
										if (dateData) {
											dateData = dateData.replace(/\//g, "-");
										}
										var dateString = dateData.split("-");
										if ((dateString) && (dateString.length) > 0) {
											dateObj = new Date(dateString[2], dateString[0] - 1, dateString[1]);
										}
										return dateObj.getDate() + " " + monthShortNames[dateObj.getMonth()] + " " +
												dateObj.getFullYear();
									}
								}

								function keepDateFieldReadable(keyEvent) {
									keyEvent.preventDefault();
									return false;
								}

								function escapeHtml(unsafe) {
									if (typeof unsafe == "number") {
										return unsafe;
									}
									return unsafe.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;")
											.replace(/"/g, "&quot;").replace(/'/g, "&#039;");
								}

								function unescapeHtml(safeHtml) {
									if (typeof safeHtml == "string") {
										return safeHtml.replace(/&amp;/g, "&").replace(/&lt;/g, "<").replace(/&gt;/g,
												">").replace(/&quot;/g, '"').replace(/&#039;/g, "'");
									}
									return safeHtml;
								}

								function isValidResponse(response) {
									if (response[0]) {
										if ((response[0].error !== null) && (response[0].error !== undefined)) {
											response.printError = false;
											$(".alert-msg").hide();
											if (response[0].error !== "") {
												$rootScope.errorMsg = response[0].error;
												$rootScope.showError = true;
												$timeout(function() {
													$rootScope.showError = false;
													$rootScope.errorMsg = i8nConstants.SOMETHING_WENT_WRONG;
												}, 3000);
											} else {
												response.printError = true;
											}
										} else if (response[0].success === true) {
											response.printError = false;
											return true;
										} else {
											response.printError = false;
											displayError();
										}
									} else {
										response.printError = true;
									}
									return false;
								}

								function displayError() {
									$rootScope.showError = true;
									$timeout(function() {
										$rootScope.showError = false;
									}, 3000);
								}

								function getCsrfToken() {
									function readCookie(name) {
										var nameEQ = name + "=";
										var ca = document.cookie.split(';');
										for (var i = 0; i < ca.length; i++) {
											var c = ca[i];
											while (c.charAt(0) === ' ') {
												c = c.substring(1, c.length);
											}
											if (c.indexOf(nameEQ) === 0) {
												return c.substring(nameEQ.length, c.length);
											}
										}
										return null;
									}

									return readCookie("csrf");
								}

								function uniqid(prefix, more_entropy) {
									//  discuss at: http://phpjs.org/functions/uniqid/
									// original by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
									//  revised by: Kankrelune (http://www.webfaktory.info/)
									//        note: Uses an internal counter (in php_js global) to avoid collision
									//        test: skip
									//   example 1: uniqid();
									//   returns 1: 'a30285b160c14'
									//   example 2: uniqid('foo');
									//   returns 2: 'fooa30285b1cd361'
									//   example 3: uniqid('bar', true);
									//   returns 3: 'bara20285b23dfd1.31879087'

									if (typeof prefix === 'undefined') {
										prefix = '';
									}

									var retId;
									var formatSeed = function(seed, reqWidth) {
										seed = parseInt(seed, 10).toString(16); // to hex str
										if (reqWidth < seed.length) { // so long we split
											return seed.slice(seed.length - reqWidth);
										}
										if (reqWidth > seed.length) { // so short we pad
											return Array(1 + (reqWidth - seed.length)).join('0') + seed;
										}
										return seed;
									};

									// BEGIN REDUNDANT
									if (!this.php_js) {
										this.php_js = {};
									}
									// END REDUNDANT
									if (!this.php_js.uniqidSeed) { // init seed with big random int
										this.php_js.uniqidSeed = Math.floor(Math.random() * 0x75bcd15);
									}
									this.php_js.uniqidSeed++;

									retId = prefix; // start with prefix, add current milliseconds hex string
									retId += formatSeed(parseInt(new Date().getTime() / 1000, 10), 8);
									retId += formatSeed(this.php_js.uniqidSeed, 5); // add seed hex string
									if (more_entropy) {
										// for more entropy we add a float lower to 10
										retId += (Math.random() * 10).toFixed(8).toString();
									}

									return retId;
								}

								return {
									sanitizeRestangularOne : function(item) {
										return _.omit(item,
												"route",
												"parentResource",
												"getList",
												"get",
												"post",
												"put",
												"remove",
												"head",
												"trace",
												"options",
												"patch",
												"$get",
												"$save",
												"$query",
												"$remove",
												"$delete",
												"$put",
												"$post",
												"$head",
												"$trace",
												"$options",
												"$patch",
												"plain",
												"putElement",
												"several",
												"withHttpConfig",
												"_proto_",
												"$then",
												"$resolved",
												"restangularCollection",
												"customOperation",
												"customGET",
												"customPOST",
												"fromServer",
												"getRequestedUrl",
												"newlyAddedProp",
												"oneUrl",
												"customPUT",
												"customDELETE",
												"customGETLIST",
												"$getList",
												"$resolved",
												"restangularCollection",
												"one",
												"all",
												"doGET",
												"doPOST",
												"allUrl",
												"clone",
												"doPUT",
												"doDELETE",
												"$$hashKey",
												"doGETLIST",
												"addRestangularMethod",
												"getRestangularUrl",
												"restangularEtag",
												"reqParams",
												"getParentList",
												"save",
												"data",
												"source",
												"restangularized");
									},
									'getCsrfToken' : getCsrfToken,
									'respDateFormat' : respDateFormat,
									'convertDateString' : convertDateString,
									'isValidResponse' : isValidResponse,
									'displayError' : displayError,
									"defaultFormateDate" : defaultFormateDate,
									"calculateDays" : calculateDays,
									"sortArrayBasedOnDates" : sortArrayBasedOnDates,
									"keepDateFieldReadable" : keepDateFieldReadable,
									"escapeHtml" : escapeHtml,
									"unescapeHtml" : unescapeHtml,
									'uniqid' : uniqid
								};
							} ]);
})();