'use strict';
/**
 * @ngdoc overview
 * @name timeOffCommvaultApp
 * @description
 * # timeOffCommvaultApp
 *
 * Main module of the application.
 */

    var app = angular
        .module('timeOffCommvaultApp', ['ngCookies', 'ngResource', 'ngAnimate', 'ngRoute', 'ngSanitize', 'ngTouch', 'ui.bootstrap', 'angularFileUpload', 'angular-jquery-validate', 'timeOffCommvaultApp.calendarServices',  'timeOffCommvaultApp.services', 'timeOffCommvaultApp.validateObjectServices', 'timeOffCommvaultApp.holidayServices', 'ui.calendar', 'restangular', 'timeOffCommvaultApp.timeoffinfoService', 'timeOffCommvaultApp.urlsServices', 'timeOffCommvaultApp.addLeaveTypeServices', 'timeOffCommvaultApp.adminServices', 'timeOffCommvaultApp.parameterServices', 'timeOffCommvaultApp.assignProxyServices', 'angularUtils.directives.dirPagination', 'ui', 'timeOffCommvaultApp.approveTimeOffService', 'timeOffCommvaultApp.reportsService', 'timeOffCommvaultApp.unescapeFilter', 'timeOffCommvaultApp.i8n'])
        .constant('TIMEOFF_CONSTANTS', {
        	'CALENDER_END_YEAR': 2017
        })
        .run(["$rootScope", "$location", "employeeServices", "Restangular", "$window", "Utils", "i8nConstants", function ($rootScope, $location, employeeServices, Restangular, $window, Utils, i8nConstants) {
            $rootScope.$location = $location
            $rootScope.contentLoaded = false;
            $rootScope.i8nConstants = i8nConstants;
            
            $rootScope.appRoot = appUtil.appRoot;

            window.onload = function () {
                $rootScope.$apply(function () {
                    $rootScope.contentLoaded = true;
                });
                $(".wrapper").removeClass("hide");
            };
            if (window.location.host == "localhost:9000") {
                employeeServices.setEnvironment("dev"); // dev , prod
            } else {
                employeeServices.setEnvironment("prod"); // dev , prod
            }
            if (employeeServices.getEnvironment() == "prod") {
                Restangular.setBaseUrl(window.location.protocol + "//" + window.location.host + appUtil.appRoot);
                $rootScope.$on('$routeChangeStart', function (event, next) {
                    if (Utils.getCsrfToken() == null) {
                        $("#error-msg").html("Redirecting to login page......");
                        $("#error-msg").show();
                        $window.location.href = appUtil.appRoot + "login/#" + $location.path();
                    }
                });
                Restangular.addRequestInterceptor(function (element) {
                    var csrfToken = Utils.getCsrfToken();
                    if (csrfToken != null) {
                        Restangular.setDefaultHeaders({token: csrfToken});
                    }
                    $(".loadingBar").show();
                    if (Utils.getCsrfToken() == null) {
                        $("#error-msg").html("Redirecting to login page......");
                        $("#error-msg").show();
                        $window.location.href = appUtil.appRoot + "login/#" + $location.path();
                    }
                    return element;
                });
                Restangular.addResponseInterceptor(function (data, operation, what, url, response, deferred) {
                    $(".loadingBar").hide();
                    if ((response.config.headers.csrf == null) && (response.config.method != "GET")) {
                        $("#error-msg").html(i8nConstants.REDIRECTING_TO_LOGIN_PAGE);
                        $("#error-msg").show();
                        $window.location.href = appUtil.appRoot + "timeoff/#" + $location.path();
                    }
                    return data;
                });
                Restangular.setErrorInterceptor(function (response, deferred, responseHandler) {
                    $(".loadingBar").hide();
                });
            }
            else {
                Restangular.setBaseUrl("http://localhost:9000");
                Restangular.addRequestInterceptor(function (element) {
                    $(".loadingBar").show();
                    return element;
                });
                Restangular.addResponseInterceptor(function (data, operation, what, url, response, deferred) {
                    $(".loadingBar").hide();
                    return data;
                });
                Restangular.setErrorInterceptor(function (response, deferred, responseHandler) {
                    $(".loadingBar").hide();
                });
            }
        }])
        .config(["$routeProvider", "$jqueryValidateProvider", "$locationProvider", "paginationTemplateProvider", function ($routeProvider, $jqueryValidateProvider, $locationProvider, paginationTemplateProvider) {
            paginationTemplateProvider.setPath('views/dirPagination.tpl.html');
            $routeProvider
                .when('/applyleave', {
                    templateUrl: 'views/apply_time_off.html',
                    controller: 'applyTimeOffCtrl',
                    resolve: {
                        data: ["employeeServices", "$q", "$rootScope", function (employeeServices, $q, $rootScope) {
                            var deferred = $q.defer();
                            employeeServices.preserveData().then(function (resp) {
                                $rootScope.empName = resp.empName;
                                $rootScope.levelFlag = resp.levelFlag;
                                $rootScope.startdate = undefined;
                                $rootScope.enddate = undefined;
                                $rootScope.comment = undefined;
                                $rootScope.requestId = undefined;
                                $rootScope.leaveType = "Select time off type";
                                $rootScope.requestor = undefined;
                                $rootScope.halfDay = "0";
                                deferred.resolve(resp);
                            });
                            return deferred.promise;
                        }]
                    }
                }).when('/editleave/:leaveId/:requestor/:startDate/:endDate', {
                    templateUrl: 'views/apply_time_off.html',
                    controller: 'applyTimeOffCtrl',
                    resolve: {
                        data: ["employeeServices", "$q", "$rootScope", "$route", "Utils", function (employeeServices, $q, $rootScope, $route, Utils) {
                            var deferred = $q.defer();

                            employeeServices.preserveData().then(function (resp) {
                                $rootScope.empName = resp.empName;
                                $rootScope.levelFlag = resp.levelFlag;
                                employeeServices.getLeaveDetailsForEdit($route.current.params.leaveId, $route.current.params.requestor, $route.current.params.startDate, $route.current.params.endDate).then(function (response) {
                                    var resp = response[0];
                                    $rootScope.startdate = new Date(resp.dateStart.replace(/-/g, "/"));
                                    $rootScope.enddate = new Date(resp.dateEnd.replace(/-/g, "/"));
                                    $rootScope.calStartDate = resp.dateStart.replace(/-/g, "/");
                                    $rootScope.calEndDate = new Date(resp.dateEnd.replace(/-/g, "/"));
                                    $rootScope.comment = resp.sComments;
                                    $rootScope.requestId = resp.nRequestTypeID;
                                    $rootScope.leaveType = resp.sRequestType;
                                    $rootScope.requestor = resp.sRequestor;
                                    $rootScope.nWorkDays = resp.nWorkDays;
                                    //timeOffDateDiffService.setDaysOfAbsence(resp.nWorkDays);
                                    $rootScope.halfDay = (resp.bIsHalfDay) ? resp.bHalfDayType : "0";
                                    $rootScope.halfFlag = (resp.bIsHalfDay) ? resp.bIsHalfDay : -1;
                                    $rootScope.halfDayChangeFlag = 0;


                                    deferred.resolve(resp);
                                });
                                //deferred.resolve(resp);
                            });
                            return deferred.promise;
                        }]
                    }
                })
                .when("/calendar", {
                    templateUrl: "views/calendar.html",
                    controller: 'calendarCtrl',
                    resolve: {
                        data: ["employeeServices", "$q", "$rootScope", function (employeeServices, $q, $rootScope) {
                            var deferred = $q.defer();
                            employeeServices.preserveData().then(function (resp) {
                                $rootScope.empName = resp.empName;
                                $rootScope.levelFlag = resp.levelFlag;
                                deferred.resolve(resp);
                            });
                            return deferred.promise;
                        }]
                    }
                })
                .when("/holiday", {
                    templateUrl: "views/holiday.html",
                    controller: 'holidayCtrl',
                    resolve: {
                        data: ["employeeServices", "$q", "$rootScope", "$routeParams", function (employeeServices, $q, $rootScope, $routeParams) {
                            var deferred = $q.defer();
                            employeeServices.preserveData($rootScope).then(function (resp) {
                                $rootScope.empName = resp.empName;
                                $rootScope.levelFlag = resp.levelFlag;
                                deferred.resolve(resp);
                            });
                            return deferred.promise;
                        }]
                    }
                })
                .when("/addEmployee", {
                    templateUrl: "views/addEmployee.html",
                    controller: 'addEmployeeCtrl',
                    resolve: {
                        data: ["employeeServices", "$q", "$rootScope", "$routeParams", function (employeeServices, $q, $rootScope, $routeParams) {
                            var deferred = $q.defer();
                            employeeServices.preserveData($rootScope).then(function (resp) {
                                $rootScope.empName = resp.empName;
                                $rootScope.levelFlag = resp.levelFlag;
                                deferred.resolve(resp);
                            });
                            return deferred.promise;
                        }]
                    }
                })
                .when("/editEmployee/:employeeId", {
                    templateUrl: "views/addEmployee.html",
                    controller: 'addEmployeeCtrl',
                    resolve: {
                        data: ["employeeServices", "$q", "$rootScope", "$routeParams", function (employeeServices, $q, $rootScope, $routeParams) {
                            var deferred = $q.defer();
                            employeeServices.preserveData($rootScope).then(function (resp) {
                                $rootScope.empName = resp.empName;
                                $rootScope.levelFlag = resp.levelFlag;
                                deferred.resolve(resp);
                            });
                            return deferred.promise;
                        }]
                    }
                })
                .when("/timeinfo", {
                    templateUrl: "views/timeoff_info.html",
                    controller: 'timeoffInfoCtrl',
                    resolve: {
                        data: ["employeeServices", "$q", "$rootScope", "$routeParams", function (employeeServices, $q, $rootScope, $routeParams) {
                            var deferred = $q.defer();
                            employeeServices.preserveData($rootScope).then(function (resp) {
                                $rootScope.empName = resp.empName;
                                $rootScope.levelFlag = resp.levelFlag;
                                deferred.resolve(resp);
                            });
                            return deferred.promise;
                        }]
                    }
                })
                .when("/dashboard", {
                    templateUrl: "views/dashboard.html",
                    controller: 'dashboardCtrl',
                    resolve: {
                        data: ["employeeServices", "$q", "$rootScope", "$routeParams", function (employeeServices, $q, $rootScope, $routeParams) {
                            var deferred = $q.defer();
                            employeeServices.preserveData($rootScope).then(function (resp) {
                                $rootScope.empName = resp.empName;
                                $rootScope.levelFlag = resp.levelFlag;
                                deferred.resolve(resp);
                            });
                            return deferred.promise;
                        }]
                    }
                })
                .when("/addLeaveType", {
                    templateUrl: "views/admin_add_leave_type.html",
                    controller: 'addLeaveTypeCtrl',
                    resolve: {
                        data: function (employeeServices, $q, $rootScope, $routeParams) {
                            var deferred = $q.defer();
                            employeeServices.preserveData($rootScope).then(function (resp) {
                                $rootScope.empName = resp.empName;
                                $rootScope.levelFlag = resp.levelFlag;
                                deferred.resolve(resp);
                            });
                            return deferred.promise;
                        }
                    }
                })
                .when("/assignProxy", {
                    templateUrl: "views/assign_proxy.html",
                    controller: 'crudCtrl'
                    ,
                    resolve: {
                        data: function (employeeServices, $q, $rootScope) {
                            var deferred = $q.defer();
                            employeeServices.preserveData($rootScope).then(function (resp) {
                                $rootScope.empName = resp.empName;
                                $rootScope.levelFlag = resp.levelFlag;
                                deferred.resolve(resp);
                                $rootScope.startdate = undefined;
                                $rootScope.enddate = undefined;
                            });
                            return deferred.promise;
                        }
                    }
                })
                .when("/assignManagersProxy", {
                    templateUrl: "views/manager_proxy.html",
                    controller: 'crudCtrl'
                    ,
                    resolve: {
                        data: function (employeeServices, $q, $rootScope) {
                            var deferred = $q.defer();
                            employeeServices.preserveData($rootScope).then(function (resp) {
                                $rootScope.empName = resp.empName;
                                $rootScope.levelFlag = resp.levelFlag;
                                $rootScope.startdate = undefined;
                                $rootScope.enddate = undefined;
                                deferred.resolve(resp);
                            });
                            return deferred.promise;
                        }
                    }
                })
                .when("/employee", {
                    templateUrl: "views/employee.html",
                    controller: 'crudCtrl',
                    resolve: {
                        data: function (employeeServices, $q, $rootScope) {
                            var deferred = $q.defer();
                            employeeServices.preserveData($rootScope).then(function (resp) {
                                $rootScope.empName = resp.empName;
                                $rootScope.levelFlag = resp.levelFlag;
                                deferred.resolve(resp);
                            });
                            return deferred.promise;
                        }
                    }
                })
                .when("/editLeaveType/:leaveId", {
                    templateUrl: "views/admin_add_leave_type.html",
                    controller: 'addLeaveTypeCtrl'
                    ,
                    resolve: {
                        data: function (employeeServices, $q, $rootScope, $routeParams) {
                            var deferred = $q.defer();
                            employeeServices.preserveData($rootScope).then(function (resp) {
                                $rootScope.empName = resp.empName;
                                $rootScope.levelFlag = resp.levelFlag;
                                deferred.resolve(resp);
                            });
                            return deferred.promise;
                        }
                    }
                }).when("/entitlementPolicy", {
                    templateUrl: "views/entitlement_policy.html",
                    controller: "crudCtrl"
                }).when("/addHoliday", {
                    templateUrl: "views/crud_holiday.html",
                    controller: "crudCtrl"
                    ,
                    resolve: {
                        data: function (employeeServices, $q, $rootScope, $routeParams) {
                            var deferred = $q.defer();
                            employeeServices.preserveData($rootScope).then(function (resp) {
                                $rootScope.empName = resp.empName;
                                $rootScope.levelFlag = resp.levelFlag;
                                $rootScope.startdate = undefined;
                                $rootScope.enddate = undefined;
                                deferred.resolve(resp);
                            });
                            return deferred.promise;
                        }
                    }
                }).when("/events", {
                    templateUrl: "views/events.html",
                    controller: "crudCtrl"
                    ,
                    resolve: {
                        data: function (employeeServices, $q, $rootScope, $routeParams) {
                            var deferred = $q.defer();
                            employeeServices.preserveData($rootScope).then(function (resp) {
                                $rootScope.empName = resp.empName;
                                $rootScope.levelFlag = resp.levelFlag;
                                deferred.resolve(resp);
                                $rootScope.startdate = undefined;
                                $rootScope.enddate = undefined;
                            });
                            return deferred.promise;
                        }
                    }
                }).when("/department", {
                    templateUrl: "views/department.html",
                    controller: "crudCtrl"
                    ,
                    resolve: {
                        data: function (employeeServices, $q, $rootScope, $routeParams) {
                            var deferred = $q.defer();
                            employeeServices.preserveData($rootScope).then(function (resp) {
                                $rootScope.empName = resp.empName;
                                $rootScope.levelFlag = resp.levelFlag;
                                deferred.resolve(resp);
                            });
                            return deferred.promise;
                        }
                    }
                }).when("/team", {
                    templateUrl: "views/team.html",
                    controller: "crudCtrl"
                    ,
                    resolve: {
                        data: function (employeeServices, $q, $rootScope, $routeParams) {
                            var deferred = $q.defer();
                            employeeServices.preserveData($rootScope).then(function (resp) {
                                $rootScope.empName = resp.empName;
                                $rootScope.levelFlag = resp.levelFlag;
                                deferred.resolve(resp);
                            });
                            return deferred.promise;
                        }
                    }
                }).when("/title", {
                    templateUrl: "views/title.html",
                    controller: "crudCtrl"
                    ,
                    resolve: {
                        data: function (employeeServices, $q, $rootScope, $routeParams) {
                            var deferred = $q.defer();
                            employeeServices.preserveData($rootScope).then(function (resp) {
                                $rootScope.empName = resp.empName;
                                $rootScope.levelFlag = resp.levelFlag;
                                deferred.resolve(resp);
                            });
                            return deferred.promise;
                        }
                    }
                }).when("/location", {
                    templateUrl: "views/locations.html",
                    controller: "crudCtrl"
                    ,
                    resolve: {
                        data: function (employeeServices, $q, $rootScope, $routeParams) {
                            var deferred = $q.defer();
                            employeeServices.preserveData($rootScope).then(function (resp) {
                                $rootScope.empName = resp.empName;
                                $rootScope.levelFlag = resp.levelFlag;
                                deferred.resolve(resp);
                            });
                            return deferred.promise;
                        }
                    }
                }).when("/approveTimeOff", {
                    templateUrl: "views/approve_timeoff.html",
                    controller: "approvalCtrl"
                    ,
                    resolve: {
                        data: function (employeeServices, $q, $rootScope, $routeParams) {
                            var deferred = $q.defer();
                            employeeServices.preserveData($rootScope).then(function (resp) {
                                $rootScope.empName = resp.empName;
                                $rootScope.levelFlag = resp.levelFlag;
                                deferred.resolve(resp);
                            });
                            return deferred.promise;
                        }
                    }
                })
                .when("/reports", {
                    templateUrl: "views/reports.html",
                    controller: "reportsCtrl"
                    ,
                    resolve: {
                        data: function (employeeServices, $q, $rootScope, $routeParams) {
                            var deferred = $q.defer();
                            employeeServices.preserveData($rootScope).then(function (resp) {
                                $rootScope.empName = resp.empName;
                                $rootScope.levelFlag = resp.levelFlag;
                                deferred.resolve(resp);
                                $rootScope.startdate = undefined;
                                $rootScope.enddate = undefined;
                            });
                            return deferred.promise;
                        }
                    }
                })
                .otherwise({
                    //redirectTo: '/applyleave'
                    resolve: {
                        data: ["employeeServices", "$q", "$rootScope", "$routeParams", "$location", function (employeeServices, $q, $rootScope, $routeParams, $location) {
                            var deferred = $q.defer();
                            employeeServices.preserveData($rootScope).then(function (resp) {
                                $rootScope.empName = resp.empName;
                                $rootScope.levelFlag = resp.levelFlag;
                                if ($rootScope.levelFlag == "Admin") {
                                    $location.path("/dashboard");
                                } else {
                                    $location.path("/applyleave");
                                }
                                deferred.resolve(resp);
                            });
                            return deferred.promise;
                        }]
                    }
                });
            $jqueryValidateProvider.setDefaults({
                ignore: '',
                errorPlacement: function (error, element) {
                },
                showErrors: function (errorMap, errorList) {
                    this.defaultShowErrors();
                    $(".error_msg").hide();
                    $(".button-error").removeClass("error");
                    $(".has-error").html("");
                    $(".error-msg").html("");
                    for (var i = 0; i < errorList.length; i++) {
                        var error = errorList[i];
                        if (error.message) {
                            if ($(".error_" + error.element.id).html() == "") {
                                $(".error_" + error.element.id).html(error.message);
                                $(".error_" + error.element.id).show();
                            }
                            if ($("#" + error.element.id).hasClass("input-hidden")) {
                                $("#btn_" + error.element.id).addClass("error");
                            }
                        }
                    }
                }
            });
            $jqueryValidateProvider.addMethod("time24", function (value, element) {
                return /^([01]?[0-9]|2[0-3])(:[0-5][0-9]){2}$/.test(value);
            }, "Invalid time format.");
            $jqueryValidateProvider.addMethod("time24WithoutSeconds", function (value, element) {
                return /^([0-1]\d|2[0-3]):([0-5]\d)/.test(value);
            }, "Invalid time format.");
        }]).directive("popoverHtmlUnsafePopup", function () {
            return {
                restrict: "EA",
                replace: true,
                scope: {title: "@", content: "@", placement: "@", animation: "&", isOpen: "&"},
                templateUrl: "views/popover.html"
            };
        }).directive("popoverHtmlUnsafe", ["$tooltip", function ($tooltip) {
            return $tooltip("popoverHtmlUnsafe", "popover", "click");
        }]);

/**
 * Constant responsible for getting internationalized variables in to angular app
 */
(function () {
    'use strict';
    angular.module('timeOffCommvaultApp.i8n', [])
        .constant('i8nConstants', window.i8nConstants);
})();
/**
 * Factory responsible for calendar operations
 */
(function () {
    'use strict';
    angular.module('timeOffCommvaultApp.calendarServices', ['restangular'])
        .factory('timeOffDateDiffService', ["Restangular", "$http", "employeeServices", function (Restangular, $http, employeeServices) {
            var timeoffStartDate = null;
            var timeOffEndDate = null;
            var holidays = employeeServices.getHolidays();
            var optionalHolidays = [];
            var middleHolidays = [];
            var daysOfAbsence = 0;
            return {
                setTimeOffStartDate: function (date) {
                    timeoffStartDate = date;
                },
                setTimeOffEndDate: function (date) {
                    timeOffEndDate = date;
                },
                getTimeOffStartDate: function () {
                    return timeoffStartDate;
                },
                getTimeOffEndDate: function () {
                    return timeOffEndDate;
                },
                setDaysOfAbsence: function (days) {
                    daysOfAbsence = days;
                },
                getDaysOfAbsence: function () {
                    return daysOfAbsence;
                },
                getBetweenHolidaysList: function () {
                    return middleHolidays;
                },
                getOptionalLeaveDetails: function () {
                    return optionalHolidays;
                },
                calculateDays: function () {
                    optionalHolidays = [];
                    Date.prototype.addDays = function (days) {
                        var dat = new Date(this.valueOf())
                        dat.setDate(dat.getDate() + days);
                        return dat;
                    }
                    function getDates(startDate, stopDate) {
                        var dateArray = new Array();
                        var currentDate = startDate;
                        while (currentDate <= stopDate) {
                            dateArray.push(new Date(currentDate))
                            currentDate = currentDate.addDays(1);
                        }
                        return dateArray;
                    }

                    function calculateDaysDiff(startDateStr, endDateStr, hstartDate, hendDate, holidayObj) {
                        var start = new Date(startDateStr.replace(/-/g, "/")),
                            end = new Date(endDateStr.replace(/-/g, "/")),
                            holiday = getDates(hstartDate, hendDate), i = holiday.length,
                            n_days = 0;
                        var flag = false;
                        var optionalHolidayDuplicate = [];

                        while (i--) { // loop over holidays
                            if (holiday[i] >= start)
                                if (holiday[i] <= end) {
                                    // day holiday within dates
                                    if (holidayObj.nIsOptional && holidayObj.nLocationID == employeeServices.getLocationId()) {
                                        if(optionalHolidayDuplicate.indexOf(holiday[i].toDateString()) == -1){
                                            optionalHolidays.push({
                                                "name": holidayObj.sName,
                                                "date": holiday[i].toDateString()
                                            });
                                            optionalHolidayDuplicate.push(holiday[i].toDateString());
                                        }


                                    } else {
                                        if (holiday[i].getDay() != 0 && holiday[i].getDay() != 6) n_days = n_days - 1; // not sunday and saturday
                                    }
                                    flag = true;
                                }
                        }

                        return {"diff": n_days, "flag": flag, "holidays": optionalHolidays};
                    }

                    if (typeof(timeoffStartDate) == "string") {
                        var startDate = new Date(timeoffStartDate.replace(/-/g, "/") + " 00:00:00");
                    } else {
                        var startDate = new Date(timeoffStartDate.toDateString() + " 00:00:00");
                    }
                    var endDate = new Date(timeOffEndDate.toDateString() + " 00:00:00");
                    var millisecondsPerDay = 86400 * 1000;
                    startDate.setHours(0, 0, 0, 1);
                    endDate.setHours(23, 59, 59, 999);
                    var diff = endDate - startDate;
                    var days = Math.ceil(diff / millisecondsPerDay);
                    // Subtract two weekend days for every week in between
                    var weeks = Math.floor(days / 7);
                    days = days - (weeks * 2);
                    // Handle special cases
                    var startDay = startDate.getDay();
                    var endDay = endDate.getDay();
                    // Remove weekend not previously removed.
                    if (startDay - endDay > 1)
                        days = days - 2;
                    // Remove start day if span starts on Sunday but ends before Saturday
                    if (startDay === 0 && endDay != 6)
                        days = days - 1;
                    // Remove end day if span ends on Saturday but starts after Sunday
                    if (endDay === 6 && startDay !== 0)
                        days = days - 1;
                    var totalHolidays = 0;
                    var j = 0;
                    var diffDays = 0;
                    for (var i = 0; i < holidays.length; i++) {
                        if (holidays[i].nLocationID == employeeServices.getLocationId()) {
                            startDate.setMilliseconds(0);
                            endDate.setMilliseconds(0);
                            var holidayDate = new Date(holidays[i].startDate + " 00:00:00");
                            holidayDate.setMilliseconds(0);
                            var holidayEndDate = new Date(holidays[i].endDate + " 00:00:00");
                            holidayEndDate.setMilliseconds(0);
                            var holidayMonth = new Date(holidays[i].startDate).getMonth();
                            var d = new Date(holidayDate).getDay();//Make sure holiday is not a weekendday!
                            var startDayObj = holidayDate;
                            var daysDiff = calculateDaysDiff(startDate.toDateString(), endDate.toDateString(), holidayDate, holidayEndDate, holidays[i]);
                            if (daysDiff.flag == true) {
                                diffDays = diffDays + daysDiff.diff;
                            } else {
                                var maxDiff = daysDiff.diff;
                            }
                        }
                        //console.log(holidayDate.toDateString()+"="+startDate.toDateString()+"="+holidayEndDate.toDateString()+"="+endDate.toDateString());
                    }
                    var n_days = 0;
                    while (startDate <= endDate) {
                        if (startDate.getDay() != 0 && startDate.getDay() != 6) n_days = n_days + 1; // not sunday and saturday
                        startDate.setHours(24); // add a day
                    }
                    //console.log(totalHolidays);
                    if (diffDays == 0) {
                        return n_days + maxDiff;
                    } else {
                        return n_days + diffDays;
                    }
                    //return days - totalHolidays;
                },
                getLeaveInfo: function (data) {
                    // return Restangular.all('data/employeeLeaveDetails.json').getList();
                    var req = {
                        method: 'GET', url: 'http://localhost:9000/data/employeeLeaveDetails.json', headers: {
                            'Content-Type': 'application/json'
                        }
                    };
                    return $http(req).then(function (response) {
                        return response.data;
                    }, function (error) {
                    });
                }
            }
        }]);
})();
/**
 * Factory responsible for holiday related operations
 */
(function () {
    'use strict';
    angular.module('timeOffCommvaultApp.holidayServices', ['restangular'])
        .factory('holidayService', ["Restangular", "$q", "$http", "Utils", "configService", "employeeServices", function (Restangular, $q, $http, Utils, configService, employeeServices) {
            var countriesHoliday;
            var regionList = [];
            // var CONST_COUNTRIES ['India'] = india;
            var URL = (employeeServices.getEnvironment() == 'dev') ? configService.returnDevUrl() : configService.returnProdUrl();
            return {
                getHolidayList: function (country) {
                    var holidayList = {}
                    for (var i = 0; i < country.length; i++) {
                        holidayList[country[i]] = countriesHoliday[country[i]];
                    }
                    ;
                    return holidayList;
                },
                setHolidayList: function (holidays) {
                    countriesHoliday = holidays;
                },
                getRegionList: function () {
                    regionList = Object.keys(countriesHoliday);
                    return regionList;
                },
                getAllHoliday: function () {
                    var holidayUrl = ''
                    var deferred = $q.defer();
                    var self = this;
                    Restangular.all(URL.holidayList).getList().then(function (resp) {
                        if (resp[0].data == null) {
                            resp[0].data = [];
                        }
                        self.setHolidayList(Utils.sanitizeRestangularOne(resp[0]));
                        deferred.resolve(resp);
                        return countriesHoliday;
                    }, function (resp) {
                        deferred.reject(resp);
                    });
                    return deferred.promise;
                },
                JSON_CALLBACK: function (data) {
                }
            }
        }]);
})();
'use strict';
/**
 * @ngdoc function
 * @name timeOffCommvaultApp.controller:AboutCtrl
 * @description
 * # applyTimeOffCtrl
 * Controller applying timeoff for employee
 */

(function () {
    app.controller('applyTimeOffCtrl', ["$scope", "employeeServices", "timeoffInfoService", "$routeParams", "$route", "$timeout", "Utils", "timeOffDateDiffService", "i8nConstants", function ($scope, employeeServices, timeoffInfoService, $routeParams, $route, $timeout, Utils, timeOffDateDiffService, i8nConstants) {
        // initialize optionalleave array
        employeeServices.setOptionalLeavesArray([]);

        // hide dropdown if clicked outside of dropdown
        $(document).mouseup(function (e) {
            var container = $(".leave-dropdown .dropdown");
            if (!container.is(e.target) // if the target of the click isn't the container...
                && container.has(e.target).length === 0) // ... nor a descendant of the container
            {
                $(".leave-dropdown .dropdown").find(".show").each(function () {
                    $(this).toggleClass("show");
                });
            }
        });
        $scope.uploader = {};
        /*$(".remove_btn").on("click",function(){
            console.log($(this).data("filename"));
           var fileIndex = $scope.documentsArray.indexOf($(this).data("filename"));
           $scope.uploadDocumentsArray.splice(fileIndex,1);
        });*/
        $scope.token = Utils.uniqid();
        $scope.loggedInUser = employeeServices.getProdcertName();
        $scope.leaveTypes = employeeServices.getLeaveTypes();
        $scope.teamMembers = employeeServices.getTeamMembers();
        $scope.deptName = employeeServices.getDeptName();
        $scope.daysOfAbsence = 0;
        $scope.optionalLeaveDetails = {};
        $(".msg-close-btn").click(function () {
            $(this).parent().hide();
        });
        $(document).ready(function () {
            $("#startdate").on("keydown", function (e) {
                return Utils.keepDateFieldReadable(e);
            });
            $("#enddate").on("keydown", function (e) {
                return Utils.keepDateFieldReadable(e);
            });
        });
        if ($scope.halfDay == undefined) {
            $scope.halfDay = "0";
        }

        $scope.addedNames = [];
        $scope.leaveDetails = '';
        var appliedLeaveType = '';
        $scope.detailsFlag = false;
        function displayLeaveDetailsInDiv(leaveType) {
            $scope.leaveDetails = {
                cf: "N/A",
                ac: "N/A",
                used: "N/A",
                applied: "N/A"
            }
            $scope.detailsFlag = false;
            $("#details-message").html(i8nConstants.RETREIVING_DETAILS);
            timeoffInfoService.timeOffInfoDetails().then(function () {
                $scope.timeoffDetails = timeoffInfoService.processTimeOffInfo();
                if (!$scope.timeoffDetails || $scope.timeoffDetails.length == 0)
                    $("#details-message").html(i8nConstants.NO_INFORMATION_AVAILABLE);
                else {
                    var leaveObj = employeeServices.giveValueOfAnotherMemberInArrayOfObjects($scope.timeoffDetails, leaveType, "");
                    if (leaveObj != null) {
                        $scope.leaveDetails = {
                            cf: leaveObj.nOpeningBal,
                            ac: leaveObj.nAccrued,
                            used: leaveObj.nUsed,
                            applied: leaveObj.nAppliedTimeOff
                        }
                        $scope.detailsFlag = true;
                    } else {
                        $("#details-message").html(i8nConstants.NO_INFORMATION_AVAILABLE);
                    }
                }
            }, function () {
                $("#details-message").html(i8nConstants.NO_INFORMATION_AVAILABLE);
            });
        }

        $(document).ready(function () {
            $(document).off('click', ".leave-type li").on("click", ".leave-type li", function (e) {
                $(".selVal").html($(this).html());
                appliedLeaveType = $(this).html();
                $("#timeOfTyped").val($(this).data("leaveid"));
                if ($scope.apply_flag == false) {
                    displayLeaveDetailsInDiv($(this).html());
                }
                $(e.target).parent().parent().parent().parent().find(".dropdown-toggle").trigger("click");
            });
        });
        var appliedMemberArray = [];
        $scope.membersWithNoTimeOff = [];
        // event when you click on team members dropdown
        $scope.addMember = function (memberName, $index, prodCertName) {
            $(".add-member-msg").html("<span class='blue'>"+i8nConstants.RETRIEVING_HIS_HER_APPLICATION_TIME_OFFS+"</span>");
            $(".add-member-msg").show();
            employeeServices.retrieveTimeOffApplicable(prodCertName).then(function (resp) {
                $(".add-member-msg").html("<span class='green'>"+i8nConstants.RETRIEVED_TIME_OFFS_SUCCESSFULLY+"</span>");
                $(".add-member-msg").fadeOut(5000);
                $("#memberEditor").html($("#memberEditor").html() + "<div class='memberBlock' data-indexof='{{$index}}' data-prodcertname='" + prodCertName + "' data-membername='" + memberName + "'>" + memberName + " <span class='glyphicon glyphicon-remove-circle close-btn' aria-hidden='true' ></span></div>");
                $(".memberList").hide();
                $("#btn_teamMembers").val("");
                $("#btn_teamMembers").attr("placeholder", i8nConstants.ENTER_MORE_NAMES);
                appliedMemberArray.push(prodCertName);
                $scope.addedNames.push(memberName);
                employeeServices.setAddedTeamMember($scope.addedNames);
                $("#teamMembers").val($("#teamMembers").val() + "," + memberName + ",");
                eval('$scope.leaveData' + prodCertName + ' = resp[0].data[0].empLeaveType;');
                if ($scope.leaveTypes.length != 0) {
                    $scope.leaveTypes = employeeServices.findCommonTimeOffs($scope.leaveTypes, resp[0].data[0].empLeaveType);
                } else {
                    $scope.leaveTypes = resp[0].data[0].empLeaveType;
                }
                if (resp[0].data[0].empLeaveType.length == 0) {
                    $scope.membersWithNoTimeOff.push(memberName);
                }
            }, function (resp) {
                $(".add-member-msg").html("<span class='red'>" + i8nConstants.FAILED_TO_RETREIVE + "</span>");
                $(".add-member-msg").fadeOut(5000)
            });
        }
        // remove added team members
        $("#memberEditor").on("click", ".close-btn", function () {
            $scope.addedNames.splice($scope.addedNames.indexOf($(this).parent().data("membername")), 1);
            appliedMemberArray.splice(appliedMemberArray.indexOf($(this).parent().data("prodcertname")), 1);
            $("#teamMembers").val($("#teamMembers").val().split("," + $(this).parent().data("membername") + ",").join(""));
            $(this).parent().remove();
            $scope.leaveTypes = [];
            for (var i = 0; i < appliedMemberArray.length; i++) {
                if ($scope.leaveTypes.length != 0) {
                    $scope.leaveTypes = employeeServices.findCommonTimeOffs($scope.leaveTypes, eval('$scope.leaveData' + appliedMemberArray[i]));
                } else {
                    $scope.leaveTypes = eval('$scope.leaveData' + appliedMemberArray[i]);
                }
            }
            $scope.$apply(function () {
                $scope.leaveTypes = $scope.leaveTypes;
            });
            if ($scope.addedNames.length == 0) {
                $("#btn_teamMembers").attr("placeholder", i8nConstants.START_TYPING_MEMBERS_NAME);
            }
            $scope.membersWithNoTimeOff.splice($scope.membersWithNoTimeOff.indexOf($(this).parent().data("membername")), 1);
        });
        //$(".memberList").hide();
        $scope.displayName = function ($event) {
            $(".memberList").show();
        }
        $scope.documentsArray = [];
        $scope.uploadDocumentsArray = [];
        $scope.optionalLeaveParam = [""];
        function getEditLeaveParams() {
            if (typeof(timeOffDateDiffService.getTimeOffStartDate()) == "string") {
                var startDate = new Date(timeOffDateDiffService.getTimeOffStartDate().replace(/-/g, "/"));
            } else {
                var startDate = timeOffDateDiffService.getTimeOffStartDate();
            }
            if (typeof(timeOffDateDiffService.getTimeOffEndDate()) == "string") {
                var endDate = new Date(timeOffDateDiffService.getTimeOffEndDate().replace(/-/g, "/"));
            } else {
                var endDate = timeOffDateDiffService.getTimeOffEndDate();
            }
            var optionalLeaveArray = employeeServices.getOptionalLeavesArray();
            var requestorsArray = [];
            if ($scope.apply_flag == false) {
                requestorsArray.push(employeeServices.getProdcertName());
            } else {
                requestorsArray = appliedMemberArray;
            }
            var leaveParams = {
                "bHalfDayType": (($scope.halfFlag == "0" || $scope.halfFlag == -1) ? false : ($scope.halfDayChangeFlag == -1 ? $(".day-option").first().val() : $scope.halfDay) ),
                "bIsHalfDay": (($scope.halfFlag == "0" || $scope.halfFlag == -1) ? false : true ),
                "dateApproved": null,
                "dateEnd": Utils.respDateFormat((endDate.getMonth() + 1) + "/" + endDate.getDate() + "/" + endDate.getFullYear(), true),
                "dateStart": Utils.respDateFormat((startDate.getMonth() + 1) + "/" + startDate.getDate() + "/" + startDate.getFullYear(), true),
                "nID": $routeParams.leaveId,
                "nRequestTypeID": $("#timeOfTyped").val(),
                "sApprovedBy": "",
                "sApproverComments": "",
                "sAttachment": "",
                "sAttachmentType": "",
                "nWorkDays": timeOffDateDiffService.getDaysOfAbsence(),
                "sComments": employeeServices.escapeHtml($("#reason").val().replace(new RegExp('\r?\n', 'g'), '<br />')),
                "sOptHolidays": optionalLeaveArray,
                "sSubmittedBy": employeeServices.getProdcertName(),
                "requestors": requestorsArray,
                "generatedCode": $scope.uploadDocumentsArray
            }
            employeeServices.setAppliedLeaveParameters(leaveParams);
            return leaveParams;
        }

        function getLeaveParams() {
            var startDate = new Date(timeOffDateDiffService.getTimeOffStartDate());
            var endDate = new Date(timeOffDateDiffService.getTimeOffEndDate());
            var optionalLeaveArray = employeeServices.getOptionalLeavesArray();
            var requestorsArray = [];
            if ($scope.apply_flag == false) {
                requestorsArray.push(employeeServices.getProdcertName());
            } else {
                requestorsArray = appliedMemberArray;
            }
            var leaveParams = {
                "bHalfDayType": ($(".day-option").first().val() == "false" ? false : true ),
                "bIsHalfDay": ($(".day-option").first().val() == "0" ? false : true ),
                "dateEnd": Utils.respDateFormat((endDate.getMonth() + 1) + "/" + endDate.getDate() + "/" + endDate.getFullYear(), true),
                "dateStart": Utils.respDateFormat((startDate.getMonth() + 1) + "/" + startDate.getDate() + "/" + startDate.getFullYear(), true),
                "nRequestTypeID": $("#timeOfTyped").val(),
                "nWorkDays": timeOffDateDiffService.getDaysOfAbsence(),
                "sComments": employeeServices.escapeHtml($("#reason").val().replace(new RegExp('\r?\n', 'g'), '<br />')),
                "sOptHolidays": optionalLeaveArray,
                "sSubmittedBy": employeeServices.getProdcertName(),
                "requestors": requestorsArray,
                "generatedCode": $scope.uploadDocumentsArray
            }
            employeeServices.setAppliedLeaveParameters(leaveParams);
            return leaveParams;
        }

        function resetForm() {
            $("#startdate").val(undefined);
            $("#enddate").val(undefined);
            $(".selVal").html("Select time off type");
            $("#reason").val("");
            $("btn_teamMembers").val("");
            $("#teamMembers").val("");
            $("#timeOfTyped").val("");
            $(".memberBlock").hide();
            $(".blue-popover").hide();
            $("#outNotify").prop("checked", false);
            timeOffDateDiffService.setTimeOffStartDate(undefined);
            timeOffDateDiffService.setTimeOffEndDate(undefined);
            $scope.leaveTypes = employeeServices.getLeaveTypes();
            $scope.addedNames = [];
            $(".btn_timeOfTyped").removeClass("error");
        }

        $scope.apply_flag = false;
        $scope.eventformvalidate = {
            rules: {
                startdate: {
                    required: true
                },
                enddate: {
                    required: true
                },
                timeOfTyped: {
                    required: true
                },
                reason: {
                    required: false
                },
                teamMembers: {
                    required: '#ForOthers:checked'
                }
            },
            messages: {
                startdate: {
                    required: i8nConstants.INVALID_START_DATE
                },
                enddate: {
                    required: i8nConstants.INVALID_END_DATE
                },
                timeOfTyped: {
                    required: i8nConstants.TIME_OFF_REQUIRED
                },
                reason: {
                    required: i8nConstants.REASON_IS_REQUIRED
                },
                teamMembers: {
                    required: i8nConstants.SELECT_AT_LEAST_ONE_MEMBER
                }
            },
            submitHandler: function (form) {
				$("#ApplyTimeoff").attr("disabled", true);
                $(".alert-msg").hide();
                console.log($scope.documentsArray);
                if ($scope.requestor != undefined) {
                    var leaveParams = getEditLeaveParams();
                    employeeServices.editLeave(leaveParams).then(function () {
                        $(".success-msg").fadeIn();
                        appliedMemberArray = [];
                        employeeServices.setOptionalLeavesArray([]);
                        $('html, body').animate({scrollTop: 0}, 800);
						$("#ApplyTimeoff").attr("disabled", false);
                    }, function (data) {
                        if (data[0].error == null) {
                            $(".msg-error").html(data[0].error);
                            $(".error-danger-msg").fadeIn().fadeOut(5000);
                        }
                        $('html, body').animate({scrollTop: 0}, 800);
						$("#ApplyTimeoff").attr("disabled", false);
                    });
                } else {
                    var leaveParams = getLeaveParams();
                    employeeServices.applyLeave(leaveParams).then(function () {
                        appliedMemberArray = [];
                        employeeServices.setOptionalLeavesArray([]);
                        $(".success-msg").fadeIn();
                        $('html, body').animate({scrollTop: 0}, 800);


                        $timeout(function () {
                            resetForm();                           
                        }, 1000);
                        appliedMemberArray = [];


                        $scope.token = Utils.uniqid();
						$("#ApplyTimeoff").attr("disabled", false);
                    }, function (data) {
                        if (data[0].error == null) {
                            $(".error-danger-msg").fadeIn().fadeOut(5000);
                        }
                        $('html, body').animate({scrollTop: 0}, 800);
						$("#ApplyTimeoff").attr("disabled", false);
                    });
                }				
            },
            validateOnInit: false
        };
        $(".reset-btn").click(function () {
            var validator = $("#EventForm").validate();
            $("#btn_teamMembers").removeClass("error");
            validator.resetForm();
            $(".has-error").hide();
            if ($scope.apply_flag == false) {
                $scope.leaveTypes = [];
            } else {
                $scope.leaveTypes = employeeServices.getLeaveTypes();
            }
        });
        $scope.displayLeaveDetails = function ($event) {
            var today = new Date();
            $scope.leaveDetails = employeeServices.getAppliedLeaveParameters();
            $scope.leaveDetails.managerName = employeeServices.getManagerName();
            $scope.leaveDetails.deptName = employeeServices.getDepartmentName();
            $scope.leaveDetails.leaveType = (appliedLeaveType != '') ? appliedLeaveType : $scope.leaveType;
//            $scope.leaveDetails.appliedOn = today.getFullYear() +"-"+today.getMonth() +"-"+today.getDay();
            $scope.leaveDetails.dateEnd = Utils.convertDateString($scope.leaveDetails.dateEnd);
            $scope.leaveDetails.dateStart = Utils.convertDateString($scope.leaveDetails.dateStart);
            $scope.leaveDetails.appliedOn = Utils.convertDateString(today);
            if ($scope.requestor != undefined) {
                $scope.leaveDetails.nWorkDays = timeOffDateDiffService.getDaysOfAbsence();
            }
            $scope.teamMates = employeeServices.getSelectedTeamMembersManagerName();
            employeeServices.getSelectedTeamMembersManagerName();
            $(".success-msg").fadeOut();
            $('#TimeOffDetails').modal("show");

            $event.stopPropagation();
            
        }
        $(".reset-btn").click(function () {
            var validator = $("#EventForm").validate();
            $("#btn_teamMembers").removeClass("error");
            validator.resetForm();
            $("#startdate").val(undefined);
            $("#enddate").val(undefined);
            $(".has-error").hide();
            $(".blue-popover").hide();
            $("#btn_timeOfTyped").removeClass("error");
        });
        $scope.halfDayFlag = false;
        $scope.halfDaySection = "";
        if ($scope.requestor != undefined) {




            if ($scope.requestor != employeeServices.getProdcertName()) {
                $scope.apply_flag = true;
                var memberName = employeeServices.giveValueOfAnotherMemberInArrayOfObjects($scope.teamMembers, $scope.requestor, ["ProdcertName"]);
                $scope.addMember(memberName.sEmpName, 0, $scope.requestor);
            }
            timeOffDateDiffService.setDaysOfAbsence($scope.nWorkDays);
            timeOffDateDiffService.setTimeOffStartDate($scope.calStartDate);
            timeOffDateDiffService.setTimeOffEndDate($scope.calEndDate);

            $(window).load(function () {
                if ($scope.halfDay !== "0") {
                    $(".day-option").first().val($scope.halfDay.toString());
                    $(".day-option:not(:first)").first().val($scope.halfDay.toString());
                }
            });
            $(document).ready(function(){
                $('html, body').animate({scrollTop: 0}, 200);
                if ($scope.halfDay !== "0") {
                    $scope.halfDayFlag = true;
                }
                $(".selVal").html($scope.leaveType);
                $(".reasonText").val($scope.comment);
                //$(".timeOffTypeText").val();
            });
        }


        //hide and show dropdowns manually
        $('.dropdown-toggle').off().on("click", function () {
            $(this).dropdown();
            $(this).parent().find(".dropdown-menu").toggleClass("show");
        });
        //hide dropdowns if click outside of dropdown
        $(document).mouseup(function (e) {
            var container = $(".dropdown");
            if (!container.is(e.target) // if the target of the click isn't the container...
                && container.has(e.target).length === 0) // ... nor a descendant of the container
            {
                $(".dropdown").find(".show").each(function () {
                    $(this).toggleClass("show");
                });
            }
        });

        $(document).on("change", ".day-option", function () {
            console.log($(".datepicker").first().find(".day-option").first().val());
            $(".day-option").val($(this).val());
            $scope.halfDayChangeFlag = -1;
            $scope.halfFlag = $(".day-option").val();
            if ($(".datepicker").first().find(".day-option").first().val() != "0") {
                // $("#enddate").val(Utils.defaultDateFormat($scope.startdate));
                $(".datepicker:not(:first)").first().find(".day-option").first().val($(".datepicker").first().find(".day-option").first().val());
                // $scope.daysOfAbsence = 1;
                $scope.$evalAsync(function(){
                    console.log("ioio");
                    $scope.halfDayFlag = true;
                    console.log($scope.halfDayFlag);
                });

                $("#enddate").attr("disabled", "disabled");
                if ($("#startdate").val() != "") {
                    $("#enddate").val($("#startdate").val());
                    timeOffDateDiffService.setTimeOffEndDate(new Date($("#startdate").val().replace(/-/g, "/")));
                    $("#enddate").trigger("change");
                }
                $scope.$evalAsync(function(){
                    $scope.halfDaySection = $(".datepicker").first().find(".day-option").first().find('option:selected').text();
                });

                //   $(".blue-popover").show();
            } else {

                console.log("222");
                console.log($(".datepicker").first().find(".day-option").first().val())
                $scope.halfDayFlag = false;
                $('.blue-popover').hide();
                $("#enddate").val(undefined);
                $("#enddate").prop("disabled", false);
            }
        })
    }]).controller('datePickerCtrl', ["$scope", "timeOffDateDiffService", "employeeServices", "$timeout", "Utils", function ($scope, timeOffDateDiffService, employeeServices, $timeout, Utils) {
        $scope.halfDay = -1;
        $scope.clear = function () {
            $scope.dt = null;
        };
        if (($location.path() == "/applyleave") || ($location.path() == "/reports")) {
            $scope.startdate = undefined;
            $scope.enddate = undefined;
        }
        $(document).ready(function () {
            $scope.setDate = function () {
                if ($scope.startdate == null) {
                    $(".day-option").first().val("0");
                    $(".day-option:not(:first)").first().val("0");
                }
                timeOffDateDiffService.setTimeOffStartDate($scope.startdate);
                if (timeOffDateDiffService.getTimeOffStartDate() == undefined) {
                    $(".blue-popover").hide();
                } else {
                    if (($(".datepicker").first().find(".day-option").first().val() != 0 ) && ($(".datepicker").first().find(".day-option").first().val() != undefined)) {
                        $("#enddate").val(Utils.defaultDateFormat($scope.startdate));
                        $(".datepicker:not(:first)").first().find(".day-option").first().val($(".datepicker").first().find(".day-option").first().val());
                        $scope.daysOfAbsence = 1;
                        $scope.halfDayFlag = true;
                        $scope.halfDaySection = $(".datepicker").first().find(".day-option").first().val();
                        $(".blue-popover").show();
                    }
                    if (timeOffDateDiffService.getTimeOffEndDate() != null || $scope.enddate != null) {
                        $("#enddate").val(undefined);
                        $(".blue-popover").hide();
                    }
                }
            }
            $scope.setDate();
        });
        $scope.calDate = function () {
            timeOffDateDiffService.setTimeOffEndDate($scope.enddate);
            if (timeOffDateDiffService.getTimeOffEndDate() == undefined) {
                $(".blue-popover").hide();
            } else {
                if (timeOffDateDiffService.getTimeOffStartDate() != null) {
                    if ($scope.halfDay !== "0") {
                    } else {
                    }
                    $('.blue-popover').show();
                    $(".optional-leave-div").show();
                    $(".error_enddate").hide();
                    $scope.optionalDivShowFlag = true;
                    $scope.daysOfAbsence = timeOffDateDiffService.calculateDays();
                    timeOffDateDiffService.setDaysOfAbsence($scope.daysOfAbsence);
                    $scope.optionalLeaveDetails = timeOffDateDiffService.getOptionalLeaveDetails();
                }
            }
        }
        var optionalLeaveTakenArray = [];
        $scope.consumeLeave = function (element, optionalLeave) {
            $scope.daysOfAbsence = $scope.daysOfAbsence - 1;
            timeOffDateDiffService.setDaysOfAbsence($scope.daysOfAbsence);
            if(optionalLeaveTakenArray.indexOf(Utils.respDateFormat(optionalLeave, true)) == -1){
                optionalLeaveTakenArray.push(Utils.respDateFormat(optionalLeave, true));
            }

            employeeServices.setOptionalLeavesArray(optionalLeaveTakenArray);
            //$scope.optionalDivShowFlag = false;
            $(element.target).parent().parent().hide();
        }
        $scope.doNotConsumeLeave = function (element) {
            //$scope.daysOfAbsense = $scope.daysOfAbsense - $scope.optionalLeaveDetails.length;
            //    $scope.optionalDivShowFlag = false;
            $(element.target).parent().parent().hide();
        }
        // Disable weekend selection
        $scope.disabled = function (date, mode) {
            return employeeServices.getDisabledHolidays(date, mode);
        }
        $scope.toggleMin = function () {
        };
        $scope.toggleMin();
        $scope.dateOptions = {
            showWeeks: 'false'
        };
        $scope.select = function (val) {
        }
        $scope.openStartDate = function ($event) {
            $(document).on("click", ".btn-danger", function () {
            });
            if ($scope.halfDay == -1) {
                $(".day-option").hide();
            }
            if ($scope.halfDay !== "0") {
                $(".day-option").first().val($scope.halfDay.toString());
                $(".day-option:not(:first)").first().val($scope.halfDay.toString());
            }
            $scope.showWeeks = false;
            // $event.preventDefault();
            $event.stopPropagation();
            $scope.opened = true;
        };
        $scope.openEndDate = function ($event) {
            $scope.initDate(new Date());
            if ($(".day-option").first().val() != "0") {
                $scope.disabled = function (date, mode) {
                    return employeeServices.disableCompleteCalendar(date, mode, $("#startdate").val());
                }
            } else {
                $scope.disabled = function (date, mode) {
                    return employeeServices.getDisabledHolidays(date, mode);
                }
            }
            if ($scope.halfDay == undefined) {
                $(".day-option").hide();
            }
            $scope.showWeeks = false;
            //console.log()
            $scope.enddate = undefined;
            $("#enddate").val(undefined);
            $scope.dateOptions = {
                formatYear: 'yy',
                startingDay: 1
            };
            $event.stopPropagation();
            $scope.opened = true;
        };

        $scope.format = 'dd-MMMM-yyyy';
    }]).controller('leaveDetailsCtrl', ["$scope", "timeOffDateDiffService", function ($scope, timeOffDateDiffService) {
        $scope.leaveDetails = {};
        $scope.managersList = {};
    }]);
})();

'use strict';
/**
 * @ngdoc function
 * @name timeOffCommvaultApp.controller:AboutCtrl
 * @description
 * # calendarCtrl
 * Controller for calendar page
 */
(function () {
    app.controller('calendarCtrl', ["$scope", "employeeServices", "$q", "$compile", "$location", "$rootScope", "$timeout", "Utils", "adminServices", "i8nConstants", function ($scope, employeeServices, $q, $compile, $location, $rootScope, $timeout, Utils, adminServices, i8nConstants) {
        $scope.loggedInUser = employeeServices.getProdcertName();
        // if clicked on edit link in popup of calendar
        $(document).on("click", ".edit-leave", function () {
            var leaveid = $(this).data("leaveid");
            var startdate = $(this).data("startdate");
            var enddate = $(this).data("enddate");
            var requestor = $(this).data("requestor");
            $rootScope.$apply(function () {
                $location.path("/editleave/" + leaveid + "/" + requestor + "/" + startdate + "/" + enddate);
            });
        });
        $scope.dataYearArray = [2014, 2015, 2016, 2017];
        $(document).ready(function () {
            $('.main-view-class').height($(".table-class").height());
        });
        $(".table-view-class").click(function () {
            $(".view-class").removeClass("active");
            $(this).addClass("active");
            $(".table-class").removeClass("hide");
            $("#today").fadeOut(1000);
            $("#week").fadeOut(1000);
            $("#month").fadeOut(1000);
            $("#calendar").hide();
            $(".legend-list").find('[data-source="1"]').fadeOut(1000);
            $(".legend-list").find('[data-source="2"]').fadeOut(1000);
            $(".calendar-view-btn").hide();
            $(".table-view-btn").show();
            $("#today").removeClass("active");
            $("#week").removeClass("active");
            $("#month").addClass("active");
            $("#month").trigger("click");
        });
        function resolveReferences(json) {
            if (typeof json === 'string')
                json = JSON.parse(json);
            var byid = {}, // all objects by id
                refs = []; // references to objects that could not be resolved
            json = (function recurse(obj, prop, parent) {
                if (typeof obj !== 'object' || !obj) // a primitive value
                    return obj;
                if (Object.prototype.toString.call(obj) === '[object Array]') {
                    for (var i = 0; i < obj.length; i++)
                        // check also if the array element is not a primitive value
                        if (typeof obj[i] !== 'object' || !obj[i]) // a primitive value
                            continue;
                        else if ("$ref" in obj[i])
                            obj[i] = recurse(obj[i], i, obj);
                        else
                            obj[i] = recurse(obj[i], prop, obj);
                    return obj;
                }
                if ("$ref" in obj) { // a reference
                    var ref = obj.$ref;
                    if (ref in byid)
                        return byid[ref];
                    // else we have to make it lazy:
                    refs.push([parent, prop, ref]);
                    return;
                } else if ("$id" in obj) {
                    var id = obj.$id;
                    delete obj.$id;
                    if ("$values" in obj) // an array
                        obj = obj.$values.map(recurse);
                    else // a plain object
                        for (var prop in obj)
                            obj[prop] = recurse(obj[prop], prop, obj);
                    byid[id] = obj;
                }
                return obj;
            })(json); // run it!
            for (var i = 0; i < refs.length; i++) { // resolve previously unknown references
                var ref = refs[i];
                ref[0][ref[1]] = byid[ref[2]];
                // Notice that this throws if you put in a reference at top-level
            }
            return json;
        }

        $scope.currentDateObj = new Date();
        function displayTableData(month, year) {
            $scope.tableViewTimeOffArray = employeeServices.getTableData($scope.timeOffData0, month, year, assignedArray[0], 0);
            if (counter > 3) {
                for (var i = 3; i < counter; i++) {
                    if ($(".legend-list").find('[data-source="' + i + '"]').length != 0) {
                        $scope.tableViewTimeOffArray = $scope.tableViewTimeOffArray.concat(employeeServices.getTableData(eval('$scope.timeOffData' + i), month, year, assignedArray[i], i));
                    }
                }
            }
        }

        var assignedArray = [
            {
                color: "#2fb0ee",
                empName: $scope.empName,
                prodCertName: employeeServices.getProdcertName()
            },
            {
                color: "#5d9a4a"
            },
            {
                color: "#bd4eed"
            }
        ];
        $scope.nextTable = function () {
            $scope.currentDateObj = new Date($scope.currentDateObj.getFullYear(), $scope.currentDateObj.getMonth() + 1, 1);
            $(".table-month-text span").html(Utils.getFullMonth($scope.currentDateObj.getMonth()) + " " + $scope.currentDateObj.getFullYear());
            displayTableData($scope.currentDateObj.getMonth(), $scope.currentDateObj.getFullYear());
            if ($scope.dataYearArray.indexOf($scope.currentDateObj.getFullYear()) == -1) {
                $scope.getNewDataFromServer($scope.currentDateObj.getFullYear());
            }
        }
        $scope.prevTable = function () {
            $scope.currentDateObj = new Date($scope.currentDateObj.getFullYear(), $scope.currentDateObj.getMonth() - 1, 1);
            $(".table-month-text span").html(Utils.getFullMonth($scope.currentDateObj.getMonth()) + " " + $scope.currentDateObj.getFullYear());
            displayTableData($scope.currentDateObj.getMonth(), $scope.currentDateObj.getFullYear());
            if ($scope.dataYearArray.indexOf($scope.currentDateObj.getFullYear()) == -1) {
                $scope.getNewDataFromServer($scope.currentDateObj.getFullYear());
            }
        }
        $(".calendar-view-class").click(function () {
            $(".view-class").removeClass("active");
            $(this).addClass("active");
            $(".table-class").addClass("hide");
            $("#today").fadeIn(1000);
            $("#week").fadeIn(1000);
            $("#month").fadeIn(1000);
            $("#calendar").show();
            $(".legend-list").find('[data-source="1"]').fadeIn(1000);
            $(".legend-list").find('[data-source="2"]').fadeIn(1000);
            $(".calendar-view-btn").show();
            $(".table-view-btn").hide();
            $("#calendar").fullCalendar("render");
            $("#calendar").fullCalendar("gotoDate", $scope.currentDateObj)
        });
        var cancelledLeaveId;
        var startdate;
        var enddate;
        var requestor;
        var leaveid = "";
        $(document).on("click", ".cancel-leave", function () {
            cancelledLeaveId = $(this).data("leaveid");
            startdate = $(this).data("startdate");
            enddate = $(this).data("enddate");
            requestor = $(this).data("requestor");
            leaveid = $(this).data("leaveid")
            $('#calender_cancel').modal('show');
            // selectedLeaveInfo = leaveInfo;
        });
        $scope.cancelLeave = function () {
            var reason = $('#cancelLeaveReason').val();
            employeeServices.getLeaveDetails(cancelledLeaveId, requestor, startdate, enddate).then(function (resp) {
                var cancelLeaveParameter = {
                    "nID": resp.nID,
                    "nRequestTypeID": resp.nRequestTypeID,
                    "sComments": reason,
                    "sSubmittedBy": resp.sSubmittedBy,
                    "requestors": [resp.sRequestor]
                };
                employeeServices.cancelLeave(cancelLeaveParameter).then(function () {
                	
                	//Extracting the series index of the time off that was requested for cancelling 
                	var currentSeriesIndex = $scope.getCurrentSeriesIndex(requestor);
                	
                	
                	if(currentSeriesIndex !== null) {
                		
                		var $calenderElem = $("#calendar");
                		
                		//Updating the UI on cancel timeoff success
                		$(".a" + leaveid).remove();
                		$(".leave-" + leaveid).remove();
                		
                		//Clearing the table view modal comes here...
                		
                		//Remove the entry in the object
                		$scope.updateSeriesModel(currentSeriesIndex, leaveid);
                		
                		$calenderElem.fullCalendar('removeEventSource', $scope['source' + currentSeriesIndex]);
                		$calenderElem.fullCalendar('addEventSource', $scope['source' + currentSeriesIndex]);
                		
                		//Close the confirmation pop-up
                		$scope.closeLeaveConfirmation();
                		$('#timeoff_info_cancel_confirm').modal('show');
                	} else {
                		$scope.closeLeaveConfirmation();
                	}
                }, function () {
                	//If canceling fails then just close the confirmation pop-up
                    $scope.closeLeaveConfirmation();
                });
            }, function () {
                $scope.closeLeaveConfirmation();
            });
        }
        
        //This returns the series index of the requestor for updating the calender 
        $scope.getCurrentSeriesIndex = function(requestor) {
        	var seriesIndex = null;
        	
        	for(var i = 0; ; i++) {
        		var currentSeriesObj = $scope['source' + i];
        		if(currentSeriesObj) {
        			var curSeriesEvents = currentSeriesObj.events;
        			if(curSeriesEvents && curSeriesEvents.length) {
        				if(curSeriesEvents[0].mesg === requestor) {
        					seriesIndex = i;
        					break;
        				}
        			}
        		} else {
        			break;
        		}
        	}
        	return seriesIndex;
        }
        
        //Update the current series model based on cancelled leaveid
        $scope.updateSeriesModel = function(seriesIndex, leaveId) {
        	var seriesObj = $scope['source' + seriesIndex];
        	var curTimeoffModel = $scope['timeOffData' + seriesIndex];
        	
        	if(seriesObj) {
        		var seriesEvents = seriesObj['events'];
        		if(seriesEvents) {
        			var eventsLen  = seriesEvents.length;
        			if(eventsLen) {
        				for(var i=0; i < eventsLen; i++) {
        					if(seriesEvents[i].leaveid === Number(leaveId)) {
        						seriesEvents.splice(i, 1);
        						
        						//Clearing the calendar time off entry
        						if(curTimeoffModel && curTimeoffModel[i] && curTimeoffModel[i].nID === Number(leaveid)) {
        							//Delete the cancelled time off entry from the current series
        							curTimeoffModel.splice(i, 1);	   						
        						}
        						break;
        					}
        				}
        			}
        		}
        	}
        }
        
        $scope.closeLeaveConfirmation = function () {
            $('.modal').modal('hide');
            $('.leaveCancelReason').val('');
        }
        var duplicateEventArray = [];
        var duplicateElementArray = [];
        $scope.eventRender = function (event, element, view) {
            if (event.end == null) {
                element.remove();
                return false;
            }
            var month = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sept", "Oct", "Nov", "Dec"];
            if (event.type == "timeOff") {
                if (event.mesg != employeeServices.getProdcertName()) {
                    var mesg = "";
                } else {
                    var mesg = "You are on ";
                }
                var leaveId = (event.leaveid == " ") ? "0" : event.leaveid;
                
                //Customizing the message once the new time off API returns success
                var htmlString = "<p class='popover-title-msg'> " + mesg + event.title  + " Time Off</p><p class='popover-date-msg'>From: " + month[new Date(event.start).getMonth()] + " " + new Date(event.start).getDate() + ", " + new Date(event.start).getFullYear() + " To: " + month[new Date(event.end).getMonth()] + " " + new Date(event.end).getDate() + ", " + new Date(event.end).getFullYear() + " </p><p class='popover-date-msg'>";
                if(event.status !== '') {
                	htmlString +=  "Status - " + event.status;
                }
                var flagAction = false;
                var addSlash = "";
                if (event.action.indexOf("Edit") != -1) {
                    htmlString = htmlString + "<a href='javascript:void(0);' class='green padding-options-left edit-leave' data-leaveid='" + leaveId + "' data-startdate='" + (event.start.getMonth() + 1) + "-" + event.start.getDate() + "-" + event.start.getFullYear() + "' data-enddate='" + (event.end.getMonth() + 1) + "-" + event.end.getDate() + "-" + event.end.getFullYear() + "' data-requestor='" + event.mesg + "'>Edit</a>";
                    flagAction = true;
                }
                if (flagAction == true) {
                    addSlash = " / ";
                } else {
                    addSlash = "";
                }
                if (event.action.indexOf("Cancel") != -1) {
                    htmlString = htmlString + addSlash + " <a href='javascript:void(0);' class='red cancel-leave'  data-leaveid='" + leaveId + "' data-startdate='" + (event.start.getMonth() + 1) + "-" + event.start.getDate() + "-" + event.start.getFullYear() + "' data-enddate='" + (event.end.getMonth() + 1) + "-" + event.end.getDate() + "-" + event.end.getFullYear() + "' data-requestor='" + event.mesg + "' data-leaveid='" + event.leaveid + "'>Cancel</a>";
                    flagAction = true;
                }
                htmlString = htmlString + "</p>";
                element.addClass("a" + event.leaveid);
                element.attr({
                    'popover-html-unsafe': htmlString,
                    'popover-placement': 'top',
                    'id': event.leaveid
                });
                element.addClass("mouse-hand-cursor");
                $compile(element)($scope);
            }
            if (event.type == "companyEvents") {
                element.attr({
                    'popover-html-unsafe': "<p class='popover-title-msg'>Event: " + event.title + " Time Off</p><p class='popover-date-msg'>From: " + month[new Date(event.start).getMonth()] + " " + new Date(event.start).getDate() + ", " + new Date(event.start).getFullYear()  + "</p><p class='popover-date-msg'> To: " + month[new Date(event.end).getMonth()] + " " + new Date(event.end).getDate() + ", " + new Date(event.end).getFullYear() + " </p><p class='popover-date-msg '>Venue - " + event.venue + "</p>",
                    'popover-placement': 'top'
                });
                $compile(element)($scope);
            }
        };
        $scope.getNewDataFromServer = function (year) {
            employeeServices.getTimeOffs(employeeServices.getProdcertName(), year).then(function (response) {
                $scope.source0.events = $scope.source0.events.concat(employeeServices.getEventsArray(response[0].data[0].timeOffs));
                $scope.timeOffData0 = $scope.timeOffData0.concat(response[0].data[0].timeOffs);
                $scope.tableViewTimeOffArray = $scope.tableViewTimeOffArray.concat(employeeServices.getTableData($scope.timeOffData0, ($scope.currentDateObj.getMonth()), $scope.currentDateObj.getFullYear(), {
                    color: assignedArray[0].color,
                    empName: employeeServices.getEmpName(),
                    prodCertName: employeeServices.getProdcertName()
                }, 0));
                //$("#calendar").fullCalendar("render");
            })
            if (counter > 3) {
                for (var i = 3; i < counter; i++) {
                    var j = i;
                    if ($(".legend-list").find('[data-source="' + i + '"]').length != 0) {
                        employeeServices.getTimeOffs(assignedArray[j].prodCertName, year).then(function (response) {
                            eval('$scope.source' + j + '.events = $scope.source' + j + '.events.concat(employeeServices.getEventsArray(response[0].data[0].timeOffs))');
                            eval('$scope.timeOffData' + j + ' = $scope.timeOffData' + j + '.concat(response[0].data[0].timeOffs)');
                            $scope.tableViewTimeOffArray = $scope.tableViewTimeOffArray.concat(employeeServices.getTableData(eval('$scope.timeOffData' + j), ($scope.currentDateObj.getMonth()), $scope.currentDateObj.getFullYear(), assignedArray[j], j));
                        });
                    }
                }
            }
            $scope.dataYearArray.push(year);
        }
        $scope.displayCancelConfirmation = function (leaveInfo) {
            $('#calender_cancel').modal('show');
            var selectedLeaveInfo = leaveInfo;
        }
        var timeOffs = [];
        $('#calendar').fullCalendar({
            disableDragging: true
        });
// Calendar ui config settings
        $scope.uiConfig = {
            calendar: {
                id: 'calendar',
                height: 450,
                editable: false,
                header: {
                    center: 'title',
                    right: 'month agendaDay agendaWeek prev,next'
                },
                eventResize: $scope.alertOnResize,
                viewRender: function (view, element, date) {
                    if ($scope.dataYearArray.indexOf($("#calendar").fullCalendar("getDate").getFullYear()) == -1) {
                        $scope.getNewDataFromServer($("#calendar").fullCalendar("getDate").getFullYear());
                    }
                    var dateArray = view.title.split(" ");
                    $scope.title = $(".fc-header-title h2").html();
                    $(".fc-header").hide();
                    $(".fc-day-header.fc-" + (weekDays[new Date().getDay()])).addClass("heading-blue");
                },
                eventRender: $scope.eventRender
            }
        };
        function showCalendar() {
            $(".content-area").fadeIn();
            $(".fc-header").hide();
            $("#calendar").fullCalendar('render');
        }

        $(document).ready(function () {
            $timeout(showCalendar, 1000);
        });
        $scope.eventSources = [];
        //For populating new team members
        $scope.teamMembers = employeeServices.getTeamMembers();
        $("#memberEditor").on("click", ".close-btn", function () {
            $scope.addedNames.splice($(this).parent().data("indexof"), 1);
            $(this).parent().remove();
            if ($scope.addedNames.length == 0) {
                $("#memberNameTxt").attr("placeholder", i8nConstants.START_TYPING_MEMBERS_NAME);
            }
        });
        $scope.displayName = function ($event) {
            $(".memberList").show();
        }
        $scope.addedNames = [];
        var counter = 3;
        
        var teamTimeOff = {};
        
        function assignTimeOffsToCalendar(timeOffListForEmployee, color, memberName) {
            var timeOffArray = [];
            for (var index in timeOffListForEmployee) {
                if ((timeOffListForEmployee[index].sRequestStatus != "Cancelled") && (timeOffListForEmployee[index].sRequestStatus != "Rejected")){
                    if (timeOffListForEmployee[index].bIsHalfDay) {
                        if (timeOffListForEmployee[index].bHalfDayType) {
                            var datestart = timeOffListForEmployee[index].dateStart.replace(/-/g, "/") + " 12:00:00";
                            var dateend = timeOffListForEmployee[index].dateEnd.replace(/-/g, "/") + " 23:00:00";
                        } else {
                            var datestart = timeOffListForEmployee[index].dateStart.replace(/-/g, "/") + " 00:00:00";
                            var dateend = timeOffListForEmployee[index].dateEnd.replace(/-/g, "/") + " 12:00:00";
                        }
                        timeOffArray.push({
                            type: 'timeOff',
                            title: Utils.unescapeHtml(memberName + " " + (timeOffListForEmployee[index].sRequestType || '')),
                            mesg: timeOffListForEmployee[index].sRequestor,
                            action: timeOffListForEmployee[index].sAction,
                            leaveid: timeOffListForEmployee[index].nID,
                            status: (timeOffListForEmployee[index].sRequestStatus || ''),
                            start: datestart,
                            end: dateend,
                            allDay: false
                        });
                    } else {
                        timeOffArray.push({
                            type: 'timeOff',
                            title: Utils.unescapeHtml(memberName + " " + (timeOffListForEmployee[index].sRequestType || '')),
                            mesg: timeOffListForEmployee[index].sRequestor,
                            leaveid: timeOffListForEmployee[index].nID,
                            status: (timeOffListForEmployee[index].sRequestStatus || ''),
                            action: timeOffListForEmployee[index].sAction,
                            start: timeOffListForEmployee[index].dateStart.replace(/-/g, "/") + " 00:00:00",
                            end: timeOffListForEmployee[index].dateEnd.replace(/-/g, "/") + " 19:00:00",
                            allDay: true
                        });
                    }
                }
            }
            teamTimeOff = {
                color: color,
                textColor: 'white',
                padding: '0px',
                events: timeOffArray
            };
            
            // eval('var source'+counter+ ' = "";');
            eval('$scope.source' + counter + ' = teamTimeOff;');
            $("#calendar").fullCalendar('addEventSource', eval('$scope.source' + counter));
            counter++;
        }

        $(document).on("mouseover", ".circle-increase", function () {
            $(this).addClass("bigger");
        });
        $(document).on("mouseout", ".circle-increase", function () {
            $(this).removeClass("bigger");
        });
        function removeUserFromArray(tableTimeOffArray, empIndex) {
            var timeOffArray = [];
            for (var timeOffIndex in tableTimeOffArray) {
                if (tableTimeOffArray[timeOffIndex].empIndex != empIndex) {
                    timeOffArray.push(tableTimeOffArray[timeOffIndex]);
                }
            }
            return timeOffArray;
        }

        $(document).on("click", ".circle-increase", function () {
            $("#calendar").fullCalendar('removeEventSource', eval('$scope.source' + $(this).data("relation")));
            $scope.addedNames.splice($scope.addedNames.indexOf($(this).data("name")), 1);
            $scope.tableViewTimeOffArray = removeUserFromArray($scope.tableViewTimeOffArray, $(this).data("relation"));
            $(this).closest("li").remove();
        });
        $scope.addMember = function (memberName, $index, prodCertName) {
            $(".legend-list").append($(".legend-list").children("li").last()[0].outerHTML);
            var iHTML = $(".legend-list").children("li").last().children("i").first()[0].outerHTML;
            $(".legend-list").children("li").last().html("");
            $(".legend-list").children("li").last().append(iHTML + memberName + "<span class='glyphicon glyphicon-remove-circle circle-increase' aria-hidden='true' data-relation='" + counter + "' data-name='" + memberName + "'></span>");
            var color = randomColor({
                luminosity: 'dark',
                count: 1
            });
            $(".legend-list").children("li").last().children("i").first().css({"background-color": "'" + color + "'"});
            $(".legend-list").children("li").last().attr("data-source", counter);
            $(".legend-list").children("li").last().attr("data-name", memberName);
            $(".legend-list").children("li").last().attr("data-prodcertname", prodCertName);
            $(".legend-list").children("li").last().css("display", "block");
            assignedArray.push({
                color: color.join(""),
                empName: memberName,
                prodCertName: prodCertName
            });
            var prodCertName = prodCertName;
            employeeServices.getTimeOffs(prodCertName, new Date().getFullYear()).then(function (resp) {
                eval('$scope.timeOffData' + counter + " = resp[0].data[0].timeOffs");
                assignTimeOffsToCalendar(resp[0].data[0].timeOffs, color, memberName);
                $scope.tableViewTimeOffArray = $scope.tableViewTimeOffArray.concat(employeeServices.getTableData(resp[0].data[0].timeOffs, ($scope.currentDateObj.getMonth()), $scope.currentDateObj.getFullYear(), {
                    color: color.join(""),
                    empName: memberName,
                    prodCertName: prodCertName
                }, counter - 1));
                $scope.addedNames.push(memberName);
            });
            $(".memberList").hide();
            $("#memberNameTxt").val("");
        }
        $scope.prodCertName = employeeServices.getProdcertName();
        //For calendar events population
        $scope.eventSources = [];
        var date = new Date();
        var d = date.getDate();
        var m = date.getMonth();
        var y = date.getFullYear();
        var weekDays = ["sun", "mon", "tue", "wed", "thu", "fri", "sat"];
        var today = new Date();
        //Retrieve user's holidays and create object for calendar
        var holidays = employeeServices.getHolidays();
        var holidaysArray = [];
        for (var index in holidays) {
            holidaysArray.push({
                type: 'party',
                title: Utils.unescapeHtml(holidays[index].sName),
                start: new Date(holidays[index].startDate),
                end: new Date(new Date(holidays[index].endDate).getTime() + (60 * 60)),
                allDay: true
            })
        }
        $scope.source2 = {
            color: '#bd4eed',
            textColor: 'white',
            padding: '0px',
            events: holidaysArray
        };
        // Assign library events to template events
        $scope.prev = function () {
            $(".fc-button.fc-button-prev").trigger("click");
            $scope.prevTable();
        }
        $scope.next = function () {
            $(".fc-button.fc-button-next").trigger("click");
            $scope.nextTable();
        }
        $scope.week = function () {
            $(".fc-button.fc-button-agendaWeek").trigger("click");
            
            var $calenderMenuItemsHolder = $('#calenderMenuOptionsHolder');
            
            $calenderMenuItemsHolder.find("#week").addClass("active");
            $calenderMenuItemsHolder.find("#month, #today").removeClass("active");
            $calenderMenuItemsHolder.find(".prev-btn, .next-btn").show();
        }
        $scope.month = function () {
            $(".fc-button.fc-button-month").trigger("click");
            
            var $calenderMenuItemsHolder = $('#calenderMenuOptionsHolder');
            
            $calenderMenuItemsHolder.find("#month").addClass("active");
            $calenderMenuItemsHolder.find("#week, #today").removeClass("active");
            $calenderMenuItemsHolder.find(".prev-btn, .next-btn").show();
        }
        
        $scope.convertDateToString = function (dateStr) {
           if (dateStr != '' && dateStr != undefined)
                   return Utils.convertDateString(dateStr);
           else
                return '';
        }
        $scope.today = function () {
            $(".fc-button.fc-button-agendaDay").trigger("click");
            
            var $calenderMenuItemsHolder = $('#calenderMenuOptionsHolder');
            $calenderMenuItemsHolder.find("#today").addClass("active");
            $calenderMenuItemsHolder.find("#week, #month").removeClass("active");
            $calenderMenuItemsHolder.find(".prev-btn, .next-btn").hide();
            
            $("#calendar").fullCalendar("gotoDate", new Date());
        }
        
        // Retrieve timeoffs and create object for calendar and assign it to scope
        var myTimeOffArray = [];
        $scope.tableViewTimeOffArray = [];
        //$scope.source0 = resolveReferences($scope.source0);
        employeeServices.getTimeOffs(employeeServices.getProdcertName(), new Date().getFullYear()).then(function (resp) {
            /*if (resp[0].data == null) {
             employeeServices.setMyTimeOffs([]);
             } else {
             employeeServices.setMyTimeOffs(resp[0].data[0].timeOffs);
             }*/
            employeeServices.setMyTimeOffs(resp[0].data[0].timeOffs);
            var timeOffData = employeeServices.getMyTimeOffs();
            myTimeOffArray = employeeServices.getEventSourceObject(timeOffData, '#2fb0ee', "timeOff");
            console.log(myTimeOffArray);
            $scope.source0 = myTimeOffArray;
            $(document).ready(function () {
                $("#calendar").fullCalendar('render');
                $("#calendar").fullCalendar('addEventSource', $scope.source0);
            });
            /*$timeout(function(){
             $("#calendar").fullCalendar('addEventSource', $scope.source0);
             },2000);
             */
            //$(".enable-" + employeeServices.getProdcertName() + "0").show();
            //$scope.currentDateObj = new Date($scope.currentDateObj.getFullYear(), $scope.currentDateObj.getMonth() + 1, 1);
            $(".table-month-text span").html(Utils.getFullMonth($scope.currentDateObj.getMonth()) + " " + $scope.currentDateObj.getFullYear());

            $scope.timeOffData0 = timeOffData;
            $scope.tableViewTimeOffArray = employeeServices.getTableData(timeOffData, (new Date().getMonth()), (new Date().getFullYear()), {
                color: '#2fb0ee',
                empName: $scope.empName,
                prodCertName: employeeServices.getProdcertName()
            }, 0);
            $scope.location = employeeServices.giveValueOfAnotherMemberInArrayOfObjects(employeeServices.getLocationList(), employeeServices.getLocationId(), "sRegionName");
        }, function (resp) {
            employeeServices.setMyTimeOffs([]);
            var timeOffData = employeeServices.getMyTimeOffs();
            myTimeOffArray = employeeServices.getEventSourceObject(timeOffData, '#2fb0ee', "timeOff");
            // $scope.source0 = myTimeOffArray;
            $("#calendar").fullCalendar('addEventSource', $scope.source0);
        });
        $scope.empName = employeeServices.getEmpName();
        adminServices.getListingObjArray("Event").then(function (response) {
            var companyEvents = response;
            var eventsArray = [];
            for (var index in companyEvents) {
                eventsArray.push({
                    type: 'companyEvents',
                    venue: companyEvents[index].sVenue,
                    title: Utils.unescapeHtml(companyEvents[index].sEventName),
                    start: new Date(companyEvents[index].dStartDate + " 12:00:00"),
                    end: new Date(companyEvents[index].dEndDate + " 23:00:00"),
                    allDay: true
                })
            }
            //Utils.removeSourceObject(eventsArray);
            $scope.source1 = {
                color: '#5d9a4a',
                textColor: 'white',
                padding: '0px',
                events: eventsArray
            }
            $(document).ready(function () {
                $("#calendar").fullCalendar('addEventSource', $scope.source1);
            });
        });
        // Retrieve company events and create object for calendar and assign it to scope
        $(document).off('click', '.highlight').on("click", ".highlight", function () {
            if ($(this).hasClass("enable")) {
                $(".enable-" + $(this).data("prodcertname") + $(this).data("source")).hide();
                $("#calendar").fullCalendar('removeEventSource', eval('$scope.source' + $(this).data("source")));
                $(this).removeClass("enable");
            } else {
                $(".enable-" + $(this).data("prodcertname") + $(this).data("source")).show();
                $("#calendar").fullCalendar('addEventSource', eval('$scope.source' + $(this).data("source")));
                $(this).addClass("enable");
            }
        })
        $scope.eventSources.push($scope.source2);
        //Assign holidays to calendar source list
        /*$(document).ready(function(){
         $("#calendar").fullCalendar('addEventSource', $scope.source2);
         });*/
    }]).controller('tableViewCtrl', ["$scope", function ($scope) {
        $scope.leaveDetails = {};
        $scope.managersList = {};
        $scope.orderByDate = function (item) {
            var date = new Date(item.dateStart.replace(/-/g, "/"));
            return date;
        };
    }]);
})();


'use strict';
/**
 * @ngdoc function
 * @name timeOffCommvaultApp.controller:AboutCtrl
 * @description
 * # addLeaveTypeCtrl
 * Controller adding time off types include entitlement policy and approval/notification policy
 */
(function () {
    app.controller('addLeaveTypeCtrl', ["$scope", "holidayService", "employeeServices", "addLeaveTypeServices", "configService", "$routeParams", "adminServices", "Utils", "parameterService", "$timeout", "$location", "i8nConstants", function ($scope, holidayService, employeeServices, addLeaveTypeServices, configService, $routeParams, adminServices, Utils, parameterService, $timeout, $location, i8nConstants) {

        // this check is for giving this controller access only to
        // admin  otherwise redirect to apply leave page for manager and employee
        if ($scope.levelFlag != "Admin") {
            $location.path("/applyleave");
        }
        $("#leaveOverlap").on("click", function () {
            if ($('#leaveOverlap:checked').length == 0) {
                $(".overlapCheckbox").prop('checked', false);
            }
        });
        $scope.loadingFlag = true;
        $scope.regionList = employeeServices.getLocationList();
        $scope.deleteObj = function () {
            var moduleName = $scope.policyType;
            var ObjId = $scope.deleteId;
            var deleteObjParams = {
                "nID": ObjId
            }
            $("#deletePolicyEntitlementModal").modal("hide");
            $(".alert-msg").hide();
            adminServices.cudAPI(deleteObjParams, eval("adminServices.getUrlObj().delete" + moduleName)).then(function (response) {
                if (moduleName == "EntitlementPolicy") {
                    $(".entitlement-delete-success-msg").fadeIn().fadeOut(3000);
                } else {
                    $(".notification-delete-success-msg").fadeIn().fadeOut(3000);
                }
                listAllPolicies();
                $('html, body').animate({scrollTop: 0}, 800);
            }, function (resp) {
                if(resp[0].error == null){
                    if (moduleName == "EntitlementPolicy") {
                        $(".entitlement-delete-error-danger-msg").fadeIn().fadeOut(3000);
                    } else {
                        $(".notification-delete-error-danger-msg").fadeIn().fadeOut(3000);
                    }
                }

                $('html, body').animate({scrollTop: 0}, 800);
            });
        }
        //hide and show dropdowns manually
        $('.dropdown-toggle').off().on("click", function () {
            var self = this;
            $(".dropdown").find(".show").each(function () {
                console.log($(this).prev().attr("id") +"==="+ $(self).attr("id"));
                if($(this).prev().prev().attr("id") != $(self).attr("id")){
                    console.log("asdfadsfdsf");
                    $(this).toggleClass("show");
                }

            });
            $(this).dropdown();
            $(this).parent().find(".dropdown-menu").toggleClass("show");
        });
        //hide dropdowns if click outside of dropdown
        $(document).mouseup(function (e) {
            var container = $(".dropdown");
            if (!container.is(e.target) // if the target of the click isn't the container...
                && container.has(e.target).length === 0) // ... nor a descendant of the container
            {
                $(".dropdown").find(".show").each(function () {
                    $(this).toggleClass("show");
                });
            }
        });
        //popup message hiding event
        $(".msg-close-btn").click(function () {
            $(this).parent().hide();
        });
        function getDeleteEntitlementPolicyParams(apiId) {
            return {
                "nID": apiId
            }
        }

        $scope.deleteEntitlement = function () {
            var requestParams = getDeleteEntitlementPolicyParams(apiId);
            $(".alert-msg").hide();
            adminServices.cudAPI(requestParams, URL.deleteEntitlementPolicy).then(function (resp) {
                $(".delete-success-msg").fadeIn().fadeOut(3000);
            }, function (resp) {
                alert("failure");
            });
        }
        $scope.deleteType = "time off";
        $scope.toggleMin = function () {
        };
        $scope.toggleMin();
        $scope.editEntitlementObj = function (policyId) {
            var policyParams = getEntitlementPolicyParams(policyId);
        }
        $(".day-option").hide();
        $("#startdate").on("click", function (e) {
            $(e.target).trigger("blur");
        })
        $("#startdate").on("blur", function () {
            $(".datepicker ul").hide();
        })
        $scope.halfDay = -1;
        $("#startdate").on("keydown", function (e) {
            return Utils.keepDateFieldReadable(e);
        });
        $scope.openStartDate = function ($event) {
            $scope.showWeeks = false;
            $event.preventDefault();
            $event.stopPropagation();
            $scope.opened = true;
            if ($scope.halfDay == -1) {
                $(".day-option").hide();
            }
        };
        $scope.dateOptions = {
            formatYear: 'yy',
            startingDay: 1
        };
        $scope.format = 'dd-MMMM-yyyy';
        $scope.showEntitlementPolicyPopup = function ($event, policyId) {
            Utils.clearFormValidations();
            if (policyId != "") {
                adminServices.populateForm(employeeServices.giveValueOfAnotherMemberInArrayOfObjects($scope.entitlementList, policyId, ["nID"]), parameterService.getEntitlementPolicyParams())
                $("#editFlag").val(policyId);
            } else {
                $("#editFlag").val("0");
                adminServices.populateForm("", parameterService.getEntitlementPolicyParams())
            }
            $('#addPolicyModal').modal("show");
            $event.stopPropagation();
        };
        $scope.showApproveNotifyPolicyPopup = function ($event, policyId) {
            Utils.clearFormValidations();
            adminServices.clearFields($scope.moduleName);
            if (policyId != "") {
                adminServices.populateForm(employeeServices.giveValueOfAnotherMemberInArrayOfObjects($scope.approvalList, policyId, ["nID"]), parameterService.getNotificationPolicyParams())
                $("#editFlag").val(policyId);
            } else {
                $("#editFlag").val("0");
                adminServices.populateForm("", parameterService.getNotificationPolicyParams())
            }
            $('#notificationPolicyModal').modal("show");
            $(".first-table-data .row:not(:first)").remove();
            $(".second-table-data .row:not(:first)").remove();
            $event.stopPropagation();
        };
        //fetch all policy data;
        // list timeoffs
        addLeaveTypeServices.fetchListOfTimeOffs().then(function () {
            $scope.timeOffList = addLeaveTypeServices.getTimeOffList();
            $scope.loadingFlag = false;
        });
        $scope.entitlementList = '';
        $scope.approvalList = '';
        $scope.editFlag = false;
        $scope.timeOffObj = '';
        $scope.deleteTimeOffId = '';
        var editLeaveId = '';
        $scope.overlapIdArr = [];
        if ($routeParams.leaveId != undefined) {
            $scope.editFlag = true;
            //$(".policyList").hide();
            editLeaveId = $routeParams.leaveId;
        }
        $scope.$on('user:updated', function (event, data) {
            listAllPolicies();
        });
        listAllPolicies();
        function listAllPolicies() {
            //fetch all policy data;
            // list timeoffs
            addLeaveTypeServices.fetchListOfTimeOffs().then(function () {
                $scope.timeOffList = addLeaveTypeServices.getTimeOffList();
                $scope.loadingFlag = false;
            }).then(function () {

                // list entitlement
                addLeaveTypeServices.fetchEntitlementPolicyList().then(function () {
                    $scope.entitlementList = addLeaveTypeServices.getEntitlementPolicyList();

                    // list approval/notification
                    addLeaveTypeServices.fetchApprovalPolicyList().then(function () {
                        $scope.approvalList = addLeaveTypeServices.getApprovalPolicyList();

                        if ($scope.editFlag) {
                            var timeOffObj = addLeaveTypeServices.getTimeOffObj(editLeaveId);
                            $scope.editTimeOff(timeOffObj);
                        }
                    });
                });
            });
        }

        $scope.eventformvalidate = {
            rules: {
                timeoff_name: {
                    required: true
                },
                leave_option: {
                    required: true
                },
                leave_policy: {
                    required: true
                },
                approval_policy: {
                    required: true
                },
                region_id: {
                    required: true
                },
                overlap_with: {
                    required: '#leaveOverlap:checked'
                }
            },
            messages: {
                timeoff_name: {
                    required: i8nConstants.ENTER_TIME_OFF
                },
                leave_option: {
                    required: i8nConstants.SELECT_LEAVE_OPTION
                },
                leave_policy: {
                    required: i8nConstants.SELECT_LEAVE_POLICY
                },
                approval_policy: {
                    required: i8nConstants.SELECT_APPROVAL_POLICY
                },
                region_id: {
                    required: i8nConstants.SELECT_REGION_NAME
                },
                overlap_with: {
                    required: i8nConstants.SELECT_OVERLAPPED_WITH
                }
            },
            submitHandler: function (form) {
                //success form validation
                var name = Utils.escapeHtml($("#timeoff_name").val());
                var isDeductable;
                isDeductable = ($("#Deductible").prop("checked") == true) ? isDeductable = true : isDeductable = false;
                var entitlementId = $("#leave_policy").val();
                var approvalId = $("#approval_policy").val();
                var regionId = $("#region_id").val();
                var canOverlap;
                canOverlap = ($("#leaveOverlap").prop("checked") == true) ? canOverlap = true : canOverlap = false;
                var overlapWith = $scope.overlapIdArr;
                var halfdayAllowed = $('#halfdayAllowed').prop("checked");
                var bIsOptionalType = $('#bIsOptionalType').prop("checked");
                var timeoffId;
                $(".alert-msg").hide();
                if ($scope.editFlag) {
                    timeoffId = $scope.timeOffObj.nID;
                    addLeaveTypeServices.editTimeOffType(name, isDeductable, entitlementId, approvalId, canOverlap, overlapWith, halfdayAllowed, regionId, bIsOptionalType, timeoffId).then(function () {
                        $(".edit-success-msg").fadeIn().fadeOut(3000);
                        $('html, body').animate({scrollTop: 0}, 800);
                        $timeout(function () {
                            $location.path("/addLeaveType");
                        }, 3000);
                    }, function (response) {
                        if (response[0].error == null) {
                            $(".edit-error-danger-msg").fadeIn().fadeOut(3000);
                        }
                        $('html, body').animate({scrollTop: 0}, 800);
                    });
                }
                else {
                    addLeaveTypeServices.addNewTimeOffType(name, isDeductable, entitlementId, approvalId, canOverlap, overlapWith, halfdayAllowed, regionId, bIsOptionalType).then(function () {
                        $(".success-msg").fadeIn().fadeOut(3000);
                        $('html, body').animate({scrollTop: 0}, 800);
                        $timeout(function () {
                            clearAllFields();
                            listAllPolicies();
                        }, 1000);
                    }, function (response) {
                        if (response[0].error == null) {
                            $(".error-danger-msg").fadeIn().fadeOut(3000);
                        }
                        $('html, body').animate({scrollTop: 0}, 800);
                    });
                }
            },
            validateOnInit: false
        };
        $scope.submitForm = function () {
            $("#addTimeoffTypeForm").validate();
        }
        $scope.editTimeOff = function (timeOffObj) {
            // $(".policyList").hide();
            $scope.timeOffObj = timeOffObj;
            $("#timeoff_name").val($scope.timeOffObj.sRequestType);
            ($scope.timeOffObj.bIsDeductible == true) ? $("#Deductible").attr("checked", "checked") : $("#Non-Deductible").attr("checked", "checked");
            $("#leave_policy").val($scope.timeOffObj.nEntitlementPolicyID);
            $('.selected_entitlement-policy').html(addLeaveTypeServices.getEntitlementPolicyName($scope.timeOffObj.nEntitlementPolicyID));
            $("#approval_policy").val($scope.timeOffObj.nApprovalPolicyID);
            $('.selected_approval-policy').html(addLeaveTypeServices.getApprovalPolicyName($scope.timeOffObj.nApprovalPolicyID));
            $scope.overlapIdArr = timeOffObj.OverlapRequestTypeID;
            $('#halfdayAllowed').attr('checked', $scope.timeOffObj.bIsHalfDayAllowed);
            if ($scope.timeOffObj.bIsOptionalType) {
                $('#bIsOptionalType').next().trigger("click");
            }
            $(".region-list").find("[data-regionid='" + $scope.timeOffObj.nLocationID + "']").trigger("click");

            $("#leaveOverlap").prop("checked", $scope.timeOffObj.bIsOverlapAllowed);

            if ($scope.timeOffObj.OverlapRequestTypeID.length != 0) {

                for (var i = 0; i < $scope.timeOffObj.OverlapRequestTypeID.length; i++) {
                    $("#overlapitem_" + $scope.timeOffObj.OverlapRequestTypeID[i]).prop("checked", true);
                }
                $("#overlap_with").val($scope.timeOffObj.OverlapRequestTypeID.toString());
            }
            $('html, body').animate({scrollTop: 0}, 800);
        }
        $scope.deleteTimeOffConfirmation = function (nid) {
            clearAllFields();
            $scope.editFlag = false;
            $scope.deleteTimeOffId = nid;
            $("#deletePolicyModal").modal("show");
        }
        $scope.deleteConfirmation = function (typePolicy, nid) {
            adminServices.clearFields(typePolicy);
            $scope.editFlag = false;
            $scope.policyType = typePolicy;
            $scope.deleteType = "policy";
            $scope.deleteId = nid;
            $("#deletePolicyEntitlementModal").modal("show");
            $(".entitlement-delete-success-msg").fadeIn().fadeOut(3000);
        }
        $scope.dateOptions = {
            showWeeks: 'false'
        };
        $scope.deleteTimeOff = function () {
            $(".alert-msg").hide();
            addLeaveTypeServices.deleteTimeOffType($scope.deleteTimeOffId).then(function () {
                $("#deletePolicyModal").modal("hide");
                $(".delete-success-msg").fadeIn().fadeOut(3000);
                $('html, body').animate({scrollTop: 0}, 800);
                listAllPolicies();
            }, function (resp) {
                $("#deletePolicyModal").modal("hide");
                if(resp[0].error == null)
                    $(".delete-error-danger-msg").fadeIn().fadeOut(3000);
                $('html, body').animate({scrollTop: 0}, 800);
            });
        }
        $scope.cancelDelete = function () {
            $(".deletePolicyModal").modal("hide");
        }
        function clearAllFields() {
            $("#timeoff_name").val('');
            $("#Deductible").attr('checked', true);
            $("#Non-Deductible").attr('checked', false);
            $(".selected_approval-policy").html("Select Policy");
            $(".selected_entitlement-policy").html("Select Policy");
            $(".selected_region").html("Select Region");
            $("#region_id").val('');
            $("#leave_policy").val('');
            $("#approval_policy").val('');
            $("#leaveOverlap").attr('checked', false);
            $('#overlap_with').val('');
            $('#halfdayAllowed').attr('checked', false);
            $('#bIsOptionalType').attr('checked', false);
        }

        $scope.addOverlapIdToArr = function (overlapId, e) {
            if ($.inArray(overlapId, $scope.overlapIdArr) == -1) {
                $scope.overlapIdArr[$scope.overlapIdArr.length] = overlapId;
                $("#overlap_with").val($scope.overlapIdArr);
            }
            else {
                $scope.overlapIdArr.splice($.inArray(overlapId, $scope.overlapIdArr), 1);
                if ($scope.overlapIdArr.length == 0) {
                    $("#overlap_with").val('');
                }
            }
        }
        var counter = 1;
        // all operations related to adding new approval/notification screen
        $(".first-table-data").on("click", ".plus-sign", function () {
            $(this).closest(".row").clone().appendTo(".first-table-data");
            $(".first-table-data").find(".first-text").last().attr("name", "first_text_" + counter);
            $(".first-table-data").find(".second-text").last().attr("name", "second_text_" + counter);
            $(".first-table-data").find(".first-text").last().attr("id", "first_text_" + counter);
            $(".first-table-data").find(".second-text").last().attr("id", "second_text_" + counter);
            $("#first_text_" + counter).rules("add", "required");
            $("#second_text_" + counter).rules("add", "required");
            $(".first-table-data").find(".minus-sign").last().attr("data-counter", counter);
            counter++;
        });
        $(".first-table-data").on("click", ".minus-sign", function (e) {
            $("#first_text_" + $(this).data("counter")).rules("remove", "required");
            $("#second_text_" + $(this).data("counter")).rules("remove", "required");
            $(e.target).closest(".row").remove();
        });
        var secondCounter = 1;
        $(".second-table-data").on("click", ".plus-sign", function () {
            $(this).closest(".row").clone().appendTo(".second-table-data");
            $(".second-table-data").find(".total-first-text").last().attr("name", "total_first_text_" + secondCounter);
            $(".second-table-data").find(".total-second-text").last().attr("name", "total_second_text_" + secondCounter);
            $(".second-table-data").find(".total-first-text").last().attr("id", "total_first_text_" + secondCounter);
            $(".second-table-data").find(".total-second-text").last().attr("id", "total_second_text_" + secondCounter);
            $("#total_first_text_" + secondCounter).rules("add", "required");
            $("#total_second_text_" + secondCounter).rules("add", "required");
            $(".second-table-data").find(".minus-sign").last().attr("data-counter", secondCounter);
            secondCounter++;
        });
        $(".second-table-data").on("click", ".minus-sign", function (e) {
            $("#total_first_text_" + $(this).data("counter")).rules("remove", "required");
            $("#total_second_text_" + $(this).data("counter")).rules("remove", "required");
            $(e.target).closest(".row").remove();
        });
        // enter selected value to hidden field
        $(document).ready(function () {
//          $(".customScroll").mCustomScrollbar();
            $(document).on("click", '.list-tabs-container li', function (event) {
                $('.list-tabs-container li').removeClass('active');
                $(this).addClass('active');
                var id = $(this).data('tabid');
                $('.tab-pane').hide();
                $("#" + id).show();
                $("#" + id).css("visibility", "visible");
                return false;
            });
            $(document).on("click", '.approval-policy li', function (e) {
                $('.selected_approval-policy').html($(this).html());
                $("#approval_policy").val($(this).data("approvalid"));
                $("#btn_approval_policy").removeClass("error");
                // $(e.target).parent().parent().parent().parent().find(".dropdown-toggle").trigger("click");
                $(".dropdown").find(".show").each(function () {
                    $(this).toggleClass("show");
                });
            });
            $(document).on("click", '.entitlement-policy li', function (e) {
                $('.selected_entitlement-policy').html($(this).html());
                $("#leave_policy").val($(this).data("entitlementid"));
                $("#btn_leave_policy").removeClass("error");
                $(".dropdown").find(".show").each(function () {
                    $(this).toggleClass("show");
                });
                // $(e.target).parent().parent().parent().parent().find(".dropdown-toggle").trigger("click");
            });
            $(document).on("click", '.region-list li', function (e) {
                $('.selected_region').html($(this).html());
                $("#region_id").val($(this).data("regionid"));
                $("#btn_region_id").removeClass("error");
                //$(e.target).parent().parent().parent().parent().find(".dropdown-toggle").trigger("click");
                $(".dropdown").find(".show").each(function () {
                    $(this).toggleClass("show");
                });
            });
            $(document).on("click", '.leave_type li', function (event) {
            });
        });
    }]);
})();

/**
 * Factory responsible for all employee related operations
 * It also has Utils factory for common functionality operations
 */

(function () {
    angular.module('timeOffCommvaultApp.services', ['restangular'])
        .factory('employeeServices', ["Restangular", "Utils", "$q", "$timeout", "configService", "TIMEOFF_CONSTANTS", function (Restangular, Utils, $q, $timeout, configService, TIMEOFF_CONSTANTS) {
            var employeeDetails = [];
            var empId = "";
            var deptName = "";
            var levelFlag = "";
            var empEmail = "";
            var empDeptId = "";
            var sEmpID = "";
            var empName = "";
            var empTeamId = "";
            var prodcertName = "";
            var environment = "dev";
            var myTimeOffs = [];
            var appliedLeaveData = '';
            var managerName = '';
            var teamMembers = {};
            var addedTeamMemberObj = "";
            var yearFlag = "";
            var locationList = [];
            var locationId = "";
            var leaveStartDate = "";
            var leaveEndDate = "";
            var leaveTypeId = "";
            var addedTeamMember = "";
            var optionalLeaves = [""];
            var appliedLeaveRequestparameters = '';
            var uploaderDuplicate = {};

            function escapeHtml(unsafe) {
                if (typeof unsafe == "number") {
                    return unsafe;
                }
                return unsafe
                    .replace(/&/g, "&amp;")
                    .replace(/</g, "&lt;")
                    .replace(/>/g, "&gt;")
                    .replace(/"/g, "&quot;")
                    .replace(/'/g, "&#039;");
            }
            function setUploader(uploader){
                uploaderDuplicate = uploader;
            }
            function getUploader(){
                return uploaderDuplicate;
            }
            function unescapeHtml(safeHtml) {
                if (typeof safeHtml == "string") {
                    return safeHtml.replace(/&amp;/g, "&")
                        .replace(/&lt;/g, "<")
                        .replace(/&gt;/g, ">")
                        .replace(/&quot;/g, '"')
                        .replace(/&#039;/g, "'");
                }
                return safeHtml;
            }

            function getEmployees(pageNumber, pageSize) {
                var deferred = $q.defer();
                if (environment == 'dev') {
                    Restangular.all(URL.getEmployees).getList().then(function (resp) {
                        if (Utils.isValidResponse(resp[0])) {
                            deferred.resolve(resp);
                        }
                        else {
                            Utils.displayError();
                            deferred.reject(resp);
                        }
                    }, function (resp) {
                        Utils.displayError();
                        deferred.reject(resp);
                    });
                    return deferred.promise;
                } else {
                    var employee = Restangular.all(URL.getEmployees);
                    employee.post({
                        pageno: pageNumber,
                        pageSize: pageSize
                    }, "get", {csrf: Utils.getCsrfToken()}).then(function (resp) {
                        if (Utils.isValidResponse(resp[0])) {
                            deferred.resolve(resp);
                        }
                        else {
                            Utils.displayError();
                            deferred.reject(resp);
                        }
                    }, function (resp) {
                        Utils.displayError();
                        deferred.reject(resp);
                    });
                    return deferred.promise;
                }
            }

            function getLocationList() {
                return locationList;
            }

            function getOthersId(locList) {
                var id = 0;
                for (var i = 0; i < locList.length; i++) {
                    if (locList[i].sRegionName == "OTHER") {
                        id = locList[i].nLocationID;
                    }
                }
                ;
                return id;
            }

            function getTableData(timeOffArray, currentMonth, currentYear, empData, empIndex) {
                var tableTimeOffArray = [];
                for (var index in timeOffArray) {
                    if ((timeOffArray[index].sRequestStatus != "Cancelled")&& (timeOffArray[index].sRequestStatus != "Rejected")) {
                        if ((currentMonth == new Date(timeOffArray[index].dateStart.replace(/-/g, "/")).getMonth()) && (currentYear == new Date(timeOffArray[index].dateStart.replace(/-/g, "/")).getFullYear())) {
                            timeOffArray[index].color = empData.color;
                            timeOffArray[index].empName = empData.empName;
                            timeOffArray[index].prodCertName = empData.prodCertName;
                            timeOffArray[index].empIndex = empIndex;
                            tableTimeOffArray.push(timeOffArray[index]);
                        }
                        if ((currentMonth == new Date(timeOffArray[index].dateEnd.replace(/-/g, "/")).getMonth()) && (currentYear == new Date(timeOffArray[index].dateStart.replace(/-/g, "/")).getFullYear()) && (new Date(timeOffArray[index].dateStart.replace(/-/g, "/")).getMonth() != new Date(timeOffArray[index].dateEnd.replace(/-/g, "/")).getMonth())) {
                            timeOffArray[index].color = empData.color;
                            timeOffArray[index].empName = empData.empName;
                            timeOffArray[index].prodCertName = empData.prodCertName;
                            timeOffArray[index].empIndex = empIndex;
                            tableTimeOffArray.push(timeOffArray[index]);
                        }
                    }
                }
                return tableTimeOffArray;
            }

            function setEnvironment(envType) {
                environment = envType;
            }

            function setYearFlag(year) {
                yearFlag = year;
            }

            function getYearFlag() {
                return yearFlag;
            }

            function setLeaveStartDate(startDate) {
                leaveStartDate = startDate;
            }

            function getLeaveStartDate() {
                return leaveStartDate;
            }

            function setLeaveTypeId(typeid) {
                leaveTypeId = typeid;
            }

            function getLeaveTypeId() {
                return leaveTypeId;
            }

            function setLeaveEndDate(endDate) {
                leaveEndDate = endDate;
            }

            function getLeaveEndDate() {
                return leaveEndDate;
            }

            function setEnvironment(envType) {
                environment = envType;
                URL = (environment == 'dev') ? configService.returnDevUrl() : configService.returnProdUrl();
            }

            function setOptionalLeavesArray(leaveArray) {
                optionalLeaves = leaveArray;
            }

            function getOptionalLeavesArray() {
                return optionalLeaves
            }

            function getEnvironment() {
                return environment;
            }

            function getLeaveDetails(leaveId, requestor, startDate, endDate) {
                var deferred = $q.defer();
                if (environment == "dev") {
                    Restangular.all(URL.teamMembersTimeoff).getList().then(function (resp) {
                        if (Utils.isValidResponse(resp[0])) {
                            var timeoffObj = giveValueOfAnotherMemberInArrayOfObjects(resp[0].data[0].timeOffs, leaveId, "");
                            deferred.resolve(timeoffObj);
                        }
                        else {
                            deferred.reject(resp);
                        }
                    }, function (resp) {
                        Utils.displayError();
                        deferred.reject(resp);
                    });
                } else {
                    var timeOff = Restangular.all(URL.teamMembersTimeoff);
                    timeOff.post({
                        alias: requestor,
                        startdate: Utils.respDateFormat(startDate.replace(/-/g, "/"), true),
                        enddate: Utils.respDateFormat(endDate.replace(/-/g, "/"), true)
                    }, "get", {csrf: Utils.getCsrfToken()}).then(function (resp) {
                        if (Utils.isValidResponse(resp[0])) {
                            var timeoffObj = giveValueOfAnotherMemberInArrayOfObjects(resp[0].data[0].timeOffs, leaveId, "");
                            deferred.resolve(timeoffObj);
                        }
                        else {
                            deferred.reject(resp);
                        }
                    }, function (resp) {
                        deferred.reject(resp);
                    });
                }
                return deferred.promise;
            }

            function getLeaveDetailsForEdit(leaveId, requestor, startDate, endDate) {
                var deferred = $q.defer();
                if (environment == "dev") {
                    Restangular.all(URL.editTimeOffUrl).getList().then(function (resp) {
                        if (Utils.isValidResponse(resp[0])) {
                            var timeoffObj = giveValueOfAnotherMemberInArrayOfObjects(resp[0].data[0].timeOffs, leaveId, "");
                            deferred.resolve(timeoffObj);
                        }
                        else {
                            deferred.reject(resp);
                        }
                    }, function (resp) {
                        Utils.displayError();
                        deferred.reject(resp);
                    });
                } else {
                    var timeOff = Restangular.all(URL.editTimeOffUrl);
                    timeOff.post({
                        id:leaveId
                    }, "get", {csrf: Utils.getCsrfToken()}).then(function (resp) {
                        if (Utils.isValidResponse(resp[0])) {
                            var timeoffObj = resp[0].data;
                            deferred.resolve(timeoffObj);
                        }
                        else {
                            deferred.reject(resp);
                        }
                    }, function (resp) {
                        deferred.reject(resp);
                    });
                }
                return deferred.promise;
            }

            function getEventsArray(data) {
                var eventArray = [];
                for (var index in data) {
                    if (data[index].sRequestStatus != "Cancelled") {
                        if (data[index].bIsHalfDay) {
                            if (data[index].bHalfDayType) {
                                var datestart = data[index].dateStart.replace(/-/g, "/") + " 12:00:00";
                                var dateend = data[index].dateEnd.replace(/-/g, "/") + " 23:00:00";
                            } else {
                                var datestart = data[index].dateStart.replace(/-/g, "/") + " 00:00:00";
                                var dateend = data[index].dateEnd.replace(/-/g, "/") + " 11:00:00";
                            }
                            eventArray.push({
                                type: "timeOff",
                                title: Utils.unescapeHtml(data[index].sRequestType),
                                status: data[index].sRequestStatus,
                                mesg: data[index].sRequestor,
                                leaveTypeId: data[index].nRequestTypeID,
                                leaveid: data[index].nID,
                                start: datestart,
                                end: dateend,
                                allDay: false
                            });
                        } else {
                            eventArray.push({
                                type: "timeOff",
                                title: Utils.unescapeHtml(data[index].sRequestType),
                                status: data[index].sRequestStatus,
                                mesg: data[index].sRequestor,
                                leaveTypeId: data[index].nRequestTypeID,
                                leaveid: data[index].nID,
                                start: data[index].dateStart.replace(/-/g, "/"),
                                end: data[index].dateEnd.replace(/-/g, "/") + " 23:00:00",
                                allDay: true
                            });
                        }
                    }
                }
                return eventArray;
            }

            function getEventSourceObject(data, color, type) {
                var eventArray = [];
                for (var index in data) {
                    if (type == "timeOff") {
                        if ((data[index].sRequestStatus != "Cancelled") && (data[index].sRequestStatus != "Rejected")) {
                            if (data[index].bIsHalfDay) {
                                if (data[index].bHalfDayType) {
                                    var datestart = data[index].dateStart.replace(/-/g, "/") + configService.halfDayParameters.secondHalfStartTime;
                                    var dateend = data[index].dateEnd.replace(/-/g, "/") + configService.halfDayParameters.secondHalfEndTime;
                                } else {
                                    var datestart = data[index].dateStart.replace(/-/g, "/") + configService.halfDayParameters.firstHalfStartTime;
                                    var dateend = data[index].dateEnd.replace(/-/g, "/") + configService.halfDayParameters.firstHalfEndTime;
                                }
                                eventArray.push({
                                    type: type,
                                    title: Utils.unescapeHtml(data[index].sRequestType),
                                    status: data[index].sRequestStatus,
                                    mesg: data[index].sRequestor,
                                    leaveTypeId: data[index].nRequestTypeID,
                                    action: data[index].sAction,
                                    leaveid: data[index].nID,
                                    start: datestart,
                                    end: dateend,
                                    allDay: false
                                });
                            } else {
                                eventArray.push({
                                    type: type,
                                    title: Utils.unescapeHtml(data[index].sRequestType),
                                    status: data[index].sRequestStatus,
                                    mesg: data[index].sRequestor,
                                    action: data[index].sAction,
                                    leaveTypeId: data[index].nRequestTypeID,
                                    leaveid: data[index].nID,
                                    start: data[index].dateStart.replace(/-/g, "/")+ configService.halfDayParameters.firstHalfStartTime,
                                    end: data[index].dateEnd.replace(/-/g, "/") + configService.halfDayParameters.secondHalfEndTime,
                                    allDay: true
                                });
                            }
                        }
                    } else {
                        eventArray.push({
                            type: type,
                            title: Utils.unescapeHtml(data[index].sRequestType),
                            start: data[index].dateStart.replace(/-/g, "/"),
                            end: data[index].dateEnd.replace(/-/g, "/") + " 19:00:00",
                            allDay: true
                        })
                    }
                }
                var obj = {
                    color: color,
                    textColor: 'white',
                    padding: '0px',
                    events: eventArray
                }
                return obj;
            }

            function setEmployeeDetails(data) {
                employeeDetails = data;
                empId = employeeDetails.data[0].nID;
                sEmpID = employeeDetails.data[0].sEmpID;
                deptName = employeeDetails.data[0].DeptName;
                levelFlag = employeeDetails.data[0].sRole;
                empEmail = employeeDetails.data[0].sEmail;
                empDeptId = employeeDetails.data[0].nDeptID;
                empName = employeeDetails.data[0].sEmpName;
                empTeamId = employeeDetails.data[0].nTeamID;
                prodcertName = employeeDetails.data[0].ProdcertName;
                managerName = employeeDetails.data[0].Manager;
                teamMembers = employeeDetails.data[0].TeamMembers;
                locationId = employeeDetails.data[0].nLocationID;
                locationList = employeeDetails.data[0].LocationsList;
            }

            function getProdcertName() {
                return prodcertName;
            }
            
            function getGlobalEmployeeID() {
            	return sEmpID;
            }

            function getEmpName() {
                return empName;
            }

            function getLevelFlag() {
                return levelFlag;
            }

            function getDeptName() {
                return deptName;
            }

            function editLeave(leaveParams) {
                var deferred = $q.defer();
                var requestUrl;
                if (environment == "prod") {
                    requestUrl = Restangular.all(URL.updateTimeOff)
                    requestUrl.post(leaveParams, "get", {csrf: Utils.getCsrfToken()}).then(function (data) {
                        if (!Utils.isValidResponse(data[0])) {
                            deferred.reject(data);
                        } else {
                            deferred.resolve(data);
                        }
                    }, function (data) {
                        deferred.reject(data);
                    })
                    return deferred.promise;
                }
                else {
                    deferred.resolve({'success': true});
                    return deferred.promise;
                }
            }

            function applyLeave(leaveParams) {
                var deferred = $q.defer();
                var requestUrl = Restangular.all(URL.applyTimeOff);
                if (environment == "prod") {
                    var requestUrl = Restangular.all(URL.applyTimeOff);
                    requestUrl.post(leaveParams, "get", {csrf: Utils.getCsrfToken()}).then(function (data) {
                        if (Utils.isValidResponse(data[0])) {
                            appliedLeaveData = data;
                            deferred.resolve(data);
                        }
                        else {
                            deferred.reject(data);
                        }
                    }, function (data) {
                        deferred.reject(data);
                    })
                } else {
                    deferred.resolve({'success': true});
                }
                return deferred.promise;
            }

            function retrieveTimeOffApplicable(prodCertName) {// need to modify
                var deferred = $q.defer();
                if (environment == "dev") {
                    Restangular.all("json/myTimeOffs" + prodCertName + ".json").getList().then(function (resp) {
                        if (Utils.isValidResponse(resp[0])) {
                            deferred.resolve(resp);
                        }
                        else {
                            deferred.reject(resp);
                        }
                    }, function (resp) {
                        deferred.reject(resp);
                    });
                } else {
                    var timeOff = Restangular.all("timeoff/getTimeOffsApplicableForOthers.do");
                    timeOff.post({alias: prodCertName}, "get", {csrf: Utils.getCsrfToken()}).then(function (resp) {
                        if (Utils.isValidResponse(resp[0])) {
                            deferred.resolve(resp);
                        }
                        else {
                            deferred.reject(resp);
                        }
                    }, function (resp) {
                        deferred.reject(resp);
                    });
                }
                return deferred.promise;
            }

            function setMyTimeOffs(timeOffs) {
                myTimeOffs = timeOffs;
            }

            function getMyTimeOffs() {
                return myTimeOffs;
            }

            function getTimeOffs(prodCertName, year) {
                if (year == "") {
                    year = "2015";
                }
                //TO Do remove below after testing
                var deferred = $q.defer();
                if (environment == "dev") {
                    Restangular.all("json/timeoffs" + year + ".json").getList().then(function (resp) {
                        if (Utils.isValidResponse(resp[0])) {
                            deferred.resolve(resp);
                        }
                        else {
                            Utils.displayError();
                            deferred.reject(resp);
                        }
                    }, function (resp) {
                        Utils.displayError();
                        deferred.reject(resp);
                    });
                } else {
                    var timeOff = Restangular.all(URL.teamMembersTimeoff);
                    timeOff.post({
                        alias: prodCertName,
                        startdate: "01/01/" + year,
                        enddate: "12/31/" + TIMEOFF_CONSTANTS.CALENDER_END_YEAR
                    }, "get", {csrf: Utils.getCsrfToken()}).then(function (resp) {
                        if (Utils.isValidResponse(resp[0])) {
                            deferred.resolve(resp);
                        }
                        else {
                            deferred.reject(resp);
                        }
                    }, function (resp) {
                        Utils.displayError();
                        deferred.reject(resp);
                    });
                }
                return deferred.promise;
            }

            function findCommonTimeOffs(leaveTypes, empLeaveType) {
                var timeoffsArray = empLeaveType;
                var finalLeaveTypeArray = [];
                angular.forEach(leaveTypes, function (value, index) {
                    angular.forEach(timeoffsArray, function (object, index1) {
                        if (value.sRequestType == object.sRequestType) {
                            finalLeaveTypeArray.push(object)
                        }
                    })
                })
                return finalLeaveTypeArray;
            }

            function getHolidays() {
                return employeeDetails.data[0].Holidays;
            }

            function getDisabledHolidays(date, mode) {
                var holidaysArray = getHolidays();
                var dateArray = [];
                for (var index in holidaysArray) {
                    if (holidaysArray[index].nLocationID == getLocationId()) {
                        if (holidaysArray[index].nIsOptional != true) {
                            if ((date.getDate() >= new Date(holidaysArray[index].startDate).getDate() && date.getDate() <= new Date(holidaysArray[index].endDate).getDate()) && ((date.getMonth()) == new Date(holidaysArray[index].startDate).getMonth() || ((date.getMonth()) == new Date(holidaysArray[index].endDate).getMonth())))
                                dateArray.push(date.getDate() + "-" + (date.getMonth()) + "-" + date.getYear());
                        }
                    }
                }
                var dateString = date.getDate() + "-" + date.getMonth() + "-" + date.getYear();
                return ( mode === 'day' && ( ($.inArray(dateString, dateArray) !== -1)));
            }

            function disableCompleteCalendar(date, mode, startDate) {
                return ( mode === 'day' && (Utils.defaultDateFormat(date) != startDate));
            }

            function getCountrysHolidays(country) {
                return employeeDetails.data[0].Holidays.country;
            }

            function getLeaveTypes() {
                return employeeDetails.data[0].empLeaveType;
            }

            function getTeamMembers() {
                return employeeDetails.data[0].TeamMembers;
            }

            function getTimeOffsForEmployee(employeeId) {
                var deferred = $q.defer();
                Restangular.all("json/myTimeOffs.json").getList().then(function (resp) {
                    resp = Utils.sanitizeRestangularOne(resp);
                    deferred.resolve(resp);
                });
                return deferred.promise;
            }

            function getCompanyEvents() {
                return employeeDetails.data[0].CompanyEvents;
            }

            function getEmployeeDetails() {
                return Restangular.all(URL.mainPage).getList();
            }

            function getAppliedLeaveData() {
                return appliedLeaveData;
            }

            function preserveData() {
                var deferred = $q.defer();
                if (empName == "") {
                    getEmployeeDetails().then(function (resp) {
                        if (Utils.isValidResponse(resp[0])) {
                            setEmployeeDetails(resp[0]);
                            var rootScope = {
                                empName: getEmpName(),
                                levelFlag: getLevelFlag()
                            }
                            deferred.resolve(rootScope);
                        }
                        else {
                            deferred.reject(resp);
                        }
                    });
                } else {
                    var rootScope = {
                        empName: getEmpName(),
                        levelFlag: getLevelFlag()
                    }
                    deferred.resolve(rootScope);
                }
                return deferred.promise;
            }

            function getManagerName() {
                return managerName;
            }

            function getTeamMembers() {
                return teamMembers;
            }

            function cancelLeave(leaveParams) {
                var deferred = $q.defer();
                var requestUrl = Restangular.all(URL.deleteTimeoff)
                requestUrl.post(leaveParams, "get", {csrf: Utils.getCsrfToken()}).then(function (data) {
                    if (Utils.isValidResponse(data[0])) {
                        appliedLeaveData = data;
                        deferred.resolve(data);
                    }
                    else {
                        deferred.reject(data);
                    }
                }, function (data) {
                    Utils.displayError();
                    deferred.reject(data);
                })
                return deferred.promise;
            }

            function getDepartmentName() {
                return deptName;
            }

            function preserveData() {
                var deferred = $q.defer();
                if (empName == "") {
                    getEmployeeDetails().then(function (resp) {
                        if (Utils.isValidResponse(resp[0])) {
                            setEmployeeDetails(resp[0]);
                            var rootScope = {
                                empName: getEmpName(),
                                levelFlag: getLevelFlag()
                            }
                            deferred.resolve(rootScope);
                        }
                        else {
                            deferred.reject(resp);
                        }
                    });
                } else {
                    var rootScope = {
                        empName: getEmpName(),
                        levelFlag: getLevelFlag()
                    }
                    deferred.resolve(rootScope);
                }
                return deferred.promise;
            }

            function giveValueOfAnotherMemberInArrayOfObjects(obj, valueOfField, requireValueOfanotherField) {
                for (var index in obj) {
                    for (var objkey in obj[index]) {
                        if ((obj[index][objkey] == valueOfField)) {
                            var primaryKey = "nID";
                            if ($.isArray(requireValueOfanotherField)) {
                                primaryKey = requireValueOfanotherField[0];
                                if (objkey == primaryKey) {
                                    if ((requireValueOfanotherField == "") || ($.isArray(requireValueOfanotherField))) {
                                        return obj[index];
                                    }
                                    return obj[index][requireValueOfanotherField];
                                }
                            } else {
                                if ((requireValueOfanotherField == "")) {
                                    if (objkey == primaryKey) {
                                        return obj[index];
                                    }
                                } else {
                                    return obj[index][requireValueOfanotherField];
                                }
                            }
                        }
                    }
                }
                return null;
            }

            function setAppliedLeaveParameters(params) {
                params.sComments = unescapeHtml(params.sComments);
                appliedLeaveRequestparameters = params;
            }

            function getAppliedLeaveParameters() {
                return appliedLeaveRequestparameters;
            }

            function setAddedTeamMember(team) {
                addedTeamMember = team;
            }

            function getAddedTeamMember() {
                return addedTeamMember;
            }

            function getSelectedTeamMembersManagerName() {
                var teamMemberwithManager = [];
                var k = 0;
                for (var i = 0; i < addedTeamMember.length; i++) {
                    for (var j = 0; j < teamMembers.length; j++) {
                        if (addedTeamMember[i] == teamMembers[j].sEmpName) {
                            teamMemberwithManager.push({
                                "teamMemberName": teamMembers[j].sEmpName,
                                "manager": teamMembers[j].Manager
                            });
                        }
                    }
                }
                ;
                return teamMemberwithManager;
            }

            function getLocationId() {
                return locationId;
            }

            function getEmployeeById(id) {
                var deferred = $q.defer();
                var employeeParams = {"alias": id}
                Restangular.all(URL.getEmployeeById + "?empId=" + id).getList().then(function (resp) {
                    // var requestUrl = Restangular.all(URL.getEmployeeById)
                    // requestUrl.post(employeeParams, "get", {csrf: Utils.getCsrfToken()}).then(function (data) {
                    if (Utils.isValidResponse(resp[0])) {
                        deferred.resolve(resp);
                    }
                    else {
                        deferred.reject(resp);
                    }
                }, function (resp) {
                    Utils.displayError();
                    deferred.reject(resp);
                });
                return deferred.promise;
            }

            function getEmployeeByParams(params) {
                var deferred = $q.defer();
                var employeeParams = {"searchtoken": params}
                var timeOff = Restangular.all(URL.getEmployeeByToken);
                timeOff.post(employeeParams, "get", {csrf: Utils.getCsrfToken()}).then(function (resp) {
                    //timeOff.getList().then(function (resp) {// dev mode
                    if (Utils.isValidResponse(resp[0])) {
                        deferred.resolve(resp);
                    }
                    else {
                        deferred.reject(resp);
                    }
                }, function (resp) {
                    deferred.reject(resp);
                });
                return deferred.promise;
            }

            function getEmployeeObj() {
                return employeeDetails.data[0];
            }

            return {
                'getLeaveTypes': getLeaveTypes,
                'getLocationId': getLocationId,
                'empId': empId,
                'getDeptName': getDeptName,
                'getLevelFlag': getLevelFlag,
                'empEmail': empEmail,
                'empDeptId': empDeptId,
                'getEmpName': getEmpName,
                'empTeamId': empTeamId,
                'getHolidays': getHolidays,
                'getTimeOffs': getTimeOffs,
                'getCompanyEvents': getCompanyEvents,
                'getTimeOffsForEmployee': getTimeOffsForEmployee,
                'getDisabledHolidays': getDisabledHolidays,
                'getEmployeeDetails': getEmployeeDetails,
                'setEmployeeDetails': setEmployeeDetails,
                'getProdcertName': getProdcertName,
                'getGlobalEmployeeID':getGlobalEmployeeID,
                'applyLeave': applyLeave,
                'retrieveTimeOffApplicable': retrieveTimeOffApplicable,
                'findCommonTimeOffs': findCommonTimeOffs,
                'setEnvironment': setEnvironment,
                'getEnvironment': getEnvironment,
                'getEventSourceObject': getEventSourceObject,
                'setMyTimeOffs': setMyTimeOffs,
                'getMyTimeOffs': getMyTimeOffs,
                'getLeaveDetails': getLeaveDetails,
                'getLeaveDetailsForEdit':getLeaveDetailsForEdit,
                'getManagerName': getManagerName,
                'getTeamMembers': getTeamMembers,
                'getDepartmentName': getDepartmentName,
                'cancelLeave': cancelLeave,
                'setLeaveStartDate': setLeaveStartDate,
                'setLeaveEndDate': setLeaveEndDate,
                'setLeaveTypeId': setLeaveTypeId,
                'giveValueOfAnotherMemberInArrayOfObjects': giveValueOfAnotherMemberInArrayOfObjects,
                'editLeave': editLeave,
                'preserveData': preserveData,
                'getSelectedTeamMembersManagerName': getSelectedTeamMembersManagerName,
                'getYearFlag': getYearFlag,
                'setYearFlag': setYearFlag,
                'setOptionalLeavesArray': setOptionalLeavesArray,
                'getOptionalLeavesArray': getOptionalLeavesArray,
                'setAppliedLeaveParameters': setAppliedLeaveParameters,
                'getAppliedLeaveParameters': getAppliedLeaveParameters,
                'getAppliedLeaveData': getAppliedLeaveData,
                'getAddedTeamMember': getAddedTeamMember,
                'setAddedTeamMember': setAddedTeamMember,
                'getTableData': getTableData,
                'getLocationList': getLocationList,
                'getEventsArray': getEventsArray,
                'disableCompleteCalendar': disableCompleteCalendar,
                'getEmployees': getEmployees,
                "getEmployeeById": getEmployeeById,
                "escapeHtml": escapeHtml,
                "unescapeHtml": unescapeHtml,
                "getEmployeeByParams": getEmployeeByParams,
                "getEmployeeObj": getEmployeeObj,
                "getOthersId": getOthersId,
                "setUploader": setUploader,
                "getUploader": getUploader


            }
        }]).factory('Utils', ["$timeout",
            function ($timeout) {
                function getFullMonth(monthNumber) {
                    var monthsArray = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
                    return monthsArray[monthNumber];
                }

                function getCsrfToken() {
                    function readCookie(name) {
                        var nameEQ = name + "=";
                        var ca = document.cookie.split(';');
                        for (var i = 0; i < ca.length; i++) {
                            var c = ca[i];
                            while (c.charAt(0) == ' ') c = c.substring(1, c.length);
                            if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length, c.length);
                        }
                        return null;
                    }

                    return readCookie("csrf");
                }

                function respDateFormat(rawDateString, leadingZeroFlag) {
                    return (((new Date(rawDateString).getMonth() < 9) && (leadingZeroFlag == true)) ? "0" : "") + (new Date(rawDateString).getMonth() + 1) + "/" + ((new Date(rawDateString).getDate() < 10) ? "0" : "") + new Date(rawDateString).getDate() + "/" + new Date(rawDateString).getFullYear();
                }

                function defaultFormateDate(rawDateString) {
                    var monthNames = ["January", "February", "March", "April", "May", "June",
                        "July", "August", "September", "October", "November", "December"
                    ];
                    return (((new Date(rawDateString).getDate() < 10)) ? "0" : "") + new Date(rawDateString).getDate() + "-" + monthNames[(new Date(rawDateString).getMonth())] + "-" + new Date(rawDateString).getFullYear();
                }

                function convertDateString(dateData) {
                    var monthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun",
                        "Jul", "Aug", "Sept", "Oct", "Nov", "December"
                    ];
                    if (dateData instanceof Date) {
                        return dateData.getDate() + " " + monthNames[dateData.getMonth()] + " " + dateData.getFullYear()
                    }
                    else {
                        dateData = dateData.replace("-", " ", "g");
                        var dateObj = new Date(dateData);
                        return dateObj.getDate() + " " + monthNames[dateObj.getMonth()] + " " + dateObj.getFullYear()
                    }
                }

                function defaultDateFormat(dateObj) {
                    return (((dateObj.getDate() < 10) ? "0" : "") + dateObj.getDate() + "-" + getFullMonth(dateObj.getMonth()) + "-" + dateObj.getFullYear());
                }

                function isValidResponse(resp) {
                    if ((resp.error != null) && (resp.error != undefined)) {
                        $(".alert-msg").hide();
                        $("#error-msg").html(resp.error);
                        if (resp.error != "") {
                            $("#error-msg").show().delay(8000).fadeOut(3000);
                            $timeout(function(){$("#error-msg").html("Something went wrong !!!")},14000);
                        }
                    }
                    if (resp.success == true) {
                        return true;
                    }
                    displayError();
                    return false;
                }

                function displayError() {
                    $('#error-msg').show();
                    $('#error-msg').fadeOut(10000);
                }

                function isActive(renewedDate, duration) {
                }

                function calculateDays(startDateStr, endDateStr) {
                    var startDate = new Date(startDateStr.replace(/-/g, "/"));
                    var endDate = new Date(endDateStr.replace(/-/g, "/"));
                    ;
                    var millisecondsPerDay = 86400 * 1000;
                    startDate.setHours(0, 0, 0, 1);
                    endDate.setHours(23, 59, 59, 999);
                    var diff = endDate - startDate;
                    var days = Math.ceil(diff / millisecondsPerDay);
                    return days;
                }

                function sortArrayBasedOnDates(objArr) {
                    var temp = {};
                    for (var i = 0; i < objArr.length - 1; i++) {
                        for (var d = 0; d < objArr.length - i - 1; d++) {
                            var date1 = new Date(objArr[d].date).getDate();
                            var date2 = new Date(objArr[d + 1].date).getDate();
                            if (date1 > date2) {
                                temp = objArr[d];
                                objArr[d] = objArr[d + 1];
                                objArr[d + 1] = temp;
                            }
                        }
                    }
                    return objArr;
                }

                function keepDateFieldReadable(keyEvent) {
                    keyEvent.preventDefault();
                    return false;
                }

                function escapeHtml(unsafe) {
                    if (typeof unsafe == "number") {
                        return unsafe;
                    }
                    return unsafe
                        .replace(/&/g, "&amp;")
                        .replace(/</g, "&lt;")
                        .replace(/>/g, "&gt;")
                        .replace(/"/g, "&quot;")
                        .replace(/'/g, "&#039;");
                }

                function unescapeHtml(safeHtml) {
                    if (typeof safeHtml == "string") {
                        return safeHtml.replace(/&amp;/g, "&")
                            .replace(/&lt;/g, "<")
                            .replace(/&gt;/g, ">")
                            .replace(/&quot;/g, '"')
                            .replace(/&#039;/g, "'");
                    }
                    return safeHtml;
                }

                function clearFormValidations() {
                    $('form').validate().resetForm();
                    $('.has-error').html('');
                    $("button").removeClass("error")
                    $("input").removeClass("error");
                    $("span.error-msg").html("");
                    $("span").removeClass("error");
                }

                function removeSourceObject(data) {
                    if (!Array.isArray) {
                        Array.isArray = function (arg) {
                            return Object.prototype.toString.call(arg) == '[object Array]';
                        };
                    }
                    for (var key in data) {
                        console.log(Object.keys(data[0]));
                        console.log(data[0].hasOwnProperty("source"));
                        if (data.hasOwnProperty("source")) {

                            // remove this item from the parent object
                            console.log("111===");
                            delete data[key];
                        } else {
                            if (key == "events") {
                                console.log(data[key][0]);
                                removeSourceObject(data[key][0]);
                            }
                        }
                    }
                }
                function uniqid(prefix, more_entropy) {
                    //  discuss at: http://phpjs.org/functions/uniqid/
                    // original by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
                    //  revised by: Kankrelune (http://www.webfaktory.info/)
                    //        note: Uses an internal counter (in php_js global) to avoid collision
                    //        test: skip
                    //   example 1: uniqid();
                    //   returns 1: 'a30285b160c14'
                    //   example 2: uniqid('foo');
                    //   returns 2: 'fooa30285b1cd361'
                    //   example 3: uniqid('bar', true);
                    //   returns 3: 'bara20285b23dfd1.31879087'

                    if (typeof prefix === 'undefined') {
                        prefix = '';
                    }

                    var retId;
                    var formatSeed = function(seed, reqWidth) {
                        seed = parseInt(seed, 10)
                            .toString(16); // to hex str
                        if (reqWidth < seed.length) { // so long we split
                            return seed.slice(seed.length - reqWidth);
                        }
                        if (reqWidth > seed.length) { // so short we pad
                            return Array(1 + (reqWidth - seed.length))
                                    .join('0') + seed;
                        }
                        return seed;
                    };

                    // BEGIN REDUNDANT
                    if (!this.php_js) {
                        this.php_js = {};
                    }
                    // END REDUNDANT
                    if (!this.php_js.uniqidSeed) { // init seed with big random int
                        this.php_js.uniqidSeed = Math.floor(Math.random() * 0x75bcd15);
                    }
                    this.php_js.uniqidSeed++;

                    retId = prefix; // start with prefix, add current milliseconds hex string
                    retId += formatSeed(parseInt(new Date()
                        .getTime() / 1000, 10), 8);
                    retId += formatSeed(this.php_js.uniqidSeed, 5); // add seed hex string
                    if (more_entropy) {
                        // for more entropy we add a float lower to 10
                        retId += (Math.random() * 10)
                            .toFixed(8)
                            .toString();
                    }

                    return retId;
                }
                return {
                    sanitizeRestangularOne: function (item) {
                        return _.omit(item, "route", "parentResource", "getList", "get", "post", "put", "remove", "head", "trace", "options", "patch",
                            "$get", "$save", "$query", "$remove", "$delete", "$put", "$post", "$head", "$trace", "$options", "$patch", "plain", "putElement", "several", "withHttpConfig", "_proto_",
                            "$then", "$resolved", "restangularCollection", "customOperation", "customGET", "customPOST", "fromServer", "getRequestedUrl", "newlyAddedProp", "oneUrl",
                            "customPUT", "customDELETE", "customGETLIST", "$getList", "$resolved", "restangularCollection", "one", "all", "doGET", "doPOST", "allUrl", "clone",
                            "doPUT", "doDELETE", "$$hashKey", "doGETLIST", "addRestangularMethod", "getRestangularUrl", "restangularEtag", "reqParams", "getParentList", "save", "data", "source");
                    },
                    'getCsrfToken': getCsrfToken,
                    'respDateFormat': respDateFormat,
                    'convertDateString': convertDateString,
                    'getFullMonth': getFullMonth,
                    'isValidResponse': isValidResponse,
                    'displayError': displayError,
                    'isActive': isActive,
                    "defaultFormateDate": defaultFormateDate,
                    'defaultDateFormat': defaultDateFormat,
                    "calculateDays": calculateDays,
                    "sortArrayBasedOnDates": sortArrayBasedOnDates,
                    "keepDateFieldReadable": keepDateFieldReadable,
                    "escapeHtml": escapeHtml,
                    "unescapeHtml": unescapeHtml,
                    "clearFormValidations": clearFormValidations,
                    "removeSourceObject": removeSourceObject,
                    'uniqid': uniqid
                }
            }
        ]);
})();
/**
 * Factory used for page add time off
 */
(function () {
    'use strict';
    angular.module('timeOffCommvaultApp.addLeaveTypeServices', ['restangular'])
        .factory('addLeaveTypeServices', ["employeeServices", "configService", "$q", "Utils", "Restangular", function (employeeServices, configService, $q, Utils, Restangular) {
            var environment = employeeServices.getEnvironment();
            var URL = (environment == 'dev') ? configService.returnDevUrl() : configService.returnProdUrl();
            var timeOffList = [];
            var entitlementList = [];
            var approvalList = [];

            function fetchListOfTimeOffs() {
                var deferred = $q.defer();
                if (environment == "dev") {
                    Restangular.all(URL.getListOfTimeOffs).getList().then(function (resp) {
                        if (resp[0].data == null) {
                            resp[0].data = [];
                        }
                        if (Utils.isValidResponse(resp[0])) {
                            timeOffList = resp[0].data;
                            deferred.resolve(resp);
                        } else {
                            deferred.reject(resp);
                        }
                    }, function (resp) {
                        Utils.displayError();
                        deferred.reject(resp);
                    });
                } else {

                    // test on server
                    Restangular.all(URL.getListOfTimeOffs).getList().then(function (resp) {
                        if (resp[0].data == null) {
                            resp[0].data = [];
                        }
                        if (Utils.isValidResponse(resp[0])) {
                            timeOffList = resp[0].data;
                            // var timeoffListObj = employeeServices.giveValueOfAnotherMemberInArrayOfObjects(resp[0].data[0].timeOffs, leaveId, "");
                            deferred.resolve(resp);
                        }
                        else {
                            deferred.reject(resp);
                        }
                    }, function (resp) {
                        deferred.reject(resp);
                    });
                }
                return deferred.promise;
            }

            function fetchEntitlementPolicyList() {
                var deferred = $q.defer();
                Restangular.all(URL.getEntitlementList).getList().then(function (resp) {
                    if (resp[0].data == null) {
                        resp[0].data = [];
                    }
                    if (Utils.isValidResponse(resp[0])) {
                        entitlementList = resp[0].data;
                        deferred.resolve(resp);
                    } else {
                        deferred.reject(resp);
                    }
                }, function (resp) {
                    Utils.displayError();
                    deferred.reject(resp);
                });
                return deferred.promise;
            }

            function fetchApprovalPolicyList() {
                var deferred = $q.defer();
                Restangular.all(URL.getApprovalList).getList().then(function (resp) {
                    if (resp[0].data == null) {
                        resp[0].data = [];
                    }
                    if (Utils.isValidResponse(resp[0])) {
                        approvalList = resp[0].data;
                        deferred.resolve(resp);
                    } else {
                        deferred.reject(resp);
                    }
                }, function (resp) {
                    Utils.displayError();
                    deferred.reject(resp);
                });
                return deferred.promise;
            }

            function getTimeOffList() {
                return timeOffList;
            }

            function getEntitlementPolicyList() {
                return entitlementList;
            }

            function getApprovalPolicyList() {
                return approvalList;
            }

            function getTimeOffObj(timeOffId) {
                var timeOffObj;
                for (var i = 0; i < timeOffList.length; i++) {
                    if (timeOffId == timeOffList[i].nID) {
                        timeOffObj = timeOffList[i];
                    }
                }
                ;
                return timeOffObj;
            }

            function addNewTimeOffType(name, isDeductable, entitlementId, approvalId, canOverlap, overlapWith, halfdayAllowed, regionId, bIsOptionalType) {
                // var timeoffId = (typeof timeOffId === undefined) ? -1 : timeOffId;
                var postObj = postConstructBody(name, isDeductable, entitlementId, approvalId, canOverlap, overlapWith, halfdayAllowed, regionId, bIsOptionalType, -1);
                var timeOff = Restangular.all(URL.addNewTimeOffType);
                var deferred = $q.defer();
                if (environment == 'prod') {
                    timeOff.post(postObj, "get", {csrf: Utils.getCsrfToken()}).then(function (resp) {
                        if (Utils.isValidResponse(resp[0])) {
                            // var timeoffListObj = employeeServices.giveValueOfAnotherMemberInArrayOfObjects(resp[0].data[0].timeOffs, leaveId, "");
                            deferred.resolve(resp);
                        }
                        else {
                            deferred.reject(resp);
                        }
                    }, function (resp) {
                        deferred.reject(resp);
                    });
                }
                else {
                    deferred.resolve({"success": true});
                }
                return deferred.promise;
            }

            function editTimeOffType(name, isDeductable, entitlementId, approvalId, canOverlap, overlapWith, halfdayAllowed, regionId, bIsOptionalType, timeOffId) {
                var postObj = postConstructBody(name, isDeductable, entitlementId, approvalId, canOverlap, overlapWith, halfdayAllowed, regionId, bIsOptionalType, timeOffId);
                var timeOff = Restangular.all(URL.editTimeOffType);
                var deferred = $q.defer();
                if (environment == 'prod') {
                    timeOff.post(postObj, "get", {csrf: Utils.getCsrfToken()}).then(function (resp) {
                        if (Utils.isValidResponse(resp[0])) {

                            // var timeoffListObj = employeeServices.giveValueOfAnotherMemberInArrayOfObjects(resp[0].data[0].timeOffs, leaveId, "");
                            deferred.resolve(resp);
                        }
                        else {
                            deferred.reject(resp);
                        }
                    }, function (resp) {
                        deferred.reject(resp);
                    });
                }
                else {
                    timeOff.post(postObj, "get", {csrf: Utils.getCsrfToken()}).then(function (resp) {
                        if (Utils.isValidResponse(resp[0])) {

                            // var timeoffListObj = employeeServices.giveValueOfAnotherMemberInArrayOfObjects(resp[0].data[0].timeOffs, leaveId, "");
                            deferred.resolve(resp);
                        }
                        else {
                            deferred.reject(resp);
                        }
                    }, function (resp) {
                        deferred.reject(resp);
                    });
                    deferred.resolve({"success": true});
                }
                return deferred.promise;
            }

            function deleteTimeOffType(nid) {
                var timeOff = Restangular.all(URL.deleteTimeOffType);
                var deferred = $q.defer();
                var postObj = {"nID": nid};
                if (environment == 'prod') {
                    timeOff.post(postObj, "get", {csrf: Utils.getCsrfToken()}).then(function (resp) {
                        if (Utils.isValidResponse(resp[0])) {

                            // var timeoffListObj = employeeServices.giveValueOfAnotherMemberInArrayOfObjects(resp[0].data[0].timeOffs, leaveId, "");
                            deferred.resolve(resp);
                        }
                        else {
                            deferred.reject(resp);
                        }
                    }, function (resp) {
                        deferred.reject(resp);
                    });
                }
                else {
                    timeOff.post(postObj, "get", {csrf: Utils.getCsrfToken()}).then(function (resp) {
                        if (Utils.isValidResponse(resp[0])) {

                            // var timeoffListObj = employeeServices.giveValueOfAnotherMemberInArrayOfObjects(resp[0].data[0].timeOffs, leaveId, "");
                            deferred.resolve(resp);
                        }
                        else {
                            deferred.reject(resp);
                        }
                    }, function (resp) {
                        //deferred.reject(resp);
                        deferred.resolve({"success": true});
                    });
                }
                return deferred.promise;
            }

            function postConstructBody(name, isDeductable, entitlementId, approvalId, canOverlap, overlapWith, halfdayAllowed, regionId, bIsOptionalType, timeOffId) {
                var postObj = {
                    "bIsDeductible": isDeductable,
                    "bIsHalfDayAllowed": halfdayAllowed,
                    "bIsOverlapAllowed": canOverlap,
                    "bIsVisibleToAll": true,
                    "nApprovalPolicyID": approvalId,
                    "nEntitlementPolicyID": entitlementId,
                    "nLocationID": regionId,
                    "OverlapRequestTypeID": overlapWith,
                    "sRequestType": name,
                    "bIsOptionalType": bIsOptionalType
                }
                if (timeOffId != -1) {
                    postObj.nID = timeOffId;
                }
                return postObj;
            }

            function getEntitlementPolicyName(entitlementId) {
                var entitlementObj;
                for (var i = 0; i < entitlementList.length; i++) {
                    if (entitlementId == entitlementList[i].nID) {
                        entitlementObj = entitlementList[i];
                        break;
                    }
                }
                ;
                return entitlementObj.sPolicyName;
            }

            function getApprovalPolicyName(approvalId) {
                var approvalObj;
                for (var i = 0; i < approvalList.length; i++) {
                    if (approvalId == approvalList[i].nID) {
                        approvalObj = approvalList[i];
                        break;
                    }
                }
                ;
                return approvalObj.sPolicyName;
            }

            return {
                'fetchListOfTimeOffs': fetchListOfTimeOffs,
                'getTimeOffList': getTimeOffList,
                'fetchEntitlementPolicyList': fetchEntitlementPolicyList,
                'getEntitlementPolicyList': getEntitlementPolicyList,
                'fetchApprovalPolicyList': fetchApprovalPolicyList,
                'getApprovalPolicyList': getApprovalPolicyList,
                'addNewTimeOffType': addNewTimeOffType,
                'getTimeOffObj': getTimeOffObj,
                'getEntitlementPolicyName': getEntitlementPolicyName,
                'getApprovalPolicyName': getApprovalPolicyName,
                'editTimeOffType': editTimeOffType,
                'deleteTimeOffType': deleteTimeOffType
            }
        }]);
})();

'use strict';
/**
 * @ngdoc function
 * @name timeOffCommvaultApp.controller:AboutCtrl
 * @description
 * # holidayCtrl
 * Controller of the holiday listing
 */
(function () {
    app.controller('holidayCtrl', ["$scope", "holidayService", "employeeServices", "Utils", "i8nConstants", function ($scope, holidayService, employeeServices, Utils, i8nConstants) {

        // hide dropdown if clicked outside of dropdown
        $(document).mouseup(function (e) {
            var container = $(".dropdown");
            if (!container.is(e.target) // if the target of the click isn't the container...
                && container.has(e.target).length === 0) // ... nor a descendant of the container
            {
                $(".dropdown").find(".show").each(function () {
                    $(this).toggleClass("show");
                });
            }
        });
        //hide and show dropdown on click of button
        $('.dropdown-toggle').off().on("click", function () {
            $(this).dropdown();
            $(this).parent().find(".dropdown-menu").toggleClass("show");
        });
        var dateObj = new Date();
        $scope.country = "India";
        $scope.countryFilter = [];
        $scope.filteredCountries = [];
        $scope.noHolidayMsg = i8nConstants.LOADING;
        var index = 0;
        
        //To support holiday list for subsequent year
        //@TODO: Need to acheive this in a better way
        $scope.monthYear = ["January-" + dateObj.getFullYear(), "February-" + dateObj.getFullYear(), "March-" + dateObj.getFullYear(), "April-" + dateObj.getFullYear(), "May-" + dateObj.getFullYear(), "June-" + dateObj.getFullYear(),
	        "July-" + dateObj.getFullYear(), "August-" + dateObj.getFullYear(), "September-" + dateObj.getFullYear(), "October-" + dateObj.getFullYear(), "November-" + dateObj.getFullYear(), "December-" + dateObj.getFullYear(), "January-" + (dateObj.getFullYear() + 1),
	        "February-" + (dateObj.getFullYear() + 1), "March-" + (dateObj.getFullYear() + 1), "April-" + (dateObj.getFullYear() + 1), "May-" + (dateObj.getFullYear() + 1), "June-" + (dateObj.getFullYear() + 1),
	        "July-" + (dateObj.getFullYear() + 1), "August-" + (dateObj.getFullYear() + 1), "September-" + (dateObj.getFullYear() + 1), "October-" + (dateObj.getFullYear() + 1), "November-" + (dateObj.getFullYear() + 1), "December-" + (dateObj.getFullYear() + 1)
        ];
        $scope.monthNames = ["January", "February", "March", "April", "May", "June",
            "July", "August", "September", "October", "November", "December"
        ];
        $scope.holidayList = {};
        $scope.getHolidayList = function () {
            holidayService.getAllHoliday().then(function () {
                $scope.countryFilter = holidayService.getRegionList();
                $scope.filteredCountries = holidayService.getRegionList();
                index = $scope.filteredCountries.length;
                updateCountriesHolidays();
            });
        };
        $scope.isEmpty = function () {
            if (Object.keys($scope.holidayList).length) {
                return false;
            }
            return true;
        }
        $scope.updateCountry = function (country) {
            $scope.country = country;
            if ($scope.filteredCountries.indexOf(country) == -1) {
                $scope.filteredCountries[index] = country;
                index++;
            }
            else {
                $scope.filteredCountries.splice($scope.filteredCountries.indexOf(country), 1);
                index--;
            }
            updateCountriesHolidays();
        }
        function updateCountriesHolidays() {
            $scope.holidayList = {};
            var j = 0;
            var multiCountriesHolidayList = holidayService.getHolidayList($scope.filteredCountries);
            if ($scope.filteredCountries.length == 0) {
                $scope.noHolidayMsg = i8nConstants.NO_LOCATION_IS_SELECTED;
            }
            else if (Object.keys(multiCountriesHolidayList).length > 0) {
                $scope.noHolidayMsg = i8nConstants.NO_HOLIDAYS_FOUND;
            }
            for (var j = 0; j < Object.keys(multiCountriesHolidayList).length; j++) {
                var holidayList = multiCountriesHolidayList[Object.keys(multiCountriesHolidayList)[j]];
                for (var i = 0; i < holidayList.length; i++) {
                    var temp = {}
                    //temp.date = holidayList[i].startDate.replace(/-/g, ' ');
                    var holidayDate;
                    var startDate = new Date(holidayList[i].startDate);
                    var endDate = new Date(holidayList[i].endDate);
                    if ((startDate.getDate() != endDate.getDate()) || (startDate.getMonth() != endDate.getMonth()) || (startDate.getFullYear() != endDate.getFullYear())) {
                        var daysDiff = Utils.calculateDays(startDate.toDateString(), endDate.toDateString());
                        holidayDate = new Date(holidayList[i].startDate);
                        for (var k = 0; k < daysDiff; k++) {
                        	var date = new Date(holidayDate);
                            if (!$scope.holidayList[$scope.monthNames[date.getMonth()] + "-" + date.getFullYear()]) {
                                $scope.holidayList[$scope.monthNames[date.getMonth()] + "-" + date.getFullYear()] = [];
                            }
                            //tempArr[$scope.monthNames[new Date(temp.date).getMonth()]].push(temp);
                            if (holidayList[i].nIsOptional == true) {
                                $scope.holidayList[$scope.monthNames[date.getMonth()] + "-" + date.getFullYear()].push({
                                    'month': $scope.monthNames[date.getMonth()],
                                    'date': date,
                                    'name': holidayList[i].sName,
                                    'country': holidayList[i].sCountry,
                                    'region': holidayList[i].sRegion,
                                    'color': "#344c67"
                                });
                            } else {
                                $scope.holidayList[$scope.monthNames[date.getMonth()] + "-" + date.getFullYear()].push({
                                    'month': $scope.monthNames[date.getMonth()],
                                    'date': date,
                                    'name': holidayList[i].sName,
                                    'country': holidayList[i].sCountry,
                                    'region': holidayList[i].sRegion,
                                    'color': "white"
                                });
                            }
                            holidayDate.setDate(holidayDate.getDate() + 1);
                        }
                    }
                    else {
                        //single month holidays
                        holidayDate = new Date(holidayList[i].startDate);
                        var date = new Date(holidayDate); 
                        if (!$scope.holidayList[$scope.monthNames[date.getMonth()] + "-" + date.getFullYear()]) {
                            $scope.holidayList[$scope.monthNames[date.getMonth()] + "-" + date.getFullYear()] = [];
                        }
                        //tempArr[$scope.monthNames[new Date(temp.date).getMonth()]].push(temp);
                        if (holidayList[i].nIsOptional == true) {
                            $scope.holidayList[$scope.monthNames[date.getMonth()] + "-" + date.getFullYear()].push({
                                'month': $scope.monthNames[date.getMonth()],
                                'date': date,
                                'name': holidayList[i].sName,
                                'country': holidayList[i].sCountry,
                                'region': holidayList[i].sRegion,
                                'color': '#344c67'
                            });
                        } else {
                            $scope.holidayList[$scope.monthNames[date.getMonth()] + "-" + date.getFullYear()].push({
                                'month': $scope.monthNames[date.getMonth()],
                                'date': date,
                                'name': holidayList[i].sName,
                                'country': holidayList[i].sCountry,
                                'region': holidayList[i].sRegion,
                                'color': 'white'
                            });
                        }
                    }
                }
            }
            for (var key in $scope.holidayList) {
                $scope.holidayList[key] = Utils.sortArrayBasedOnDates($scope.holidayList[key]);
            }
        }
    }]);
})();

'use strict';
/**
 * @ngdoc function
 * @name timeOffCommvaultApp.controller:AboutCtrl
 * @description
 * # timeoffInfoCtrl
 * Controller for time off info page
 */

(function () {
    app.controller('timeoffInfoCtrl', ["$scope", "timeoffInfoService", "employeeServices", "Utils", "i8nConstants", "$location", "$rootScope", function ($scope, timeoffInfoService, employeeServices, Utils, i8nConstants, $location, $rootScope) {

        // hide dropdown if clicked outside dropdown
        $(document).mouseup(function (e) {
            var container = $(".dropdown");
            if (!container.is(e.target) // if the target of the click isn't the container...
                && container.has(e.target).length === 0) // ... nor a descendant of the container
            {
                $(".dropdown").find(".show").each(function () {
                    $(this).toggleClass("show");
                });
            }
        });
        $(document).on("click", ".edit-leave", function () {
            var leaveid = $(this).data("leaveid");
            var startdate = $(this).data("startdate");
            var enddate = $(this).data("enddate");
            var requestor = $(this).data("requestor");
            $rootScope.$apply(function () {
                $location.path("/editleave/" + leaveid + "/" + requestor + "/" + startdate.replace(/\//g, "-") + "/" + enddate.replace(/\//g, "-"));
            });
        });
        // hide and show dropdown when clicked on button
        $('.dropdown-toggle').off().on("click", function () {
            var self = this;
            $(".dropdown").find(".show").each(function () {

                if($(this).prev().attr("id") != $(self).attr("id")){

                    $(this).toggleClass("show");
                }

            });
            $(this).dropdown();
            $(this).parent().find(".dropdown-menu").toggleClass("show");
        });
        $scope.timeoffHistory = '';
        $scope.timeoffInfo = '';
        $scope.typeFilter = '';
        $scope.typeFilterContents = '';
        $scope.statusFilterContents = '';
        $scope.leaveDetails = '';
        $scope.noDataMsg = i8nConstants.LOADING
        $scope.changeValue = function () {
            //$scope.statusFilter.sRequestStatus = $(this).val();
        };
        $scope.statusFilter = {};
        $scope.statusFilter.sRequestStatus = "";
        $scope.statusFilter.sRequestType = "";
        $(document).on("click", '.dropdown-menu.status-filter li', function (event) {
            var selctedVal = $(this).data("source");
            $("#status").val(selctedVal);
            $('.statusVal').html(selctedVal);
            if (selctedVal == "")
                $('.statusVal').html("All");
            var tempObj = {
                sRequestStatus: selctedVal,
                sRequestType: $scope.statusFilter.sRequestType
            }
            setTimeout(function () {
                $scope.$apply(function () {
                        $scope.statusFilter = tempObj;
                    }
                )
            }, 500);
            $(event.target).parent().parent().parent().parent().find(".dropdown-toggle").last().trigger("click");
        });
        $(document).on("click", '.dropdown-menu.type li', function (event) {
            var selctedVal = $(this).data("source");
            $("#type").val(selctedVal);
            $('.typeVal').html(selctedVal);
            if (selctedVal == "")
                $('.typeVal').html("All");
            var tempObj = {
                sRequestStatus: $scope.statusFilter.sRequestStatus,
                sRequestType: selctedVal
            }
            setTimeout(function () {
                $scope.$apply(function () {
                        $scope.statusFilter = tempObj;
                    }
                )
            }, 500);
            $(event.target).parent().parent().parent().parent().find(".dropdown-toggle").first().trigger("click");
        });
        //$(".customScroll").mCustomScrollbar();
        $(document).ready(function () {
            $(document).on('click', '.more', function (event) {
                //$(this).next().show();
                $(this).next().toggleClass("time-off-details");
            });
        });
        updateTimeOffInfo();
        function updateTimeOffInfo() {
            timeoffInfoService.timeOffInfoDetails().then(function () {
                // $scope.timeoffHistory = timeoffInfoService.getTimeoffDataList();
                $scope.timeoffHistory = timeoffInfoService.processTimeOffHistory();
                if (!$scope.timeoffHistory || $scope.timeoffHistory.length == 0)
                    $scope.noDataMsg = "Sorry no time off history";
                $scope.timeoffInfo = timeoffInfoService.processTimeOffInfo();
                timeoffInfoService.populateFilters();
                $scope.typeFilterContents = employeeServices.getLeaveTypes();

                $scope.statusFilterContents = timeoffInfoService.getStatusFilterContents();

            });
        }

        $scope.displayTimeOffDetails = function (leaveInfo) {
            $scope.leaveDetails = leaveInfo;
            $scope.leaveDetails.managerName = employeeServices.getManagerName();
            $scope.leaveDetails.deptName = employeeServices.getDepartmentName();
            $('#timeoff_info_details').modal('show');
        }
        $scope.convertDateToString = function (dateStr) {
            if (dateStr != '' && dateStr != undefined)
                return Utils.convertDateString(dateStr);
            else
                return '';
        }
        var selectedLeaveInfo;
        $scope.displayCancelConfirmation = function (leaveInfo) {
            $('#timeoff_info_cancel').modal('show');
            selectedLeaveInfo = leaveInfo;
        }
        $scope.cancelLeave = function () {
            var reason = $('#cancelLeaveReason').val();
            var cancelLeaveParameter = {
                "nID": selectedLeaveInfo.nID,
                "nRequestTypeID": selectedLeaveInfo.nRequestTypeID,
                "sComments": reason,
                "sSubmittedBy": selectedLeaveInfo.sSubmittedBy,
                "requestors": [selectedLeaveInfo.sSubmittedBy]
            };

            employeeServices.cancelLeave(cancelLeaveParameter).then(function () {
                    $scope.timeoffHistory = updateTimeOffInfo();
                    $scope.closeLeaveConfirmation();
                     $(".alert-success").fadeIn().fadeOut(5000);
                    $('html, body').animate({scrollTop: 0}, 800);
                }
                , function () {
                    $(".alert-danger").fadeIn().fadeOut(5000);
                    $('html, body').animate({scrollTop: 0}, 800);
                    $scope.closeLeaveConfirmation();
                });
        }
        $scope.closeLeaveConfirmation = function () {
            $('#timeoff_info_cancel').modal('hide');
            $('#cancelLeaveReason').val('');
        }
    }]);
})();
/**
 * Factory responsible for operations related to time off info page
 */
(function () {
    angular.module('timeOffCommvaultApp.timeoffinfoService', ['restangular'])
        .factory('timeoffInfoService', ["Restangular", "Utils", "$q", "$timeout", "$http", "employeeServices", "configService", "TIMEOFF_CONSTANTS", function (Restangular, Utils, $q, $timeout, $http, employeeServices, configService, TIMEOFF_CONSTANTS) {
            var timeoffDataList = {};
            var statusFilterContent = [];
            var typeFilterContent = [];
            var URL = (employeeServices.getEnvironment() == 'dev') ? configService.returnDevUrl() : configService.returnProdUrl();

            function getTimeoffDataList() {
                return timeoffDataList;
            }

            function processTimeOffHistory() {
                return timeoffDataList.timeOffs;
            }

            function processTimeOffInfo() {
                return timeoffDataList.HistoryDetails;
            }

            function getStatusFilterContents() {
                return statusFilterContent;
            }

            function getTypeFilterContents() {
                return typeFilterContent;
            }

            function populateFilters() {
                var j = 0, k = 0;
                statusFilterContent = [];
                typeFilterContent = [];
                if (timeoffDataList.timeOffs) {
                    for (var i = 0; i < timeoffDataList.timeOffs.length; i++) {
                        if (statusFilterContent.indexOf(timeoffDataList.timeOffs[i].sRequestStatus) == -1) {
                            statusFilterContent[j] = timeoffDataList.timeOffs[i].sRequestStatus;
                            j++;
                        }
                        if (typeFilterContent.indexOf(timeoffDataList.timeOffs[i].sRequestType) == -1) {
                            typeFilterContent[k] = timeoffDataList.timeOffs[i].sRequestType;
                            k++;
                        }
                    }
                }
            }

            function timeOffInfoDetails() {
                var data = {
                    "alias": employeeServices.getProdcertName(),//employeeServices.getProdcertName() abhinawkumar
                    "startdate": Utils.respDateFormat("01/01/" + new Date().getFullYear(), true),
                    "enddate": Utils.respDateFormat("12/31/" + TIMEOFF_CONSTANTS.CALENDER_END_YEAR, true),
                    "year": new Date().getFullYear()
                };
                var deferred = $q.defer();
                if (employeeServices.getEnvironment() == "dev") {
                    Restangular.all(URL.timeOffinfo).getList().then(function (resp) {
                        if (resp[0].data[0].timeOffs == null) {
                            resp[0].data[0].timeOffs = [];
                        }
                        if (Utils.isValidResponse(resp[0])) {
                            timeoffDataList = [];
                            if (resp[0]) {
                                timeoffDataList = resp[0].data[0];
                            }
                            deferred.resolve(timeoffDataList);
                        }
                        else {
                            deferred.reject(resp);
                        }
                    }, function (resp) {
                        deferred.reject(resp);
                    });
                } else {
                    var timeoffInfoObj = Restangular.all(URL.timeOffinfo);
                    timeoffInfoObj.post(data, "get", {csrf: Utils.getCsrfToken()}).then(function (response) {
                        if (response[0].data[0].timeOffs == null) {
                            response[0].data[0].timeOffs = [];
                        }
                        if (Utils.isValidResponse(response[0])) {
                            timeoffDataList = response[0].data[0];
                            deferred.resolve(timeoffDataList);
                        }
                        else {
                            deferred.reject(response);
                        }
                    }, function (error) {
                        deferred.reject(response);
                    });
                }
                return deferred.promise;
            }

            function updateInfoData(leaveId) {
                var historyData = timeoffDataList.timeOffs;
                for (var i = 0; i < historyData.length; i++) {
                    if (leaveId == historyData[i].nID) {
                        historyData[i]
                    }
                }
                ;
            }

            return {
                'timeOffInfoDetails': timeOffInfoDetails,
                'getTimeoffDataList': getTimeoffDataList,
                'processTimeOffHistory': processTimeOffHistory,
                'processTimeOffInfo': processTimeOffInfo,
                'populateFilters': populateFilters,
                'getTypeFilterContents': getTypeFilterContents,
                'getStatusFilterContents': getStatusFilterContents,
                'updateInfoData': updateInfoData
            }
        }]);
})();
/**
 * Factory responsible for global place for API urls
 */
(function () {
    'use strict';
    angular.module('timeOffCommvaultApp.urlsServices', ['restangular'])
        .factory('configService', function () {
            var DEV_URL = {
                "teamMembersTimeoff": "json/editLeave.json",
                "editTimeOffUrl": "timeoff/timeOffDetail.do",
                "mainPage": "json/employeeResponse.json",
                "updateTimeOff": "",
                "applyTimeOff": "",
                "getTimeoffs": "json/timeoffs.json",
                "holidayList": "data/countriesHoliday.json",
                "timeOffinfo": "data/employeeLeaveDetails.json",
                "deleteTimeoff": "",
                "getListOfTimeOffs": "data/timeoffList.json",
                "getTimeOff": "data/timeoffList.json",
                "getDepartment": "json/department.json",
                "getTeam": "json/team.json",
                "getTimezone": "json/timezone.json",
                "getEvent": "json/events.json",
                "getTitle": "json/title.json",
                "getLocation": "json/location.json",
                "deleteTitle": "timeOff/deleteTitle.do",
                "updateEntitlementPolicy": "json/addEntitlementPolicyResponse.json",
                "addEntitlementPolicy": "json/addEntitlementPolicyResponse.json",
                "addNotificationPolicy": "json/addEntitlementPolicyResponse.json",
                "deleteEntitlementPolicy": "json/addEntitlementPolicyResponse.json",
                "deleteNotificationPolicy": "json/asfasfsdf.json",
                "updateNotificationPolicy": "timeOff/updateLeaveApprovalPolicy.do",
                "getEntitlementList": "data/leaveEntitlementPolicy.json",
                "getEntitlementPolicy": "data/leaveEntitlementPolicy.json",
                "getApprovalList": "data/leaveApprovalPolicy.json",
                "getNotificationPolicy": "data/leaveApprovalPolicy.json",
                "addNewTimeOffType": "timeOff/applyTimeOff.do",//change url
                "editTimeOffType": "timeOff/updateTimeOff.do",//change url
                "getEmployees": "json/individualEmployee.json",
                "deleteTimeOffType": "timeOff/deleteTimeOffType.do",
                "getManager": "json/manager.json",
                "getManagerDetails": "data/listManagersAndDept.json",
                "getAssignProxy": "timeOff/newProxy.do",
                "addAssignProxy": "data/assignedProxies.json",
                "updateAssignProxy": "timeOff/updateProxy.do",
                "deleteAssignProxy": "timeOff/deleteProxy.do",
                "updateEvent": "timeOff/updateEvent.do",
                "addEvent": "timeOff/addEvent.do",
                "deleteEvent": "timeOff/deleteEvent.do",
                "getEmployeeId": "timeOff/deleteEvent.do",
                "getEmployeeById": "json/individualEmployee.json",
                "updateEmployee": "timeOff/updateEmployee.do", // change url
                "addEmployee": "timeOff/addEmployee.do", // change url
                "deleteEmployee": "timeOff/deleteEmployee.do", // change url
                "addDepartment": "timeOff/addDepartment.do",
                "updateDepartment": "timeOff/updateDepartment.do",
                "deleteDepartment": "timeOff/deleteDepartment.do",
                "addTeam": "timeOff/addTeam.do",
                "updateTeam": "timeOff/updateTeam.do",
                "deleteTeam": "timeOff/deleteTeam.do",
                "addTitle": "timeOff/addTitle.do",
                "updateTitle": "timeOff/updateTitle.do",
                "addHoliday": "timeOff/addHoliday.do",
                "updateHoliday": "timeOff/updateHoliday.do",
                "deleteHoliday": "timeOff/deleteHoliday.do",
                "addLocation": "timeOff/addLocation.do",
                "updateLocation": "timeOff/updateLocation.do",
                "deleteLocation": "timeOff/deleteLocation.do",
                "setRank": "timeOff/updateRank.do",
                "getEmployeeByToken": "json/employee.json",
                "getManagerProxy": "data/assignedProxies.json",
                "addManagerProxy": "data/assignedProxies.json",
                "updateManagerProxy": "timeOff/updateProxy.do",
                "deleteManagerProxy": "timeOff/deleteProxy.do",
                "pendingTimeOff": "data/pendingTimeOff.json",
                "approvedTimeOff": "data/approvedList.json",
                "rejectedTimeOff": "",
                "sendEmail": "timeOff/sendEmail.do",//need to change thios
                "approveTimeOff": "timeOff/approve.do",//need to change thios
                "rejectTimeOff": "timeOff/reject.do",//need to change thios
                "managerReports": "data/report.json"//need to change thios
            }
            var PROD_URL = {
                "teamMembersTimeoff": "timeoff/getTeamMembersTimeOffDetails.do",
                "editTimeOffUrl": "timeoff/timeOffDetail.do",
                "getEmployees": "timeOff/employeeDetailsPagination.do",
                "getNotificationPolicy": "timeOff/getLeaveApprovalPolicies.do",
                "getEntitlementPolicy": "timeOff/getLeaveEntitlementPolicies.do",
                "addNotificationPolicy": "timeOff/newLeaveApprovalPolicy.do",
                "deleteNotificationPolicy": "timeOff/deleteLeaveApprovalPolicy.do",
                "getTimeOff": "timeOff/getListOfTimeOffs.do",
                "mainPage": "timeoff/mainPageDetails.do",
                "getTimezone": "timeoff/ListOfTimezones.do",
                "deleteTitle": "timeOff/deleteTitle.do",
                "getManager": "timeOff/getListOfManagers.do",
                "getTeam": "timeOff/ListOfTeams.do",
                "getTitle": "timeOff/ListOfTitles.do",
                "getLocation": "timeOff/ListOfLocations.do",
                "getEvent": "timeOff/ListOfEvents.do",
                "updateTimeOff": "timeOff/updateTimeOff.do",
                "applyTimeOff": "timeOff/applyTimeOff.do",
                "deleteTimeoff": "timeOff/deleteTimeOff.do",
                "getDepartment": "timeOff/ListOfDepartments.do",
                "timeOffinfo": "timeOff/getTimeOffHistoryDetails.do",
                "getListOfTimeOffs": "timeOff/getListOfTimeOffs.do",
                "updateEntitlementPolicy": "timeOff/updateLeaveEntitlementPolicy.do",
                "updateNotificationPolicy": "timeOff/updateLeaveApprovalPolicy.do",
                "addEntitlementPolicy": "timeOff/newLeaveEntitlementPolicy.do",
                "deleteEntitlementPolicy": "timeOff/deleteLeaveEntitlementPolicy.do",
                "getEntitlementList": "timeOff/getLeaveEntitlementPolicies.do",
                "getApprovalList": "timeOff/getLeaveApprovalPolicies.do",
                "addNewTimeOffType": "timeOff/newTimeOffType.do", //change url
                "editTimeOffType": "timeOff/updateTimeOffType.do",//change url
                "deleteTimeOffType": "timeOff/deleteTimeOffType.do",
                "getManagerDetails": "timeOff/getListOfManagers.do",
                "getAssignProxy": "timeOff/getListOfAssignedProxy.do",
                "holidayList": "timeOff/getAllHolidays.do",
                "addAssignProxy": "timeOff/newProxy.do",
                "updateAssignProxy": "timeOff/updateProxy.do",
                "deleteAssignProxy": "timeOff/deleteProxy.do",
                "updateEmployee": "timeOff/updateEmployee.do", // change url
                "addEmployee": "timeOff/addEmployee.do", // change url
                "deleteEmployee": "timeOff/deleteEmployee.do", // change url
                "updateEvent": "timeOff/updateEvent.do",
                "addEvent": "timeOff/addEvent.do",
                "deleteEvent": "timeOff/deleteEvent.do",
                "addDepartment": "timeOff/addDepartment.do",
                "updateDepartment": "timeOff/updateDepartment.do",
                "deleteDepartment": "timeOff/deleteDepartment.do",
                "addTeam": "timeOff/addTeam.do",
                "updateTeam": "timeOff/updateTeam.do",
                "deleteTeam": "timeOff/deleteTeam.do",
                "addTitle": "timeOff/addTitle.do",
                "updateTitle": "timeOff/updateTitle.do",
                "addHoliday": "timeOff/addHoliday.do",
                "updateHoliday": "timeOff/updateHoliday.do",
                "deleteHoliday": "timeOff/deleteHoliday.do",
                "getEmployeeId": "timeOff/deleteEvent.do",
                "getEmployeeById": "timeOff/getEmployeeByToken.do",
                "getEmployeeByToken": "timeOff/getEmployeeByToken.do",
                "addLocation": "timeOff/addLocation.do",
                "updateLocation": "timeOff/updateLocation.do",
                "deleteLocation": "timeOff/deleteLocation.do",
                "setRank": "timeOff/updateRank.do",
                "getManagerProxy": "timeOff/getListOfAssignedProxy.do", // change this url
                "addManagerProxy": "timeOff/newProxy.do",
                "updateManagerProxy": "timeOff/updateProxy.do",
                "deleteManagerProxy": "timeOff/deleteProxy.do",
                "pendingTimeOff": "timeOff/listOfApprovals.do",
                "approvedTimeOff": "timeOff/listOfApprovals.do",
                "rejectedTimeOff": "timeOff/listOfApprovals.do",
                "sendEmail": "timeOff/sendEmail.do",//need to change thios
                "approveTimeOff": "timeOff/approveTimeOffs.do",//need to change thios
                "rejectTimeOff": "timeOff/denyTimeOffs.do",//need to change thios
                "managerReports": "timeOff/managerReports.do"//need to change thios
            };
            var halfDayParameters = {
                firstHalfStartTime: " 09:30:00",
                firstHalfEndTime: " 13:30:00",
                secondHalfStartTime: " 14:00:00",
                secondHalfEndTime: " 18:30:00"
            }
            function returnDevUrl() {
                return DEV_URL;
            }

            function returnProdUrl() {
                return PROD_URL;
            }

            return {
                'returnDevUrl': returnDevUrl,
                'returnProdUrl': returnProdUrl,
                'halfDayParameters': halfDayParameters
            }
        });
})();

/**
 * Factory responsible for validation of all forms present in all modules
 */
(function () {
    'use strict';
    angular.module('timeOffCommvaultApp.validateObjectServices', ['restangular'])
        .factory('validateObjectService', ["parameterService", "adminServices", "configService", "$route", "$rootScope", "assignProxyServices", "Utils", "$location", "i8nConstants", function (parameterService, adminServices, configService, $route, $rootScope, assignProxyServices, Utils, $location, i8nConstants) {
            var moduleList = [];

            function getValidateObj(moduleName) {
                var formFieldsObj = {};
                if (moduleName == "EntitlementPolicy") {
                    formFieldsObj =
                    {
                        ignore: ':hidden, [readonly=readonly]',
                        rules: {
                            sPolicyName: {
                                required: true
                            },
                            nMaxAllowed: {
                                required: true,
                                number: true
                            },
                            nDuration: {
                                required: true,
                                number: true
                            },
                            nMaxContAllowed: {
                                required: true,
                                number: true
                            },
                            nMaxCountAllowed: {
                                required: true,
                                number: true
                            },
                            nAccruedPerMonth: {
                                required: true,
                                number: true
                            },
                            startdate: {
                                required: true
                            },
                            nCarryFwdAllowed: {
                                required: true
                            }
                        },
                        messages: {
                            sPolicyName: {
                                required: i8nConstants.ENTER_VALID_POLICY_NAME
                            },
                            nMaxAllowed: {
                                required: i8nConstants.ENTER_VALID_MAXIMUM_DAYS,
                                number: i8nConstants.ENTER_VALID_MAXIMUM_DAYS
                            },
                            nDuration: {
                                required: i8nConstants.ENTER_VALID_MONTHS,
                                number: i8nConstants.ENTER_VALID_MONTHS
                            },
                            nMaxContAllowed: {
                                required: i8nConstants.ENTER_VALID_DATA,
                                number: i8nConstants.ENTER_VALID_DATA
                            },
                            nMaxCountAllowed: {
                                required: i8nConstants.ENTER_VALID_DATA,
                                number: i8nConstants.ENTER_VALID_DATA
                            },
                            nAccruedPerMonth: {
                                required: i8nConstants.ENTER_VALID_DATA,
                                number: i8nConstants.ENTER_VALID_DATA
                            },
                            startdate: {
                                required: i8nConstants.SELECT_VALID_DATE
                            },
                            nCarryFwdAllowed: {
                                required: i8nConstants.ENTER_VALID_DATA,
                                number: i8nConstants.ENTER_VALID_DATA
                            }
                        },
                        validateOnInit: false
                    };
                }
                if (moduleName == "AssignProxy" || moduleName == "ManagerProxy") {
                    formFieldsObj =
                    {
                        rules: {
                            sUser: {
                                required: true
                            },
                            sProxy: {
                                required: true
                            },
                            dValidFrom: {
                                required: true
                            },
                            dExpiryDate: {
                                required: true
                            }
                        },
                        messages: {
                            sUser: {
                                required: i8nConstants.ENTER_CURRENT_MANAGER_NAME
                            },
                            sProxy: {
                                required: i8nConstants.ENTER_TEMPORARY_MANAGER_NAME
                            },
                            dValidFrom: {
                                required: i8nConstants.ENTER_START_DATE
                            },
                            dExpiryDate: {
                                required: i8nConstants.ENTER_END_DATE
                            }
                        }
                    }
                }
                if (moduleName == "NotificationPolicy") {
                    formFieldsObj =
                    {
                        ignore: ':hidden, [readonly=readonly]',
                        rules: {
                            notification_policy_name: {
                                required: true
                            },
                            first_text_0: {
                                required: true
                            },
                            second_text_0: {
                                required: true
                            },
                            total_first_text_0: {
                                required: true
                            },
                            total_second_text_0: {
                                required: true
                            }
                        },
                        messages: {
                            notification_policy_name: {
                                required: i8nConstants.ENTER_VALID_POLICY_NAME
                            },
                            first_text_0: {
                                required: i8nConstants.INVALID_DATA
                            },
                            second_text_0: {
                                required: i8nConstants.INVALID_DATA
                            },
                            total_first_text_0: {
                                required: i8nConstants.INVALID_DATA
                            },
                            total_second_text_0: {
                                required: i8nConstants.INVALID_DATA
                            }
                        },
                        validateOnInit: false
                    };
                }
                if (moduleName == "TimeOffEmployee") {
                    formFieldsObj =
                    {
                        ignore: '',
                        rules: {
                            nTimeOffID: {
                                required: true
                            },
                            nEntitlementID: {
                                required: true
                            },
                            nNotificationID: {
                                required: true
                            }
                        },
                        messages: {
                            nTimeOffID: {
                                required: i8nConstants.SELECT_VALID_TIME_OFF
                            },
                            nEntitlementID: {
                                required: i8nConstants.SELECT_VALID_POLICY
                            },
                            nNotificationID: {
                                required: i8nConstants.SELECT_VALID_POLICY
                            }
                        },
                        validateOnInit: false
                    };
                }
                if (moduleName == "Holiday") {
                    formFieldsObj =
                    {
                        ignore: '',
                        rules: {
                            startDate: {
                                required: true
                            },
                            endDate: {
                                required: true
                            },
                            sCountry: {
                                required: true
                            },
                            sName: {
                                required: true
                            },
                            sRegion: {
                                required: true
                            }
                        },
                        messages: {
                            startDate: {
                                required: i8nConstants.INVALID_START_DATE
                            },
                            endDate: {
                                required: i8nConstants.INVALID_END_DATE
                            },
                            sCountry: {
                                required: i8nConstants.INVALID_COUNTRY
                            },
                            sName: {
                                required: i8nConstants.INVALID_HOLIDAY_NAME
                            },
                            sRegion: {
                                required: i8nConstants.INVALID_REGION
                            }
                        },
                        validateOnInit: false
                    };
                }
                if (moduleName == "Title") {
                    formFieldsObj =
                    {
                        ignore: '',
                        rules: {
                            sTitleName: {
                                required: true
                            }
                        },
                        messages: {
                            sTitleName: {
                                required: i8nConstants.INVALID_TITLE
                            }
                        },
                        validateOnInit: false
                    };
                }
                if (moduleName == "Department") {
                    formFieldsObj =
                    {
                        ignore: '',
                        rules: {
                            sDeptName: {
                                required: true
                            }
                        },
                        messages: {
                            sDeptName: {
                                required: i8nConstants.INVALID_DEPARTMENT_NAME
                            }
                        },
                        validateOnInit: false
                    };
                }
                if (moduleName == "Team") {
                    formFieldsObj =
                    {
                        ignore: '',
                        rules: {
                            sTeamName: {
                                required: true
                            }
                        },
                        messages: {
                            sTeamName: {
                                required: i8nConstants.INVALID_TEAM_NAME
                            }
                        },
                        validateOnInit: false
                    };
                }
                if (moduleName == "Event") {
                    formFieldsObj =
                    {
                        ignore: '',
                        rules: {
                            startdate: {
                                required: true
                            },
                            enddate: {
                                required: true
                            },
                            sEventName: {
                                required: true
                            },
                            sVenue: {
                                required: true
                            },
                            sRegion: {
                                required: true
                            },
                            sDetails: {
                                required: true
                            }
                        },
                        messages: {
                            startdate: {
                                required: i8nConstants.INVALID_START_DATE
                            },
                            enddate: {
                                required: i8nConstants.INVALID_END_DATE
                            },
                            sEventName: {
                                required: i8nConstants.ENTER_EVENT_NAME
                            },
                            sVenue: {
                                required: i8nConstants.VENUE_NAME_REQUIRED
                            },
                            sRegion: {
                                required: i8nConstants.INVALID_REGION
                            },
                            sDetails: {
                                required: i8nConstants.DETIALS_ARE_REQUIRED
                            }
                        },
                        validateOnInit: false
                    };
                }
                if (moduleName == "Location") {
                    formFieldsObj =
                    {
                        ignore: '',
                        rules: {
                            sCountryName: {
                                required: true
                            },
                            sRegionName: {
                                required: true
                            },
                            sTimeZone: {
                                required: true
                            }
                        },
                        messages: {
                            sCountryName: {
                                required: i8nConstants.INVALID_COUNTRY_NAME
                            },
                            sRegionName: {
                                required: i8nConstants.INVALID_REGION_NAME
                            },
                            sTimeZone: {
                                required: i8nConstants.INVALID_TIMEZONE_SELECTED
                            }
                        },
                        validateOnInit: false
                    };
                }
                if (moduleName == "Employee") {
                    formFieldsObj =
                    {
                        ignore: '',
                        rules: {
                            sEmpID: {
                                required: true
                            },
                            sEmployeeID:{
                            	required : true
                            },
                            sEmpName: {
                                required: true
                            },
                            nTitleID: {
                                required: true
                            },
                            dDateHired: {
                                required: true
                            },
                            nDeptID: {
                                required: true
                            },
                            nTeamID: {
                                required: true
                            },
                            Manager: {
                                required: true
                            },
                            sMobileNumber: {
                                required: true
                            },
                            sEmail: {
                                required: true,
                                email: true
                            },
                            nLocationID: {
                                required: true
                            }
                        },
                        messages: {
                        	sEmployeeID: {
                                required: i8nConstants.ENTER_HR_EMPLOYEE_ID
                            },
                            sEmpID: {
                                required: i8nConstants.ENTER_EMPLOYEE_ID
                            },
                            sEmpName: {
                                required: i8nConstants.ENTER_EMPLOYEE_NAME
                            },
                            nTitleID: {
                                required: i8nConstants.SELECT_TITLE_NAME
                            },
                            dDateHired: {
                                required: i8nConstants.ENTER_DATE_HIRED
                            },
                            nDeptID: {
                                required: i8nConstants.SELECT_DEPARTMENT_NAME
                            },
                            nTeamID: {
                                required: i8nConstants.SELECT_TEAM_NAME
                            },
                            Manager: {
                                required: i8nConstants.SELECT_MANAGER_NAME
                            },
                            sMobileNumber: {
                                required: i8nConstants.ENTER_CONTACT_NUMBER
                            },
                            sEmail: {
                                required: i8nConstants.ENTER_EMAIL_ADDRESS,
                                email: i8nConstants.ENTER_VALID_EMAIL_ADDRESS
                            },
                            nLocationID: {
                                required: i8nConstants.SELECT_LOCATION
                            }
                            ,
                            selectedTimeOff: {
                                required: ""
                            },
                            selectedEntitlement: {
                                required: ""
                            },
                            selectedApproverNotification: {
                                required: ""
                            }
                        },
                        validateOnInit: false
                    }
                }
                formFieldsObj.submitHandler = function (form) {
                    Utils.clearFormValidations();
                    if (moduleName == "Employee") {
                        if ($('#AssignTimeOff:checked').length > 0) {
                            var timeoffList = [$("#selectedTimeOff").val()];
                            var entitlementList = [$("#selectedEntitlement").val()];
                            var approverList = [$("#selectedApproverNotification").val()];
                        }
                    }
                    if (moduleName == "TimeOffEmployee") {
                        var id = $("#nTimeOffID").val();
                        //$scope.$apply(function () {
                        //    $scope.selectedTimeOffType = $("#selectedTimeOff").val()+$("#nTimeOffID").val()+",";
                        //});
                        $("#selectedTimeOff").val($("#selectedTimeOff").val() + $("#nTimeOffID").val() + ",");
                        $("#dummyTimeOff").clone().appendTo("#timeOffsApplicable");
                        $("#timeOffsApplicable").find("div").last().addClass("real").removeClass("hide");
                        $("#timeOffsApplicable").find("span").last().html('<a href="javascript:void(0)" ng-click="displayTimeOff("' + id + '","' + $(".selTimeOff").html() + '")" >' + $(".selTimeOff").html() + '</a><i class="icon close"></i>');
                        $("#nTimeOffID").val("");
                        $("#nEntitlementID").val("");
                        $("#nNotificationID").val("");
                        $(".selTimeOff").html("Select Time Off");
                        $(".selEntitlement").html("Select Policy");
                        $(".selNotification").html("Select Policy");
                        $(".error").removeClass("error");
                    } else {
                        var moduleArray = ["EntitlementPolicy","NotificationPolicy"];
                        var requestParams = eval("parameterService.get" + moduleName + '("' + (($("#editFlag").val() == "0") ? "" : ((($("#duplicateAddFlag").length > 0) && (moduleArray.indexOf(moduleName) != -1 ))? "": $("#editFlag").val())) + '")');
                        var editFlag = ($("#editFlag").val() == "0")?"0":((($("#duplicateAddFlag").length > 0) && (moduleArray.indexOf(moduleName) != -1 ))? "0": $("#editFlag").val());
                        $(".alert-msg").hide();
                        if (moduleName == "Event") {
                            if (requestParams.sVenue == "Others") {
                                requestParams.sVenue = $("#sVenueOthers").val();
                            }
                        }
                        adminServices.cudAPI(requestParams, (($("#editFlag").val() == "0") ? eval("adminServices.getUrlObj().add" + moduleName) : ((($("#duplicateAddFlag").length > 0) && (moduleArray.indexOf(moduleName) != -1 )) ? eval("adminServices.getUrlObj().add" + moduleName) : eval("adminServices.getUrlObj().update" + moduleName)))).then(function (resp) {
                            if (moduleName == "AssignProxy" && editFlag == "0") {
                                $('.new-proxy').show();
                                $('.new-proxy').fadeOut(5000);
                                $('html, body').animate({scrollTop: 0}, 800);
                            }
                            else if (moduleName == "AssignProxy" && editFlag != "0") {
                                $('.edited-proxy').show();
                                $('.edited-proxy').fadeOut(5000);
                                $('html, body').animate({scrollTop: 0}, 800);
                            } else if (moduleName == "ManagerProxy" && editFlag == "0") {
                                $('.new-proxy').show();
                                $('.new-proxy').fadeOut(5000);
                                $('html, body').animate({scrollTop: 0}, 800);
                            }
                            else if (moduleName == "ManagerProxy" && editFlag != "0") {
                                $('.edited-proxy').show();
                                $('.edited-proxy').fadeOut(5000);
                                $('html, body').animate({scrollTop: 0}, 800);
                            }
                            else if (moduleName == "EntitlementPolicy") {
                                $("#addPolicyModal").modal("hide");

                                if (editFlag != "0") {
                                    $(".entitlement-edit-success-msg").fadeIn().fadeOut(3000);
                                } else {
                                    $("#duplicateAddFlag").val("-1");
                                    $("#nEntitlementID").val(resp[0].data);
                                    $("#leave_policy").val(resp[0].data);
                                    $(".selected_entitlement-policy").html(requestParams.sPolicyName);
                                    $(".selEntitlement").html(requestParams.sPolicyName);
                                    $(".entitlement-success-msg").fadeIn().fadeOut(3000);
                                }
                                $('html, body').animate({scrollTop: 0}, 800);
                            } else if (moduleName == "NotificationPolicy") {
                                $("#notificationPolicyModal").modal("hide");
                                if (editFlag != "0") {
                                    $(".notification-edit-success-msg").fadeIn().fadeOut(3000);
                                } else {
                                    $("#duplicateAddFlag").val("-1");
                                    $("#nNotificationID").val(resp[0].data);
                                    $(".selNotification").html(requestParams.sPolicyName);
                                    $(".selected_approval-policy").html(requestParams.sPolicyName);
                                    $("#approval_policy").val(resp[0].data);
                                    $(".notification-success-msg").fadeIn().fadeOut(3000);
                                }
                                $('html, body').animate({scrollTop: 0}, 800);
                            } else {
                                if (editFlag == "0") {
                                    $(".success-msg").fadeIn().fadeOut(3000);
                                } else {
                                    $(".edit-success-msg").fadeIn().fadeOut(3000);
                                }
                                $('html, body').animate({scrollTop: 0}, 800);
                            }
                            if (moduleName != "Employee") {
                                if (moduleName == 'ManagerProxy') {
                                    assignProxyServices.getAllManagersProxies().then(function (response) {
                                        adminServices.clearFields(moduleName);
                                        moduleList = response;
                                        $rootScope.$broadcast('user:updated', response);
                                    });
                                } else {
                                    adminServices.getListingObjArray(moduleName).then(function (response) {
                                        adminServices.clearFields(moduleName);
                                        moduleList = response;
                                        $rootScope.$broadcast('user:updated', response);
                                    });
                                }
                            } else {
                                $("#duplicateAddFlag").val("0");
                                if ($("#editFlag").val() == "0") {
                                    $("#Manager").val("");
                                    $("#btn_Manager").val("");
                                    $("#sManager").val("");
                                    $("#btn_sManager").val("");
                                    $("#sEmpID").val("");
                                    $("#dDateHired").val("");
                                    $("#nDeptID").val("");
                                    $("#btn_nDeptID").val("");
                                    $("#nTeamID").val("");
                                    $("#btn_nTeamID").val("");
                                    $("#nTitleID").val("");
                                    $("#btn_nTitleID").val("");
                                    $("#sEmail").val("");
                                    $("#sEmpID").val("");
                                    $("#sEmpName").val("");
                                    $("#sMobileNumber").val("");
                                    $("#sPhoneNumber").val("");
                                    $("#selectedTimeOff").val("");
                                    $("#selectedEntitlement").val("");
                                    $("#selectedApproverNotification").val("");
                                    $("#nLocationID").val("");
                                    $("#btn_nLocationID").val("");
                                    if ($('#AssignTimeOff:checked').length > 0) {
                                        $('#AssignTimeOff:checked').trigger("click");
                                    }
                                    $("#Male").trigger("click");
                                    $("#timeOffsApplicable span:not(:first)").remove();
                                }
                            }
                        }, function (resp) {
                            if (moduleName == "AssignProxy" && editFlag == "0") {
                                if (resp[0].error == null) {
                                    $('.error-danger-msg').show();
                                }
                                $('.error-danger-msg').fadeOut(3000);
                                $('html, body').animate({scrollTop: 0}, 800);
                            }
                            else if (moduleName == "AssignProxy" && editFlag != "0") {
                                if (resp[0].error == null) {
                                    $('.edited-proxy-error-danger-msg').show();
                                }
                                $('.edited-proxy-error-danger-msg').fadeOut(3000);
                                $('html, body').animate({scrollTop: 0}, 800);
                            } else if (moduleName == "EntitlementPolicy") {
                                $("#addPolicyModal").modal("hide");
                                if (resp[0].error == null) {
                                    if (editFlag != "0") {
                                        $(".entitlement-edit-error-danger-msg").fadeIn().fadeOut(3000);
                                    } else {
                                        $(".entitlement-error-danger-msg").fadeIn().fadeOut(3000);
                                    }
                                }
                                $('html, body').animate({scrollTop: 0}, 800);
                            } else if (moduleName == "NotificationPolicy") {
                                $("#notificationPolicyModal").modal("hide");
                                if (resp[0].error == null) {
                                    if (editFlag != "0") {
                                        $(".notification-edit-error-danger-msg").fadeIn().fadeOut(3000);
                                    } else {
                                        $(".notification-error-danger-msg").fadeIn().fadeOut(3000);
                                    }
                                }
                                $('html, body').animate({scrollTop: 0}, 800);
                            } else {
                                if (resp[0].error == null) {
                                    if (editFlag == "0") {
                                        $(".error-danger-msg").fadeIn().fadeOut(3000);
                                    } else {
                                        $(".edit-error-danger-msg").fadeIn().fadeOut(3000);
                                    }
                                }
                                $('html, body').animate({scrollTop: 0}, 800);
                            }
                            // adminServices.clearFields(moduleName);
                        });
                    }
                }
                return formFieldsObj;
            }

            return {
                "getValidateObj": getValidateObj,
                "moduleList": moduleList
            }
        }])
})();
/**
 * Factory responsible for creating JSON request for all modules
 */
(function () {
    'use strict';
    angular.module('timeOffCommvaultApp.parameterServices', ['restangular'])
        .factory('parameterService', ["Utils", "employeeServices", function (Utils, employeeServices) {
            function getEntitlementPolicy(editId) {
                if (editId == "") {
                    return {
                        "RenewedOn": Utils.respDateFormat($("#startdate").val().replace(/-/g, "/"), true),
                        "nAccruedPerMonth": parseInt($("#nAccruedPerMonth").val()),
                        "nCarryFwdAllowed": parseInt($("#nCarryFwdAllowed").val()),
                        "nDuration": parseInt($("#nDuration").val()),
                        "nMaxAllowed": parseInt($("#nMaxAllowed").val()),
                        "nMaxContAllowed": parseInt($("#nMaxContAllowed").val()),
                        "nMaxCountAllowed": parseInt($("#nMaxCountAllowed").val()),
                        "sPolicyName": Utils.escapeHtml($("#sPolicyName").val())
                    }
                } else {
                    return {
                        "RenewedOn": Utils.respDateFormat($("#startdate").val().replace(/-/g, "/"), true),
                        "nAccruedPerMonth": parseInt($("#nAccruedPerMonth").val()),
                        "nCarryFwdAllowed": parseInt($("#nCarryFwdAllowed").val()),
                        "nDuration": parseInt($("#nDuration").val()),
                        "nMaxAllowed": parseInt($("#nMaxAllowed").val()),
                        "nMaxContAllowed": parseInt($("#nMaxContAllowed").val()),
                        "nMaxCountAllowed": parseInt($("#nMaxCountAllowed").val()),
                        "sPolicyName": Utils.escapeHtml($("#sPolicyName").val()),
                        "nID": parseInt(editId)
                    }
                }
            }

            function getTitle(editId) {
                if (editId == "") {
                    return {
                        "sTitleName": Utils.escapeHtml($("#sTitleName").val())
                    }
                } else {
                    return {
                        "sTitleName": Utils.escapeHtml($("#sTitleName").val()),
                        "nRank": $("[data-titleid='" + editId + "']").data("sortorder"),
                        "nTitleID": parseInt(editId)
                    }
                }
            }

            function getTitleParams() {
                return {
                    "sTitleName": ""
                }
            }

            function getDepartment(editId) {
                if (editId == "") {
                    return {
                        "sDeptName": Utils.escapeHtml($("#sDeptName").val()),
                        "nIsActive": true
                    }
                } else {
                    return {
                        "sDeptName": Utils.escapeHtml($("#sDeptName").val()),
                        "nIsActive": true,
                        "nDeptID": parseInt(editId)
                    }
                }
            }

            function getDepartmentParams() {
                return {
                    "sDeptName": ""
                }
            }

            function getTeam(editId) {
                if (editId == "") {
                    return {
                        "sTeamName": Utils.escapeHtml($("#sTeamName").val()),
                        "bIsActive": true
                    }
                } else {
                    return {
                        "sTeamName": Utils.escapeHtml($("#sTeamName").val()),
                        "bIsActive": true,
                        "nTeamID": parseInt(editId)
                    }
                }
            }

            function getTeamParams() {
                return {
                    "sTeamName": ""
                }
            }

            function getHoliday(editId) {
                if (editId == "") {
                    return {
                        "startDate": Utils.respDateFormat($("#startDate").val().replace(/-/g, "/"), true),
                        "endDate": Utils.respDateFormat($("#endDate").val().replace(/-/g, "/"), true),
                        "sRegion": $("#sRegion").val(),
                        "sCountry": $("#sCountry").val(),
                        "sName": Utils.escapeHtml($("#sName").val()),
                        "nIsOptional": ($('#nIsOptional:checked').length > 0) ? true : false,
                        "nLocationID": $("#nLocationID").val()
                    }
                } else {
                    return {
                        "startDate": Utils.respDateFormat($("#startDate").val().replace(/-/g, "/"), true),
                        "endDate": Utils.respDateFormat($("#endDate").val().replace(/-/g, "/"), true),
                        "sRegion": $("#sRegion").val(),
                        "sCountry": $("#sCountry").val(),
                        "sName": Utils.escapeHtml($("#sName").val()),
                        "nIsOptional": ($('#nIsOptional:checked').length > 0) ? true : false,
                        "nLocationID": $("#nLocationID").val(),
                        "nID": parseInt(editId)
                    }
                }
            }

            function getHolidayParams() {
                return {
                    "startDate": ["startDate"],
                    "endDate": ["endDate"],
                    "sRegion": "",
                    "sCountry": "",
                    "sName": "",
                    "nIsOptional": "",
                    "nLocationID": "",
                    "nID": ""
                }
            }

            function getNotificationPolicy(editId) {
                var countArray = [];
                $(".first-text").each(function (index) {
                    countArray.push({
                        "key": parseInt($(this).val()),
                        "value": parseInt($("#second_text_" + index).val())
                    });
                });
                var countTotalArray = [];
                $(".total-first-text").each(function (index) {
                    countTotalArray.push({
                        "key": parseInt($(this).val()),
                        "value": parseInt($("#total_second_text_" + index).val())
                    });
                });
                if (editId == "") {
                    return {
                        "nCntCountEscalationList": countArray,
                        "nDefaultApprover": 0,
                        "nTotalCountEscalationList": countTotalArray,
                        "sPolicyName": Utils.escapeHtml($("#notification_policy_name").val())
                    }
                } else {
                    return {
                        "nCntCountEscalationList": countArray,
                        "nDefaultApprover": 0,
                        "nTotalCountEscalationList": countTotalArray,
                        "sPolicyName": Utils.escapeHtml($("#notification_policy_name").val()),
                        "nID": parseInt(editId)
                    }
                }
            }

            function getEntitlementPolicyParams() {
                return {
                    "RenewedOn": ["startdate"],
                    "nAccruedPerMonth": "",
                    "nCarryFwdAllowed": "",
                    "nDuration": "",
                    "nMaxAllowed": "",
                    "nMaxContAllowed": "",
                    "nMaxCountAllowed": "",
                    "sPolicyName": "",
                    "nID": ""
                }
            }

            function getNotificationPolicyParams() {
                return {
                    "nCntCountEscalationList": {"first_text": "array"},
                    "nCntCounEscApprover": {"second_text": "array"},
                    "nDefaultApprover": "",
                    "nTotalCountEscalationList": {"total_first_text": "array"},
                    "nTotalCountEscApprover": {"total_second_text": "array"},
                    "sPolicyName": {"notification_policy_name": ""},
                    "nID": ""
                }
            }

            function getEvent(editId) {
                if (editId == "") {
                    return {
                        "dEndDate": Utils.respDateFormat($("#enddate").val().replace(/-/g, "/"), true),
                        "dStartDate": Utils.respDateFormat($("#startdate").val().replace(/-/g, "/"), true),
                        "sAlias": $("#sAlias").val(),
                        "sDetails": Utils.escapeHtml($("#sDetails").val()),
                        "sEventName": Utils.escapeHtml($("#sEventName").val()),
                        "sVenue": ($("#sVenue").val() == "OTHER") ? $("#sVenueOthers").val() : $("#sVenue").val(),
                        "nLocationID": $("#nLocationID").val()
                    }
                } else {
                    return {
                        "dEndDate": Utils.respDateFormat($("#enddate").val().replace(/-/g, "/"), true),
                        "dStartDate": Utils.respDateFormat($("#startdate").val().replace(/-/g, "/"), true),
                        "sAlias": $("#sAlias").val(),
                        "sDetails": Utils.escapeHtml($("#sDetails").val()),
                        "sEventName": Utils.escapeHtml($("#sEventName").val()),
                        "sVenue": ($("#sVenue").val() == "OTHER") ? $("#sVenueOthers").val() : $("#sVenue").val(),
                        "nLocationID": $("#nLocationID").val(),
                        "nID": parseInt(editId)
                    }
                }
            }

            function getEventParams() {
                return {
                    "dEndDate": ["enddate"],
                    "dStartDate": ["startdate"],
                    "nID": "",
                    "nLocationID": "",
                    "sAlias": "",
                    "sDetails": "",
                    "sEventName": "",
                    "sVenue": ""
                }
            }

            function getLocation(editId) {
                if (editId == "") {
                    return {
                        "sCountryName": Utils.escapeHtml($("#sCountryName").val().toUpperCase()),
                        "sRegionName": Utils.escapeHtml($("#sRegionName").val().toUpperCase()),
                        "sTimeZone": $("#sTimeZone").val(),
                        "nIsActive": "true"
                    }
                } else {
                    return {
                        "sCountryName": Utils.escapeHtml($("#sCountryName").val().toUpperCase()),
                        "sRegionName": Utils.escapeHtml($("#sRegionName").val().toUpperCase()),
                        "sTimeZone": $("#sTimeZone").val(),
                        "nIsActive": "true",
                        "nLocationID": parseInt(editId)
                    }
                }
            }

            function getLocationParams() {
                return {
                    "sCountryName": "",
                    "sRegionName": "",
                    "nLocationID": "",
                    "sTimeZone": ""
                }
            }

            function getProxyParams() {
                return {
                    "dExpiryDate": ["dExpiryDate"],
                    "dValidFrom": ["dValidFrom"],
                    "sProxy": "",
                    "sUser": "",
                    "nID": ""
                }
            }

            function getAssignProxy(editId) {
                if (editId == "") {
                    return {
                        "dExpiryDate": Utils.respDateFormat($("#dExpiryDate").val().replace(/-/g, "/"), true),
                        "dValidFrom": Utils.respDateFormat($("#dValidFrom").val().replace(/-/g, "/"), true),
                        "sProxy": $("#sProxy").val(),
                        "sUser": $("#sUser").val()
                    }
                }
                else {
                    return {
                        "dExpiryDate": Utils.respDateFormat($("#dExpiryDate").val().replace(/-/g, "/"), true),
                        "dValidFrom": Utils.respDateFormat($("#dValidFrom").val().replace(/-/g, "/"), true),
                        "sProxy": $("#sProxy").val(),
                        "sUser": $("#sUser").val(),
                        "nID": parseInt(editId)
                    }
                }
            }

            function getManagerProxy(editId) {
                if (editId == "") {
                    return {
                        "dExpiryDate": Utils.respDateFormat($("#dExpiryDate").val().replace(/-/g, "/"), true),
                        "dValidFrom": Utils.respDateFormat($("#dValidFrom").val().replace(/-/g, "/"), true),
                        "sProxy": $("#sProxy").val(),
                        "sUser": $("#sUser").val()
                    }
                }
                else {
                    return {
                        "dExpiryDate": Utils.respDateFormat($("#dExpiryDate").val().replace(/-/g, "/"), true),
                        "dValidFrom": Utils.respDateFormat($("#dValidFrom").val().replace(/-/g, "/"), true),
                        "sProxy": $("#sProxy").val(),
                        "sUser": $("#sUser").val(),
                        "nID": parseInt(editId)
                    }
                }
            }

            function getEmployee(editId) {
                var applicableTimeOff = [];
                if ($('#AssignTimeOff:checked').length > 0) {
                    var timeOffArray = $("#selectedTimeOff").val().split(",");
                    var EntitlementArray = $("#selectedEntitlement").val().split(",");
                    var ApproverNotificationArray = $("#selectedApproverNotification").val().split(",");
                    for (var key = 0; key < timeOffArray.length - 1; key++) {
                        var obj = {
                            "nLeaveApprovalPolicyID": ApproverNotificationArray[key],
                            "nLeaveEntitlementPolicyID": EntitlementArray[key],
                            "nRequestType": timeOffArray[key],
                            "sEmpAlias": $("#sEmpID").val()
                        }
                        applicableTimeOff.push(obj);
                    }
                }
                if (editId == "") {
                    var manager = $("#Manager").val();
                    if ($("#sManager").val() != "")
                        manager = $("#Manager").val() + "," + $("#sManager").val();
                    return {
                        "emp": {
                            "Manager": manager,
                            "ProdcertName": Utils.escapeHtml($("#sEmpID").val()),
                            "bIsDeleted": false,
                            "dDateHired": Utils.respDateFormat($("#dDateHired").val().replace(/-/g, "/"), true),
                            "dDateTerminated": "",
                            "gender": $('input[name=gender]:checked').val(),
                            "nDeptID": $("#nDeptID").val(),
                            "nLocationID": $("#nLocationID").val(),
                            "nTeamID": $("#nTeamID").val(),
                            "nTitleID": $("#nTitleID").val(),
                            "sEmail": Utils.escapeHtml($("#sEmail").val()),
                            "sEmpID": $("#sEmployeeID").val(),
                            "sEmpName": Utils.escapeHtml($("#sEmpName").val()),
                            "sMobileNumber": Utils.escapeHtml($("#sMobileNumber").val()),
                            "sPhoneNumber": Utils.escapeHtml($("#sPhoneNumber").val()),
                            "sRole": "Employee"
                        },
                        "emp_map": applicableTimeOff
                    };
                } else {
                    var manager = $("#Manager").val();
                    if ($("#sManager").val() != "")
                        manager = $("#Manager").val() + "," + $("#sManager").val();
                    return {
                        "emp": {
                            "Manager": manager,
                            "ProdcertName": Utils.escapeHtml($("#sEmpID").val()),
                            "bIsDeleted": false,
                            "dDateHired": Utils.respDateFormat($("#dDateHired").val().replace(/-/g, "/"), true),
                            "dDateTerminated": "",
                            "gender": $('input[name=gender]:checked').val(),
                            "nDeptID": $("#nDeptID").val(),
                            "nLocationID": $("#nLocationID").val(),
                            "nTeamID": $("#nTeamID").val(),
                            "nTitleID": $("#nTitleID").val(),
                            "sEmail": Utils.escapeHtml($("#sEmail").val()),
                            "sEmpID": $("#sEmployeeID").val(),
                            "sEmpName": Utils.escapeHtml($("#sEmpName").val()),
                            "sMobileNumber": Utils.escapeHtml($("#sMobileNumber").val()),
                            "sPhoneNumber": Utils.escapeHtml($("#sPhoneNumber").val()),
                            "sRole": "Employee",
                            "nID": parseInt(editId)
                        },
                        "emp_map": applicableTimeOff
                    };
                }
            }

            function getEmployeeParams() {
                return {
                    "Manager": "",
                    "ProdcertName": "",
                    "bIsDeleted": "",
                    "dDateHired": ["dDateHired"],
                    "dDateTerminated": "",
                    "gender": "",
                    "nDeptID": "",
                    "nID": "",
                    "nLocationID": "",
                    "nTeamID": "",
                    "nTitleID": "",
                    "sEmail": "",
                    "sEmpID": "",
                    "sEmpName": "",
                    "sMobileNumber": "",
                    "sPhoneNumber": "",
                    "sRole": ""
                }
            }

            return {
                "getEntitlementPolicy": getEntitlementPolicy,
                "getEntitlementPolicyParams": getEntitlementPolicyParams,
                "getNotificationPolicy": getNotificationPolicy,
                "getNotificationPolicyParams": getNotificationPolicyParams,
                "getHoliday": getHoliday,
                "getHolidayParams": getHolidayParams,
                "getTitle": getTitle,
                "getTitleParams": getTitleParams,
                "getDepartment": getDepartment,
                "getDepartmentParams": getDepartmentParams,
                "getEvent": getEvent,
                "getEventParams": getEventParams,
                "getEmployee": getEmployee,
                "getEmployeeParams": getEmployeeParams,
                "getTeam": getTeam,
                "getTeamParams": getTeamParams,
                "getAssignProxy": getAssignProxy,
                "getProxyParams": getProxyParams,
                "getLocation": getLocation,
                "getLocationParams": getLocationParams,
                "getManagerProxy": getManagerProxy
            }
        }])
})();

/**
 * Factory used for admin related operations
 */
(function () {
    angular.module('timeOffCommvaultApp.adminServices', ['restangular'])
        .factory('adminServices', ["Restangular", "Utils", "$q", "$timeout", "configService", "employeeServices", "holidayService", "i8nConstants", function (Restangular, Utils, $q, $timeout, configService, employeeServices, holidayService, i8nConstants) {
            var URL = {};
            var moduleList = [];
            var approvalId = -1;
            var entitlementId = -1;

            function getApprovalId(){
                return approvalId;
            }
            function setApprovalId(approvalID){
                approvalId = approvalID;
            }
            function getEntitlementId(){
                return entitlementId;
            }
            function setEntitlementId(entitlementID){
                entitlementId = entitlementID;
            }
            function addRules() {
                if ($("#selectedTimeOff").val() == "") {
                    $("#nTimeOffID").rules("add", {
                        required: true
                    });
                    $("#nEntitlementID").rules("add", {
                        required: true
                    });
                    $("#nNotificationID").rules("add", {
                        required: true
                    });
                }
            }

            function removeRules() {
                $("#nTimeOffID").rules("remove");
                $("#nEntitlementID").rules("remove");
                $("#nNotificationID").rules("remove");
            }

            function setURL() {
                URL = (employeeServices.getEnvironment() == 'dev') ? configService.returnDevUrl() : configService.returnProdUrl();
            }

            function getUrlObj() {
                var UrlObj = (employeeServices.getEnvironment() == 'dev') ? configService.returnDevUrl() : configService.returnProdUrl();
                return UrlObj;
            }

            function getCountries(locationList) {
                var countryList = [];
                var completeList = [];
                for (var index in locationList) {
                    if (locationList[index].sCountryName != "") {
                        if (countryList.indexOf(locationList[index].sCountryName) == -1) {
                            countryList.push(locationList[index].sCountryName);
                            completeList.push([]);
                        }
                        completeList[countryList.indexOf(locationList[index].sCountryName)].push(locationList[index].sRegionName);
                    }
                }
                var obj = {
                    "countries": countryList,
                    "completeList": completeList
                }
                return obj;
            }

            function populateForm(parameterObj, actualParams) {
                if (parameterObj == "") {
                    for (var key in actualParams) {
                        var dateCheck = eval("actualParams." + key);
                        if ($.isArray(dateCheck)) {
                            $("#" + eval("actualParams." + key + "[0]")).val("");
                        } else {
                            var obj = eval("actualParams." + key);
                            if (obj === Object(obj) && Object.prototype.toString.call(obj) !== '[object Array]') {
                                for (var objKey in obj) {
                                    if (obj[objKey] != "array") {
                                        $("#" + obj[objKey] + "_0").val("");
                                    } else {
                                        $("#" + obj[objKey]).val("");
                                    }
                                }
                            } else {
                                $("#" + key).val("");
                            }
                        }
                    }
                } else {
                    for (var key in actualParams) {
                        var dateCheck = eval("actualParams." + key);
                        if ($.isArray(dateCheck)) {
                            $("#" + eval("actualParams." + key + "[0]")).val(Utils.defaultFormateDate(eval("parameterObj." + key)));
                        } else {
                            var obj = eval("actualParams." + key);
                            if (obj === Object(obj) && Object.prototype.toString.call(obj) !== '[object Array]') {
                                for (var objKey in obj) {
                                    if (obj[objKey] == "array") {
                                        var dataArray = eval("parameterObj." + key);
                                        if (key == "nCntCountEscalationList") {
                                            for (var i = 0; i < dataArray.length; i++) {
                                                if (i != 0) {
                                                    $("#first_text_" + i).closest(".row").find(".plus-sign").trigger("click");
                                                }
                                                $("#first_text_" + i).val(dataArray[i].key);
                                                $("#second_text_" + i).val(dataArray[i].value);
                                            }
                                        }
                                        if (key == "nTotalCountEscalationList") {
                                            for (var i = 0; i < dataArray.length; i++) {
                                                if (i != 0) {
                                                    $("#total_first_text_" + i).closest(".row").find(".plus-sign").trigger("click");
                                                }
                                                $("#total_first_text_" + i).val(dataArray[i].key);
                                                $("#total_second_text_" + i).val(dataArray[i].value);
                                            }
                                        }
                                    } else {
                                        if (typeof eval("parameterObj." + key) == 'number')
                                            $("#" + objKey).val(eval("parameterObj." + key));
                                        else
                                            $("#" + objKey).val(Utils.unescapeHtml(eval("parameterObj." + key)));
                                    }
                                }
                            } else {
                                if (typeof eval("parameterObj." + key) == 'number')
                                    $("#" + key).val(eval("parameterObj." + key));
                                else
                                    $("#" + key).val(Utils.unescapeHtml(eval("parameterObj." + key)));
                            }
                        }
                    }
                }
            }

            // ised for all create , update and delete API's
            function cudAPI(requestParams, url) {
                setURL();
                var deferred = $q.defer();
                var urlObj = Restangular.all(url);
                urlObj.post(requestParams, "get", {csrf: Utils.getCsrfToken()}).then(function (resp) {
                    if (Utils.isValidResponse(resp[0])) {
                        deferred.resolve(resp);
                    }
                    else {
                        deferred.reject(resp);
                    }
                }, function (resp) {
                    //deferred.resolve({"success": true});
                    deferred.reject(resp);
                });
                return deferred.promise;
            }

            function getListingObjArray(moduleName) {
                setURL();
                moduleList = [];
                if (moduleName == "Holiday") {
                    return holidayService.getAllHoliday();
                }
                var deferred = $q.defer();
                Restangular.all(eval("URL.get" + moduleName)).getList().then(function (resp) {
                    if (resp[0].data == null) {
                        resp[0].data = [];
                    }
                    if (Utils.isValidResponse(resp[0])) {
                        deferred.resolve(resp[0].data);
                    }
                    else {
                        deferred.reject(resp);
                    }
                }, function (resp) {
                    deferred.reject(resp);
                })
                return deferred.promise;
            }

            function clearFields(module) {
                if (module != "Employee") {
                    $("#editFlag").val("0");
                }
                if (module == "AssignProxy") {
                    $("#btn_sProxy").val("");
                    $("#btn_sUser").val("");
                    $("#sProxy").val("");
                    $("#sUser").val("");
                    $("#currDept").val("");
                    $("#tempDept").val("");
                    $("#dValidFrom").val("");
                    $("#dExpiryDate").val("");
                }
                if (module == "ManagerProxy") {
                    $("#btn_sProxy").val("");
                    $("#sProxy").val("");
                    $("#tempDept").val("");
                    $("#dValidFrom").val("");
                    $("#dExpiryDate").val("");
                }
                if (module == "Title") {
                    $("#sTitleName").val('');
                }
                if (module == "Team") {
                    $("#sTeamName").val('');
                }
                if (module == "Department") {
                    $("#sDeptName").val('');
                }
                if (module == "Location") {
                    $("#sCountryName").val('');
                    $("#sRegionName").val('');
                    $("#btn_sTimeZone .selVal").html(i8nConstants.SELECT_TIMEZONE);
                    $("#sTimeZone").val('');
                }
                if (module == "Holiday") {
                    $(".selRegion").html(i8nConstants.SELECT_REGION_STATE);
                    $("#sRegion").val('');
                    $(".selCountry").html(i8nConstants.SELECT_COUNTRY);
                    $("#sCountry").val('');
                    $('#CompensatoryH').attr("checked", false);
                    $('#nIsOptional').attr("checked", false);
                    $("#startDate").val('');
                    $("#endDate").val('');
                    $("#sName").val('');
                    $("#nLocationID").val('');
                }
                if (module == "Event") {
                    $('#startdate').val('');
                    $('#enddate').val('');
                    $('#sVenue').val('');
                    $("#sEventName").val('');
                    $("#btn_sVenue").val('');
                    $('#sDetails').val('');
                    $("#sVenueOthers").val('');
                    $(".other-venue").hide();
                }
                if (module == "EntitlementPolicy") {
                    $('#sPolicyName').val('');
                    $('#nMaxAllowed').val('');
                    $('#nDuration').val('');
                    $("#startdate").val('');
                    $("#nMaxContAllowed").val('');
                    $('#nMaxCountAllowed').val('')
                    $('#nAccruedPerMonth').val('')
                    $('#nCarryFwdAllowed').val('')
                }
                if (module == "NotificationPolicy") {
                    $('#notification_policy_name').val('');
                    $('.first-text').val('');
                    $('.second-text').val('');
                    $(".total-first-text").val('');
                    $(".total-second-text").val('');
                }
            }

            return {
                "cudAPI": cudAPI,
                "getUrlObj": getUrlObj,
                "populateForm": populateForm,
                "getListingObjArray": getListingObjArray,
                "getCountries": getCountries,
                "moduleList": moduleList,
                "addRules": addRules,
                "removeRules": removeRules,
                "clearFields": clearFields,
                "setApprovalId": setApprovalId,
                "getApprovalId": getApprovalId,
                "setEntitlementId": setEntitlementId,
                "getEntitlementId": getEntitlementId
            }
        }]);
})();

/**
 * Factory responsible for operations used in assign proxy and manager proxy page
 */
(function () {
    angular.module('timeOffCommvaultApp.assignProxyServices', ['restangular'])
        .factory('assignProxyServices', ["Restangular", "Utils", "$q", "$timeout", "configService", "employeeServices", function (Restangular, Utils, $q, $timeout, configService, employeeServices) {
            var URL = {};
            var managerList;
            var assignedProxy;

            function setURL() {
                URL = (employeeServices.getEnvironment() == 'dev') ? configService.returnDevUrl() : configService.returnProdUrl();
            }

            function getAllManagersData() {
                var deffered = $q.defer();
                Restangular.all(URL.getManagerDetails).getList().then(function (resp) {
                    if (resp[0].data == null) {
                        resp[0].data = [];
                    }
                    if (Utils.isValidResponse(resp[0])) {
                        managerList = resp[0].data;
                        deffered.resolve(managerList);
                    }
                    else {
                        deffered.reject(resp);
                    }
                }, function (resp) {
                    deffered.reject(resp);
                    Utils.displayError();
                });
                return deffered.promise;
            }

            function getManagerNameDept(certName) {
                var temp = {};
                for (var i = 0; i < managerList.length; i++) {
                    if (managerList[i].ProdcertName == certName) {
                        temp = {"sEmpName": managerList[i].sEmpName, "sDeptName": managerList[i].sDeptName}
                    }
                }
                return temp;
            }

            function getManagersList() {
                return managerList;
            }

            function getAllAssignedProxies() {
                //return makeGetRequest(URL.getAssignedProxy).then(function (){
                //    return managerList;
                //})
                var defered = $q.defer();
                Restangular.all(URL.getAssignProxy).getList().then(function (resp) {
                    if (resp[0].data == null) {
                        resp[0].data = [];
                    }
                    if (Utils.isValidResponse(resp[0])) {
                        assignedProxy = resp[0].data;
                        defered.resolve(assignedProxy);
                    }
                    else {
                        defered.reject(resp);
                    }
                }, function (resp) {
                    defered.reject(resp);
                    Utils.displayError();
                });
                return defered.promise;
            }

            function getAllManagersProxies() {
                var deferred = $q.defer();
                var requestUrl;
                var leaveParams = {"alias": employeeServices.getProdcertName()};
                if (employeeServices.getEnvironment() == "prod") {
                    requestUrl = Restangular.all(URL.getManagerProxy)
                    requestUrl.post(leaveParams, "get", {csrf: Utils.getCsrfToken()}).then(function (data) {
                        if (!Utils.isValidResponse(data[0])) {
                            if (data[0].data == null) {
                                data[0].data = [];
                            }
                            deferred.reject(data);
                        } else {
                            if (data[0].data == null) {
                                data[0].data = [];
                            }
                            deferred.resolve(data[0].data);
                        }
                    }, function (data) {
                        deferred.reject(data);
                    })
                    return deferred.promise;
                }
                else {
                    requestUrl = Restangular.all(URL.getManagerProxy).getList().then(function (resp) {
                        if (resp[0].data == null) {
                            resp[0].data = [];
                        }
                        if (Utils.isValidResponse(resp[0])) {
                            assignedProxy = resp[0].data;
                            deferred.resolve(assignedProxy);
                        }
                        else {
                            deferred.reject(resp);
                        }
                    })
                    //deferred.resolve({'success': true});
                    return deferred.promise;
                }
            }

            function postNewProxy() {
            }

            return {
                "getAllManagersData": getAllManagersData,
                "setURL": setURL,
                "getAllAssignedProxies": getAllAssignedProxies,
                "getManagerNameDept": getManagerNameDept,
                "getAllManagersProxies": getAllManagersProxies
            }
        }]);
})();

/**
 * Created by Avidyanath on 3/31/2015.
 */
// controller for displaying dashboard
(function () {
    app.controller('dashboardCtrl', ["$scope", "holidayService", "employeeServices", "i8nConstants", function ($scope, holidayService, employeeServices, i8nConstants) {

        // check if access is to admin only
        if ($scope.levelFlag != "Admin") {
            $location.path("/applyleave");
        }
    }]);
})();

'use strict';
// This is common controller for creating, listing  , updating , deleting different modules like title ,
// department , location , title , assign proxy , manager proxy , holidays , events ,
// entitlement policy , approval/notification policy , listing employee
(function () {
    app.controller('crudCtrl', ["$scope", "holidayService", "employeeServices", "addLeaveTypeServices", "validateObjectService", "adminServices", "Utils", "parameterService", "assignProxyServices", "$rootScope", "$location", "$timeout", function ($scope, holidayService, employeeServices, addLeaveTypeServices, validateObjectService, adminServices, Utils, parameterService, assignProxyServices, $rootScope, $location, $timeout) {
        $scope.$watch('$viewContentLoaded', function () {
            // this check is for giving this controller access only to
            // admin  otherwise redirect to apply leave page for manager and employee
            if ($scope.levelFlag != "Admin" && ($scope.levelFlag == "Manager" && ($scope.moduleName != "ManagerProxy"))) {
                $location.path("/applyleave");
            }
            if ($scope.levelFlag == "Employee") {
                $location.path("/applyleave");
            }
            $scope.halfDay = -1;
            // for title dragging
            $scope.dragStart = function (e, ui) {
                ui.item.data('start', ui.item.index());
            }
            // make date picker readonly
            $(document).ready(function () {
                $("#dValidFrom").on("keydown", function (e) {
                    return Utils.keepDateFieldReadable(e);
                });
                $("#dExpiryDate").on("keydown", function (e) {
                    return Utils.keepDateFieldReadable(e);
                });
                $("#startDate").on("keydown", function (e) {
                    return Utils.keepDateFieldReadable(e);
                });
                $("#endDate").on("keydown", function (e) {
                    return Utils.keepDateFieldReadable(e);
                });
                $("#startdate").on("keydown", function (e) {
                    return Utils.keepDateFieldReadable(e);
                });
                $("#enddate").on("keydown", function (e) {
                    return Utils.keepDateFieldReadable(e);
                });
            });
            // event after title dragging is complete
            $scope.dragEnd = function (e, ui) {
                var start = ui.item.data('start'),
                    end = ui.item.index();
                var titleObj = [];
                $(".sort-row").each(function (index) {
                    $(this).attr("data-sortorder", index + 1);
                    titleObj.push({
                        "nRank": index + 1,
                        "nTitleID": $(this).attr("data-titleid")
                    });
                });
                adminServices.cudAPI(titleObj, adminServices.getUrlObj().setRank).then(function () {
                    $(".title-success-msg").fadeIn().fadeOut(5000);
                    $('html, body').animate({scrollTop: 0}, 800);
                }, function (response) {
                    if (response[0].error == null) {
                        $(".title-error-danger-msg").fadeIn().fadeOut(5000);
                    }
                    $('html, body').animate({scrollTop: 0}, 800);
                });
                $scope.$apply();
            }
            var sortableEle = $('#sortable').sortable({
                start: $scope.dragStart,
                update: $scope.dragEnd,
                cancel: ".tbl-head"
            });
            $scope.editFlag = 0;
            var index = 0;
            $scope.loadingFlag = true;
            // modulename is defined in respective views
            if ($scope.moduleName == "AssignProxy" || $scope.moduleName == "ManagerProxy") {
                $(".clear-on-key-press").on("keyup", function () {
                    $(this).next().next().val("");
                });
                retrieveManagerList($scope.moduleName);
            }
            if ($scope.moduleName == "Location") {
                $("#timezone_dropdown").on("click", "li", function (e) {
                    $(".selVal").html($(this).html());
                    $("#sTimeZone").val($(this).html());
                    $("#btn_sTimeZone").removeClass("error");
                    $(e.target).parent().parent().parent().parent().find(".dropdown-toggle").trigger("click");
                });
                adminServices.getListingObjArray("Timezone").then(function (response) {
                    $scope.timezoneList = response;
                });
                $(document).mouseup(function (e) {
                    var container = $(".dropdown");
                    if (!container.is(e.target) // if the target of the click isn't the container...
                        && container.has(e.target).length === 0) // ... nor a descendant of the container
                    {
                        if ($(".dropdown-menu").hasClass("show")) {
                            $(".dropdown-menu").toggleClass("show");
                            // container.parent().find(".dropdown-toggle").trigger("click");
                        }
                    }
                });
                $('#btn_sTimeZone').off().on("click", function () {
                    $('.dropdown-div .dropdown-toggle').dropdown();
                    $(".dropdown-div .dropdown-menu").toggleClass("show");
                });
            }
            function retrieveManagerList(moduleName) {
                assignProxyServices.setURL();
                var loggedUser = employeeServices.getEmployeeObj();
                $scope.managersList = assignProxyServices.getAllManagersData().then(function (managerList) {
                    $scope.managersList = managerList;
                    var currManagerObj = employeeServices.giveValueOfAnotherMemberInArrayOfObjects($scope.managersList, loggedUser.ProdcertName, ["ProdcertName"])
//                $("#currDept").val(currManagerObj.sDeptName);
                    if (moduleName == "ManagerProxy") {
                        $scope.addCurrentManager(currManagerObj);
                        $("#sUser").val(currManagerObj.ProdcertName);
                        $("#currDept").val(currManagerObj.sDeptName);
                    }
                });
                var loggedUser = employeeServices.getEmployeeObj();
                if (moduleName == "AssignProxy") {
                    assignProxyServices.getAllAssignedProxies().then(function (proxies) {
                        $scope.assignedProxies = proxies;
                        $scope.loadingFlag = false;
                    });
                } else {
                    assignProxyServices.getAllManagersProxies(employeeServices.getProdcertName()).then(function (proxies) {
                        $scope.assignedProxies = proxies;
                        $scope.loadingFlag = false;
                    });
                    $scope.loadingFlag = false;
                }
            }

            $scope.displayCurrManagersName = function ($event) {
                $(".curr-manager").show();
            }
            $scope.displayTempManagersName = function () {
                employeeServices.getEmployeeByParams($("#btn_sProxy").val()).then(function (response) {
                    $scope.managerList = response[0].data;
                    $(".temp-manager").show();
                }, function (resp) {
                });
            }
            $scope.addCurrentManager = function (manager) {
                $scope.currentManager = manager;
                $("#sUser").val(manager.ProdcertName);
                $scope.currManagerName = manager.sEmpName;
                $scope.currentManagersDept = manager.sDeptName;
                $(".memberList").hide();
            }
            var departmentList = [];
            adminServices.getListingObjArray("Department").then(function (response) {
                departmentList = response;
                // populate department field if page is in edit mode
            });
            $("#searchTempManager").on("click", function () {
                $scope.displayTempManagersName();
            });
            $scope.addTemporaryManager = function (manager) {
                $scope.temporaryManager = manager;
                $scope.tempManagerName = manager.sEmpName;
                $("#sProxy").val(manager.ProdcertName);
                $(".memberList").hide();
                for (var i = 0; i < departmentList.length; i++) {
                    if (departmentList[i].nDeptID == manager.nDeptID) {
                        $scope.temporaryManagersDept = departmentList[i].sDeptName;
                    }
                }
            }
            $scope.displayRevokeProxy = function (proxy) {
                adminServices.clearFields($scope.moduleName);
                $scope.editFlag = false;
                $("#deletePolicyModal").modal('show');
                $scope.revokeProxyObj = proxy;
            }
            $scope.revokeProxy = function () {
                var id = $scope.revokeProxyObj.nID;
                var deleteObjParams = {
                    "nID": id
                }
                adminServices.cudAPI(deleteObjParams, eval("adminServices.getUrlObj().delete" + $scope.moduleName)).then(function (response) {
                    $scope.closeRevokeModal();
                    $(".delete-success-msg").fadeIn().fadeOut(5000);
                    if ($scope.moduleName == 'ManagerProxy') {
                        assignProxyServices.getAllManagersProxies().then(function (response) {
                            adminServices.clearFields($scope.moduleName);
                            $rootScope.$broadcast('user:updated', response);
                        });
                    } else if ($scope.moduleName == 'AssignProxy') {
                        assignProxyServices.getAllAssignedProxies().then(function (response) {
                            adminServices.clearFields($scope.moduleName);
                            $rootScope.$broadcast('user:updated', response);
                        });
                    } else {
                        adminServices.getListingObjArray(moduleName).then(function (response) {
                            adminServices.clearFields($scope.moduleName);
                            $rootScope.$broadcast('user:updated', response);
                        });
                    }
                    $('html, body').animate({scrollTop: 0}, 800);
                }, function (response) {
                    $scope.closeRevokeModal();
                    if (response[0].error == null) {
                        $(".delete-error-danger-msg").fadeIn().fadeOut(5000);
                    }
                    81
                    $('html, body').animate({scrollTop: 0}, 800);
                });
            }
            $scope.closeRevokeModal = function () {
                $("#deletePolicyModal").modal('hide');
                $scope.revokeProxyObj = '';
            }
            $scope.editProxy = function (proxy) {
                Utils.clearFormValidations();
                var id = proxy.nID;
                adminServices.populateForm(proxy, parameterService.getProxyParams());
                $("#editFlag").val(id).trigger("change");
                var managerData = assignProxyServices.getManagerNameDept(proxy.sUser);

                //var tempmanagerData = assignProxyServices.getManagerNameDept(proxy.sProxy);
                $("#btn_sProxy").val(proxy.sProxyName);
                $("#btn_sUser").val(managerData.sEmpName);
                $("#sProxy").val(proxy.sProxy);
                $("#sUser").val(proxy.sUser);
                $("#currDept").val(managerData.sDeptName);
                $("#tempDept").val(proxy.sProxyDept);
                $('html, body').animate({scrollTop: 0}, 800);
            }
            $scope.getFullName = function (name) {
                return assignProxyServices.getManagerNameDept(name).sEmpName
            }
            $("#editFlag").on('change', function () {
                if ($(this).val() == 0) {
                    $scope.editFlag = 0;
                }
                else {
                    $scope.editFlag = 1;
                }
            })
            $scope.cancelProxyEdit = function () {
                $scope.editFlag = 0;
                $('#editFlag').val("0");
                $("#dExpiryDate").val('');
                $("#dValidFrom").val('');
                $("#sProxy").val('');
                $("#btn_sProxy").val('');
                $("#sUser").val('');
                $("#btn_sUser").val('')
                $("#currDept").val('');
                $("#tempDept").val('');
                $("#nID").val('');
            };
            $scope.calcDays = function (startDate, endDate, locationID) {
                return Utils.calculateDays(startDate, endDate);
            }
            $scope.formatDates = function (dateStr) {
                return Utils.convertDateString(dateStr);
            }
            if ($scope.moduleName != undefined) {
                var updateModulename = $scope.moduleName.toLowerCase();
            }
            // refresh listing of for respective modules if add or edit happens
            $scope.$on('user:updated', function (event, data) {
                $scope.editFlag = 0;
                if ($scope.moduleName != undefined) {
                    if ($scope.moduleName == "Holiday") {
                        updateCountriesHolidays();
                    } else {
                        if ($scope.moduleName == "AssignProxy" || $scope.moduleName == "ManagerProxy") {
                            $scope.assignedProxies = data;
                        } else {
                            eval('$scope.' + updateModulename + 'List = data');

                        }
                    }
                }
            });
            if (($scope.moduleName == "Department") || ($scope.moduleName == "Team") || ($scope.moduleName == "Event") || ($scope.moduleName == "Title") || ($scope.moduleName == "Location")) {
                getLisings($scope.moduleName);
                $scope.editRow = function (rowId) {
                    Utils.clearFormValidations();
                    $scope.editFlag = 1;
                    if (rowId != "") {
                        var primaryKey = "nID";
                        if ($scope.moduleName == "Title") {
                            primaryKey = "nTitleID";
                        }
                        if ($scope.moduleName == "Department") {
                            primaryKey = "nDeptID";
                        }
                        if ($scope.moduleName == "Team") {
                            primaryKey = "nTeamID";
                        }
                        if ($scope.moduleName == "Title") {
                            primaryKey = "nTitleID";
                        }
                        if ($scope.moduleName == "Location") {
                            primaryKey = "nLocationID";
                        }
                        adminServices.populateForm(employeeServices.giveValueOfAnotherMemberInArrayOfObjects(eval('$scope.' + $scope.moduleName.toLowerCase() + 'List'), rowId, [primaryKey]), eval("parameterService.get" + $scope.moduleName + "Params()"));
                        $("#editFlag").val(rowId);
                        if ($scope.moduleName == "Location") {
                            $(".selVal").html($("#sTimeZone").val());
                        }
                        $('html, body').animate({scrollTop: 0}, 800);
                    }
                }
            }
            function getLisings(module) {
                adminServices.getListingObjArray(module).then(function (response) {
                    eval('$scope.' + $scope.moduleName.toLowerCase() + 'List = response');
                    $scope.loadingFlag = false;
                });
            }

            if ($scope.moduleName == "Employee") {
                $scope.searchEmployee = function () {
                    if ($("#empSearchText").val() == "") {
                        getResultsPage(1);
                        $(".pagination").show();
                    } else {
                        $(".pagination").hide();
                    }
                    employeeServices.getEmployeeByParams($('#empSearchText').val()).then(function (response) {
                        $scope.users = response[0].data;
                        $scope.totalUsers = response[0].count;
                    });
                }
                $scope.loadingFlag = true;
                $scope.checkArray = function (empVal) {
                    if ($.isArray(empVal)) {
                        return true;
                    } else {
                        return false;
                    }
                }
                $scope.usersPerPage = 15; // this should match however many results your API puts on one page
                var getResultsPage = function (pageNumber) {
                    employeeServices.getEmployees(pageNumber, $scope.usersPerPage).then(function (response) {
                        $scope.users = response[0].data[0].employees;
                        $scope.totalUsers = response[0].data[0].TotalEmpCount;
                        $scope.loadingFlag = false;
                    });
                }
                getResultsPage(1);
                $scope.pagination = {
                    current: 1
                };
                $scope.pageChanged = function (newPage) {
                    getResultsPage(newPage);
                };
                $scope.teamListsArray = [];
                adminServices.getListingObjArray("Team").then(function (response) {
                    $scope.teamLists = response;
                    for (var i = 0; i < $scope.teamLists.length; i++) {
                        $scope.teamListsArray[$scope.teamLists[i].nTeamID] = $scope.teamLists[i].sTeamName;
                    }
                    $scope.displayTeam = function ($event) {
                        $(".teamList").show();
                    }
                });
                $scope.locationListsArray = [];
                adminServices.getListingObjArray("Location").then(function (response) {
                    $scope.locationLists = response;
                    for (var i = 0; i < $scope.locationLists.length; i++) {
                        $scope.locationListsArray[$scope.locationLists[i].nLocationID] = [];
                        $scope.locationListsArray[$scope.locationLists[i].nLocationID][0] = $scope.locationLists[i].sRegionName;
                        $scope.locationListsArray[$scope.locationLists[i].nLocationID][1] = $scope.locationLists[i].sCountryName;
                    }
                });
                $scope.managerListsArrayProd = [];
                $scope.managerListsArrayName = [];
                adminServices.getListingObjArray("Manager").then(function (response) {
                    $scope.managerLists = response;
                    for (var i = 0; i < $scope.managerLists.length; i++) {
                        $scope.managerListsArrayProd [i] = $scope.managerLists[i].ProdcertName;
                        $scope.managerListsArrayName[i] = $scope.managerLists[i].sEmpName;
                    }
                });
            }
            if ($scope.moduleName == "Holiday") {
                $('.dropdown-toggle').off().on("click", function (e) {
                    $(this).dropdown();
                    $(this).parent().find(".dropdown-menu").toggleClass("show");
                    if ($(e.target).attr("id") == "btn_sCountry") {
                        $("#btn_sRegion").parent().find(".show").each(function () {
                            $(this).toggleClass("show");
                        });
                    }
                });
                $(document).mouseup(function (e) {
                    var container = $(".dropdown");
                    if (!container.is(e.target) // if the target of the click isn't the container...
                        && container.has(e.target).length === 0) // ... nor a descendant of the container
                    {
                        $(".dropdown").find(".show").each(function () {
                            $(this).toggleClass("show");
                        });
                    }
                });
                $scope.regionList = [];
                adminServices.getListingObjArray("Location").then(function (response) {
                    $scope.LocationList = response;
                    var locationObj = adminServices.getCountries($scope.LocationList);
                    $scope.countriesList = locationObj.countries;
                    $scope.completeLocationObj = locationObj.completeList;
                });
                $scope.indexList = 0;
                $scope.addedName = [];
                $("#country_dropdown").on("click", "li", function (e) {
                    $scope.addedName = [];
                    $("#sRegion").val("");
                    $("#btn_sCountry").removeClass("error");
                    $(".selCountry").html($(this).html());
                    $(".selRegion").html("Select region/state");
                    $("#sCountry").val($(this).html());
                    $scope.addedName.push($(this).html());
                    $scope.$evalAsync(function () {
                        $scope.indexList = $(this).data("index");
                    });
                    $(e.target).parent().parent().parent().parent().find(".dropdown-toggle").trigger("click");
                });
                $("#region_dropdown").on("click", "li", function (e) {
                    $(".selRegion").html($(this).html());
                    $("#btn_sRegion").removeClass("error");
                    $("#sRegion").val($(this).html())
                    $("#nLocationID").val($(this).data("locationid"));
                    $(e.target).parent().parent().parent().parent().find(".dropdown-toggle").trigger("click");
                });
                $scope.isEmpty = function () {
                    if (Object.keys($scope.holidayList).length) {
                        return false;
                    }
                    return true;
                }
                var updateCountriesHolidays = function () {
                    $scope.holidayList = {};
                    var j = 0;
                    $scope.multiCountriesHolidayList = holidayService.getHolidayList($scope.filteredCountries);
                    if ($scope.filteredCountries.length == 0) {
                        $scope.noHolidayMsg = "No location is selected,please select a location to view the holiday list.";
                    }
                    else if (Object.keys($scope.multiCountriesHolidayList).length > 0) {
                        $scope.noHolidayMsg = "No holiday(s) found for this/these location/locations.";
                    }
                    for (var j = 0; j < Object.keys($scope.multiCountriesHolidayList).length; j++) {
                        var holidayList = $scope.multiCountriesHolidayList[Object.keys($scope.multiCountriesHolidayList)[j]];
                        for (var i = 0; i < holidayList.length; i++) {
                            var temp = {}
                            //temp.date = holidayList[i].startDate.replace(/-/g, ' ');
                            var holidayDate;
                            var startDate = new Date(holidayList[i].startDate);
                            var endDate = new Date(holidayList[i].endDate);
                            //If the holidays span between days
                            if ((startDate.getDate() != endDate.getDate()) || (startDate.getMonth() != endDate.getMonth()) || (startDate.getFullYear() != endDate.getFullYear())) {
                                var daysDiff = Utils.calculateDays(startDate.toDateString(), endDate.toDateString());
                                holidayDate = new Date(holidayList[i].startDate);
                                for (var k = 0; k < daysDiff; k++) {
                                	var date = new Date(holidayDate);
                                    if (!$scope.holidayList[$scope.monthNames[date.getMonth()] + "-" + date.getFullYear()]) {
                                        $scope.holidayList[$scope.monthNames[date.getMonth()] + "-" + date.getFullYear()] = [];
                                    }
                                    //tempArr[$scope.monthNames[new Date(temp.date).getMonth()]].push(temp);
                                    if (holidayList[i].nIsOptional == true) {
                                        $scope.holidayList[$scope.monthNames[date.getMonth()] + "-" + date.getFullYear()].push({
                                            'month': $scope.monthNames[date.getMonth()],
                                            'date': date,
                                            'name': holidayList[i].sName,
                                            'country': holidayList[i].sCountry,
                                            'region': holidayList[i].sRegion,
                                            'color': "#344c67",
                                            'nID': holidayList[i].nID
                                        });
                                    } else {
                                        $scope.holidayList[$scope.monthNames[date.getMonth()] + "-" + date.getFullYear()].push({
                                            'month': $scope.monthNames[date.getMonth()],
                                            'date':date,
                                            'name': holidayList[i].sName,
                                            'country': holidayList[i].sCountry,
                                            'region': holidayList[i].sRegion,
                                            'color': "white",
                                            'nID': holidayList[i].nID
                                        });
                                    }
                                    holidayDate.setDate(holidayDate.getDate() + 1);
                                }
                            }
                            else {
                                //single month holidays
                                holidayDate = new Date(holidayList[i].startDate);
                                var date = new Date(holidayDate);
                                if (!$scope.holidayList[$scope.monthNames[date.getMonth()] + "-" + date.getFullYear()]) {
                                    $scope.holidayList[$scope.monthNames[date.getMonth()] + "-" + date.getFullYear()] = [];
                                }
                                //tempArr[$scope.monthNames[new Date(temp.date).getMonth()]].push(temp);
                                if (holidayList[i].nIsOptional == true) {
                                    $scope.holidayList[$scope.monthNames[date.getMonth()] + "-" + date.getFullYear()].push({
                                        'month': $scope.monthNames[date.getMonth()],
                                        'date':date,
                                        'name': holidayList[i].sName,
                                        'country': holidayList[i].sCountry,
                                        'region': holidayList[i].sRegion,
                                        'color': "#344c67",
                                        'nID': holidayList[i].nID
                                    });
                                } else {
                                    $scope.holidayList[$scope.monthNames[date.getMonth()] + "-" + date.getFullYear()].push({
                                        'month': $scope.monthNames[date.getMonth()],
                                        'date': date,
                                        'name': holidayList[i].sName,
                                        'country': holidayList[i].sCountry,
                                        'region': holidayList[i].sRegion,
                                        'color': "white",
                                        'nID': holidayList[i].nID
                                    });
                                }
                            }
                        }
                    }
                    for (var key in $scope.holidayList) {
                        $scope.holidayList[key] = Utils.sortArrayBasedOnDates($scope.holidayList[key]);
                    }
                }
                $scope.holidayList = [];
                var dateObj = new Date();
                $scope.country = "India";
                $scope.countryFilter = [];
                $scope.filteredCountries = [];
                $scope.noHolidayMsg = "Loading ...";
                var index = 0;
				
				//To support holiday list for subsequent year
        		//@TODO: Need to acheive this in a better way
                $scope.monthYear = ["January-" + dateObj.getFullYear(), "February-" + dateObj.getFullYear(), "March-" + dateObj.getFullYear(), "April-" + dateObj.getFullYear(), "May-" + dateObj.getFullYear(), "June-" + dateObj.getFullYear(),
	                "July-" + dateObj.getFullYear(), "August-" + dateObj.getFullYear(), "September-" + dateObj.getFullYear(), "October-" + dateObj.getFullYear(), "November-" + dateObj.getFullYear(), "December-" + dateObj.getFullYear(), "January-" + (dateObj.getFullYear() + 1),
	                "February-" + (dateObj.getFullYear() + 1), "March-" + (dateObj.getFullYear() + 1), "April-" + (dateObj.getFullYear() + 1), "May-" + (dateObj.getFullYear() + 1), "June-" + (dateObj.getFullYear() + 1),
	                "July-" + (dateObj.getFullYear() + 1), "August-" + (dateObj.getFullYear() + 1), "September-" + (dateObj.getFullYear() + 1), "October-" + (dateObj.getFullYear() + 1), "November-" + (dateObj.getFullYear() + 1), "December-" + (dateObj.getFullYear() + 1)
                ];
                $scope.monthNames = ["January", "February", "March", "April", "May", "June",
                    "July", "August", "September", "October", "November", "December"
                ];
                $scope.getHolidayList = function () {
                    holidayService.getAllHoliday().then(function () {
                        $scope.countryFilter = holidayService.getRegionList();
                        $scope.filteredCountries = holidayService.getRegionList();
                        index = $scope.filteredCountries.length;
                        updateCountriesHolidays();
                    });
                };
                $scope.editRow = function (rowId, country) {
                    Utils.clearFormValidations();
                    $scope.editFlag = 1;
                    $("#editFlag").val(rowId);
                    if (rowId != "") {
                        var formObj = employeeServices.giveValueOfAnotherMemberInArrayOfObjects($scope.multiCountriesHolidayList[country], rowId, "");
                        adminServices.populateForm(formObj, parameterService.getHolidayParams())
                        $("[data-country='" + $("#sCountry").val() + "']").trigger("click");
                        $("#btn_sCountry").parent().find(".show").toggleClass("show");
                        $("[data-locationid='" + $("#nLocationID").val() + "']").trigger("click");
                        $("#btn_sRegion").parent().find(".show").toggleClass("show");
                        if (formObj.nIsOptional == true)
                            $('#nIsOptional').trigger('click');
                        // $("#nIsOptional").attr("checked","checked");
                        $('html, body').animate({scrollTop: 0}, 800);
                    }
                }
                $scope.updateCountry = function (country) {
                    $scope.country = country;
                    if ($scope.filteredCountries.indexOf(country) == -1) {
                        $scope.filteredCountries[index] = country;
                        index++;
                    }
                    else {
                        $scope.filteredCountries.splice($scope.filteredCountries.indexOf(country), 1);
                        index--;
                    }
                    updateCountriesHolidays();
                }
                $scope.getHolidayList();
            }
            var validateObj = validateObjectService.getValidateObj($scope.moduleName);
            $scope.evenFormvalidate = validateObj;
            $scope.deleteAlert = function (ObjId) {
                adminServices.clearFields($scope.moduleName);
                $scope.editFlag = false;
                $scope.deleteObjId = ObjId;
                $("#deletePolicyModal").modal('show');
            }
            $scope.deleteObj = function () {
                $scope.editFlag = 0;
                adminServices.clearFields($scope.moduleName);
                var ObjId = $scope.deleteObjId;
                var deleteObjParams = {
                    "nID": ObjId
                }
                if ($scope.moduleName == "Title") {
                    deleteObjParams = {
                        "nTitleID": ObjId
                    }
                }
                if ($scope.moduleName == "Department") {
                    deleteObjParams = {
                        "nDeptID": ObjId
                    }
                }
                if ($scope.moduleName == "Team") {
                    deleteObjParams = {
                        "nTeamID": ObjId
                    }
                }
                if ($scope.moduleName == "Title") {
                    deleteObjParams = {
                        "nTitleID": ObjId
                    }
                }
                if ($scope.moduleName == "Location") {
                    deleteObjParams = {
                        "nLocationID": ObjId
                    }
                }
                $(".alert-msg").hide();
                $("#deletePolicyModal").modal("hide");
                adminServices.cudAPI(deleteObjParams, eval("adminServices.getUrlObj().delete" + $scope.moduleName)).then(function (response) {
                    $(".delete-success-msg").fadeIn().fadeOut(3000);
                    if ($scope.moduleName == "Holiday") {
                        $scope.getHolidayList();
                    } else {
                        adminServices.getListingObjArray($scope.moduleName).then(function (response) {
                            if ($scope.moduleName == "AssignProxy") {
                                $scope.assignedProxies = response;
                            } else {
                                eval('$scope.' + $scope.moduleName.toLowerCase() + 'List = response');
                                $scope.loadingFlag = false;
                            }
                        });
                    }
                    $('html, body').animate({scrollTop: 0}, 800);
                }, function (response) {
                    if (response[0].error == null) {
                        $(".delete-error-danger-msg").fadeIn().fadeOut(5000);
                    }
                    $('html, body').animate({scrollTop: 0}, 800);
                });
            }
            //event
            adminServices.getListingObjArray("Location").then(function (response) {
                $scope.locationList = response;
            });
            $scope.locationList = employeeServices.getLocationList();
            $scope.venue = '';
            $scope.deleteEventObj = '';
            $scope.editFlag = 0;
            if ($scope.moduleName == 'Event') {
                $('.dropdown-toggle').off().on("click", function () {
                    $(this).dropdown();
                    $(this).parent().find(".dropdown-menu").toggleClass("show");
                });
                $(document).mouseup(function (e) {
                    var container = $(".dropdown");
                    if (!container.is(e.target) // if the target of the click isn't the container...
                        && container.has(e.target).length === 0) // ... nor a descendant of the container
                    {
                        $(".dropdown").find(".show").each(function () {
                            $(this).toggleClass("show");
                        });
                    }
                });
                $scope.updateVenue = function (venue, e) {
                    $('.event-loc').hide();
                    if (venue == "OTHER") {
                        $(".other-venue").show();
                        $("#sVenueOthers").rules("add", {
                            required: true
                        });
                    }
                    else {
                        $("#sVenueOthers").rules("remove");
                        $(".other-venue").hide();
                    }
                    $scope.venue = venue;
                    $("#nLocationID").val($(e.target).attr("data-locationid"));
                    $("#sVenue").val(venue);
                    $("#btn_sVenue").val(venue);
                    $(e.target).parent().parent().parent().parent().find(".dropdown-toggle").trigger("click");
                }
                $scope.deleteEventAlert = function (singleEvent, $event) {
                    adminServices.clearFields($scope.moduleName);
                    $scope.editFlag = false;
                    $scope.deleteEventObj = singleEvent;
                    $("#deletePolicyModal").modal('show');
                    $event.stopPropagation();
                }
                $scope.deleteEvent = function () {
                    $scope.editFlag = 0;
                    adminServices.clearFields($scope.moduleName);
                    var id = $scope.deleteEventObj.nID;
                    var deleteObjParams = {
                        "nID": id
                    }
                    $(".alert-msg").hide();
                    $("#deletePolicyModal").modal("hide");
                    adminServices.cudAPI(deleteObjParams, eval("adminServices.getUrlObj().delete" + $("#moduleName").val())).then(function (response) {
                        $(".delete-success-msg").fadeIn().fadeOut(3000);
                        adminServices.getListingObjArray($scope.moduleName).then(function (response) {
                            eval('$scope.' + $scope.moduleName.toLowerCase() + 'List = response');
                            $scope.loadingFlag = false;
                        });
                        $('html, body').animate({scrollTop: 0}, 800);
                    }, function (response) {
                        if (response[0].error == null) {
                            $(".delete-error-danger-msg").fadeIn().fadeOut(5000);
                        }
                        $('html, body').animate({scrollTop: 0}, 800);
                    });
                }
                $scope.displayEvent = function () {
                    $("#sVenueOthers").rules("add", {
                        required: false
                    });
                    $("#sVenueOthers").val('');
                    $('#sVenue').val('');
                    $('#nLocationID').val('');
                    $('.event-loc').show();
                }
                $scope.editEvent = function (eve, e) {
                    Utils.clearFormValidations();
                    $(".other-venue").hide();
                    $("#sVenueOthers").rules("add", {
                        required: false
                    });
                    //adminServices.clearFields($('#moduleName').val());
                    var id = eve.nID;
                    var othersloc = employeeServices.getOthersId($scope.locationList);
                    adminServices.populateForm(eve, parameterService.getEventParams());
                    $("#editFlag").val(id);
                    var isInArrFlag = false;
                    for (var key in $scope.locationList) {
                        if ($scope.locationList[key].nLocationID == eve.nLocationID && $scope.locationList[key].nLocationID == othersloc) {
                            isInArrFlag = true;
                            break;
                        }
                    }
                    $("#nLocationID").val(eve.nLocationID);
                    if (isInArrFlag == true) {
                        $(".other-venue").show();
                        $("#btn_sVenue").val("OTHER");
                        $("#sVenueOthers").rules("add", {
                            required: true
                        });
                        $("#sVenueOthers").val(eve.sVenue);
                        $("#sVenue").val('OTHER')
                    }
                    else {
                        $("#sVenue").val(eve.sVenue);
                        $("#btn_sVenue").val($("#sVenue").val());
                    }
                    $scope.editFlag = 1;
                    $('html, body').animate({scrollTop: 0}, 800);
                }
            }
            $scope.closeEventModal = function () {
                $("#deletePolicyModal").modal("hide");
            }
            //----------
            $scope.cancelEdit = function () {
                $scope.editFlag = 0;
                adminServices.clearFields($scope.moduleName);
            }
            $scope.showEntitlementModal = function () {
                $("#addPolicyModal").modal("show")
            }
            $scope.showNotificationModal = function () {
                $("#notificationPolicyModal").modal("show");
            }
        });
        var counter = 1;
        $(".first-table-data").off().on("click", ".plus-sign", function (e) {
            $(this).closest(".row").clone().appendTo(".first-table-data");
            $(".first-table-data").find(".first-text").last().attr("name", "first_text_" + counter);
            $(".first-table-data").find(".second-text").last().attr("name", "second_text_" + counter);
            $(".first-table-data").find(".first-text").last().attr("id", "first_text_" + counter);
            $(".first-table-data").find(".second-text").last().attr("id", "second_text_" + counter);
            $("#first_text_" + counter).val("");
            $("#second_text_" + counter).val("");
            $("#first_text_" + counter).rules("add", "required");
            $("#second_text_" + counter).rules("add", "required");
            $(".first-table-data").find(".minus-sign").last().attr("data-counter", counter);
            counter++;
            e.stopPropagation();
            e.preventDefault();
        });
        $(".first-table-data").on("click", ".minus-sign", function (e) {
            $("#first_text_" + $(this).data("counter")).rules("remove", "required");
            $("#second_text_" + $(this).data("counter")).rules("remove", "required");
            $(e.target).closest(".row").remove();
        });
        var secondCounter = 1;
        $(".second-table-data").off().on("click", ".plus-sign", function () {
            $(this).closest(".row").clone().appendTo(".second-table-data");
            $(".second-table-data").find(".total-first-text").last().attr("name", "total_first_text_" + secondCounter);
            $(".second-table-data").find(".total-second-text").last().attr("name", "total_second_text_" + secondCounter);
            $(".second-table-data").find(".total-first-text").last().attr("id", "total_first_text_" + secondCounter);
            $(".second-table-data").find(".total-second-text").last().attr("id", "total_second_text_" + secondCounter);
            $("#total_first_text_" + secondCounter).val("");
            $("#total_second_text_" + secondCounter).val("");
            $("#total_first_text_" + secondCounter).rules("add", "required");
            $("#total_second_text_" + secondCounter).rules("add", "required");
            $(".second-table-data").find(".minus-sign").last().attr("data-counter", secondCounter);
            secondCounter++;
        });
        $(".second-table-data").on("click", ".minus-sign", function (e) {
            $("#total_first_text_" + $(this).data("counter")).rules("remove", "required");
            $("#total_second_text_" + $(this).data("counter")).rules("remove", "required");
            $(e.target).closest(".row").remove();
        });
    }]).controller("dateCtrl", ["$scope", function ($scope) {
        $scope.toggleMin = function () {
        };
        $scope.toggleMin();
        $scope.dateOptions = {
            showWeeks: 'false'
        };
        $scope.openStartDate = function ($event) {
            $scope.showWeeks = false;
            $(".day-option").hide();
            $event.stopPropagation();
            $scope.opened = true;
            $("#endDate").val(undefined);
        };
        $scope.openEndDate = function ($event) {

            $(".day-option").hide();
            $scope.enddate = ($("#startDate").val() == "") ?undefined : new Date($("#startDate").val().replace(/-/g, "/"));
            $scope.minDate = ($("#startDate").val() == "") ? undefined : new Date($("#startDate").val().replace(/-/g, "/"));
            $event.stopPropagation();
            $scope.opened = true;
        };
        $scope.format = 'dd-MMMM-yyyy';
    }]);
})();
/*
 This controller is used for adding and editing employee with details.
 */
(function () {
    app.controller('addEmployeeCtrl', ["$scope", "assignProxyServices", "adminServices", "employeeServices", "$timeout", "validateObjectService", "$routeParams", "parameterService", "Utils", "$location", function ($scope, assignProxyServices, adminServices, employeeServices, $timeout, validateObjectService, $routeParams, parameterService, Utils, $location) {

        // this check is for giving this controller access only to
        // admin  otherwise redirect to apply leave page for manager and employee
        if ($scope.levelFlag != "Admin") {
            $location.path("/applyleave");
        }
        $(".clear-on-key-press").on("keyup", function () {
            $(this).next().next().val("");
        });
        $scope.assignFlag = false;
        $scope.teamList = '';
        $scope.editFlagMode = false;
        $scope.selectedTimeOffTypes = [];
        $scope.selectedEntitlement = [];
        $scope.selectedApproval = [];
        $("#editFlag").val(0);
        var employeeId;
        var employeeObj;
        var employeeTimeOffsObj;
        // to make date field read only
        $("#dDateHired").on("keydown", function (e) {
            return Utils.keepDateFieldReadable(e);
        });
        // condition for edit employee
        if ($routeParams.employeeId != undefined) {
            $scope.editFlagMode = true;
            $("#editFlag").val(1);
            employeeId = $routeParams.employeeId;
            //fetch employee details based on ID
            employeeServices.getEmployeeByParams(employeeId).then(function (response) {
                employeeObj = response[0].data[0].emp;
                employeeTimeOffsObj = response[0].data[0].emp_map;
                $scope.editEvent();
            });
        }
        //for hiding dropdowns if click outside of dropdown
        $(document).mouseup(function (e) {
            var container = $(".dropdown");
            if (!container.is(e.target) // if the target of the click isn't the container...
                && container.has(e.target).length === 0) // ... nor a descendant of the container
            {
                $(".dropdown").find(".show").each(function () {
                    $(this).toggleClass("show");
                });
            }
        });
        $("#startdate").on("blur", function () {
            $(".datepicker ul").hide();
        })
        $('.dropdown-toggle').off().on("click", function () {
            $(this).dropdown();
            $(this).parent().find(".dropdown-menu").toggleClass("show");
        });
        $scope.openStartDate = function ($event) {
            $scope.showWeeks = false;
            $event.preventDefault();
            $event.stopPropagation();
            $(".day-option").hide();
            $scope.opened = true;
        };
        $scope.dateOptions = {
            showWeeks: 'false'
        };
        $scope.format = 'dd-MMMM-yyyy';
        function getAllEntities() {
            adminServices.getListingObjArray("Title").then(function (response) {
                $scope.titleList = response;
                // populate title field if page is in edit mode
                if ($scope.editFlagMode == true) {
                    for (var i = 0; i < $scope.titleList.length; i++) {
                        if ($scope.titleList[i].nTitleID == $("#nTitleID").val()) {
                            $("#btn_nTitleID").val($scope.titleList[i].sTitleName);
                        }
                    }
                }
                $scope.displayTitle = function ($event) {
                    $(".titleList").show();
                }
            });
            adminServices.getListingObjArray("Department").then(function (response) {
                $scope.departmentList = response;
                // populate department field if page is in edit mode
                if ($scope.editFlagMode == true) {
                    for (var i = 0; i < $scope.departmentList.length; i++) {
                        if ($scope.departmentList[i].nDeptID == $("#nDeptID").val()) {
                            $("#btn_nDeptID").val($scope.departmentList[i].sDeptName);
                        }
                    }
                }
                $scope.displayDepartment = function ($event) {
                    $(".departmentList").show();
                }
            });
            $('.detailLink').click(function () {
                $(this).closest('.row').next('.DetailsTab').slideToggle();
            });
            adminServices.getListingObjArray("Team").then(function (response) {
                $scope.teamList = response;
                if ($scope.editFlagMode == true) {
                    for (var i = 0; i < $scope.teamList.length; i++) {
                        if ($scope.teamList[i].nTeamID == $("#nTeamID").val()) {
                            $("#btn_nTeamID").val($scope.teamList[i].sTeamName);
                        }
                    }
                }
                $scope.displayTeam = function ($event) {
                    $(".teamList").show();
                }
            });
            adminServices.getListingObjArray("Location").then(function (response) {
                $scope.locationList = response;
                if ($scope.editFlagMode == true) {
                    for (var i = 0; i < $scope.locationList.length; i++) {
                        if ($scope.locationList[i].nLocationID == $("#nLocationID").val()) {
                            $("#btn_nLocationID").val($scope.locationList[i].sRegionName);
                        }
                    }
                }
                $scope.displayLocation = function ($event) {
                    $(".locationList").show();
                }
            });
            adminServices.getListingObjArray("Manager").then(function (response) {
                $scope.managerList = response;
                if ($scope.editFlagMode == true) {
                    for (var i = 0; i < $scope.managerList.length; i++) {
                        if ($scope.managerList[i].ProdcertName == $("#Manager").val()) {
                            $("#btn_Manager").val($scope.managerList[i].sEmpName);
                        }
                        if ($scope.managerList[i].ProdcertName == $("#sManager").val()) {
                            $("#btn_sManager").val($scope.managerList[i].sEmpName);
                        }
                    }
                }
                $scope.displayManager = function ($event) {
                    $(".managerList").show();
                }
                $scope.displaysManager = function ($event) {
                    $(".managersList").show();
                }
            });
        }

        // do everything after view is loaded
        $scope.$watch('$viewContentLoaded', function () {
            getAllEntities();
            // if edit or add happens refresh time off listing
            $scope.$on('user:updated', function (event, data) {

                listTimeOffTypes();
            });
            listTimeOffTypes();
            function listTimeOffTypes() {
                adminServices.getListingObjArray("ListOfTimeOffs").then(function (response) {
                    $scope.timeOffList = response;
                    $scope.assignedTimeOff = '';
                    var timeOffList = response;
                    adminServices.getListingObjArray("EntitlementList").then(function (response) {
                        $scope.entitlementList = response;
                        $scope.displayEntitlement = function (policyId, policyName, e) {
                            $("#nEntitlementID").val(policyId);
                            $(".selEntitlement").html(policyName)
                            $(e.target).parent().parent().parent().parent().find(".dropdown-toggle").trigger("click");
                            $(".dropdown").find(".show").each(function () {
                                $(this).toggleClass("show");
                            });
                        }
                        adminServices.getListingObjArray("ApprovalList").then(function (response) {
                            $scope.notificationList = response;
                            $scope.displayNotification = function (policyId, policyName, e) {
                                $("#nNotificationID").val(policyId);
                                $(".selNotification").html(policyName);
                                $(e.target).parent().parent().parent().parent().find(".dropdown-toggle").trigger("click");
                                $(".dropdown").find(".show").each(function () {
                                    $(this).toggleClass("show");
                                });
                            }

                            if (($scope.editFlagMode == true) && ($("#duplicateAddFlag").val() =="0" )) {
                                if (employeeTimeOffsObj.length > 0) {
                                    $timeout(function() {
                                        $("[data-type='" + employeeTimeOffsObj[0].nRequestType + "']").trigger("click");
                                    }, 0);
                                    $timeout(function() {
                                        for (var indexTimeOff = 0; indexTimeOff < employeeTimeOffsObj.length; indexTimeOff++) {

                                            $("[data-type='" + employeeTimeOffsObj[indexTimeOff].nRequestType + "']").trigger("click");
                                            $("[data-entitlement='" + employeeTimeOffsObj[indexTimeOff].nLeaveEntitlementPolicyID + "']").trigger("click");
                                            $("[data-notification='" + employeeTimeOffsObj[indexTimeOff].nLeaveApprovalPolicyID + "']").trigger("click");
                                            $("#AssignBtn").trigger("click");

                                        }
                                    }, 0);
                                }
                            }
                        });
                    });
                    $scope.displayTimeOff = function (timeOffId, timeOffName, e) {
                        $("#nTimeOffID").val(timeOffId);
                        $(".selTimeOff").html(timeOffName);
                        var timeOffObj = employeeServices.giveValueOfAnotherMemberInArrayOfObjects(timeOffList, timeOffId, "");
                        $timeout(function () {
                            $("[data-entitlement='" + timeOffObj.nEntitlementPolicyID + "']").trigger("click");
                            $("[data-notification='" + timeOffObj.nApprovalPolicyID + "']").trigger("click");
                            $("[data-entitlement='" + timeOffObj.nEntitlementPolicyID + "']").parent().parent().parent().parent().find(".dropdown-toggle").trigger("click");
                            $("[data-notification='" + timeOffObj.nApprovalPolicyID + "']").parent().parent().parent().parent().find(".dropdown-toggle").trigger("click");
                            $(".error").removeClass("error");
                            $(".dropdown").find(".show").each(function () {
                                $(this).toggleClass("show");
                            });
                        }, 100);
                        //$(e.target).parent().parent().parent().parent().find(".dropdown-toggle").trigger("click");
                        $(".dropdown").find(".show").each(function () {
                            $(this).toggleClass("show");
                        });
                    }
                });
            }
        });
        $scope.firstManager = "";
        //functions for click events based on li of dropdown displayed
        $scope.addTitle = function (titleId, titleName) {
            $("#nTitleID").val(titleId);
            $("#btn_nTitleID").val(titleName);
            $(".titleList").hide();
        }
        $scope.addManager = function (managerProdCertName, managerName) {
            $scope.$evalAsync(function () {
                $scope.firstManager = managerName;
            });
            $("#Manager").val(managerProdCertName);
            $("#btn_Manager").val(managerName);
            $(".managerList").hide();
        }
        $("#btn_Manager").on("keyup", function () {
            $("#Manager").val($("#btn_Manager").val());
        })
        $scope.addsManager = function (managerProdCertName, managerName) {
            $("#sManager").val(managerProdCertName);
            $("#btn_sManager").val(managerName);
            $(".managersList").hide();
        }
        $("#btn_sManager").on("keyup", function () {
            $("#sManager").val($("#btn_sManager").val());
        })
        $scope.addDepartment = function (deptId, deptName) {
            $("#nDeptID").val(deptId);
            $("#btn_nDeptID").val(deptName);
            $(".departmentList").hide();
        }
        $scope.addTeam = function (teamId, teamName) {
            $("#nTeamID").val(teamId);
            $("#btn_nTeamID").val(teamName);
            $(".teamList").hide();
        }
        $scope.addLocation = function (locationId, locationName) {
            $("#nLocationID").val(locationId);
            $("#btn_nLocationID").val(locationName);
            $(".locationList").hide();
            if ($('#AssignTimeOff:checked').length > 0) {
                $scope.$evalAsync(function () {
                    $scope.assignFlag = true;
                });
            }
            $scope.locationObj = {};
            $scope.locationObj.nLocationID = locationId;

        }
        $scope.locationObj = {};
        $scope.locationObj.nLocationID = -1;
        $scope.locationTypeObj = function(locationObj){
            return locationObj.nLocationID == $scope.locationObj.nLocationID;
        };
        //angular jquery validate module used for validation
        var validateObj = validateObjectService.getValidateObj("TimeOffEmployee");
        $scope.evenTimeOffEmployeeFormvalidate = validateObj;
        $("#AssignTimeOff").on("click", function () {
            if ($('#AssignTimeOff:checked').length > 0) {
                if( $("#nLocationID").val() != ""){
                     $scope.$evalAsync(function () {
                        $scope.assignFlag = true;
                    });
                    adminServices.addRules();
                }
                else{
                     $("#nLocationID").valid();
                    
                }
               
            } else {
                $scope.$evalAsync(function () {
                    $scope.assignFlag = false;
                    $scope.selectedTimeOffTypes = [];
                    $scope.selectedEntitlement = [];
                    $scope.selectedApproval = [];
                });
                $("#timeOffsApplicable span:not(:first)").remove();
                adminServices.removeRules();
            }
        });
        //click event after clicking close button of assigned time off
        $(document).on("click", ".assign-close", function () {
            var timeOffArray = $("#selectedTimeOff").val().split(",");
            var timeOffIndex = timeOffArray.indexOf($(this).data("timeoffselected").toString());
            timeOffArray.splice(timeOffIndex, 1);
            $("#selectedTimeOff").val(timeOffArray.join(","));
            var EntitlementArray = $("#selectedEntitlement").val().split(",");
            EntitlementArray.splice(timeOffIndex, 1)
            $("#selectedEntitlement").val(EntitlementArray.join(","))
            var ApproverNotificationArray = $("#selectedApproverNotification").val().split(",");
            ApproverNotificationArray.splice(timeOffIndex, 1)
            $("#selectedApproverNotification").val(ApproverNotificationArray.join(","))
            $scope.$apply(function () {
                $scope.selectedTimeOffTypes.splice(timeOffIndex, 1);
                $scope.selectedEntitlement.splice(timeOffIndex, 1);
                $scope.selectedApproval.splice(timeOffIndex, 1);
            });
            $(this).parent().remove();
        });
        // click event for assigning time off for employee
        $(document).on("click", ".assignedTimeOffType", function () {
            $("#nTimeOffID").val($(this).data("timeoffselected"));
            $(".selTimeOff").html($(this).html());
            //= $scope.selectedTimeOffTypes.indexOf($(this).data('timeoffselected')); // this line doesnt wprk
            var index;
            for (var i = 0; i < $scope.selectedTimeOffTypes.length; i++) {
                if ($scope.selectedTimeOffTypes[i] == $(this).data('timeoffselected')) {
                    index = i;
                    break;
                }
            }
            $("[data-entitlement='" + $scope.selectedEntitlement[index] + "']").trigger("click");
            $("[data-notification='" + $scope.selectedApproval[index] + "']").trigger("click");
            $scope.editTimeOffIndex = $(this).data("timeoffselected");
            $(".dropdown").find(".show").each(function () {
                $(this).toggleClass("show");
            });
        })
        // event after clicking edit link of employee
        $scope.editEvent = function () {
            $('#' + employeeObj.gender).trigger("click");
            var managerArray = [];
            if (employeeObj.Manager.indexOf(",") != -1) {
                managerArray = employeeObj.Manager.split(",");
                $("#Manager").val($.trim(managerArray[0]));
                $("#sManager").val($.trim(managerArray[1]));
            } else {
                $("#Manager").val(employeeObj.Manager);
            }
            $("#sEmpID").val(employeeObj.ProdcertName);
            $("#dDateHired").val(Utils.defaultFormateDate(employeeObj.dDateHired.replace(/-/g, "/")));
            $("#nDeptID").val(employeeObj.nDeptID);
            $("#sEmployeeID").val(employeeObj.sEmpID);
            $("#nTeamID").val(employeeObj.nTeamID);
            $("#nTitleID").val(employeeObj.nTitleID);
            $("#sEmail").val(Utils.unescapeHtml(employeeObj.sEmail));
            $("#sEmpName").val(Utils.unescapeHtml(employeeObj.sEmpName));
            $("#sMobileNumber").val(Utils.unescapeHtml(employeeObj.sMobileNumber));
            $("#sPhoneNumber").val(Utils.unescapeHtml(employeeObj.sPhoneNumber));
            $("#nLocationID").val(employeeObj.nLocationID);
            $scope.locationObj = {};
            $scope.locationObj.nLocationID = employeeObj.nLocationID;
            getAllEntities();
            if (employeeTimeOffsObj.length > 0) {
                $('#AssignTimeOff').trigger("click");
            }
            $("#editFlagMode").val(employeeObj.nID);
            $("#nTimeOffID").val("");
            $("#nEntitlementID").val("");
            $("#nNotificationID").val("");
            $(".selTimeOff").html("Select Time Off");
            $(".selEntitlement").html("Select Policy");
            $(".selNotification").html("Select Policy");
            $(".error").removeClass("error");
        }
        var validateEmployeeObj = validateObjectService.getValidateObj("Employee");
        $scope.eventformvalidate = validateEmployeeObj;
        //click event after submitting assign time off form
        $scope.submitAssignTimeOffForm = function () {
            // add validation rules
            $("#nTimeOffID").rules("add", {
                required: true
            });
            $("#nEntitlementID").rules("add", {
                required: true
            });
            $("#nNotificationID").rules("add", {
                required: true
            });
            $('#nTimeOffID').valid();
            $('#nEntitlementID').valid();
            $('#nNotificationID').valid();
            if ($("#nTimeOffID").val() != "") {
                var index;
                var id = $("#nTimeOffID").val();
                if ($scope.selectedTimeOffTypes.indexOf($("#nTimeOffID").val()) == -1) {
                    index = $scope.selectedTimeOffTypes.length;
                    $("#selectedTimeOff").val($("#selectedTimeOff").val() + $("#nTimeOffID").val() + ",");
                    $("#selectedEntitlement").val($("#selectedEntitlement").val() + $("#nEntitlementID").val() + ",");
                    $("#selectedApproverNotification").val($("#selectedApproverNotification").val() + $("#nNotificationID").val() + ",");
                    $("#dummyTimeOff").clone().appendTo("#timeOffsApplicable");
                    $("#timeOffsApplicable").find("div").last().addClass("real").removeClass("hide");
                    $("#timeOffsApplicable").find("span").last().html('<a href="javascript:void(0)" class="assignedTimeOffType" data-timeoffSelected = "' + $('#nTimeOffID').val() + '">' + $(".selTimeOff").html() + '</a><i class="icon close assign-close" data-closeindex="' + index + '" data-timeoffselected="' + $('#nTimeOffID').val() + '"></i>');
                    //if($scope.selectedEntitlement.indexOf( $("#nEntitlementID").val()) == -1){
                    //$scope.selectedEntitlement[$scope.selectedEntitlement.length] = $("#nTimeOffID").val();
                    //}
                    //if($scope.selectedApproval.indexOf( $("#nNotificationID").val()) == -1){
                    //$scope.selectedApproval[$scope.selectedApproval.length] = $("#nNotificationID").val();
                    //}
                }
                else {
                    index = $scope.selectedTimeOffTypes.indexOf($("#nTimeOffID").val());
                    var EntitlementArray = $("#selectedEntitlement").val().split(",");
                    EntitlementArray[index] = $("#nEntitlementID").val();
                    $("#selectedEntitlement").val(EntitlementArray.join(","))
                    var ApproverNotificationArray = $("#selectedApproverNotification").val().split(",");
                    ApproverNotificationArray[index] = $("#nNotificationID").val()
                    $("#selectedApproverNotification").val(ApproverNotificationArray.join(","))
                }
                $scope.selectedTimeOffTypes[index] = $("#nTimeOffID").val();
                $scope.selectedEntitlement[index] = $("#nEntitlementID").val();
                $scope.selectedApproval[index] = $("#nNotificationID").val();
                $("#nTimeOffID").val("");
                $("#nEntitlementID").val("");
                $("#nNotificationID").val("");
                $(".selTimeOff").html("Select Time Off");
                $(".selEntitlement").html("Select Policy");
                $(".selNotification").html("Select Policy");
                $(".error").removeClass("error");
                // remove validate rules
                if ($("#selectedTimeOff").val() != "") {
                    $("#nTimeOffID").rules("add", {
                        required: false
                    });
                    $("#nEntitlementID").rules("add", {
                        required: false
                    });
                    $("#nNotificationID").rules("add", {
                        required: false
                    });
                }
            }
        }
    }]);
})();
/**
 * Created by Shrujan    on 4/2/2015.
 */
(function () {
    app.controller('approvalCtrl', ["$scope", "approveTimeOffService", "adminServices", "validateObjectService", "Utils", "employeeServices", "$location", function ($scope, approveTimeOffService, adminServices, validateObjectService, Utils, employeeServices, $location) {

        // check if access is only to admin and manager
        if ($scope.levelFlag != "Manager" && $scope.levelFlag != "Admin") {
            $location.path("/applyleave");
        }
        $scope.eventFormvalidate = {
            validateOnInit: false
        };
        // approveTimeOffService.retrievePendingTimeOffs().then(function(){
        $scope.pendingList;
        $scope.pendingListCount = -1;
        $scope.approvedList;
        $scope.rejectedList;
        $scope.approvedListCount = -1;
        $scope.rejectedListCount = -1;
        $scope.regionList = []
        $scope.filterCountryList = [];
        var selectedTimeOffs = [];
        var action;
        $(document).ready(function () {
            $(document).off().on("click", ".detailLink", function () {
                $(this).parent().parent().next('.DetailsTab').slideToggle();
            });
        })
        fetchAllList([]);
        function fetchAllList(locations) {
            approveTimeOffService.retrievePendingTimeOffs(1, locations).then(function (response) {
                $scope.pendingList = response.MyTimeOffApprovals;
                $scope.pendingListCount = response.TotalTimeOffCount;
            })
            approveTimeOffService.retrieveApprovedTimeOffs(1, locations).then(function (response) {
                $scope.approvedList = response.MyTimeOffApprovals;
                $scope.approvedListCount = response.TotalTimeOffCount;
            })
            approveTimeOffService.retrieveRejectedTimeOffs(1, locations).then(function (response) {
                $scope.rejectedList = response.MyTimeOffApprovals;
                $scope.rejectedListCount = response.TotalTimeOffCount;
            })
            adminServices.getListingObjArray("Location").then(function (response) {
                var locationLists = response;
                for (var i = 0; i < locationLists.length; i++) {
                    $scope.regionList[i] = locationLists[i];
                }
            });
        }

        $(document).ready(function () {
            $(document).on("click", '.timeoff-tabs-container li', function (event) {
                $('.timeoff-tabs-container li').removeClass('active');
                $(this).addClass('active');
                var id = $(this).data('tabid');
                $('.tab-pane').hide();
                $("#" + id).show();
                $("#" + id).css("visibility", "visible");
                return false;
            });
            $(document).mouseup(function (e) {
                var container = $(".approve-filter .dropdown");
                if (!container.is(e.target) // if the target of the click isn't the container...
                    && container.has(e.target).length === 0) // ... nor a descendant of the container
                {
                    if ($(" .approve-filter .dropdown-menu").hasClass("show")) {
                        $(".approve-filter .dropdown-menu").toggleClass("show");
                        // container.parent().find(".dropdown-toggle").trigger("click");
                    }
                }
            });
        })
        //$scope.pendingListCount = 100;
        $scope.pageChangedPending = function (newPage, listType) {
            approveTimeOffService.retrievePendingTimeOffs(newPage, $scope.filterCountryList).then(function (response) {
                $scope.pendingList = response.MyTimeOffApprovals;
                $scope.pendingListCount = response.TotalTimeOffCount;
            })
        };
        $scope.approvedPageChanged = function (newPage, listType) {
            approveTimeOffService.retrieveApprovedTimeOffs(newPage, $scope.filterCountryList).then(function (response) {
                $scope.approvedList = response.MyTimeOffApprovals;
                $scope.approvedListCount = response.TotalTimeOffCount;
            })
        };
        $scope.rejectedPageChanged = function (newPage, listType) {
            approveTimeOffService.retrieveRejectedTimeOffs(newPage, $scope.filterCountryList).then(function (response) {
                $scope.rejectedList = response.MyTimeOffApprovals;
                $scope.rejectedListCount = response.TotalTimeOffCount;
            })
        };
        $scope.selectAllPendingTimeOffs = function () {
            var status;
            if ($("#ApprovalList").prop("checked")) {
                status = true;
                $(".pending-timeoff").addClass("enable");
                $("#approve-btn").removeAttr('disabled');
                $("#reject-btn").removeAttr('disabled');
            }
            else {
                status = false;
                $(".pending-timeoff").removeClass("enable");
                $("#approve-btn").attr('disabled', 'disabled');
                $("#reject-btn").attr('disabled', 'disabled');
                $(".error").removeClass("error");
            }
            
            //Clearing the selected timeoff id's before applying either select all or deselect all
            selectedTimeOffs = [];
            
            for (var key in $scope.pendingList) {
                if (status) {
                    if($scope.pendingList[key].sAction[0] != 'No Action'){
                        selectedTimeOffs.push($scope.pendingList[key].nID);
                        $("#pending_" + $scope.pendingList[key].nID).prop("checked", "checked");
                    }
                    //$('.bulk-selection').css("max-height",'500px');
                } else {
                    $("#pending_" + $scope.pendingList[key].nID).prop("checked", "");
                    //$('.bulk-selection').css("max-height",'0px');
                }
            }
            
            //If there are no timeoffs to select for approve or reject
            if(!selectedTimeOffs.length && status) {
            	$("#approve-btn").attr('disabled', 'disabled');
            	$("#reject-btn").attr('disabled', 'disabled');
            }
            
            console.log(selectedTimeOffs)
        }
        $scope.selectIndividualTimeOffs = function (id) {
            if (selectedTimeOffs.indexOf(id) == -1) {
                $("#approve-btn").removeAttr('disabled');
                $("#reject-btn").removeAttr('disabled');
                selectedTimeOffs[selectedTimeOffs.length] = id;
                if (selectedTimeOffs.length == $scope.pendingList.length)
                    $('#ApprovalList').prop("checked", true)
            }
            else {
                $('#ApprovalList').prop("checked", false);

                var curSelectedTimeoffElem = $("#comment_" + id);
                curSelectedTimeoffElem.rules("remove", "required");
                curSelectedTimeoffElem.rules("remove", "messages");
                selectedTimeOffs.splice(selectedTimeOffs.indexOf(id), 1);
                
                if (selectedTimeOffs.length == 0) {
                    $("#approve-btn").attr('disabled', 'disabled');
                    $("#reject-btn").attr('disabled', 'disabled');
                    $(".error").removeClass("error");
                }
            }
        }
        $scope.sendEmail = function () {
            approveTimeOffService.sendDetailsRequest("Email", selectedTimeOffs);
        }
        $(document).ready(function(){
            $('#timeOfStatusObj').on("click", function () {
                $('.approve-filter .dropdown-toggle').dropdown();
                $(".approve-filter .dropdown-menu").toggleClass("show");
            });
        });

        $scope.convertDate = function (dateStr) {
            if (dateStr != undefined)
                return Utils.convertDateString(dateStr)
            else
                return "N.A"
        }
        $scope.updateCountry = function (regionId) {
            if ($scope.filterCountryList.indexOf(regionId) == -1) {
                $scope.filterCountryList[$scope.filterCountryList.length] = regionId
            }
            else {
                $scope.filterCountryList.splice($scope.filterCountryList.indexOf(regionId), 1);
            }
        }
        // });
        $scope.refreshList = function () {
            $scope.pendingList = [];
            $scope.approvedList = [];
            $scope.rejectedList = [];
            $scope.pendingListCount = 0;
            $scope.approvedListCount = 0;
            $scope.rejectedListCount = 0;
            $(".dropdown-menu").hide();
            approveTimeOffService.retrievePendingTimeOffs(1, $scope.filterCountryList).then(function (response) {
                $scope.pendingList = response.MyTimeOffApprovals;
                $scope.pendingListCount = response.TotalTimeOffCount;
            })
            approveTimeOffService.retrieveApprovedTimeOffs(1, $scope.filterCountryList).then(function (response) {
                $scope.approvedList = response.MyTimeOffApprovals;
                $scope.approvedListCount = response.TotalTimeOffCount;
            })
            approveTimeOffService.retrieveRejectedTimeOffs(1, $scope.filterCountryList).then(function (response) {
                $scope.rejectedList = response.MyTimeOffApprovals;
                $scope.rejectedListCount = response.TotalTimeOffCount;
            })
        }
        $scope.showApproveConfirmation = function () {
        	//Remove the validation rules added for comments box
        	//since reason is not required to be entered for approval
        	toggleTimeOffApprovalValidations(true);
        	
            if ($("#pendingListForm").valid()) {
                $("#approve_timeoff").modal("show");
            }
        }
        
        //Toggle the validations
        //If approval remove the required validation on reason
        //If reject, re-apply the required validation
        function toggleTimeOffApprovalValidations(isApproval) {
        	
        	var selectedTimeOffLen = selectedTimeOffs.length;
        	for(var i=0; i < selectedTimeOffLen; ) {
        		var currentTimeOffElem = $("#comment_" + selectedTimeOffs[i]);
        		
        		if(currentTimeOffElem.length) {
        			if(isApproval) {
        				currentTimeOffElem.rules("remove", "required");
        				currentTimeOffElem.rules("remove", "messages");
        			} else {
        				currentTimeOffElem.rules("add", {required: true, "messages": {required: "Please enter comments"}});
        			}
        			
        			i++;
        		} else {
        			selectedTimeOffs.splice(i, 1);
        			selectedTimeOffLen = selectedTimeOffs.length;
        		}
        	}
        }
        
        $scope.approveTimeOffs = function () {
            $("#approve_timeoff").modal("hide");
            var body = constructBody();
            if (body.length > 0) {
                approveTimeOffService.sendDetailsRequest('Approve', body).then(function () {
                    fetchAllList([]);
                    $(".timeoff-approve-succ").fadeIn().fadeOut(5000);
                    $('html, body').animate({scrollTop: 0}, 800);
                    $("#approve-btn").attr('disabled', 'disabled');
                    $("#reject-btn").attr('disabled', 'disabled');
                }, function (response) {
                    if (response[0].error == null) {
                        $(".timeoff-approve-fail").fadeIn().fadeOut(5000);
                    }
                    $('html, body').animate({scrollTop: 0}, 800);
                });
            }
        }
        $scope.closeApproveConfirmation = function () {
            $("#approve_timeoff").modal("hide");
        }
        $scope.showRejectConfirmation = function () {
        	
        	toggleTimeOffApprovalValidations(false);
            
        	if ($("#pendingListForm").valid()) {
                $("#reject_timeoff").modal("show");
            }
        }
        $scope.rejectTimeOffs = function () {
            $("#reject_timeoff").modal("hide");
            var body = constructBody();
            if (body.length > 0) {
                approveTimeOffService.sendDetailsRequest('Reject', body).then(function () {
                    fetchAllList([]);
                    $(".timeoff-reject-succ").fadeIn().fadeOut(5000);
                    $('html, body').animate({scrollTop: 0}, 800);
                    $("#approve-btn").attr('disabled', 'disabled');
                    $("#reject-btn").attr('disabled', 'disabled');
                }, function (response) {
                    if (response[0].error == null) {
                        $(".timeoff-reject-fail").fadeIn().fadeOut(5000);
                    }
                    $('html, body').animate({scrollTop: 0}, 800);
                });
            }
        }
        function constructBody() {
            var requestBody = [];
            for (var i = 0; i < selectedTimeOffs.length; i++) {
            	var currentTimeOffComment = $("#comment_" + selectedTimeOffs[i]).val();
            	currentTimeOffComment = (currentTimeOffComment) ? currentTimeOffComment : '';
            	
            	//if(currentTimeOffComment) {
            		var temp = {};
            		temp.nID = selectedTimeOffs[i];
            		temp.sComment = Utils.escapeHtml(currentTimeOffComment);
            		requestBody.push(temp);
            	//}
            }
            return requestBody;
        }

        var cancelObj = {}
        $scope.closeRejectConfirmation = function () {
            $("#reject_timeoff").modal("hide");
        }
        $scope.cancelPopupDisplay = function (id, requestor, submittedBy, requestType) {
            cancelObj.toBeCancelledId = id;
            cancelObj.requestor = requestor;
            cancelObj.submittedBy = submittedBy;
            cancelObj.requestType = requestType;
            $("#cancelLeaveReason").val("");
            Utils.clearFormValidations();
            $("#cancel_timeoff").modal("show");
        }
        $scope.closeCancelConfirmation = function () {
            $("#cancel_timeoff").modal("hide");
        }
        $scope.cancelTimeOffs = function () {
            if ($scope.cancelReason == "" || $scope.cancelReason == undefined) {
                $("#cancelLeaveReason").addClass("error");
            }
            else {
                Utils.clearFormValidations();
                var body = [{
                    "nID": cancelObj.toBeCancelledId,
                    "sComment": $scope.cancelReason
                }];
                $scope.cancelReason == "";
                if (body.length > 0) {
                    approveTimeOffService.sendDetailsRequest('Reject', body).then(function () {
                        $scope.closeCancelConfirmation();
                        fetchAllList([]);
                        $(".timeoff-reject-succ").fadeIn().fadeOut(5000);
                        $('html, body').animate({scrollTop: 0}, 800);
                        $("#approve-btn").attr('disabled', 'disabled');
                        $("#reject-btn").attr('disabled', 'disabled');
                    }, function (response) {
                        $scope.closeCancelConfirmation();
                        if(response[0].error == null ) {
                                $(".timeoff-reject-fail").fadeIn().fadeOut(5000);
                            }
                        $('html, body').animate({scrollTop: 0}, 800);
                    });
                }
            }
        }
    }]);
})();
/**
 * Factory used for operations related to approve time off page
 */
(function () {
    'use strict';
    angular.module('timeOffCommvaultApp.approveTimeOffService', ['restangular'])
        .factory('approveTimeOffService', ["Restangular", "$q", "$http", "Utils", "configService", "employeeServices", function (Restangular, $q, $http, Utils, configService, employeeServices) {
            var URL = (employeeServices.getEnvironment() == 'dev') ? configService.returnDevUrl() : configService.returnProdUrl();
            var environment = employeeServices.getEnvironment();

            function retrievePendingTimeOffs(pageNo, location) {
                var deferred = $q.defer();
                var requestParams = {
                    "alias": employeeServices.getProdcertName(),
                    "status": "Submitted",
                    "pageno": pageNo,
                    "pageSize": 7,
                    'locations': location
                };
                var urlObj = Restangular.all(URL.pendingTimeOff);
                if (environment == 'dev') {
                    urlObj.getList().then(function (resp) {
                        if (Utils.isValidResponse(resp[0])) {
                            deferred.resolve(resp[0].data[0]);
                        }
                        else {
                            deferred.reject(resp);
                        }
                    }, function (resp) {
                       // deferred.resolve({"success": true});
                        deferred.reject(resp);
                    });
                }
                else {
                    urlObj.post(requestParams, "get", {csrf: Utils.getCsrfToken()}).then(function (resp) {
                        if (resp[0].data == null) {
                            resp[0].data = [{"MyTimeOffApprovals": [], "TotalTimeOffCount": 0}];
                        }
                        if (Utils.isValidResponse(resp[0])) {
                            deferred.resolve(resp[0].data[0]);
                        }
                        else {
                            deferred.reject(resp);
                        }
                    }, function (resp) {
                        //deferred.resolve({"success": true});
                        deferred.reject(resp);
                    });
                }
                return deferred.promise;
            }

            function retrieveApprovedTimeOffs(pageNo, location) {
                var deferred = $q.defer();
                var requestParams = {
                    "alias": employeeServices.getProdcertName(),
                    "status": "Approved",
                    "pageno": pageNo,
                    "pageSize": 7,
                    'locations': location
                };
                var urlObj = Restangular.all(URL.pendingTimeOff);
                if (environment == 'dev') {
                    urlObj.getList().then(function (resp) {
                        if (Utils.isValidResponse(resp[0])) {
                            deferred.resolve(resp[0].data[0]);
                        }
                        else {
                            deferred.reject(resp);
                        }
                    }, function (resp) {
                        deferred.resolve({"success": true});
                        //deferred.reject(resp);
                    });
                }
                else {
                    urlObj.post(requestParams, "get", {csrf: Utils.getCsrfToken()}).then(function (resp) {
                        if (resp[0].data == null) {
                            resp[0].data = [{"MyTimeOffApprovals": [], "TotalTimeOffCount": 0}];
                        }
                        if (Utils.isValidResponse(resp[0])) {
                            deferred.resolve(resp[0].data[0]);
                        }
                        else {
                            deferred.reject(resp);
                        }
                    }, function (resp) {
                       // deferred.resolve({"success": true});
                        deferred.reject(resp);
                    });
                }
                return deferred.promise;
            }

            function retrieveRejectedTimeOffs(pageNo, location) {
                var deferred = $q.defer();
                var requestParams = {
                    "alias": employeeServices.getProdcertName(),
                    "status": "Rejected",
                    "pageno": pageNo,
                    "pageSize": 7,
                    'locations': location
                };
                var urlObj = Restangular.all(URL.pendingTimeOff);
                if (environment == 'dev') {
                    urlObj.getList().then(function (resp) {
                        if (Utils.isValidResponse(resp[0])) {
                            deferred.resolve(resp[0].data[0]);
                        }
                        else {
                            deferred.reject(resp);
                        }
                    }, function (resp) {
                        deferred.resolve({"success": true});
                        //deferred.reject(resp);
                    });
                }
                else {
                    urlObj.post(requestParams, "get", {csrf: Utils.getCsrfToken()}).then(function (resp) {
                        if (resp[0].data == null) {
                            resp[0].data = [{"MyTimeOffApprovals": [], "TotalTimeOffCount": 0}];
                        }
                        if (Utils.isValidResponse(resp[0])) {
                            deferred.resolve(resp[0].data[0]);
                        }
                        else {
                            deferred.reject(resp);
                        }
                    }, function (resp) {
                       // deferred.resolve({"success": true});
                        deferred.reject(resp);
                    });
                }
                return deferred.promise;
            }

            function sendDetailsRequest(type, body) {
                var deferred = $q.defer();
                var url;
                if (type == "Email") {
                    url = URL.sendEmail;
                }
                else if (type == "Approve") {
                    url = URL.approveTimeOff;
                }
                else if (type == "Reject") {
                    url = URL.rejectTimeOff;
                }
                var requestParams = body;
                var urlObj = Restangular.all(url);
                urlObj.post(requestParams, "get", {csrf: Utils.getCsrfToken()}).then(function (resp) {
                    if (resp[0].data == null) {
                        resp[0].data = [{"MyTimeOffApprovals": [], "TotalTimeOffCount": 0}];
                    }
                    //urlObj.getList().then(function(resp) {
                    if (Utils.isValidResponse(resp[0])) {
                        deferred.resolve(resp[0].data[0]);
                    }
                    else {
                        deferred.reject(resp);
                    }
                }, function (resp) {
                   // deferred.resolve({"success": true});
                    deferred.reject(resp);
                });
                return deferred.promise;
            }

            return {
                "retrievePendingTimeOffs": retrievePendingTimeOffs,
                "retrieveApprovedTimeOffs": retrieveApprovedTimeOffs,
                "retrieveRejectedTimeOffs": retrieveRejectedTimeOffs,
                "sendDetailsRequest": sendDetailsRequest
            }
        }]);
})();

/**
 * Created by Shrujan    on 4/2/2015.
 */
(function () {
    app.controller('reportsCtrl', ["$scope", "approveTimeOffService", "adminServices", "validateObjectService", "Utils", "employeeServices", "timeOffDateDiffService", 'reportsService', "$location", "i8nConstants", function ($scope, approveTimeOffService, adminServices, validateObjectService, Utils, employeeServices, timeOffDateDiffService, reportsService, $location, i8nConstants) {
        if ($scope.levelFlag != "Manager" && $scope.levelFlag != "Admin") {
            $location.path("/applyleave");
        }
        $scope.halfDay = -1;
        $scope.loggedInUser = employeeServices.getProdcertName()
        $scope.teamMembers = employeeServices.getTeamMembers();
        $scope.leaveTypes = employeeServices.getLeaveTypes();
        timeOffDateDiffService.setTimeOffStartDate(undefined);
        timeOffDateDiffService.setTimeOffEndDate(undefined)
        $scope.regionList = [];
        $scope.report = [];
        $scope.loadingFlag = true;
        var selectedTeamMember = '';
        var selectedRegion = '';
        var leaveType = '';
        var startDate = '';
        var endDate = '';
        var pageNo = 1;
        $scope.startDate = '';
        $scope.endDate = '';
        $("#enddate").on("keydown", function (e) {
            return Utils.keepDateFieldReadable(e);
        });
        $("#startdate").on("keydown", function (e) {
            return Utils.keepDateFieldReadable(e);
        });
        $('.dropdown-toggle').off().on("click", function () {
            $(this).dropdown();
            $(this).parent().find(".dropdown-menu").toggleClass("show");
        });
        $(document).mouseup(function (e) {
            $(".dropdown-div .dropdown").find(".show").each(function () {
                $(this).toggleClass("show");
            });
        });
        adminServices.getListingObjArray("Location").then(function (response) {
            var locationLists = response;
            for (var i = 0; i < locationLists.length; i++) {
                $scope.regionList[i] = locationLists[i];
            }
        });
        refreshList();
        function refreshList() {
            reportsService.retrieveReports(pageNo, 10, startDate, endDate, selectedTeamMember, selectedRegion, leaveType).then(function (response) {
                if (response != undefined) {
                    $scope.report = response.MyTimeOffApprovals;
                    $scope.reportCount = response.TotalTimeOffCount;
                } else {
                    $scope.report = [];
                    $scope.reportCount = 0;
                }
                $scope.loadingFlag = false;
            }, function () {
                $scope.report = [];
                $scope.reportCount = 0;
                $scope.loadingFlag = false;
            })
        }

        $scope.selectTeam = function (teamName, e) {
            selectedTeamMember = teamName;
            if (teamName == "") {
                $("#EmpSearchName .selVal").html(i8nConstants.SELECT_AN_EMPLOYEE_NAME)
            }
            else {
                $("#EmpSearchName .selVal").html(teamName)
            }
            $(e.target).parent().parent().parent().parent().find(".dropdown-toggle").trigger("click");
            $(".dropdown-div .dropdown").find(".show").each(function () {
                $(this).toggleClass("show");
            });
            //$(e).toggleClass("show");
        }
        $scope.selectTimeOffType = function (timeoffId, timeoffType, e) {
            if (timeoffType == "") {
                $("#SearchTimeOffType .selVal").html(i8nConstants.SELECT_TIME_OFF_TYPE);
                leaveType = '';
            }
            else {
                leaveType = timeoffId;
                $("#SearchTimeOffType .selVal").html(timeoffType)
            }
            $(e.target).parent().parent().parent().parent().find(".dropdown-toggle").trigger("click");
            $(".dropdown-div .dropdown").find(".show").each(function () {
                $(this).toggleClass("show");
            });
        }
        $scope.selectRegion = function (regionId, regionName, e) {
            if (regionName == "") {
                $("#searchLocation .selVal").html(i8nConstants.SELECT_LOCATION);
                selectedRegion = '';
            }
            else {
                selectedRegion = regionId;
                $("#searchLocation .selVal").html(regionName)
            }
            $(e.target).parent().parent().parent().parent().find(".dropdown-toggle").trigger("click");
            $(".dropdown-div .dropdown").find(".show").each(function () {
                $(this).toggleClass("show");
            });
        }
        $scope.pageChanged = function (pageno) {
            pageNo = pageno;
            refreshList();
        }
        $scope.filterNow = function () {
            pageNo = 1;
            startDate = (timeOffDateDiffService.getTimeOffStartDate() == undefined) ? "" : ((timeOffDateDiffService.getTimeOffStartDate().getMonth() + 1 < 10 ) ? "0" : "") + (timeOffDateDiffService.getTimeOffStartDate().getMonth() + 1) + "/" + ((timeOffDateDiffService.getTimeOffStartDate().getDate() < 10) ? "0" : "") + timeOffDateDiffService.getTimeOffStartDate().getDate() + "/" + timeOffDateDiffService.getTimeOffStartDate().getFullYear();
            endDate = (timeOffDateDiffService.getTimeOffEndDate() == undefined) ? "" : ((timeOffDateDiffService.getTimeOffEndDate().getMonth() +1 < 10 ) ? "0" : "") + (timeOffDateDiffService.getTimeOffEndDate().getMonth() + 1) + "/" + ((timeOffDateDiffService.getTimeOffEndDate().getDate() < 10) ? "0" : "") + timeOffDateDiffService.getTimeOffEndDate().getDate() + "/" + timeOffDateDiffService.getTimeOffEndDate().getFullYear();
            if (endDate != "" && endDate != null)
                $scope.endDate = Utils.convertDateString(timeOffDateDiffService.getTimeOffEndDate());
            else
                $scope.endDate = '';
            if (startDate != "" && startDate != null)
                $scope.startDate = Utils.convertDateString(timeOffDateDiffService.getTimeOffStartDate());
            else
                $scope.startDate = '';
            refreshList();
        }
        $scope.convertDate = function (dateStr) {
            if (dateStr != undefined)
                return Utils.convertDateString(dateStr)
            else
                return "N.A"
        }
    }]).controller('datePickerCtrl', ["$scope", "timeOffDateDiffService", "employeeServices", "$timeout", "Utils", "$location", function ($scope, timeOffDateDiffService, employeeServices, $timeout, Utils, $location) {
        // $scope.halfDay = 0;
        $scope.clear = function () {
            $scope.dt = null;
        };
        if (($location.path() == "/applyleave") || ($location.path() == "/reports")) {
            $scope.startdate = undefined;
            $scope.enddate = undefined;
            timeOffDateDiffService.setTimeOffStartDate($scope.startdate);
            timeOffDateDiffService.setTimeOffEndDate($scope.enddate);
        }
        $(document).ready(function () {
            $scope.setDate = function () {
                if ($scope.startdate == null) {
                    $(".day-option").first().val("0");
                    $(".day-option:not(:first)").first().val("0");
                }
                
                if($(".day-option").first().val()=="0"){
                    $("#enddate").val(undefined);
                    $("#dExpiryDate").val(undefined);
                }
                
                timeOffDateDiffService.setTimeOffStartDate($scope.startdate);

                if (timeOffDateDiffService.getTimeOffStartDate() == undefined) {
                    $(".blue-popover").hide();
                } else {
                    console.log($scope.startdate);
                        if($scope.enddate == undefined){
                            timeOffDateDiffService.setTimeOffEndDate($scope.startdate);
                        }



                   // $("#enddate").val(Utils.defaultDateFormat($scope.startdate));

                    //$("#enddate").trigger("change");
                    if (($(".datepicker").first().find(".day-option").first().val() != 0 ) && ($(".datepicker").first().find(".day-option").first().val() != undefined)) {
                        $("#enddate").val(Utils.defaultDateFormat($scope.startdate));
                        timeOffDateDiffService.setTimeOffEndDate(new Date($("#enddate").val().replace(/-/g, "/")));
                        $(".datepicker:not(:first)").first().find(".day-option").first().val($(".datepicker").first().find(".day-option").first().val());

                        $scope.$evalAsync(function(){
                            $scope.daysOfAbsence = 1;
                            $scope.halfDayFlag = true;
                            //$scope.halfDaySection = $(".datepicker").first().find(".day-option").first().find('option:selected').text();
                        });
                        $(".blue-popover").show();
                    } else if (timeOffDateDiffService.getTimeOffEndDate() != null || $scope.enddate != null || $scope.enddate == undefined) {
                        $(".blue-popover").hide();
                        /*$("#enddate").val(undefined);
                        $(".blue-popover").hide();*/
                        //$("#enddate").val(Utils.defaultDateFormat($scope.startdate));

                       /* timeOffDateDiffService.setTimeOffEndDate(new Date($("#enddate").val().replace(/-/g, "/")));
                        $(".datepicker:not(:first)").first().find(".day-option").first().val($(".datepicker").first().find(".day-option").first().val());
                        $scope.daysOfAbsence = 1;
                        $scope.halfDayFlag = false;
                        $scope.halfDaySection = $(".datepicker").first().find(".day-option").first().val();
                        $(".blue-popover").show();*/
                    }
                }
            }
            $scope.setDate();
        });
        $scope.disabled = function (date, mode) {
            return employeeServices.getDisabledHolidays(date, mode);
        }
        $scope.calDate = function () {
            employeeServices.setOptionalLeavesArray([]);
            timeOffDateDiffService.setTimeOffEndDate($scope.enddate);
            if (timeOffDateDiffService.getTimeOffEndDate() == undefined) {
                $(".blue-popover").hide();
            } else {
                if (timeOffDateDiffService.getTimeOffStartDate() != null) {
                    if (typeof(timeOffDateDiffService.getTimeOffStartDate()) == "string") {
                        timeOffDateDiffService.setTimeOffStartDate(new Date(timeOffDateDiffService.getTimeOffStartDate().replace(/-/g, "/") + " 00:00:00"));
                    }
                    if (timeOffDateDiffService.getTimeOffStartDate().getTime() != timeOffDateDiffService.getTimeOffEndDate().getTime()) {
                        if($(".day-option").first().val() == "0"){
                           // $scope.halfDayFlag = false;
                            $(".day-option").first().val("0");
                            $(".day-option:not(:first)").first().val("0");
                        }
                    }
                    $('.blue-popover').show();
                    $(".optional-leave-div").show();
                    $(".error_enddate").hide();
                    $scope.optionalDivShowFlag = true;
                    $scope.daysOfAbsence = timeOffDateDiffService.calculateDays();
                    timeOffDateDiffService.setDaysOfAbsence($scope.daysOfAbsence);
                    $scope.optionalLeaveDetails = timeOffDateDiffService.getOptionalLeaveDetails();
                }
            }
        }
        var optionalLeaveTakenArray = [];
        $scope.consumeLeave = function (element, optionalLeave) {
            $scope.daysOfAbsence = $scope.daysOfAbsence - 1;
            timeOffDateDiffService.setDaysOfAbsence($scope.daysOfAbsence);
            if(optionalLeaveTakenArray.indexOf(Utils.respDateFormat(optionalLeave, true)) == -1){

                optionalLeaveTakenArray.push(Utils.respDateFormat(optionalLeave, true));
            }
            employeeServices.setOptionalLeavesArray(optionalLeaveTakenArray);
            //$scope.optionalDivShowFlag = false;
            $(element.target).parent().parent().hide();
        }
        $scope.doNotConsumeLeave = function (element) {
            //$scope.daysOfAbsense = $scope.daysOfAbsense - $scope.optionalLeaveDetails.length;
            //    $scope.optionalDivShowFlag = false;
            $(element.target).parent().parent().hide();
        }
        // Disable weekend selection
        $scope.toggleMin = function () {
        };
        $scope.toggleMin();
        $scope.dateOptions = {
            showWeeks: 'false',
            dateFormat: 'dd-MMM-YYYY'
        };

        $scope.select = function (val) {
        }
        $scope.openStartDate = function ($event) {
            $(document).on("click", ".btn-danger", function () {
            });
            if ($scope.halfDay == -1) {
                $(".day-option").hide();
            }
            if (($scope.halfDay !== "0") && ( $(".day-option").first().val() == "0")) {
                $(".day-option").first().val($scope.halfDay.toString());
                $(".day-option:not(:first)").first().val($scope.halfDay.toString());
            }
            $scope.showWeeks = false;
            // $event.preventDefault();
            $event.stopPropagation();
            $scope.opened = true;
        };
        $scope.openEndDate = function ($event) {

           // $scope.enddate = Utils.defaultDateFormat(timeOffDateDiffService.getTimeOffEndDate());
           // $("#enddate").val(Utils.defaultDateFormat($scope.enddate))
           // $scope.enddate = undefined;
            employeeServices.setOptionalLeavesArray([]);
            if ($scope.halfDay == -1) {
                $(".day-option").hide();
            }
            $scope.showWeeks = false;
            $scope.minDate = (timeOffDateDiffService.getTimeOffStartDate() == undefined) ? undefined : new Date(timeOffDateDiffService.getTimeOffStartDate());

                //$scope.enddate = (timeOffDateDiffService.getTimeOffStartDate() == undefined) ? undefined : (typeof(timeOffDateDiffService.getTimeOffStartDate())== "string")? new Date(timeOffDateDiffService.getTimeOffStartDate().replace(/-/g,"/")):new Date(timeOffDateDiffService.getTimeOffStartDate());


            $scope.dateOptions = {
                formatYear: 'yy',
                startingDay: 1
            };
            if ($scope.halfDay !== "0") {
                $(".day-option").first().val($scope.halfDay.toString());
                $(".day-option:not(:first)").first().val($scope.halfDay.toString());
            }
            if ($scope.halfDayFlag == true) {
                $scope.opened = false;
                //$scope.halfDaySection = $(".datepicker").first().find(".day-option").first().find('option:selected').text();
            } else {
                $scope.opened = true;
                $scope.dateOptions.showButtonBar = true;
                $scope.dateOptions.dateDisabled = false;
            }

            if(timeOffDateDiffService.getTimeOffEndDate() != undefined)
                $scope.enddate = new Date(timeOffDateDiffService.getTimeOffEndDate());

            if(($("#dExpiryDate").length > 0 ) && ($("#dExpiryDate").val()!="")){
                $scope.enddate = new Date($("#dExpiryDate").val().replace(/-/g,"/"));
            }
            if(($(".enddateclass").length > 0 ) && ($("#enddate").val()!="")){
                $scope.enddate = new Date($("#enddate").val().replace(/-/g,"/"));
            }
            $scope.calDate();




            $event.stopPropagation();
        };
        $scope.format = 'dd-MMMM-yyyy';
    }]).directive('datepickerPopup', function (){
        return {
            restrict: 'EAC',
            require: 'ngModel',
            link: function(scope, element, attr, controller) {
                //remove the default formatter from the input directive to prevent conflict
                controller.$formatters.shift();
            }
        }
    });
})();
/**
 * Factory responsible for all operations related to  reports
 */
(function () {
    angular.module('timeOffCommvaultApp.reportsService', ['restangular'])
        .factory('reportsService', ["Restangular", "Utils", "$q", "$timeout", "$http", "employeeServices", "configService", function (Restangular, Utils, $q, $timeout, $http, employeeServices, configService) {
            var URL = (employeeServices.getEnvironment() == 'dev') ? configService.returnDevUrl() : configService.returnProdUrl();
            var environment = employeeServices.getEnvironment();

            function setURL() {
            }

            function retrieveReports(pageNo, pageSize, startDate, endDate, employeeName, locationId, timeOffTypeId) {
                var deferred = $q.defer();
                var requestParams = constructBody(pageNo, pageSize, startDate, endDate, employeeName, locationId, timeOffTypeId);
                var urlObj = Restangular.all(URL.managerReports);
                if (environment == 'dev') {
                    urlObj.getList().then(function (resp) {
                        if (Utils.isValidResponse(resp[0])) {
                            deferred.resolve(resp[0].data[0]);
                        }
                        else {
                            deferred.reject(resp);
                        }
                    });
                }
                else {
                    urlObj.post(requestParams, "get", {csrf: Utils.getCsrfToken()}).then(function (resp) {
                        if (Utils.isValidResponse(resp[0])) {
                            if (resp[0].data == null) {
                                deferred.resolve({"MyTimeOffApprovals": [], "TotalTimeOffCount": 0});
                            } else {
                                deferred.resolve(resp[0].data[0]);
                            }
                        }
                        else {
                            deferred.resolve({"MyTimeOffApprovals": [], "TotalTimeOffCount": 0});
                        }
                    });
                }
                return deferred.promise;
            }

            function constructBody(pageNo, pageSize, startDate, endDate, employeeName, locationId, timeOffTypeId) {
                var body = {};
                body.alias = employeeServices.getProdcertName();
                if (pageNo != '' && pageNo != undefined) {
                    body.pageno = pageNo;
                }
                else {
                    body.pageno = 1;
                }
                if (pageSize != '' && pageSize != undefined) {
                    body.pageSize = pageSize;
                }
                if (startDate != '' && startDate != undefined) {
                    body.startdate = startDate;
                }
                if (endDate != '' && endDate != undefined) {
                    body.enddate = endDate;
                }
                if (employeeName != '' && employeeName != undefined) {
                    body.employee = employeeName;
                }
                if (locationId != '' && locationId != undefined) {
                    body.location = locationId;
                }
                if (timeOffTypeId != '' && timeOffTypeId != undefined) {
                    body.reqType = timeOffTypeId;
                }
                return body;
            }

            return {
                'retrieveReports': retrieveReports
            }
        }]);
})();
// this filter is used in all views to unescape special characters in html
(function () {
    angular.module('timeOffCommvaultApp.unescapeFilter', []).filter('unescape', function (Utils) {
        return function (input) {
            return Utils.unescapeHtml(input)
        };
    });
})();