/**
 * @ngdoc function
 * @name timeOffCommvaultApp.filters:AboutFilters
 * @description # timeOffTypeFilter: Filter for add timeOff type page Table listing
 */
(function() {
	app.filter('timeOffTypeFilter', [
			'employeeServices',
			function(employeeServices) {
				return function(timeoff, locationList, departmentList, locationFilter, deptFilter) {
					var output = [];
					for ( var index in timeoff) {
						var location = "";
						var parentID = employeeServices.valueOfAnotherMember(locationList,
								timeoff[index].nLocationID,
								"nParentLocID",
								"nLocationID");
						if (parentID !== 0 && parentID !== -1) {
							location = employeeServices.valueOfAnotherMember(locationList,
									timeoff[index].nLocationID,
									"sRegionName",
									"nLocationID");
						} else {
							location = employeeServices.valueOfAnotherMember(locationList,
									timeoff[index].nLocationID,
									"sCountryName",
									"nLocationID");
							if (location === "") {
								location = employeeServices.valueOfAnotherMember(locationList,
										timeoff[index].nLocationID,
										"sRegionName",
										"nLocationID");
							}
						}
						if (locationFilter.indexOf(location) !== -1) {
							for ( var pos in timeoff[index].DeptID) {
								var dept = employeeServices.valueOfAnotherMember(departmentList,
										timeoff[index].DeptID[pos],
										"sDeptName");
								if (deptFilter.indexOf(dept) !== -1) {
									output.push(timeoff[index]);
									break;
								}
							}
							if (deptFilter.indexOf("All") !== -1 && timeoff[index].DeptID.length === 0) {
								output.push(timeoff[index]);
							}
						}
					}
					return output;
				};
			} ]);
})();