/**
 * @ngdoc function
 * @name timeOffCommvaultApp.directive:AboutDirective
 * @description # escalationRuleDirective Directive to add escalation rules to new approval/notification
 *              policy
 */
(function() {
	app
			.directive('escalationRule',

					function() {
						return {
							restrict : 'A',
							replace : true,
							template : '<div class="row">'
									+ '<div class="col-sm-5"><p> {{ daysExceedMsg }}</p></div>'
									+ '<div class="col-sm-1"> <input type="number" class="first-text number" name="first_text_{{ruleName}}{{counter}}" ng-model="data.key" autocomplete="off" required>'
									+ '<span class="error-msg_policy" ng-if="form.$submitted && form[\'first_text_\'+ruleName+counter].$invalid">{{ errorMsg }} </span></div>'
									+ '<div class="col-sm-3"><p>{{ escalateApprovalMsg }}</p></div>'
									+ '<div class="col-sm-1"> <input type="number" class="second-text number" name="second_text_{{ruleName}}{{counter}}" ng-model="data.value" autocomplete="off" required>'
									+ '<span class="error-msg_policy" ng-if="form.$submitted && form[\'second_text_\'+ruleName+counter].$invalid">{{ errorMsg }}</span></div>'
									+ '<div class="col-sm-2 text-center"><span class="glyphicon glyphicon-plus-sign mouse-hand-cursor" ng-click="addRule()"></span>'
									+ '<span class="glyphicon glyphicon-minus-sign mouse-hand-cursor" ng-click="removeRule({index:counter})" ng-if="counter != 0"></span></div>'
									+ '</div>',
							scope : {
								data : "=",
								counter : "@",
								daysExceedMsg : "@",
								escalateApprovalMsg : "@",
								errorMsg : "@",
								addRule : "&",
								removeRule : "&",
								form : "=",
								ruleName : "@"
							}
						};
					});

}());
