'use strict';
/**
 * @ngdoc function
 * @name timeOffCommvaultApp.controller:AboutCtrl
 * @description # timeoffInfoCtrl Controller for time off info page
 */

(function() {
	app.controller('timeoffInfoCtrl', [
			"$scope",
			"$location",
			"$timeout",
			"$anchorScroll",
			"$filter",
			"Utils",
			"i8nConstants",
			"timeoffInfoService",
			"employeeServices",
			function($scope, $location, $timeout, $anchorScroll, $filter, Utils, i8nConstants, timeoffInfoService,
					employeeServices) {
				$scope.filteredData = '';
				$scope.timeoffHistory = '';
				$scope.timeoffInfo = '';
				$scope.leaveDetails = '';
				$scope.reason = "";
				$scope.timeoffFilter = {
					requestStatus : "",
					requestType : "",
					requestYear : new Date().getFullYear()
				};
				$scope.filterContents = {
					statusFilterContents : '',
					typeFilterContents : '',
					yearFilterContents : employeeServices.getYearList()
				};
				$scope.Msg = {
					noDataMsg : i8nConstants.LOADING,
					yearFilterMsg : i8nConstants.FILTER_BY_TIME_OFF_YEAR,
					typeFilterMsg : i8nConstants.FILTER_BY_TIME_OFF_TYPE,
					statusFilterMsg : i8nConstants.FILTER_BY_TIME_OFF_STATUS
				};
				$scope.dropDownCtrl = {
					year : false,
					status : false,
					type : false
				};
				$scope.alertSuccess = false;
				var selectedLeaveInfo;
				$scope.yearFilter = function(year) {
					$scope.Msg.yearFilterMsg = year;
					$scope.timeoffFilter.requestYear = (year === "All" ? "" : year);
					$scope.filteredData = $filter('timeOffInfoFilter')($scope.timeoffHistory, $scope.timeoffFilter);
					$scope.dropDownCtrl.year = false;
				};
				$scope.typeFilter = function(type) {
					$scope.Msg.typeFilterMsg = type;
					$scope.timeoffFilter.requestType = (type === "All" ? "" : type);
					$scope.filteredData = $filter('timeOffInfoFilter')($scope.timeoffHistory, $scope.timeoffFilter);
					$scope.dropDownCtrl.type = false;
				};
				$scope.statusFilter = function(status) {
					$scope.Msg.statusFilterMsg = status;
					$scope.timeoffFilter.requestStatus = (status === "All" ? "" : status);
					$scope.filteredData = $filter('timeOffInfoFilter')($scope.timeoffHistory, $scope.timeoffFilter);
					$scope.dropDownCtrl.status = false;
				};
				$scope.preventPropagation = function(event) {
					event.stopPropagation();
				};
				$scope.editLeave = function(leaveDetails) {
					$timeout(function() {
						$location.path("/editleave/" + leaveDetails.nID + "/" + leaveDetails.sRequestor + "/" +
								leaveDetails.dateStart.replace(/\//g, "-") + "/" +
								leaveDetails.dateEnd.replace(/\//g, "-"));
					});

				};
				$scope.updateTimeOffInfo = function() {
					timeoffInfoService.timeOffInfoDetails()
							.then(function() {
								$scope.timeoffHistory = timeoffInfoService.processTimeOffHistory();
								if (!$scope.timeoffHistory || $scope.timeoffHistory.length === 0) {
									$scope.Msg.noDataMsg = "Sorry no time off history";
								}
								$scope.timeoffInfo = timeoffInfoService.processTimeOffInfo();
								timeoffInfoService.populateFilters();
								//$scope.filterContents.typeFilterContents = employeeServices.getLeaveTypes();
								$scope.filterContents.typeFilterContents = timeoffInfoService.getTypeFilterContents();
								$scope.filterContents.statusFilterContents = timeoffInfoService
										.getStatusFilterContents();
								$scope.filteredData = $filter('timeOffInfoFilter')($scope.timeoffHistory,
										$scope.timeoffFilter);
							},
									function(resp) {
										if (resp.printError === true) {
											Utils.displayError();
										}
									});

				};
				$scope.displayTimeOffDetails = function(leaveInfo) {
					$scope.leaveDetails = leaveInfo;
					$scope.leaveDetails.managerName = employeeServices.getManagerName();
					$scope.leaveDetails.deptName = employeeServices.getDepartmentName();
					$scope.leaveDetails.sComments = Utils.unescapeHtml(leaveInfo.sComments
							.replace(new RegExp('<br />'), '\n'));
				};
				$scope.convertDateToString = function(dateStr) {
					if (dateStr !== '' && dateStr !== undefined) {
						return Utils.convertDateString(dateStr);
					} else {
						return '';
					}
				};
				$scope.displayCancelConfirmation = function(leaveInfo) {
					$scope.reason = "";
					selectedLeaveInfo = leaveInfo;
				};
				$scope.cancelLeave = function() {
					var cancelLeaveParameter = {
						"nID" : selectedLeaveInfo.nID,
						"nRequestTypeID" : selectedLeaveInfo.nRequestTypeID,
						"sComments" : Utils.escapeHtml($scope.reason),
						"sSubmittedBy" : selectedLeaveInfo.sSubmittedBy,
						"requestors" : [ selectedLeaveInfo.sSubmittedBy ]
					};
					var url = employeeServices.getUrlObj().deleteTimeoff;
					employeeServices.cudAPI(cancelLeaveParameter, url).then(function(response) {
						$scope.updateTimeOffInfo();
						$scope.alertSuccess = true;
						$anchorScroll();
						$timeout(function() {
							$scope.alertSuccess = false;
						}, 3000);
					}, function(resp) {
						if (resp.printError === true) {
							Utils.displayError();
						}
						$anchorScroll();
					});
				};
			} ]);
})();