/**
 * This controller is used for adding and editing pre-requisites details: title, dept, team, location
 */
(function() {
	app.controller('preRequisitesCtrl', [
			"$scope",
			"$location",
			"$anchorScroll",
			"$timeout",
			"Utils",
			"$filter",
			"employeeServices",
			"parameterService",
			function($scope, $location, $anchorScroll, $timeout, Utils, $filter, employeeServices, parameterService) {
				$scope.loadingFlag = true;
				$scope.editFlag = false;
				$scope.nParentLocID = 0;
				var deleteObjId = "";
				if ($scope.levelFlag !== "Admin") {
					$location.path("/applyleave");
				}

				$scope.closeAlertMessage = function() {
					$scope.alerts = {
						deleteSuccess : false,
						deleteFailure : false,
						addSuccess : false,
						addFailure : false,
						editSuccess : false,
						editFailure : false,
						reorderSuccess : false,
						reorderFailure : false
					};
				};

				$scope.getLisings = function(module) {
					$scope.closeAlertMessage();
					employeeServices.getListingObjArray(module).then(function(response) {
						$scope[module.toLowerCase() + 'List'] = response;
						if (module === "Title" && $scope.loadingFlag === false) {
							reorderTitle();
						}
						$scope.loadingFlag = false;
					}, function(resp) {
						if (resp.printError === true) {
							Utils.displayError();
						}
						$scope[module.toLowerCase() + 'List'] = [];
						$scope.loadingFlag = false;
					});
				};

				$scope.editRow = function(index, rowId) {
					$scope.editFlag = true;
					if (rowId) {
						var parameterObj = $scope[$scope.moduleName.toLowerCase() + 'List'][index];
						var actualParams = parameterService["get" + $scope.moduleName + "Params"]();
						for ( var key in actualParams) {
							$scope[key] = parameterObj[key];
						}
						$anchorScroll();
						if ($scope.moduleName === "Location") {
							for ( var key in $scope.timezoneList) {
								if ($scope.sTimeZone === Utils.escapeHtml($scope.timezoneList[key].value)) {
									$scope.sTimeZoneID = $scope.timezoneList[key].key;
									break;
								}
							}
							if ($scope.nParentLocID === 0) {
								$scope.setAsParent = true;
							}
						}
					}
				};
				$scope.deleteAlert = function(ObjId) {
					$scope.clearFields();
					deleteObjId = ObjId;
				};
				$scope.deleteObj = function(param) {
					var deleteObjParams = {};
					deleteObjParams[param] = deleteObjId;
					employeeServices
							.cudAPI(deleteObjParams, employeeServices.getUrlObj()["delete" + $scope.moduleName])
							.then(function() {
								$scope.getLisings($scope.moduleName);
								$scope.alerts.deleteSuccess = true;
								$anchorScroll();
								$timeout(function() {
									$scope.alerts.deleteSuccess = false;
								}, 3000);
							}, function(resp) {
								if (resp.printError === true) {
									$scope.alerts.deleteFailure = true;
									$anchorScroll();
									$timeout(function() {
										$scope.alerts.deleteFailure = false;
									}, 3000);
								}
							});
				};

				$scope.clearFields = function() {
					$scope.editFlag = false;
					$scope.addItem.$setPristine();
					var actualParams = parameterService["get" + $scope.moduleName + "Params"]();
					for ( var key in actualParams) {
						$scope[key] = actualParams[key];
					}
				};
				$scope.submitForm = function() {
					if ($scope.addItem.$valid) {
						var params = {};
						var url = employeeServices.getUrlObj()["add" + $scope.moduleName];
						if ($scope.editFlag === true) {
							url = employeeServices.getUrlObj()["update" + $scope.moduleName];
						}
						if ($scope.moduleName === "Title") {
							params = {
								"sTitleName" : Utils.escapeHtml($scope.sTitleName)
							};
							if ($scope.editFlag === true) {
								params.nRank = $scope.nRank;
								params.nTitleID = $scope.nTitleID;
							}
						} else if ($scope.moduleName === "Department") {
							params = {
								"sDeptName" : Utils.escapeHtml($scope.sDeptName),
								"nIsActive" : true
							};
							if ($scope.editFlag === true) {
								params.nDeptID = $scope.nDeptID;
							}
						} else if ($scope.moduleName === "Team") {
							params = {
								"sTeamName" : Utils.escapeHtml($scope.sTeamName),
								"bIsActive" : true
							};
							if ($scope.editFlag === true) {
								params.nTeamID = $scope.nTeamID;
							}
						} else if ($scope.moduleName === "Location") {
							params = {
								"sCountryName" : Utils.escapeHtml($scope.sCountryName),
								"sRegionName" : Utils.escapeHtml($scope.sRegionName),
								"sTimeZone" : $scope.sTimeZone,
								"nIsActive" : true,
								"nParentLocID" : $scope.nParentLocID
							};
							if ($scope.editFlag === true) {
								params.nLocationID = $scope.nLocationID;
							}
							if ($scope.setAsParent === true) {
								params.nParentLocID = 0;
							}
						}
						employeeServices.cudAPI(params, url).then(function() {
							$scope.getLisings($scope.moduleName);
							if ($scope.editFlag === false) {
								$scope.alerts.addSuccess = true;
							} else {
								$scope.alerts.editSuccess = true;
							}
							$anchorScroll();
							$scope.clearFields();
							$timeout(function() {
								$scope.alerts.addSuccess = false;
								$scope.alerts.editSuccess = false;
							}, 3000);
						}, function(resp) {
							if (resp.printError === true) {
								if ($scope.editFlag === false) {
									$scope.alerts.addFailure = true;
								} else {
									$scope.alerts.editFailure = true;
								}
								$anchorScroll();
								$timeout(function() {
									$scope.alerts.addFailure = false;
									$scope.alerts.editFailure = false;
								}, 3000);
							}
						});
					}
				};

				//drag and drop table rows to reorder title
				$scope.dragEndTitle = function(e, ui) {
					var titleObj = [];
					for (var i = 0; i < $scope.titleList.length; i += 1) {
						titleObj.push({
							"nRank" : i + 1,
							"nTitleID" : $scope.titleList[i].nTitleID
						});
					}
					employeeServices.cudAPI(titleObj, employeeServices.getUrlObj().setRank).then(function() {
						employeeServices.getListingObjArray('Title').then(function(response) {
							$scope.titleList = response;
						}, function(resp) {
							if (resp.printError === true) {
								Utils.displayError();
							}
						});
						$scope.clearFields();
						$scope.alerts.reorderSuccess = true;
						$anchorScroll();
						$timeout(function() {
							$scope.alerts.reorderSuccess = false;
						}, 3000);
					}, function() {
						employeeServices.getListingObjArray('Title').then(function(response) {
							$scope.titleList = response;
						}, function(resp) {
							if (resp.printError === true) {
								Utils.displayError();
							}
						});
						$scope.alerts.reorderFailure = true;
						$anchorScroll();
						$timeout(function() {
							$scope.alerts.reorderFailure = false;
						}, 3000);
					});
				};
				$scope.sortableOptions = {
					'stop' : $scope.dragEndTitle
				};

				//After delete, insert or edit change rank
				function reorderTitle() {
					var titleObj = [];
					for (var i = 0; i < $scope.titleList.length; i += 1) {
						titleObj.push({
							"nRank" : i + 1,
							"nTitleID" : $scope.titleList[i].nTitleID
						});
					}
					employeeServices.cudAPI(titleObj, employeeServices.getUrlObj().setRank).then(function() {
						employeeServices.getListingObjArray('Title').then(function(response) {
							$scope.titleList = response;
						}, function(resp) {
							if (resp.printError === true) {
								Utils.displayError();
							}
						});
					}, function(resp) {
						if (resp.printError === true) {
							Utils.displayError();
						}
					});
				}

				//Timezone selection

				$scope.filteredData = {
					country : [],
					timezone : []
				};
				$scope.showList = {
					country : false,
					timezone : false
				};

				$scope.preventPropagation = function(event) {
					event.stopPropagation();
				};
				$scope.keypressTimezoneList = function(event) {
					$scope.filteredData.timezone = $filter('filter')($scope.timezoneList, {
						'value' : $scope.sTimeZone
					});
					$scope.sTimeZoneID = "";
					if (!angular.element(event.target.parentElement).hasClass('open')) {
						$scope.showList.timezone = false;
						$timeout(function() {
							$scope.showList.timezone = true;
						});
					}
				};
				$scope.keypressCountryList = function(event) {
					$scope.filteredData.country = $filter('filter')($scope.locationList, {
						'sCountryName' : $scope.sCountryName
					});
					$scope.filteredData.country = $filter('orderBy')($scope.filteredData.country, 'sCountryName');
					$scope.nParentLocID = 0;
					if (!angular.element(event.target.parentElement).hasClass('open')) {
						$scope.showList.country = false;
						$timeout(function() {
							$scope.showList.country = true;
						});
					}
				};
				$scope.clickonCountryList = function(event) {
					if (!angular.element(event.target.parentElement).hasClass('open')) {
						$scope.showList.country = false;
						$timeout(function() {
							$scope.showList.country = true;
						});
					}
					$scope.filteredData.country = $scope.locationList;
				};
				$scope.clickonTimezoneList = function(event) {
					if (!angular.element(event.target.parentElement).hasClass('open')) {
						$scope.showList.timezone = false;
						$timeout(function() {
							$scope.showList.timezone = true;
						});
					}
					$scope.filteredData.timezone = $scope.timezoneList;
				};
				$scope.selectTimezone = function(timezone) {
					$scope.sTimeZone = timezone.value;
					$scope.sTimeZoneID = timezone.key;
					$scope.showList.timezone = false;
				};
				$scope.addCountry = function(country) {
					$scope.nParentLocID = country.nLocationID;
					$scope.sCountryName = country.sCountryName;
					$scope.showList.country = false;
				};
			} ]);
}());