'use strict';
/**
 * @ngdoc function
 * @name timeOffCommvaultApp.controller:AboutCtrl
 * @description # holidayCtrl Controller of the holiday listing
 */
(function() {
	app.controller('holidayCtrl', [
			"$scope",
			"$filter",
			"holidayService",
			"employeeServices",
			"i8nConstants",
			"TIMEOFF_CONSTANTS",
			function($scope, $filter, holidayService, employeeServices, i8nConstants, TIMEOFF_CONSTANTS) {
				var dateObj = new Date();
				$scope.noHoliday = true;
				var regionFilter = [];
				$scope.filteredRegion = [];
				$scope.yearFilter = [];
				$scope.filteredYear = [];
				$scope.holidayList = {};
				$scope.showHolidayList = false;
				$scope.showYearList = false;
				$scope.noHolidayMsg = i8nConstants.LOADING;
				$scope.monthNames = holidayService.getMonthNames();
				$scope.filter = {
					searchLocation : "",
					searchBasedLocationsList : []
				};

				$scope.initialData = {
					region : employeeServices.getRegionName(),
					year : dateObj.getFullYear()
				};

				$scope.getHolidayList = function() {
					$scope.yearFilter = employeeServices.getYearList();
					regionFilter = employeeServices.getLocationList();
					$scope.filteredYear[0] = $scope.initialData.year;
					$scope.filteredRegion[0] = $scope.initialData.region;
					holidayService.sortByRegionYearMonth();
					updateRegionYearHolidays();
				};

				$scope.preventPropagation = function(event) {
					event.stopPropagation();
				};

				$scope.updateYearList = function(year, event) {
					if ($scope.filteredYear.indexOf(year) === -1) {
						$scope.filteredYear.push(year);
						$scope.filteredYear.sort().reverse();
					} else {
						$scope.filteredYear.splice($scope.filteredYear.indexOf(year), 1);
					}
					updateRegionYearHolidays();
					event.stopPropagation();
				};

				$scope.openLocationList = function() {
					$scope.showHolidayList = !$scope.showHolidayList;
					$scope.filter.searchBasedLocationsList = regionFilter;
					$scope.filter.searchBasedLocationsList = $filter('orderBy')($scope.filter.searchBasedLocationsList,
							'sRegionName');
					$scope.filter.searchLocation = "";
				};

				$scope.keypressSearchRegionName = function(event) {
					$scope.filter.searchBasedLocationsList = $filter('filter')(regionFilter, {
						'sRegionName' : $scope.filter.searchLocation
					});
					$scope.filter.searchBasedLocationsList = $filter('orderBy')($scope.filter.searchBasedLocationsList,
							'sRegionName');
				};
				$scope.updateRegionList = function(region, event) {
					if ($scope.filteredRegion.indexOf(region) === -1) {
						$scope.filteredRegion.push(region);
						$scope.filteredRegion.sort();
					} else {
						$scope.filteredRegion.splice($scope.filteredRegion.indexOf(region), 1);
					}
					updateRegionYearHolidays();
					$scope.filter.searchLocation = "";
					//$scope.filter.searchBasedLocationsList = regionFilter;
					$scope.filter.searchBasedLocationsList = $filter('orderBy')(regionFilter, 'sRegionName');
					event.stopPropagation();
				};
				$scope.removeRegionByIndex = function(index) {
					$scope.filteredRegion.splice(index, 1);
					updateRegionYearHolidays();
					$scope.filter.searchLocation = "";
				};
				$scope.rowHeight = function(rowNumber) {
					return (calculateRowHeight(rowNumber));
				};
				$scope.findHeight = function(region, year) {
					var rowsRegionYear = 0;
					if ($scope.holidayList[region][year]) {
						for ( var month in $scope.holidayList[region][year]) {
							rowsRegionYear += $scope.holidayList[region][year][month].length;
						}
					}
					return (calculateRowHeight(rowsRegionYear));
				};
				function calculateRowHeight(rowNumber) {
					var rowHeight = TIMEOFF_CONSTANTS.ONE_ROW_HEIGHT * rowNumber;
					var fontSize = TIMEOFF_CONSTANTS.FONT_SIZE;
					return {
						"height" : rowHeight,
						"font-size" : fontSize,
						"padding-top" : (rowHeight - fontSize) / 2,
					};
				}
				function updateRegionYearHolidays() {
					$scope.noHoliday = true;
					if ($scope.filteredRegion.length === 0) {
						$scope.noHolidayMsg = i8nConstants.NO_LOCATION_IS_SELECTED;
						return;
					} else if ($scope.filteredYear.length === 0) {
						$scope.noHolidayMsg = i8nConstants.NO_YEAR_IS_SELECTED;
						return;
					}
					$scope.holidayList = holidayService.getRegionYearMonthHolidays($scope.filteredRegion,
							$scope.filteredYear);
					if ($scope.holidayList) {
						$scope.noHoliday = false;
					}
					$scope.noHolidayMsg = i8nConstants.NO_HOLIDAYS_FOUND;
				}
			} ]);
})();
