/**
 * This controller is used for adding and editing events details
 */
(function() {
	app.controller('eventCtrl', [
			"$scope",
			"$location",
			"$anchorScroll",
			"$timeout",
			"Utils",
			"$filter",
			"employeeServices",
			"parameterService",
			function($scope, $location, $anchorScroll, $timeout, Utils, $filter, employeeServices, parameterService) {

				$scope.editFlag = false;
				$scope.loadingFlag = true;
				$scope.showLocationsList = false;
				$scope.locationList = employeeServices.getLocationList();
				var deleteObjId = '';
				$scope.filteredLocations = [];
				if ($scope.levelFlag !== "Admin") {
					$location.path("/applyleave");
				}
				$scope.$on('startDateChanged', function(event, date) {
					$scope.dStartDate = date;
				});

				$scope.$on('endDateChanged', function(event, date) {
					$scope.dEndDate = date;
				});
				$scope.others = {
					sVenueOthers : ""
				};
				$scope.closeAlertMessage = function() {
					$scope.alerts = {
						deleteSuccess : false,
						deleteFailure : false,
						addSuccess : false,
						addFailure : false,
						editSuccess : false,
						editFailure : false
					};
				};
				$scope.getLisings = function(module) {
					$scope.closeAlertMessage();
					employeeServices.getListingObjArray(module).then(function(response) {
						$scope[module.toLowerCase() + 'List'] = response;
						$scope.loadingFlag = false;
					}, function(resp) {
						if (resp.printError === true) {
							Utils.displayError();
						}
						$scope[module.toLowerCase() + 'List'] = [];
						$scope.loadingFlag = false;
					});
				};

				$scope.selectLocation = function(region) {
					if (region.sRegionName === "OTHER") {
						$scope.otherVenue = true;
					} else {
						$scope.otherVenue = false;
					}
					$scope.sVenue = region.sRegionName;
					$scope.nLocationID = region.nLocationID;
					$scope.showLocationsList = false;
				};

				$scope.clearFields = function() {
					$scope.editFlag = false;
					$scope.addItem.$setPristine();
					var actualParams = parameterService["get" + $scope.moduleName + "Params"]();
					for ( var key in actualParams) {
						$scope[key] = actualParams[key];
					}
					$scope.others.sVenueOthers = "";
					$scope.otherVenue = false;
					$scope.$broadcast('editDates', $scope.dStartDate, $scope.dEndDate);
				};

				$scope.deleteEventAlert = function(singleEvent) {
					$scope.clearFields();
					deleteObjId = singleEvent.nID;
				};
				$scope.deleteEvent = function(param) {
					var deleteObjParams = {
						'nID' : deleteObjId
					};
					employeeServices
							.cudAPI(deleteObjParams, employeeServices.getUrlObj()["delete" + $scope.moduleName])
							.then(function(response) {
								$scope[$scope.moduleName.toLowerCase() + 'List'] = [];
								$scope.loadingFlag = true;
								$scope.getLisings($scope.moduleName);
								$scope.alerts.deleteSuccess = true;
								$anchorScroll();
								$timeout(function() {
									$scope.alerts.deleteSuccess = false;
								}, 3000);
							}, function(resp) {
								if (resp.printError === true) {
									$scope.alerts.deleteFailure = true;
									$anchorScroll();
									$timeout(function() {
										$scope.alerts.deleteFailure = false;
									}, 3000);
								}
							});
				};

				$scope.clickonLocationList = function(event) {
					if (!angular.element(event.target.parentElement).hasClass('open')) {
						$scope.showLocationsList = false;
						$timeout(function() {
							$scope.showLocationsList = true;
						});
					}
					$scope.filteredLocations = $scope.locationList;
				};

				$scope.keypressLocationsList = function(event) {
					$scope.filteredLocations = $filter('filter')($scope.locationList, {
						'sRegionName' : $scope.sVenue
					});
					$scope.filteredLocations = $filter('orderBy')($scope.filteredLocations, 'sRegionName');
					$scope.otherVenue = false;
					$scope.others.sVenueOthers = "";
					$scope.nLocationID = "";
					if (!angular.element(event.target.parentElement).hasClass('open')) {
						$scope.showLocationsList = false;
						$timeout(function() {
							$scope.showLocationsList = true;
						});
					}
				};
				$scope.editEvent = function(eve) {
					$scope.otherVenue = false;
					var othersLocID = employeeServices.getOthersId($scope.locationList);
					var actualParams = parameterService["get" + $scope.moduleName + "Params"]();
					for ( var key in actualParams) {
						$scope[key] = eve[key];
					}
					if (eve.nLocationID === othersLocID) {
						$scope.otherVenue = true;
						$scope.sVenue = "OTHER";
						$scope.others.sVenueOthers = eve.sVenue;
					} else {
						$scope.sVenue = eve.sVenue;
					}
					$scope.nLocationID = eve.nLocationID;
					$scope.editFlag = true;
					$anchorScroll();
					$scope.$broadcast('editDates', $scope.dStartDate, $scope.dEndDate);
				};

				$scope.formatDates = function(dateStr) {
					return Utils.convertDateString(dateStr);
				};
				$scope.preventPropagation = function(event) {
					event.stopPropagation();
				};
				$scope.calcDays = function(startDate, endDate) {
					return Utils.calculateDays(startDate, endDate);
				};

				$scope.submitForm = function() {
					if ($scope.addItem.$valid) {
						var params = {};
						var url = employeeServices.getUrlObj()["add" + $scope.moduleName];
						if ($scope.editFlag === true) {
							url = employeeServices.getUrlObj()["update" + $scope.moduleName];
						}
						params = {
							"dEndDate" : Utils.respDateFormat($scope.dEndDate, true),
							"dStartDate" : Utils.respDateFormat($scope.dStartDate, true),
							"sAlias" : $scope.sAlias,
							"sDetails" : Utils.escapeHtml($scope.sDetails),
							"sEventName" : Utils.escapeHtml($scope.sEventName),
							"sVenue" : $scope.sVenue === "OTHER" ? $scope.others.sVenueOthers : $scope.sVenue,
							"nLocationID" : $scope.nLocationID
						};
						if ($scope.editFlag === true) {
							params.nID = $scope.nID;
						}
						employeeServices.cudAPI(params, url).then(function(resp) {
							$scope[$scope.moduleName.toLowerCase() + 'List'] = [];
							$scope.loadingFlag = true;
							$scope.getLisings($scope.moduleName);
							if ($scope.editFlag === false) {
								$scope.alerts.addSuccess = true;
							} else {
								$scope.alerts.editSuccess = true;
							}
							$anchorScroll();
							$scope.clearFields();
							$timeout(function() {
								$scope.alerts.addSuccess = false;
								$scope.alerts.editSuccess = false;
							}, 3000);
						}, function(resp) {
							if (resp.printError === true) {
								if ($scope.editFlag === false) {
									$scope.alerts.addFailure = true;
								} else {
									$scope.alerts.editFailure = true;
								}
								$anchorScroll();
								$timeout(function() {
									$scope.alerts.addFailure = false;
									$scope.alerts.editFailure = false;
								}, 3000);
							}
						});
					}
				};

			} ]);
}());