/*
 This controller is used for showing employee with details.
 */
(function() {
	app
			.controller('employeeCtrl',
					[
							"$scope",
							"$location",
							"employeeServices",
							"Utils",
							function($scope, $location, employeeServices, Utils) {

								$scope.loadingFlag = true;
								$scope.usersPerPage = 15;
								$scope.teamListsArray = {};
								$scope.locationListsArray = {};
								$scope.managerListsArrayProd = [];
								$scope.managerListsArrayName = [];
								$scope.searchEmp = "";
								$scope.users = [];
								$scope.totalUsers = 0;
								$scope.searchPaginate = false;

								$scope.getInitialData = function() {
									$scope.searchPaginate = false;
									if ($scope.levelFlag !== "Admin") {
										$location.path("/applyleave");
									}

									employeeServices
											.getListingObjArray("Team")
											.then(function(response) {
												$scope.teamLists = response;
												for (var i = 0; i < $scope.teamLists.length; i++) {
													$scope.teamListsArray[$scope.teamLists[i].nTeamID] = $scope.teamLists[i].sTeamName;
												}
											},
													function(resp) {
														if (resp.printError === true) {
															Utils.displayError();
														}
													});
									employeeServices
											.getListingObjArray("Location")
											.then(function(response) {
												$scope.locationLists = response;
												for (var i = 0; i < $scope.locationLists.length; i++) {
													$scope.locationListsArray[$scope.locationLists[i].nLocationID] = [];
													$scope.locationListsArray[$scope.locationLists[i].nLocationID][0] = $scope.locationLists[i].sRegionName;
													$scope.locationListsArray[$scope.locationLists[i].nLocationID][1] = $scope.locationLists[i].sCountryName;
												}
											},
													function(resp) {
														if (resp.printError === true) {
															Utils.displayError();
														}
													});
									employeeServices.getListingObjArray("Manager").then(function(response) {
										$scope.managerLists = response;
										for (var i = 0; i < $scope.managerLists.length; i++) {
											$scope.managerListsArrayProd[i] = $scope.managerLists[i].ProdcertName;
											$scope.managerListsArrayName[i] = $scope.managerLists[i].sEmpName;
										}
									}, function(resp) {
										if (resp.printError === true) {
											Utils.displayError();
										}
									});
									$scope.pageChanged(1);
								};

								$scope.searchEmployee = function() {
									$scope.loadingFlag = true;
									$scope.users = [];
									$scope.totalUsers = 0;
									if ($scope.searchEmp === "") {
										$scope.pageChanged(1);
									} else {
										$scope.searchPaginate = true;
										var params = {
											"searchtoken" : Utils.escapeHtml($scope.searchEmp)
										};
										var url = employeeServices.getUrlObj().getEmployeeByToken;
										employeeServices.cudAPI(params, url).then(function(response) {
											$scope.searchEmp = "";
											$scope.loadingFlag = false;
											if (response[0].data) {
												$scope.users = response[0].data;
												$scope.totalUsers = response[0].data.length;
												for (var i = 0; i < $scope.users.length; i += 1) {
													$scope.users[i].showDetails = false;
												}
											}
										}, function(resp) {
											if (resp.printError === true) {
												Utils.displayError();
											}
											$scope.loadingFlag = false;
										});
									}
								};

								$scope.pageChanged = function(pageNumber) {
									$scope.searchPaginate = false;
									$scope.disableSearch = true;
									var params = {
										pageno : pageNumber,
										pageSize : $scope.usersPerPage
									};
									var url = employeeServices.getUrlObj().getEmployees;
									employeeServices.cudAPI(params, url).then(function(response) {
										$scope.disableSearch = false;
										$scope.loadingFlag = false;
										$scope.users = response[0].data[0].employees;
										$scope.totalUsers = response[0].data[0].TotalEmpCount;
										for (var i = 0; i < $scope.users.length; i += 1) {
											$scope.users[i].showDetails = false;
										}
									}, function(resp) {
										if (resp.printError === true) {
											Utils.displayError();
										}
										$scope.loadingFlag = false;
									});
								};

							} ]);

}());