'use strict';
/**
 * @ngdoc function
 * @name timeOffCommvaultApp.controller:AboutCtrl
 * @description # datePickerCtrl Controller for date picker
 */
(function() {

	app.controller('datePickerCtrl', [
			"$scope",
			"employeeServices",
			"Utils",
			function($scope, employeeServices, Utils) {
				$scope.dateOptions = {
					showWeeks : 'false'
				};
				$scope.format = 'dd-MMMM-yyyy';
				var optionalHolidays = [];
				$scope.daysOfAbsence = 0;

				$scope.$on('editApplyDates', function(event, startDate, endDate) {
					$scope.startdate = startDate ? new Date(startDate) : undefined;
					$scope.enddate = endDate ? new Date(endDate) : undefined;
					if ($scope.startdate && $scope.enddate) {
						$scope.setDate();
					}
				});

				$scope.$on('requestTypeChanged', function(event) {
					if ($scope.startdate && $scope.enddate) {
						$scope.setDate();
					}
				});

				$scope.datePickerKey = function(event) {
					return Utils.keepDateFieldReadable(event);
				};

				$scope.disabled = function(date, mode) {
					return employeeServices.getDisabledHolidays(date, mode, $scope.$parent.availableHolidays);
				};

				$scope.openStartDate = function($event) {
					if (!$scope.startdate) {
						$scope.startdate = new Date(new Date().toDateString() + " 00:00:00");
						$scope.minDate = $scope.startdate;
					}
					employeeServices.setOptionalLeavesArray([]);
					$event.preventDefault();
					$event.stopPropagation();
					$scope.startDateOpened = true;
					$scope.endDateOpened = false;
					if ($scope.enddate) {
						if ($scope.startdate && $scope.startdate > $scope.enddate) {
							$scope.enddate = $scope.startdate;
						}
					} else {
						//$scope.enddate = undefined;
						$scope.enddate = $scope.startdate;
					}
					if ($scope.startdate && $scope.enddate) {
						$scope.calDate();
					}
				};
				$scope.openEndDate = function($event) {
					$scope.minDate = $scope.startdate;
					$scope.endDateOpened = true;
					$scope.startDateOpened = false;
					$event.preventDefault();
					$event.stopPropagation();
					if (!$scope.enddate && $scope.startdate) {
						$scope.enddate = $scope.startdate;
					} else if (!$scope.enddate && !$scope.startdate) {
						$scope.startdate = new Date(new Date().toDateString() + " 00:00:00");
						$scope.minDate = $scope.startdate;
						$scope.enddate = $scope.startdate;
					}
					employeeServices.setOptionalLeavesArray([]);

					if ($scope.$parent.params.halfDayFlag === true) {
						$scope.endDateOpened = false;
					} else {
						$scope.endDateOpened = true;
					}
					if ($scope.startdate && $scope.enddate) {
						$scope.calDate();
					}
				};

				$scope.setDate = function() {
					$scope.minDate = $scope.startdate;
					employeeServices.setOptionalLeavesArray([]);
					if (($scope.startdate && $scope.startdate > $scope.enddate) || (!$scope.enddate) ||
							$scope.$parent.params.halfDayFlag) {
						$scope.enddate = $scope.startdate;
					}
					showOptionalHolidaysSidePopup();
				};

				$scope.calDate = function() {
					employeeServices.setOptionalLeavesArray([]);
					if (($scope.enddate && $scope.startdate > $scope.enddate) || (!$scope.startdate)) {
						$scope.startdate = $scope.enddate;
						$scope.minDate = $scope.startdate;
					}
					showOptionalHolidaysSidePopup();
				};

				function showOptionalHolidaysSidePopup() {
					$scope.daysOfAbsence = calculateDays();
					$scope.optionalLeaveDetails = angular.copy(optionalHolidays);
					$scope.optionalDivShowFlag = true;
					//if optional holiday type then set $scope.optionalDivShowFlag = false;
					//check bIsOptionalType only, not nID since it could be over ridden

					if ($scope.$parent.params.bIsOptionalType === true) {
						$scope.optionalDivShowFlag = false;
						for (var k = 0; k < optionalHolidays.length; k++) {
							$scope.consumeLeave(optionalHolidays[k].date, k);
						}
					}
					$scope.$emit('applyDateChanged', $scope.startdate, $scope.enddate, $scope.daysOfAbsence);
					$scope.$parent.params.markOutOfOffice = false;
				}
				$scope.consumeLeave = function(optionalLeave, index) {
					$scope.daysOfAbsence = $scope.daysOfAbsence - 1;
					var optionalLeaveTakenArray = employeeServices.getOptionalLeavesArray();
					if (optionalLeaveTakenArray.indexOf(Utils.respDateFormat(optionalLeave, true)) === -1) {
						optionalLeaveTakenArray.push(Utils.respDateFormat(optionalLeave, true));
					}
					$scope.optionalLeaveDetails.splice(index, 1);
					if ($scope.optionalLeaveDetails.length === 0) {
						$scope.optionalDivShowFlag = false;
					}
					employeeServices.setOptionalLeavesArray(optionalLeaveTakenArray);
					$scope.$emit('applyDateChanged', $scope.startdate, $scope.enddate, $scope.daysOfAbsence);

				};

				$scope.doNotConsumeLeave = function(index) {
					$scope.optionalLeaveDetails.splice(index, 1);
					if ($scope.optionalLeaveDetails.length === 0) {
						$scope.optionalDivShowFlag = false;
					}
				};

				function calculateDays() {
					optionalHolidays = [];
					var startDate = new Date($scope.startdate);
					var endDate = new Date($scope.enddate);
					var totalLeave = 0;

					//Count total leave days
					while (startDate <= endDate) {
						if (startDate.getDay() !== 0 && startDate.getDay() !== 6) {
							totalLeave = totalLeave + 1; // not sunday and saturday
						}
						startDate.setDate(startDate.getDate() + 1);
					}

					var n_days = 0;
					var applicableHolidays = $scope.$parent.availableHolidays;

					if (applicableHolidays) {
						//find if any holiday or optional holiday applicable
						for (var k = 0; k < applicableHolidays.length; k++) {
							var holidayDate = new Date(applicableHolidays[k].startDate);
							var holidayEnd = new Date(applicableHolidays[k].endDate);
							while (holidayDate <= holidayEnd) {
								if (holidayDate >= $scope.startdate) {
									if (holidayDate <= $scope.enddate) {
										if (applicableHolidays[k].nIsOptional) {
											optionalHolidays.push({
												"name" : applicableHolidays[k].sName,
												"date" : holidayDate.toDateString()
											});
										} else {
											if (holidayDate.getDay() !== 0 && holidayDate.getDay() !== 6) {
												n_days = n_days + 1;
											}
										}
									}
								}
								holidayDate.setDate(holidayDate.getDate() + 1);
							}
						}
					}
					return totalLeave - n_days;
				}

			} ]);
}());