'use strict';
/**
 * @ngdoc function
 * @name timeOffCommvaultApp.controller:AboutCtrl
 * @description # dateCtrl Controller for date picker
 */
(function() {
	app.controller("dateCtrl", [ "$scope", function($scope) {

		$scope.format = 'dd-MMMM-yyyy';
		$scope.dateOptions = {
			showWeeks : 'false'
		};
		$scope.$on('editDates', function(event, startDate, endDate) {
			$scope.startdate = startDate !== "" ? new Date(startDate) : "";
			$scope.enddate = endDate !== "" ? new Date(endDate) : "";
			if ($scope.startdate && $scope.enddate) {
				$scope.minDate = $scope.startdate;
			}
		});
		$scope.openStartDate = function($event) {
			if (!$scope.startdate) {
				$scope.startdate = new Date(new Date().toDateString() + " 00:00:00");
				$scope.minDate = $scope.startdate;
				$scope.$emit('startDateChanged', $scope.startdate);
			}
			$scope.showWeeks = false;
			$event.preventDefault();
			$event.stopPropagation();
			$scope.startDateOpened = true;
			$scope.endDateOpened = false;
			if ($scope.enddate) {
				if ($scope.startdate && $scope.startdate > $scope.enddate) {
					$scope.enddate = $scope.startdate;
					$scope.$emit('endDateChanged', $scope.enddate);
				}
			} else {
				//$scope.enddate = undefined;
				$scope.enddate = $scope.startdate;
				$scope.$emit('endDateChanged', $scope.enddate);
			}
		};
		$scope.openEndDate = function($event) {
			$scope.minDate = $scope.startdate;
			$scope.endDateOpened = true;
			$scope.startDateOpened = false;
			$event.preventDefault();
			$event.stopPropagation();
			if (!$scope.enddate && $scope.startdate) {
				$scope.enddate = $scope.startdate;
				$scope.$emit('endDateChanged', $scope.enddate);
			} else if (!$scope.enddate && !$scope.startdate) {
				$scope.startdate = new Date(new Date().toDateString() + " 00:00:00");
				$scope.minDate = $scope.startdate;
				$scope.$emit('startDateChanged', $scope.startdate);
				$scope.enddate = $scope.startdate;
				$scope.$emit('endDateChanged', $scope.enddate);
			}
		};
		$scope.selStartDate = function() {
			$scope.minDate = $scope.startdate;
			$scope.$emit('startDateChanged', $scope.startdate);
			if (($scope.startdate && $scope.startdate > $scope.enddate) || (!$scope.enddate)) {
				$scope.enddate = $scope.startdate;
				$scope.$emit('endDateChanged', $scope.enddate);
			}
		};
		$scope.selEndDate = function() {
			$scope.$emit('endDateChanged', $scope.enddate);
			if (($scope.enddate && $scope.startdate > $scope.enddate) || (!$scope.startdate)) {
				$scope.startdate = $scope.enddate;
				$scope.minDate = $scope.startdate;
				$scope.$emit('startDateChanged', $scope.startdate);
			}
		};
	} ]);
}());
