'use strict';
// This is common controller for creating, listing  , updating , deleting different modules like title ,
// department , location , title , assign proxy , manager proxy , holidays , events ,
// entitlement policy , approval/notification policy , listing employee
(function() {
	app
			.controller('crudCtrl',
					[
							"$scope",
							"holidayService",
							"employeeServices",
							"addLeaveTypeServices",
							"validateObjectService",
							"adminServices",
							"Utils",
							"parameterService",
							"assignProxyServices",
							"$rootScope",
							"$location",
							"$timeout",
							"timeOffDateDiffService",
							function($scope, holidayService, employeeServices, addLeaveTypeServices,
									validateObjectService, adminServices, Utils, parameterService, assignProxyServices,
									$rootScope, $location, $timeout, timeOffDateDiffService) {
								$scope
										.$watch('$viewContentLoaded',
												function() {
													// this check is for giving this controller access only to
													// admin  otherwise redirect to apply leave page for manager and employee
													if ($scope.levelFlag != "Admin" &&
															($scope.levelFlag == "Manager" && ($scope.moduleName != "ManagerProxy"))) {
														$location.path("/applyleave");
													}
													if ($scope.levelFlag == "Employee") {
														$location.path("/applyleave");
													}
													$scope.halfDay = -1;
													// for title dragging
													$scope.dragStart = function(e, ui) {
														ui.item.data('start', ui.item.index());
													}
													// make date picker readonly
													$(document).ready(function() {
														$("#dValidFrom").on("keydown", function(e) {
															return Utils.keepDateFieldReadable(e);
														});
														$("#dExpiryDate").on("keydown", function(e) {
															return Utils.keepDateFieldReadable(e);
														});
														$("#startDate").on("keydown", function(e) {
															return Utils.keepDateFieldReadable(e);
														});
														$("#endDate").on("keydown", function(e) {
															return Utils.keepDateFieldReadable(e);
														});
														$("#startdate").on("keydown", function(e) {
															return Utils.keepDateFieldReadable(e);
														});
														$("#enddate").on("keydown", function(e) {
															return Utils.keepDateFieldReadable(e);
														});
													});
													// event after title dragging is complete
													$scope.dragEnd = function(e, ui) {
														var start = ui.item.data('start'), end = ui.item.index();
														var titleObj = [];
														$(".sort-row").each(function(index) {
															$(this).attr("data-sortorder", index + 1);
															titleObj.push({
																"nRank" : index + 1,
																"nTitleID" : $(this).attr("data-titleid")
															});
														});
														adminServices.cudAPI(titleObj,
																adminServices.getUrlObj().setRank).then(function() {
															$(".title-success-msg").fadeIn().fadeOut(5000);
															$('html, body').animate({
																scrollTop : 0
															}, 800);
														}, function(response) {
															if (response[0].error == null) {
																$(".title-error-danger-msg").fadeIn().fadeOut(5000);
															}
															$('html, body').animate({
																scrollTop : 0
															}, 800);
														});
														$scope.$apply();
													}
													var sortableEle = $('#sortable').sortable({
														start : $scope.dragStart,
														update : $scope.dragEnd,
														cancel : ".tbl-head"
													});
													$scope.editFlag = 0;
													var index = 0;
													$scope.loadingFlag = true;
													// modulename is defined in respective views
													if ($scope.moduleName == "AssignProxy" ||
															$scope.moduleName == "ManagerProxy") {
														$(".clear-on-key-press").on("keyup", function() {
															$(this).next().next().val("");
														});
														retrieveManagerList($scope.moduleName);
													}
													if ($scope.moduleName == "Location") {
														$("#timezone_dropdown").on("click",
																"li",
																function(e) {
																	$(".selVal").html($(this).html());
																	$("#sTimeZone").val($(this).html());
																	$("#btn_sTimeZone").removeClass("error");
																	$(e.target).parent().parent().parent().parent()
																			.find(".dropdown-toggle").trigger("click");
																});
														adminServices.getListingObjArray("Timezone").then(function(
																response) {
															$scope.timezoneList = response;
														});
														$(document).mouseup(function(e) {
															var container = $(".dropdown");
															if (!container.is(e.target) // if the target of the click isn't the container...
																	&& container.has(e.target).length === 0) // ... nor a descendant of the container
															{
																if ($(".dropdown-menu").hasClass("show")) {
																	$(".dropdown-menu").toggleClass("show");
																	// container.parent().find(".dropdown-toggle").trigger("click");
																}
															}
														});
														$('#btn_sTimeZone').off().on("click", function() {
															$('.dropdown-div .dropdown-toggle').dropdown();
															$(".dropdown-div .dropdown-menu").toggleClass("show");
														});
													}
													function retrieveManagerList(moduleName) {
														assignProxyServices.setURL();
														var loggedUser = employeeServices.getEmployeeObj();
														$scope.managersList = assignProxyServices
																.getAllManagersData()
																.then(function(managerList) {
																	$scope.managersList = managerList;
																	var currManagerObj = employeeServices
																			.giveValueOfAnotherMemberInArrayOfObjects($scope.managersList,
																					loggedUser.ProdcertName,
																					[ "ProdcertName" ])
																	//                $("#currDept").val(currManagerObj.sDeptName);
																	if (moduleName == "ManagerProxy") {
																		$scope.addCurrentManager(currManagerObj);
																		$("#sUser").val(currManagerObj.ProdcertName);
																		$("#currDept").val(currManagerObj.sDeptName);
																	}
																});
														var loggedUser = employeeServices.getEmployeeObj();
														if (moduleName == "AssignProxy") {
															assignProxyServices.getAllAssignedProxies().then(function(
																	proxies) {
																$scope.assignedProxies = proxies;
																$scope.loadingFlag = false;
															});
														} else {
															assignProxyServices.getAllManagersProxies(employeeServices
																	.getProdcertName()).then(function(proxies) {
																$scope.assignedProxies = proxies;
																$scope.loadingFlag = false;
															});
															$scope.loadingFlag = false;
														}
													}

													$scope.displayCurrManagersName = function($event) {
														$(".curr-manager").show();
													}
													$scope.displayTempManagersName = function() {
														employeeServices.getEmployeeByParams($("#btn_sProxy").val())
																.then(function(response) {
																	$scope.managerList = response[0].data;
																	$(".temp-manager").show();
																}, function(resp) {
																});
													}
													$scope.addCurrentManager = function(manager) {
														$scope.currentManager = manager;
														$("#sUser").val(manager.ProdcertName);
														$scope.currManagerName = manager.sEmpName;
														$scope.currentManagersDept = manager.sDeptName;
														$(".memberList").hide();
													}
													var departmentList = [];
													adminServices.getListingObjArray("Department").then(function(
															response) {
														departmentList = response;
														// populate department field if page is in edit mode
													});
													$("#searchTempManager").on("click", function() {
														$scope.displayTempManagersName();
													});
													$scope.addTemporaryManager = function(manager) {
														$scope.temporaryManager = manager;
														$scope.tempManagerName = manager.sEmpName;
														$("#sProxy").val(manager.ProdcertName);
														$(".memberList").hide();
														for (var i = 0; i < departmentList.length; i++) {
															if (departmentList[i].nDeptID == manager.nDeptID) {
																$scope.temporaryManagersDept = departmentList[i].sDeptName;
															}
														}
													}
													$scope.displayRevokeProxy = function(proxy) {
														adminServices.clearFields($scope.moduleName);
														$scope.editFlag = false;
														$("#deletePolicyModal").modal('show');
														$scope.revokeProxyObj = proxy;
													}
													$scope.revokeProxy = function() {
														var id = $scope.revokeProxyObj.nID;
														var deleteObjParams = {
															"nID" : id
														}
														adminServices.cudAPI(deleteObjParams,
																eval("adminServices.getUrlObj().delete" +
																		$scope.moduleName)).then(function(response) {
															$scope.closeRevokeModal();
															$(".delete-success-msg").fadeIn().fadeOut(5000);
															if ($scope.moduleName == 'ManagerProxy') {
																assignProxyServices.getAllManagersProxies()
																		.then(function(response) {
																			adminServices
																					.clearFields($scope.moduleName);
																			$rootScope.$broadcast('user:updated',
																					response);
																		});
															} else if ($scope.moduleName == 'AssignProxy') {
																assignProxyServices.getAllAssignedProxies()
																		.then(function(response) {
																			adminServices
																					.clearFields($scope.moduleName);
																			$rootScope.$broadcast('user:updated',
																					response);
																		});
															} else {
																adminServices.getListingObjArray(moduleName)
																		.then(function(response) {
																			adminServices
																					.clearFields($scope.moduleName);
																			$rootScope.$broadcast('user:updated',
																					response);
																		});
															}
															$('html, body').animate({
																scrollTop : 0
															}, 800);
														},
																function(response) {
																	$scope.closeRevokeModal();
																	if (response[0].error == null) {
																		$(".delete-error-danger-msg").fadeIn()
																				.fadeOut(5000);
																	}
																	81
																	$('html, body').animate({
																		scrollTop : 0
																	}, 800);
																});
													}
													$scope.closeRevokeModal = function() {
														$("#deletePolicyModal").modal('hide');
														$scope.revokeProxyObj = '';
													}
													$scope.editProxy = function(proxy) {
														Utils.clearFormValidations();
														var id = proxy.nID;
														adminServices.populateForm(proxy, parameterService
																.getProxyParams());
														$("#editFlag").val(id).trigger("change");
														var managerData = assignProxyServices
																.getManagerNameDept(proxy.sUser);

														if (proxy) {
															if (proxy.dValidFrom && proxy.dExpiryDate) {
																var scope = angular.element("#dExpiryDate").scope();
																scope.startdate = new Date(proxy.dValidFrom);
																scope.enddate = new Date(proxy.dExpiryDate);
																timeOffDateDiffService
																		.setTimeOffStartDate(scope.startdate);
																timeOffDateDiffService.setTimeOffEndDate(scope.enddate);
															}
														}

														//var tempmanagerData = assignProxyServices.getManagerNameDept(proxy.sProxy);
														$("#btn_sProxy").val(proxy.sProxyName);
														$("#btn_sUser").val(managerData.sEmpName);
														$("#sProxy").val(proxy.sProxy);
														$("#sUser").val(proxy.sUser);
														$("#currDept").val(managerData.sDeptName);
														$("#tempDept").val(proxy.sProxyDept);
														$('html, body').animate({
															scrollTop : 0
														}, 800);
													}
													$scope.getFullName = function(name) {
														return assignProxyServices.getManagerNameDept(name).sEmpName
													}
													$("#editFlag").on('change', function() {
														if ($(this).val() == 0) {
															$scope.editFlag = 0;
														} else {
															$scope.editFlag = 1;
														}
													})
													$scope.cancelProxyEdit = function() {
														$scope.editFlag = 0;
														$('#editFlag').val("0");
														$("#dExpiryDate").val('');
														$("#dValidFrom").val('');
														$("#sProxy").val('');
														$("#btn_sProxy").val('');
														$("#sUser").val('');
														$("#btn_sUser").val('')
														$("#currDept").val('');
														$("#tempDept").val('');
														$("#nID").val('');
													};
													$scope.calcDays = function(startDate, endDate, locationID) {
														return Utils.calculateDays(startDate, endDate);
													}
													$scope.formatDates = function(dateStr) {
														return Utils.convertDateString(dateStr);
													}
													if ($scope.moduleName != undefined) {
														var updateModulename = $scope.moduleName.toLowerCase();
													}
													// refresh listing of for respective modules if add or edit happens
													$scope.$on('user:updated', function(event, data) {
														$scope.editFlag = 0;
														if ($scope.moduleName != undefined) {
															if ($scope.moduleName == "Holiday") {
																updateCountriesHolidays();
															} else {
																if ($scope.moduleName == "AssignProxy" ||
																		$scope.moduleName == "ManagerProxy") {
																	$scope.assignedProxies = data;
																} else {
																	eval('$scope.' + updateModulename + 'List = data');

																}
															}
														}
													});
													if (($scope.moduleName == "Department") ||
															($scope.moduleName == "Team") ||
															($scope.moduleName == "Event") ||
															($scope.moduleName == "Title") ||
															($scope.moduleName == "Location")) {
														getLisings($scope.moduleName);
														$scope.editRow = function(rowId) {
															Utils.clearFormValidations();
															$scope.editFlag = 1;
															if (rowId != "") {
																var primaryKey = "nID";
																if ($scope.moduleName == "Title") {
																	primaryKey = "nTitleID";
																}
																if ($scope.moduleName == "Department") {
																	primaryKey = "nDeptID";
																}
																if ($scope.moduleName == "Team") {
																	primaryKey = "nTeamID";
																}
																if ($scope.moduleName == "Title") {
																	primaryKey = "nTitleID";
																}
																if ($scope.moduleName == "Location") {
																	primaryKey = "nLocationID";
																}
																adminServices
																		.populateForm(employeeServices
																				.giveValueOfAnotherMemberInArrayOfObjects(eval('$scope.' +
																						$scope.moduleName.toLowerCase() +
																						'List'),
																						rowId,
																						[ primaryKey ]),
																				eval("parameterService.get" +
																						$scope.moduleName + "Params()"));
																$("#editFlag").val(rowId);
																if ($scope.moduleName == "Location") {
																	$(".selVal").html($("#sTimeZone").val());
																}
																$('html, body').animate({
																	scrollTop : 0
																}, 800);
															}
														}
													}
													function getLisings(module) {
														adminServices.getListingObjArray(module)
																.then(function(response) {
																	eval('$scope.' + $scope.moduleName.toLowerCase() +
																			'List = response');
																	$scope.loadingFlag = false;
																});
													}

													if ($scope.moduleName == "Employee") {
														$scope.searchEmployee = function() {
															if ($("#empSearchText").val() == "") {
																getResultsPage(1);
																$(".pagination").show();
															} else {
																$(".pagination").hide();
															}
															employeeServices.getEmployeeByParams($('#empSearchText')
																	.val()).then(function(response) {
																$scope.users = response[0].data;
																$scope.totalUsers = response[0].count;
															});
														}
														$scope.loadingFlag = true;
														$scope.checkArray = function(empVal) {
															if ($.isArray(empVal)) {
																return true;
															} else {
																return false;
															}
														}
														$scope.usersPerPage = 15; // this should match however many results your API puts on one page
														var getResultsPage = function(pageNumber) {
															employeeServices.getEmployees(pageNumber,
																	$scope.usersPerPage).then(function(response) {
																$scope.users = response[0].data[0].employees;
																$scope.totalUsers = response[0].data[0].TotalEmpCount;
																$scope.loadingFlag = false;
															});
														}
														getResultsPage(1);
														$scope.pagination = {
															current : 1
														};
														$scope.pageChanged = function(newPage) {
															getResultsPage(newPage);
														};
														$scope.teamListsArray = [];
														adminServices
																.getListingObjArray("Team")
																.then(function(response) {
																	$scope.teamLists = response;
																	for (var i = 0; i < $scope.teamLists.length; i++) {
																		$scope.teamListsArray[$scope.teamLists[i].nTeamID] = $scope.teamLists[i].sTeamName;
																	}
																	$scope.displayTeam = function($event) {
																		$(".teamList").show();
																	}
																});
														$scope.locationListsArray = [];
														adminServices
																.getListingObjArray("Location")
																.then(function(response) {
																	$scope.locationLists = response;
																	for (var i = 0; i < $scope.locationLists.length; i++) {
																		$scope.locationListsArray[$scope.locationLists[i].nLocationID] = [];
																		$scope.locationListsArray[$scope.locationLists[i].nLocationID][0] = $scope.locationLists[i].sRegionName;
																		$scope.locationListsArray[$scope.locationLists[i].nLocationID][1] = $scope.locationLists[i].sCountryName;
																	}
																});
														$scope.managerListsArrayProd = [];
														$scope.managerListsArrayName = [];
														adminServices
																.getListingObjArray("Manager")
																.then(function(response) {
																	$scope.managerLists = response;
																	for (var i = 0; i < $scope.managerLists.length; i++) {
																		$scope.managerListsArrayProd[i] = $scope.managerLists[i].ProdcertName;
																		$scope.managerListsArrayName[i] = $scope.managerLists[i].sEmpName;
																	}
																});
													}
													if ($scope.moduleName == "Holiday") {
														$('.dropdown-toggle').off().on("click",
																function(e) {
																	$(this).dropdown();
																	$(this).parent().find(".dropdown-menu")
																			.toggleClass("show");
																	if ($(e.target).attr("id") == "btn_sCountry") {
																		$("#btn_sRegion").parent().find(".show")
																				.each(function() {
																					$(this).toggleClass("show");
																				});
																	}
																});
														$(document).mouseup(function(e) {
															var container = $(".dropdown");
															if (!container.is(e.target) // if the target of the click isn't the container...
																	&& container.has(e.target).length === 0) // ... nor a descendant of the container
															{
																$(".dropdown").find(".show").each(function() {
																	$(this).toggleClass("show");
																});
															}
														});
														$scope.regionList = [];
														adminServices.getListingObjArray("Location").then(function(
																response) {
															$scope.LocationList = response;
															var locationObj = adminServices
																	.getCountries($scope.LocationList);
															$scope.countriesList = locationObj.countries;
															$scope.completeLocationObj = locationObj.completeList;
														});
														$scope.indexList = 0;
														$scope.addedName = [];
														$("#country_dropdown").on("click",
																"li",
																function(e) {
																	$scope.addedName = [];
																	$("#sRegion").val("");
																	$("#btn_sCountry").removeClass("error");
																	$(".selCountry").html($(this).html());
																	$(".selRegion").html("Select region/state");
																	$("#sCountry").val($(this).html());
																	$scope.addedName.push($(this).html());
																	$scope.$evalAsync(function() {
																		$scope.indexList = $(this).data("index");
																	});
																	$(e.target).parent().parent().parent().parent()
																			.find(".dropdown-toggle").trigger("click");
																});
														$("#region_dropdown").on("click",
																"li",
																function(e) {
																	$(".selRegion").html($(this).html());
																	$("#btn_sRegion").removeClass("error");
																	$("#sRegion").val($(this).html())
																	$("#nLocationID").val($(this).data("locationid"));
																	$(e.target).parent().parent().parent().parent()
																			.find(".dropdown-toggle").trigger("click");
																});
														$scope.isEmpty = function() {
															if (Object.keys($scope.holidayList).length) {
																return false;
															}
															return true;
														}
														var updateCountriesHolidays = function() {
															$scope.holidayList = {};
															var j = 0;
															$scope.multiCountriesHolidayList = holidayService
																	.getHolidayList($scope.filteredCountries);
															if ($scope.filteredCountries.length == 0) {
																$scope.noHolidayMsg = "No location is selected,please select a location to view the holiday list.";
															} else if (Object.keys($scope.multiCountriesHolidayList).length > 0) {
																$scope.noHolidayMsg = "No holiday(s) found for this/these location/locations.";
															}
															for (var j = 0; j < Object
																	.keys($scope.multiCountriesHolidayList).length; j++) {
																var holidayList = $scope.multiCountriesHolidayList[Object
																		.keys($scope.multiCountriesHolidayList)[j]];
																for (var i = 0; i < holidayList.length; i++) {
																	var temp = {}
																	//temp.date = holidayList[i].startDate.replace(/-/g, ' ');
																	var holidayDate = new Date(holidayList[i].startDate);
																	var startDate = new Date(holidayList[i].startDate);
																	var endDate = new Date(holidayList[i].endDate);
																	//If the holidays span between days
																	if ((startDate.getDate() != endDate.getDate()) ||
																			(startDate.getMonth() != endDate.getMonth()) ||
																			(startDate.getFullYear() != endDate
																					.getFullYear())) {
																		var daysDiff = Utils
																				.calculateDays(startDate.toDateString(),
																						endDate.toDateString());
																		holidayDate = new Date(holidayList[i].startDate);
																		for (var k = 0; k < daysDiff; k++) {
																			var date = new Date(holidayDate);
																			if (!$scope.holidayList[$scope.monthNames[date
																					.getMonth()] +
																					"-" + date.getFullYear()]) {
																				$scope.holidayList[$scope.monthNames[date
																						.getMonth()] +
																						"-" + date.getFullYear()] = [];
																			}
																			//tempArr[$scope.monthNames[new Date(temp.date).getMonth()]].push(temp);
																			if (holidayList[i].nIsOptional == true) {
																				$scope.holidayList[$scope.monthNames[date
																						.getMonth()] +
																						"-" + date.getFullYear()]
																						.push({
																							'month' : $scope.monthNames[date
																									.getMonth()],
																							'date' : date,
																							'name' : holidayList[i].sName,
																							'country' : holidayList[i].sCountry,
																							'region' : holidayList[i].sRegion,
																							'color' : "#344c67",
																							'nID' : holidayList[i].nID
																						});
																			} else {
																				$scope.holidayList[$scope.monthNames[date
																						.getMonth()] +
																						"-" + date.getFullYear()]
																						.push({
																							'month' : $scope.monthNames[date
																									.getMonth()],
																							'date' : date,
																							'name' : holidayList[i].sName,
																							'country' : holidayList[i].sCountry,
																							'region' : holidayList[i].sRegion,
																							'color' : "white",
																							'nID' : holidayList[i].nID
																						});
																			}
																			holidayDate
																					.setDate(holidayDate.getDate() + 1);
																		}
																	} else {
																		//single month holidays
																		var date = new Date(holidayDate);
																		//var date = new Date(temp.date);
																		if (!$scope.holidayList[$scope.monthNames[date
																				.getMonth()] +
																				"-" + date.getFullYear()]) {
																			$scope.holidayList[$scope.monthNames[date
																					.getMonth()] +
																					"-" + date.getFullYear()] = [];
																		}
																		//tempArr[$scope.monthNames[new Date(temp.date).getMonth()]].push(temp);
																		if (holidayList[i].nIsOptional == true) {
																			$scope.holidayList[$scope.monthNames[date
																					.getMonth()] +
																					"-" + date.getFullYear()].push({
																				'month' : $scope.monthNames[date
																						.getMonth()],
																				'date' : date,
																				'name' : holidayList[i].sName,
																				'country' : holidayList[i].sCountry,
																				'region' : holidayList[i].sRegion,
																				'color' : "#344c67",
																				'nID' : holidayList[i].nID
																			});
																		} else {
																			$scope.holidayList[$scope.monthNames[date
																					.getMonth()] +
																					"-" + date.getFullYear()].push({
																				'month' : $scope.monthNames[date
																						.getMonth()],
																				'date' : date,
																				'name' : holidayList[i].sName,
																				'country' : holidayList[i].sCountry,
																				'region' : holidayList[i].sRegion,
																				'color' : "white",
																				'nID' : holidayList[i].nID
																			});
																		}
																	}
																}
															}
															for ( var key in $scope.holidayList) {
																$scope.holidayList[key] = Utils
																		.sortArrayBasedOnDates($scope.holidayList[key]);
															}
														}
														$scope.holidayList = [];
														var dateObj = new Date();
														$scope.country = "India";
														$scope.countryFilter = [];
														$scope.filteredCountries = [];
														$scope.noHolidayMsg = "Loading ...";
														var index = 0;

														//To support holiday list for subsequent year
														//@TODO: Need to acheive this in a better way
														$scope.monthYear = [
																"January-" + dateObj.getFullYear(),
																"February-" + dateObj.getFullYear(),
																"March-" + dateObj.getFullYear(),
																"April-" + dateObj.getFullYear(),
																"May-" + dateObj.getFullYear(),
																"June-" + dateObj.getFullYear(),
																"July-" + dateObj.getFullYear(),
																"August-" + dateObj.getFullYear(),
																"September-" + dateObj.getFullYear(),
																"October-" + dateObj.getFullYear(),
																"November-" + dateObj.getFullYear(),
																"December-" + dateObj.getFullYear(),
																"January-" + (dateObj.getFullYear() + 1),
																"February-" + (dateObj.getFullYear() + 1),
																"March-" + (dateObj.getFullYear() + 1),
																"April-" + (dateObj.getFullYear() + 1),
																"May-" + (dateObj.getFullYear() + 1),
																"June-" + (dateObj.getFullYear() + 1),
																"July-" + (dateObj.getFullYear() + 1),
																"August-" + (dateObj.getFullYear() + 1),
																"September-" + (dateObj.getFullYear() + 1),
																"October-" + (dateObj.getFullYear() + 1),
																"November-" + (dateObj.getFullYear() + 1),
																"December-" + (dateObj.getFullYear() + 1) ];
														$scope.monthNames = [
																"January",
																"February",
																"March",
																"April",
																"May",
																"June",
																"July",
																"August",
																"September",
																"October",
																"November",
																"December" ];
														$scope.getHolidayList = function() {
															holidayService.getAllHoliday().then(function() {
																$scope.countryFilter = holidayService.getRegionList();
																$scope.filteredCountries = holidayService
																		.getRegionList();
																index = $scope.filteredCountries.length;
																updateCountriesHolidays();
															});
														};
														$scope.editRow = function(rowId, country) {
															Utils.clearFormValidations();
															$scope.editFlag = 1;
															$("#editFlag").val(rowId);
															if (rowId != "") {
																var formObj = employeeServices
																		.giveValueOfAnotherMemberInArrayOfObjects($scope.multiCountriesHolidayList[country],
																				rowId,
																				"");
																adminServices.populateForm(formObj, parameterService
																		.getHolidayParams())

																var scope = angular.element("#endDate").scope();
																if (formObj) {
																	scope.startdate = new Date(formObj.startDate);
																	scope.enddate = new Date(formObj.endDate);
																	scope.mindate = new Date(formObj.startDate);
																}
																$("[data-country='" + $("#sCountry").val() + "']")
																		.trigger("click");
																$("#btn_sCountry").parent().find(".show")
																		.toggleClass("show");
																$("[data-locationid='" + $("#nLocationID").val() + "']")
																		.trigger("click");
																$("#btn_sRegion").parent().find(".show")
																		.toggleClass("show");
																if (formObj.nIsOptional == true) {
																	$('#nIsOptional').trigger('click');
																}
																// $("#nIsOptional").attr("checked","checked");
																$('html, body').animate({
																	scrollTop : 0
																}, 800);
															}
														}
														$scope.updateCountry = function(country) {
															$scope.country = country;
															if ($scope.filteredCountries.indexOf(country) == -1) {
																$scope.filteredCountries[index] = country;
																index++;
															} else {
																$scope.filteredCountries
																		.splice($scope.filteredCountries
																				.indexOf(country), 1);
																index--;
															}
															updateCountriesHolidays();
														}
														$scope.getHolidayList();
													}
													var validateObj = validateObjectService
															.getValidateObj($scope.moduleName);
													$scope.evenFormvalidate = validateObj;
													$scope.deleteAlert = function(ObjId) {
														adminServices.clearFields($scope.moduleName);
														$scope.editFlag = false;
														$scope.deleteObjId = ObjId;
														$("#deletePolicyModal").modal('show');
													}
													$scope.deleteObj = function() {
														$scope.editFlag = 0;
														adminServices.clearFields($scope.moduleName);
														var ObjId = $scope.deleteObjId;
														var deleteObjParams = {
															"nID" : ObjId
														}
														if ($scope.moduleName == "Title") {
															deleteObjParams = {
																"nTitleID" : ObjId
															}
														}
														if ($scope.moduleName == "Department") {
															deleteObjParams = {
																"nDeptID" : ObjId
															}
														}
														if ($scope.moduleName == "Team") {
															deleteObjParams = {
																"nTeamID" : ObjId
															}
														}
														if ($scope.moduleName == "Title") {
															deleteObjParams = {
																"nTitleID" : ObjId
															}
														}
														if ($scope.moduleName == "Location") {
															deleteObjParams = {
																"nLocationID" : ObjId
															}
														}
														$(".alert-msg").hide();
														$("#deletePolicyModal").modal("hide");
														adminServices
																.cudAPI(deleteObjParams,
																		eval("adminServices.getUrlObj().delete" +
																				$scope.moduleName))
																.then(function(response) {
																	$(".delete-success-msg").fadeIn().fadeOut(3000);
																	if ($scope.moduleName == "Holiday") {
																		$scope.getHolidayList();
																	} else {
																		adminServices
																				.getListingObjArray($scope.moduleName)
																				.then(function(response) {
																					if ($scope.moduleName == "AssignProxy") {
																						$scope.assignedProxies = response;
																					} else {
																						eval('$scope.' +
																								$scope.moduleName
																										.toLowerCase() +
																								'List = response');
																						$scope.loadingFlag = false;
																					}
																				});
																	}
																	$('html, body').animate({
																		scrollTop : 0
																	}, 800);
																},
																		function(response) {
																			if (response[0].error == null) {
																				$(".delete-error-danger-msg").fadeIn()
																						.fadeOut(5000);
																			}
																			$('html, body').animate({
																				scrollTop : 0
																			}, 800);
																		});
													}
													//event
													adminServices.getListingObjArray("Location")
															.then(function(response) {
																$scope.locationList = response;
															});
													$scope.locationList = employeeServices.getLocationList();
													$scope.venue = '';
													$scope.deleteEventObj = '';
													$scope.editFlag = 0;
													if ($scope.moduleName == 'Event') {
														$('.dropdown-toggle').off().on("click",
																function() {
																	$(this).dropdown();
																	$(this).parent().find(".dropdown-menu")
																			.toggleClass("show");
																});
														$(document).mouseup(function(e) {
															var container = $(".dropdown");
															if (!container.is(e.target) // if the target of the click isn't the container...
																	&& container.has(e.target).length === 0) // ... nor a descendant of the container
															{
																$(".dropdown").find(".show").each(function() {
																	$(this).toggleClass("show");
																});
															}
														});
														$scope.updateVenue = function(venue, e) {
															$('.event-loc').hide();
															if (venue == "OTHER") {
																$(".other-venue").show();
																$("#sVenueOthers").rules("add", {
																	required : true
																});
															} else {
																$("#sVenueOthers").rules("remove");
																$(".other-venue").hide();
															}
															$scope.venue = venue;
															$("#nLocationID").val($(e.target).attr("data-locationid"));
															$("#sVenue").val(venue);
															$("#btn_sVenue").val(venue);
															$(e.target).parent().parent().parent().parent()
																	.find(".dropdown-toggle").trigger("click");
														}
														$scope.deleteEventAlert = function(singleEvent, $event) {
															adminServices.clearFields($scope.moduleName);
															$scope.editFlag = false;
															$scope.deleteEventObj = singleEvent;
															$("#deletePolicyModal").modal('show');
															$event.stopPropagation();
														}
														$scope.deleteEvent = function() {
															$scope.editFlag = 0;
															adminServices.clearFields($scope.moduleName);
															var id = $scope.deleteEventObj.nID;
															var deleteObjParams = {
																"nID" : id
															}
															$(".alert-msg").hide();
															$("#deletePolicyModal").modal("hide");
															adminServices.cudAPI(deleteObjParams,
																	eval("adminServices.getUrlObj().delete" +
																			$("#moduleName").val())).then(function(
																	response) {
																$(".delete-success-msg").fadeIn().fadeOut(3000);
																adminServices.getListingObjArray($scope.moduleName)
																		.then(function(response) {
																			eval('$scope.' +
																					$scope.moduleName.toLowerCase() +
																					'List = response');
																			$scope.loadingFlag = false;
																		});
																$('html, body').animate({
																	scrollTop : 0
																}, 800);
															},
																	function(response) {
																		if (response[0].error == null) {
																			$(".delete-error-danger-msg").fadeIn()
																					.fadeOut(5000);
																		}
																		$('html, body').animate({
																			scrollTop : 0
																		}, 800);
																	});
														}
														$scope.displayEvent = function() {
															$("#sVenueOthers").rules("add", {
																required : false
															});
															$("#sVenueOthers").val('');
															$('#sVenue').val('');
															$('#nLocationID').val('');
															$('.event-loc').show();
														}
														$scope.editEvent = function(eve, e) {
															Utils.clearFormValidations();
															$(".other-venue").hide();
															$("#sVenueOthers").rules("add", {
																required : false
															});
															//adminServices.clearFields($('#moduleName').val());
															var id = eve.nID;
															var othersloc = employeeServices
																	.getOthersId($scope.locationList);
															adminServices.populateForm(eve, parameterService
																	.getEventParams());
															$("#editFlag").val(id);
															var isInArrFlag = false;
															for ( var key in $scope.locationList) {
																if ($scope.locationList[key].nLocationID == eve.nLocationID &&
																		$scope.locationList[key].nLocationID == othersloc) {
																	isInArrFlag = true;
																	break;
																}
															}
															$("#nLocationID").val(eve.nLocationID);
															if (isInArrFlag == true) {
																$(".other-venue").show();
																$("#btn_sVenue").val("OTHER");
																$("#sVenueOthers").rules("add", {
																	required : true
																});
																$("#sVenueOthers").val(eve.sVenue);
																$("#sVenue").val('OTHER')
															} else {
																$("#sVenue").val(eve.sVenue);
																$("#btn_sVenue").val($("#sVenue").val());
															}
															$scope.editFlag = 1;
															$('html, body').animate({
																scrollTop : 0
															}, 800);
														}
													}
													$scope.closeEventModal = function() {
														$("#deletePolicyModal").modal("hide");
													}
													//----------
													$scope.cancelEdit = function() {
														$scope.editFlag = 0;
														adminServices.clearFields($scope.moduleName);
													}
													$scope.showEntitlementModal = function() {
														$("#addPolicyModal").modal("show")
													}
													$scope.showNotificationModal = function() {
														$("#notificationPolicyModal").modal("show");
													}
												});
								var counter = 1;
								$(".first-table-data").off().on("click",
										".plus-sign",
										function(e) {
											$(this).closest(".row").clone().appendTo(".first-table-data");
											$(".first-table-data").find(".first-text").last().attr("name",
													"first_text_" + counter);
											$(".first-table-data").find(".second-text").last().attr("name",
													"second_text_" + counter);
											$(".first-table-data").find(".first-text").last().attr("id",
													"first_text_" + counter);
											$(".first-table-data").find(".second-text").last().attr("id",
													"second_text_" + counter);
											$("#first_text_" + counter).val("");
											$("#second_text_" + counter).val("");
											$("#first_text_" + counter).rules("add", "required");
											$("#second_text_" + counter).rules("add", "required");
											$(".first-table-data").find(".minus-sign").last().attr("data-counter",
													counter);
											counter++;
											e.stopPropagation();
											e.preventDefault();
										});
								$(".first-table-data").on("click", ".minus-sign", function(e) {
									$("#first_text_" + $(this).data("counter")).rules("remove", "required");
									$("#second_text_" + $(this).data("counter")).rules("remove", "required");
									$(e.target).closest(".row").remove();
								});
								var secondCounter = 1;
								$(".second-table-data").off().on("click",
										".plus-sign",
										function() {
											$(this).closest(".row").clone().appendTo(".second-table-data");
											$(".second-table-data").find(".total-first-text").last().attr("name",
													"total_first_text_" + secondCounter);
											$(".second-table-data").find(".total-second-text").last().attr("name",
													"total_second_text_" + secondCounter);
											$(".second-table-data").find(".total-first-text").last().attr("id",
													"total_first_text_" + secondCounter);
											$(".second-table-data").find(".total-second-text").last().attr("id",
													"total_second_text_" + secondCounter);
											$("#total_first_text_" + secondCounter).val("");
											$("#total_second_text_" + secondCounter).val("");
											$("#total_first_text_" + secondCounter).rules("add", "required");
											$("#total_second_text_" + secondCounter).rules("add", "required");
											$(".second-table-data").find(".minus-sign").last().attr("data-counter",
													secondCounter);
											secondCounter++;
										});
								$(".second-table-data").on("click", ".minus-sign", function(e) {
									$("#total_first_text_" + $(this).data("counter")).rules("remove", "required");
									$("#total_second_text_" + $(this).data("counter")).rules("remove", "required");
									$(e.target).closest(".row").remove();
								});
							} ]).controller("dateCtrl", [ "$scope", function($scope) {
				$scope.toggleMin = function() {
				};
				$scope.toggleMin();
				$scope.dateOptions = {
					showWeeks : 'false'
				};
				$scope.openStartDate = function($event) {
					$scope.showWeeks = false;
					$event.preventDefault();
					$event.stopPropagation();
					$scope.startDateOpened = true;
					$scope.endDateOpened = false;
					if ($scope.enddate) {
						if ($scope.startdate && $scope.startdate > $scope.enddate) {
							$scope.enddate = $scope.startdate;
						}
					} else {
						$scope.enddate = undefined;
					}
				};
				$scope.openEndDate = function($event) {

					$scope.enddate = $scope.startdate;

					$scope.minDate = $scope.startdate;
					$scope.endDateOpened = true;
					$scope.startDateOpened = false;
					$event.preventDefault();
					$event.stopPropagation();
				};
				$scope.selStartDate = function() {
					$scope.minDate = $scope.startdate;
					if (($scope.startdate && $scope.startdate > $scope.enddate) || (!$scope.enddate)) {
						$scope.enddate = $scope.startdate;
					}
				}
				$scope.selEndDate = function() {
					if (($scope.enddate && $scope.startdate > $scope.enddate) || (!$scope.startdate)) {
						$scope.startdate = $scope.enddate;
					}
				}
				$scope.format = 'dd-MMMM-yyyy';
			} ]);
})();