'use strict';
/**
 * @ngdoc function
 * @name timeOffCommvaultApp.controller:AboutCtrl
 * @description # calendarCtrl Controller for calendar page
 */
(function() {
	app
			.controller('calendarCtrl',
					[
							"$scope",
							"$document",
							"$compile",
							"$timeout",
							"$filter",
							"uiCalendarConfig",
							"calenderService",
							"employeeServices",
							"Utils",
							"$anchorScroll",
							function($scope, $document, $compile, $timeout, $filter, uiCalendarConfig, calenderService,
									employeeServices, Utils, $anchorScroll) {

								$scope.name = employeeServices.getEmpName();
								$scope.clientRegion = employeeServices.getRegionName();
								$scope.teamMembers = employeeServices.getTeamMembers();
								$scope.filteredMembers = $scope.teamMembers;
								$scope.regionList = angular.copy(employeeServices.getHolidayRegionList()).sort();
								$scope.eventSources = [];
								$scope.addedNames = [];
								$scope.filteredRegion = [];
								$scope.tableViewTimeOffArray = [];
								$scope.dataRetrieveFailure = false;
								$scope.dataAvailable = false;

								var $calender = angular.element("#calendar");
								var eventData = {};
								var serverData = [];
								var addedNamesProdcert = [];
								var disabledData = {};
								var dataYearArray = angular.copy(employeeServices.getYearList());
								var weekDays = [ "sun", "mon", "tue", "wed", "thu", "fri", "sat" ];
								var months = [
										"Jan",
										"Feb",
										"Mar",
										"Apr",
										"May",
										"Jun",
										"Jul",
										"Aug",
										"Sepr",
										"Oct",
										"Nov",
										"Dec" ];
								var startYear = dataYearArray[0];
								var endYear = dataYearArray[dataYearArray.length - 1];
								var dateHeader = new Date();
								var weekEnd = new Date();
								$scope.currentActive = 'month';
								$scope.calenderShow = true;
								$scope.reason = "";
								$scope.currentUser = employeeServices.getProdcertName();
								$scope.companyName = "company";

								$document.ready(function() {
									$document
											.mouseup(function(e) {
												if (!(angular.element(e.target.parentElement)
														.hasClass('popover-content') || angular
														.element(e.target.parentElement).hasClass('popover-inner'))) {
													$(".popover").remove();
												}
											});
								});

								$scope.getCalenderData = function() {
									$scope.filteredRegion[0] = $scope.clientRegion;
									if ($scope.regionList.indexOf($scope.clientRegion) >= 0) {
										$scope.regionList.splice($scope.regionList.indexOf($scope.clientRegion), 1);
									}
									$scope.header = $filter('date')(dateHeader, 'MMMM y');
									$calender.fullCalendar("gotoDate", dateHeader);
									$calender.fullCalendar("render");
									$scope.addMember($scope.currentUser);

									employeeServices.getListingObjArray("Event").then(function(response) {
										var companyEvents = calenderService.createCompanyEvents(response);
										pushDataToSource(companyEvents,
												"#5d9a4a",
												$scope.companyName,
												$scope.companyName,
												"");
										serverData.push("");
									},
											function(resp) {
												if (resp.printError === true) {
													Utils.displayError();
												}
											});
									var holidays = calenderService.getRegionHolidays($scope.clientRegion);
									var holidayEvents = calenderService.createEventsList(holidays, "party");
									pushDataToSource(holidayEvents,
											"#bd4eed",
											$scope.clientRegion,
											$scope.clientRegion,
											"");
									serverData.push("");

								};

								$scope.eventRender = function(event, element, view) {
									event.startdate = (event.start.getMonth() + 1) + "-" + event.start.getDate() + "-" +
											event.start.getFullYear();
									event.enddate = (event.end.getMonth() + 1) + "-" + event.end.getDate() + "-" +
											event.end.getFullYear();

									if (event.type === "timeOff" || event.type === "companyEvents") {
										var title = "";
										if (event.requestor) {
											if ((event.requestor).toLowerCase() === (employeeServices.getProdcertName())
													.toLowerCase() &&
													event.type === "timeOff") {
												title = "You are on ";
											}
										}
										title = title + event.title + " Time Off";
										var popUpMsg = "From: " + months[(event.start).getMonth()] + " " +
												(event.start).getDate() + ", " + (event.start).getFullYear() + " To: " +
												months[(event.end).getMonth()] + " " + (event.end).getDate() + ", " +
												(event.end).getFullYear() + " <br\> ";
										if (event.type === "timeOff") {
											if (event.status !== "") {
												popUpMsg += "Status - " + event.status;
											}
											if (event.action) {
												if (event.action.indexOf("Edit") !== -1) {
													popUpMsg = popUpMsg + "\x3ca href\x3d'#/editleave/" +
															event.leaveid + "/" + event.requestor + "/" +
															event.startdate + "/" + event.enddate +
															"' class\x3d'green padding-options-left edit-leave' \x3eEdit\x3c/a\x3e";
													if (event.action.indexOf("Cancel") !== -1) {
														popUpMsg = popUpMsg + " / ";
													}
												}
												if (event.action.indexOf("Cancel") !== -1) {
													popUpMsg = popUpMsg +
															"\x3ca class\x3d'red cancel-leave mouse-hand-cursor'  data-toggle='modal' data-target='#calender_cancel' \x3eCancel\x3c/a\x3e";
												}
											}
										}
										if (event.type === "companyEvents") {
											popUpMsg = popUpMsg + "Venue - " + event.venue + "\x3c/p\x3e";
										}
										element.attr({
											"popover-html-unsafe" : popUpMsg,
											"popover-title" : title,
											"popover-placement" : "top"
										});
										element.addClass("mouse-hand-cursor");
										$compile(element)($scope);
									}
								};

								$scope.eventclick = function(event, jsEvent, view) {
									eventData = {
										leaveId : event.leaveid,
										startdate : event.startdate,
										enddate : event.enddate,
										requestor : event.requestor
									};
								};

								// Calendar ui config settings
								$scope.uiConfig = {
									calendar : {
										id : "calendar",
										height : 450,
										editable : false,
										disableDragging : true,
										header : false,
										viewRender : function(view, element) {
											angular.element(".fc-day-header.fc-" + weekDays[(new Date()).getDay()])
													.addClass("heading-blue");
										},
										eventRender : $scope.eventRender,
										eventClick : $scope.eventclick
									}
								};
								$scope.calenderView = function() {
									$scope.calenderShow = true;
									$timeout(function() {
										//uiCalendarConfig.calendars.myCalendar.fullCalendar("gotoDate",
										//		dateHeader);
										$calender.fullCalendar("render");
										$calender.fullCalendar("gotoDate", dateHeader);
									});
								};

								$scope.tableView = function() {
									$scope.month();
									$scope.calenderShow = false;
									displayTableData();
								};

								$scope.month = function() {
									$scope.currentActive = 'month';
									$calender.fullCalendar('changeView', 'month');
									$scope.getHeader();
								};

								$scope.week = function() {
									$scope.currentActive = 'week';
									$calender.fullCalendar('changeView', 'agendaWeek');
									$scope.getHeader();

								};

								$scope.today = function() {
									$scope.currentActive = 'today';
									$calender.fullCalendar('changeView', 'agendaDay');
									$scope.getHeader();
								};

								$scope.prev = function() {
									$calender.fullCalendar('prev');
									traverseCalender(-1);
								};

								$scope.next = function() {
									$calender.fullCalendar('next');
									traverseCalender(1);
								};
								$scope.displayName = function($event) {
									$scope.filteredMembers = $filter('filter')($scope.teamMembers, $scope.memberName);
									if (!angular.element($event.target.parentElement).hasClass('open')) {
										$scope.showDropDown = false;
										$timeout(function() {
											$scope.showDropDown = true;
										});
									}
								};
								$scope.preventDefault = function(event) {
									$scope.showRegions = false;
									event.stopPropagation();
								};
								function traverseCalender(num) {
									if ($scope.calenderShow) {
										$scope.getHeader();
									} else {
										dateHeader = new Date(dateHeader.getFullYear(), dateHeader.getMonth() + num, 1);
										$scope.header = $filter('date')(dateHeader, 'MMMM y');
									}
									displayTableData();
								}

								$scope.getHeader = function() {
									dateHeader = $calender.fullCalendar('getView').start;

									if ($scope.currentActive === 'month') {
										$scope.header = $filter('date')(dateHeader, 'MMMM y');
									} else if ($scope.currentActive === 'week') {
										weekEnd = $calender.fullCalendar('getView').end;
										weekEnd.setDate(weekEnd.getDate() - 1);
										$scope.header = $filter('date')(dateHeader, 'MMM d');
										if (dateHeader.getFullYear() !== weekEnd.getFullYear()) {
											$scope.header = $scope.header + ', ' + $filter('date')(dateHeader, 'yyyy');
										}
										$scope.header = $scope.header + ' - ';
										if (dateHeader.getMonth() !== weekEnd.getMonth()) {
											$scope.header = $scope.header + $filter('date')(weekEnd, 'MMM d, yyyy');
										} else {
											$scope.header = $scope.header + $filter('date')(weekEnd, ' d, yyyy');
										}

									} else {
										dateHeader = new Date();
										$calender.fullCalendar("gotoDate", dateHeader);
										$scope.header = $filter('date')(dateHeader, 'EEEE, MMM d, y');
									}
								};
								$scope.preventPropagation = function(event) {
									event.stopPropagation();
								};
								$scope.removeItem = function(name, event) {
									if ($scope.filteredRegion.indexOf(name) !== -1) {
										$scope.filteredRegion.splice($scope.filteredRegion.indexOf(name), 1);
										$scope.regionList.push(name);
										$scope.regionList.sort();
									} else {
										var index = addedNamesProdcert.indexOf(name);
										addedNamesProdcert.splice(index, 1);
										$scope.addedNames.splice(index, 1);
									}
									var position = getPosition(name);
									$scope.eventSources.splice(position, 1);
									serverData.splice(position, 1);
									displayTableData();
									angular.element(event.target).parent().remove();
								};

								function getPosition(name) {
									for (var i = 0; i < $scope.eventSources.length; i++) {
										if ($scope.eventSources[i].prodCertName === name) {
											return i;
										}
									}
								}

								$scope.disableColor = function(name, event) {
									var focus;
									if (angular.element(event.target).hasClass("enableColor")) {
										focus = angular.element(event.target);
									} else if (angular.element(event.target.parentElement).hasClass("enableColor")) {
										focus = angular.element(event.target.parentElement);
										event.stopPropagation();
									}
									if (focus.hasClass("enable")) {
										var position = getPosition(name);
										if (position || position === 0) {
											disabledData[name] = {
												"calenderData" : $scope.eventSources[position],
												"dataServer" : serverData[position]
											};
											$scope.eventSources.splice(position, 1);
											serverData.splice(position, 1);
										}
										focus.removeClass("enable");
									} else {
										if (disabledData[name]) {
											$scope.eventSources.push(disabledData[name].calenderData);
											serverData.push(disabledData[name].dataServer);
										}
										focus.addClass("enable");
									}
									displayTableData();
								};

								$scope.convertDateToString = function(dateStr) {
									if (dateStr !== '' && dateStr !== undefined) {
										return Utils.convertDateString(dateStr);
									} else {
										return '';
									}
								};

								function displayTableData() {
									var getData = false;
									$scope.tableViewTimeOffArray = [];
									var month = dateHeader.getMonth();
									var year = dateHeader.getFullYear();
									if (dataYearArray.indexOf(year) === -1) {
										getData = true;
										dataYearArray.push(year);
										dataYearArray.sort();
										startYear = dataYearArray[0];
										endYear = dataYearArray[dataYearArray.length - 1];
									}

									for (var i = 0; i < addedNamesProdcert.length; i++) {
										var name = addedNamesProdcert[i];
										var position = getPosition(name);
										if (getData) {
											getNewDataFromServer(name, position, year, month);
										} else {
											if ((position || position === 0) && !$scope.calenderShow) {
												$scope.tableViewTimeOffArray = $scope.tableViewTimeOffArray
														.concat(calenderService.getTableData(serverData[position],
																month,
																year,
																$scope.eventSources[position],
																position));
												$scope.tableViewTimeOffArray = $filter('orderBy')
														($scope.tableViewTimeOffArray, 'dateStart');
											}
										}
									}
								}

								function getNewDataFromServer(name, position, year, month) {
									if (position || position === 0) {
										disabledData[name] = {
											"calenderData" : $scope.eventSources[position],
											"dataServer" : serverData[position]
										};
										$scope.eventSources.splice(position, 1);
										serverData.splice(position, 1);
									}
									var params = {
										alias : name,
										startdate : "01/01/" + year,
										enddate : "12/31/" + year
									};
									var url = employeeServices.getUrlObj().teamMembersTimeoff;
									employeeServices
											.cudAPI(params, url)
											.then(function(response) {
												if (response[0].data[0].timeOffs) {
													disabledData[name].calenderData.events = disabledData[name].calenderData.events
															.concat(calenderService
																	.getEventsArray(response[0].data[0].timeOffs, name));
													if (disabledData[name].dataServer) {
														disabledData[name].dataServer = disabledData[name].dataServer
																.concat(response[0].data[0].timeOffs);
													} else {
														disabledData[name].dataServer = (response[0].data[0].timeOffs);
													}
												}
												if (position || position === 0) {
													$scope.eventSources.push(disabledData[name].calenderData);
													serverData.push(disabledData[name].dataServer);
													position = getPosition(name);
													$scope.tableViewTimeOffArray = $scope.tableViewTimeOffArray
															.concat(calenderService
																	.getTableData(disabledData[name].dataServer,
																			month,
																			year,
																			disabledData[name].calenderData,
																			position));
													$scope.tableViewTimeOffArray = $filter('orderBy')
															($scope.tableViewTimeOffArray, 'dateStart');
												}
											},
													function(resp) {
														if (resp.printError === true) {
															Utils.displayError();
														}
													});
								}

								$scope.addMember = function(prodCertName) {
									var memberTimeOffData = "";
									$scope.showDropDown = false;
									var params = {
										alias : Utils.escapeHtml(prodCertName),
										startdate : "01/01/" + startYear,
										enddate : "12/31/" + endYear
									};
									var url = employeeServices.getUrlObj().teamMembersTimeoff;
									employeeServices
											.cudAPI(params, url)
											.then(function(resp) {
												if (resp) {
													if (resp[0]) {
														if (resp[0].data) {
															for (var i = 0; i < resp[0].data.length; i++) {
																var indivData = resp[0].data[i];
																//indivData.ProdcertName = "abhinaw";
																//indivData.sEmpName = "abhinaw";
																if (addedNamesProdcert.indexOf(indivData.ProdcertName) === -1) {
																	$scope.addedNames.push(indivData.sEmpName);
																	addedNamesProdcert.push(indivData.ProdcertName);
																	var location = employeeServices
																			.getRegionName(indivData.nLocationID);
																	var color = "";
																	if ($scope.currentUser !== indivData.ProdcertName) {
																		color = getColor().toString()
																				.replace(/[^a-zA-Z0-9]/g, '');
																		var html = "<div add-member  member='" +
																				indivData.sEmpName +
																				"'color='" +
																				color +
																				"'remove=removeItem(name,event) prodcertname='" +
																				indivData.ProdcertName + "' ></div>";
																		angular.element('.legend-list')
																				.append($compile(html)($scope));
																		memberTimeOffData = calenderService
																				.getEventsArray(indivData.timeOffs,
																						indivData.sEmpName);
																	} else {
																		color = "#2fb0ee";
																		memberTimeOffData = calenderService
																				.getEventsArray(indivData.timeOffs);
																	}

																	serverData.push(indivData.timeOffs);
																	pushDataToSource(memberTimeOffData,
																			color,
																			indivData.sEmpName,
																			indivData.ProdcertName,
																			location);
																	//render calendar after adding data, else error in mozilla refresh
																	$timeout(function() {
																		$calender.fullCalendar("gotoDate", dateHeader);
																		$calender.fullCalendar("render");
																	});
																} else {
																	$scope.dataAvailable = true;
																	$anchorScroll();
																	$timeout(function() {
																		$scope.dataAvailable = false;
																	}, 3000);
																}
															}
														} else {
															$scope.dataRetrieveFailure = true;
															$anchorScroll();
															$timeout(function() {
																$scope.dataRetrieveFailure = false;
															}, 3000);
														}
													} else {
														$scope.dataRetrieveFailure = true;
														$anchorScroll();
														$timeout(function() {
															$scope.dataRetrieveFailure = false;
														}, 3000);
													}
												} else {
													$scope.dataRetrieveFailure = true;
													$anchorScroll();
													$timeout(function() {
														$scope.dataRetrieveFailure = false;
													}, 3000);
												}
											},
													function(resp) {
														if (resp.printError === true) {
															Utils.displayError();
														}
													});
									$scope.memberName = "";
									$scope.filteredMembers = $scope.teamMembers;

								};

								$scope.addRegion = function(region, $event) {
									if ($scope.filteredRegion.indexOf(region) === -1) {
										$scope.regionList.splice($scope.regionList.indexOf(region), 1);
										$scope.filteredRegion.push(region);
										var color = getColor().toString().replace(/[^a-zA-Z0-9]/g, '');
										var html = "<div add-region  region='" + region + "'color='" + color +
												"'remove=removeItem(name,event) ng-show= calenderShow ></div>";
										angular.element('.legend-list').append($compile(html)($scope));
										var holidays = calenderService.getRegionHolidays(region);
										var holidaysArray = calenderService.createEventsList(holidays, "party");
										pushDataToSource(holidaysArray, color, region, region, "");
										serverData.push("");
										$event.stopPropagation();
									}
								};

								function getColor() {
									var color;
									do {
										color = randomColor({
											luminosity : 'dark',
											count : 1
										});
										for (var i = 0; i < $scope.eventSources.length; i++) {
											if ($scope.eventSources[i].color === color) {
												break;
											}
										}
										if (i >= $scope.eventSources.length) {
											return color;
										}
									} while (true);
								}

								function pushDataToSource(data, color, name, prodcertName, location) {
									$scope.eventSources.push({
										color : color,
										textColor : 'white',
										padding : '0px',
										events : data,
										empName : name,
										prodCertName : prodcertName,
										location : location
									});
								}

								$scope.cancelLeave = function() {
									var params = {
										alias : eventData.requestor,
										startdate : Utils.respDateFormat(eventData.startdate.replace(/-/g, "/"), true),
										enddate : Utils.respDateFormat(eventData.enddate.replace(/-/g, "/"), true)
									};
									var url = employeeServices.getUrlObj().teamMembersTimeoff;
									employeeServices.cudAPI(params, url).then(function(resp) {
										var timeoffObj = employeeServices
												.valueOfAnotherMember(resp[0].data[0].timeOffs,
														eventData.leaveId,
														"",
														"nID");
										resp = timeoffObj;
										var cancelLeaveParameter = {
											"nID" : resp.nID,
											"nRequestTypeID" : resp.nRequestTypeID,
											"sComments" : Utils.escapeHtml($scope.reason),
											"sSubmittedBy" : resp.sSubmittedBy,
											"requestors" : [ resp.sRequestor ]
										};
										$scope.reason = "";
										var url = employeeServices.getUrlObj().deleteTimeoff;
										employeeServices.cudAPI(cancelLeaveParameter, url).then(function(response) {
											updateEventSource(eventData.requestor, eventData.leaveId);
											angular.element("#timeoff_info_cancel_confirm").modal("show");
										}, function(resp) {
											if (resp.printError === true) {
												Utils.displayError();
											}
										});
									},
											function(resp) {
												if (resp.printError === true) {
													Utils.displayError();
												}
											});
								};
								function updateEventSource(requestor, leaveId) {
									for (var i = 0; i < $scope.eventSources.length; i++) {
										if ($scope.eventSources[i].prodCertName === requestor) {
											updateSeriesModel($scope.eventSources[i].events, leaveId);
											updateTimeOffData(serverData[i], leaveId);
										}
									}
								}
								function updateSeriesModel(sourceData, leaveId) {
									if (sourceData) {
										for (var i = 0; i < sourceData.length; i++) {
											if (sourceData[i].leaveid === Number(leaveId)) {
												sourceData.splice(i, 1);
												break;
											}
										}
									}
								}
								function updateTimeOffData(timeOffData, leaveId) {
									if (timeOffData) {
										for (var i = 0; i < timeOffData.length; i++) {
											if (timeOffData[i].nID === Number(leaveId)) {
												timeOffData[i].sRequestStatus = "Cancelled";
												break;
											}
										}
									}
								}
							} ]);
})();