/**
 * This controller is used for assigning manager proxy by the admin
 */

(function() {
	app
			.controller('assignProxyCtrl',
					[
							"$scope",
							"$location",
							"$anchorScroll",
							"$timeout",
							"Utils",
							"$filter",
							"parameterService",
							"employeeServices",
							function($scope, $location, $anchorScroll, $timeout, Utils, $filter, parameterService,
									employeeServices) {

								$scope.editFlag = false;
								$scope.loadingFlag = true;
								var departmentList = [];
								var prodcertName = "";
								$scope.closeAlertMessage = function() {
									$scope.alerts = {
										deleteSuccess : false,
										deleteFailure : false,
										addSuccess : false,
										addFailure : false,
										editSuccess : false,
										editFailure : false,
										reorderSuccess : false,
										reorderFailure : false
									};
								};
								if (!(($scope.levelFlag === "Admin") || ($scope.levelFlag === "Manager" && $scope.moduleName !== "ManagerProxy"))) {
									$location.path("/applyleave");
								}
								$scope.$on('startDateChanged', function(event, date) {
									$scope.dValidFrom = date;
								});

								$scope.$on('endDateChanged', function(event, date) {
									$scope.dExpiryDate = date;
								});

								$scope.retrieveManagerList = function(moduleName) {
									$scope.closeAlertMessage();
									prodcertName = employeeServices.getEmployeeObj().ProdcertName;
									employeeServices.getListingObjArray("ManagerDetails").then(function(response) {
										$scope.managersList = response;
										if (moduleName === "ManagerProxy") {
											var currManagerObj = employeeServices
													.valueOfAnotherMember($scope.managersList,
															prodcertName,
															"",
															"ProdcertName");
											$scope.addCurrentManager(currManagerObj);
										}

									},
											function(resp) {
												if (resp.printError === true) {
													Utils.displayError();
												}
												$scope.managersList = [];
											});
									employeeServices.getListingObjArray("Department").then(function(response) {
										departmentList = response;
									}, function(resp) {
										if (resp.printError === true) {
											Utils.displayError();
										}
										departmentList = [];
									});
								};
								$scope.getAssignedProxies = function() {
									if ($scope.moduleName === 'ManagerProxy') {
										$scope.sUser = employeeServices.getEmployeeObj().ProdcertName;
										var url = employeeServices.getUrlObj().getManagerProxy;
										employeeServices.cudAPI({
											"alias" : $scope.sUser
										}, url).then(function(response) {
											$scope.assignedProxies = response[0].data;
											if ($scope.assignedProxies === null) {
												$scope.assignedProxies = [];
											}
											$scope.loadingFlag = false;
										}, function(resp) {
											if (resp.printError === true) {
												Utils.displayError();
											}
											$scope.assignedProxies = [];
										});
									} else {
										employeeServices.getListingObjArray("AssignProxy").then(function(response) {
											$scope.assignedProxies = response;
											$scope.loadingFlag = false;
										}, function(resp) {
											if (resp.printError === true) {
												Utils.displayError();
											}
											$scope.assignedProxies = [];
										});
									}
								};

								$scope.clickonCurrManagersList = function() {
									if (!angular.element(event.target.parentElement).hasClass('open')) {
										$scope.showManagers = false;
										$timeout(function() {
											$scope.showManagers = true;
										});
									}
									$scope.filteredManagerList = $scope.managersList;
								};

								$scope.keypressCurrManagersName = function(event) {
									$scope.filteredManagerList = $filter('filter')($scope.managersList, {
										'sEmpName' : $scope.sUserName
									});
									$scope.filteredManagerList = $filter('orderBy')($scope.filteredManagerList,
											'sEmpName');
									$scope.sUser = "";
									$scope.sUserDept = "";
									if (!angular.element(event.target.parentElement).hasClass('open')) {
										$scope.showManagers = false;
										$timeout(function() {
											$scope.showManagers = true;
										});
									}
								};
								$scope.tempManagerKeypress = function() {
									$scope.sProxy = "";
									$scope.sProxyDept = "";
								};

								$scope.searchTempManagersName = function() {
									var params = {
										"searchtoken" : Utils.escapeHtml($scope.sProxyName)
									};
									var url = employeeServices.getUrlObj().getEmployeeByToken;
									employeeServices.cudAPI(params, url).then(function(response) {
										$scope.tempManagerList = response[0].data;
										$scope.showTempManagers = false;
										$timeout(function() {
											$scope.showTempManagers = true;
										});
									}, function(resp) {
										if (resp.printError === true) {
											Utils.displayError();
										}
										$scope.tempManagerList = [];
									});
								};
								$scope.addCurrentManager = function(manager) {
									if (manager) {
										$scope.sUser = manager.ProdcertName;
										$scope.sUserName = manager.sEmpName;
										$scope.sUserDept = manager.sDeptName;
										$scope.showManagers = false;
									}
								};

								$scope.addTemporaryManager = function(manager) {
									$scope.showTempManagers = false;
									$scope.sProxyName = manager.sEmpName;
									$scope.sProxy = manager.ProdcertName;

									for (var i = 0; i < departmentList.length; i++) {
										if (departmentList[i].nDeptID === manager.nDeptID) {
											$scope.sProxyDept = departmentList[i].sDeptName;
										}
									}
								};

								$scope.clearFields = function() {
									$scope.editFlag = false;
									$scope.proxyForm.$setPristine();
									var actualParams = parameterService.getProxyParams();
									for ( var key in actualParams) {
										$scope[key] = actualParams[key];
									}
									$scope.$broadcast('editDates', $scope.dValidFrom, $scope.dExpiryDate);
									if ($scope.moduleName === "ManagerProxy") {
										var currManagerObj = employeeServices.valueOfAnotherMember($scope.managersList,
												prodcertName,
												"",
												"ProdcertName");
										$scope.addCurrentManager(currManagerObj);
									}
								};

								$scope.displayRevokeProxy = function(proxy) {
									$scope.clearFields();
									$scope.revokeProxyObjID = proxy.nID;
								};
								$scope.revokeProxy = function() {
									var deleteObjParams = {
										"nID" : $scope.revokeProxyObjID
									};
									employeeServices.cudAPI(deleteObjParams,
											employeeServices.getUrlObj()["delete" + $scope.moduleName]).then(function(
											response) {
										$scope.assignedProxies = [];
										$scope.loadingFlag = true;
										$scope.alerts.deleteSuccess = true;
										$scope.getAssignedProxies();
										$anchorScroll();
										$timeout(function() {
											$scope.alerts.deleteSuccess = false;
										}, 3000);

									},
											function(resp) {
												if (resp.printError === true) {
													$scope.alerts.deleteFailure = true;
													$anchorScroll();
													$timeout(function() {
														$scope.alerts.deleteFailure = false;
													}, 3000);
												}
											});
								};

								$scope.editProxy = function(proxy) {
									$scope.clearFields();
									$scope.editFlag = true;
									var actualParams = parameterService.getProxyParams();
									for ( var key in actualParams) {
										$scope[key] = proxy[key];
									}
									$scope.$broadcast('editDates', $scope.dValidFrom, $scope.dExpiryDate);
									$anchorScroll();
								};

								$scope.formatDates = function(dateStr) {
									return Utils.convertDateString(dateStr);
								};

								$scope.preventPropagation = function(event) {
									event.stopPropagation();
								};

								$scope.submitForm = function() {
									if ($scope.proxyForm.$valid) {
										var url = employeeServices.getUrlObj()["add" + $scope.moduleName];
										if ($scope.editFlag === true) {
											url = employeeServices.getUrlObj()["update" + $scope.moduleName];
										}
										var params = {
											"dExpiryDate" : Utils.respDateFormat($scope.dExpiryDate, true),
											"dValidFrom" : Utils.respDateFormat($scope.dValidFrom, true),
											"sProxy" : $scope.sProxy,
											"sUser" : Utils.escapeHtml($scope.sUser)
										};
										if ($scope.editFlag === true) {
											params.nID = $scope.nID;
										}
										employeeServices.cudAPI(params, url).then(function(resp) {
											$scope.assignedProxies = [];
											$scope.loadingFlag = true;
											if ($scope.editFlag === false) {
												$scope.alerts.addSuccess = true;
											} else {
												$scope.alerts.editSuccess = true;
											}
											$anchorScroll();
											$scope.clearFields();
											$scope.getAssignedProxies();
											$timeout(function() {
												$scope.alerts.addSuccess = false;
												$scope.alerts.editSuccess = false;
											}, 3000);
										}, function(resp) {
											if (resp.printError === true) {
												if ($scope.editFlag === false) {
													$scope.alerts.addFailure = true;
												} else {
													$scope.alerts.editFailure = true;
												}
												$anchorScroll();
												$timeout(function() {
													$scope.alerts.addFailure = false;
													$scope.alerts.editFailure = false;
												}, 3000);
											}
										});
									}
								};

							} ]);
}());