/**
 * Created by Shrujan on 4/2/2015.
 */
(function() {
	app.controller('approvalCtrl', [
			"$scope",
			"$location",
			"$anchorScroll",
			"$timeout",
			"$filter",
			"i8nConstants",
			"Utils",
			"employeeServices",
			function($scope, $location, $anchorScroll, $timeout, $filter, i8nConstants, Utils, employeeServices) {

				$scope.chkbox = {
					approveAllPending : false
				};
				$scope.alerts = {
					success : false,
					failure : false
				};
				$scope.locationsList = {
					show : false,
					name : "",
					filteredData : ""
				};
				$scope.alertMessage = "";
				$scope.pageSizeList = [ 'All', 5, 10, 20, 50 ];
				$scope.filterCountryList = [];
				$scope.filteredCountryName = [];
				$scope.activateButton = false;
				$scope.showError = false;
				var cancelObjId = "";
				var requestBody = [];
				var checkedItemsCount = 0;

				// check if access is only to admin and manager
				if ($scope.levelFlag !== "Manager" && $scope.levelFlag !== "Admin") {
					$location.path("/applyleave");
				}
				employeeServices.getListingObjArray("Location").then(function(response) {
					$scope.regionList = response;
					$scope.regionList = $filter('orderBy')($scope.regionList, 'sRegionName');
				}, function(resp) {
					if (resp.printError === true) {
						Utils.displayError();
					}
				});

				$scope.fetchAllList = function() {
					$scope.currentPage = {
						pending : 1,
						approved : 1,
						rejected : 1
					};
					$scope.pageSize = {
						pending : 10,
						approved : 10,
						rejected : 10
					};
					$scope.paginationPageSize = {
						pending : 10,
						approved : 10,
						rejected : 10
					};
					$scope.pageChangedPending(1);
					$scope.approvedPageChanged(1);
					$scope.rejectedPageChanged(1);
				};

				$scope.pageChangedPending = function(newPage) {
					$scope.chkbox.approveAllPending = false;
					$scope.activateButton = false;
					$scope.pendingList = [];
					$scope.pendingListCount = -1;

					var params = {
						"alias" : employeeServices.getProdcertName(),
						"status" : "Submitted",
						"pageno" : newPage,
						"pageSize" : $scope.paginationPageSize.pending,
						'locations' : $scope.filterCountryList
					};
					var url = employeeServices.getUrlObj().pendingTimeOff;
					employeeServices.cudAPI(params, url).then(function(response) {
						if (response[0].data === null) {
							response[0].data = [ {
								"MyTimeOffApprovals" : [],
								"TotalTimeOffCount" : 0
							} ];
						}
						response = response[0].data[0];
						$scope.pendingList = response.MyTimeOffApprovals;
						$scope.pendingListCount = response.TotalTimeOffCount;
						for ( var indx in $scope.pendingList) {
							$scope.pendingList[indx].showDetails = false;
							$scope.pendingList[indx].checked = false;
							$scope.pendingList[indx].showError = false;
							$scope.pendingList[indx].comments = "";
						}
						if ($scope.pageSize.pending === 'All') {
							$scope.paginationPageSize.pending = $scope.pendingListCount;
						}
					}, function(resp) {
						if (resp.printError === true) {
							Utils.displayError();
						}
					});
				};
				$scope.approvedPageChanged = function(newPage) {
					$scope.chkbox.approveAllPending = false;
					$scope.activateButton = false;
					$scope.approvedList = [];
					$scope.approvedListCount = -1;

					var params = {
						"alias" : employeeServices.getProdcertName(),
						"status" : "Approved",
						"pageno" : newPage,
						"pageSize" : $scope.paginationPageSize.approved,
						'locations' : $scope.filterCountryList
					};
					var url = employeeServices.getUrlObj().pendingTimeOff;
					employeeServices.cudAPI(params, url).then(function(response) {
						if (response[0].data === null) {
							response[0].data = [ {
								"MyTimeOffApprovals" : [],
								"TotalTimeOffCount" : 0
							} ];
						}
						response = response[0].data[0];
						$scope.approvedList = response.MyTimeOffApprovals;
						$scope.approvedListCount = response.TotalTimeOffCount;
						for ( var indx in $scope.approvedList) {
							$scope.approvedList[indx].showDetails = false;
						}
						if ($scope.pageSize.approved === 'All') {
							$scope.paginationPageSize.approved = $scope.approvedListCount;
						}
					}, function(resp) {
						if (resp.printError === true) {
							Utils.displayError();
						}
					});
				};
				$scope.rejectedPageChanged = function(newPage) {
					$scope.chkbox.approveAllPending = false;
					$scope.activateButton = false;
					$scope.rejectedList = [];
					$scope.rejectedListCount = -1;

					var params = {
						"alias" : employeeServices.getProdcertName(),
						"status" : "Rejected",
						"pageno" : newPage,
						"pageSize" : $scope.paginationPageSize.rejected,
						'locations' : $scope.filterCountryList
					};
					var url = employeeServices.getUrlObj().pendingTimeOff;
					employeeServices.cudAPI(params, url).then(function(response) {
						if (response[0].data === null) {
							response[0].data = [ {
								"MyTimeOffApprovals" : [],
								"TotalTimeOffCount" : 0
							} ];
						}
						response = response[0].data[0];
						$scope.rejectedList = response.MyTimeOffApprovals;
						$scope.rejectedListCount = response.TotalTimeOffCount;
						for ( var indx in $scope.rejectedList) {
							$scope.rejectedList[indx].showDetails = false;
						}
						if ($scope.pageSize.rejected === 'All') {
							$scope.paginationPageSize.rejected = $scope.rejectedListCount;
						}
					}, function(resp) {
						if (resp.printError === true) {
							Utils.displayError();
						}
					});
				};

				$scope.convertDate = function(dateStr) {
					if (dateStr !== undefined) {
						return Utils.convertDateString(dateStr);
					} else {
						return "N.A";
					}
				};
				$scope.valueChanged = function(type) {
					if (type === 'Pending') {
						if ($scope.pageSize.pending === 'All') {
							$scope.paginationPageSize.pending = $scope.pendingListCount;
						} else {
							$scope.paginationPageSize.pending = $scope.pageSize.pending;
						}
					} else if (type === 'Approved') {
						if ($scope.pageSize.approved === 'All') {
							$scope.paginationPageSize.approved = $scope.approvedListCount;
						} else {
							$scope.paginationPageSize.approved = $scope.pageSize.approved;
						}
					} else if (type === 'Rejected') {
						if ($scope.pageSize.rejected === 'All') {
							$scope.paginationPageSize.rejected = $scope.rejectedListCount;
						} else {
							$scope.paginationPageSize.rejected = $scope.pageSize.rejected;
						}
					}
				};
				$scope.preventPropagation = function(event) {
					event.stopPropagation();
				};

				$scope.clickonLocationsList = function(event) {
					if (!angular.element(event.target.parentElement).hasClass('open')) {
						$scope.locationsList.show = false;
						$timeout(function() {
							$scope.locationsList.show = true;
						});
					}
					$scope.locationsList.filteredData = $scope.regionList;
				};

				$scope.keypressLocationsList = function(event) {
					$scope.locationsList.filteredData = $filter('filter')($scope.regionList, {
						'sRegionName' : $scope.locationsList.name
					});
					$scope.locationsList.filteredData = $filter('orderBy')($scope.locationsList.filteredData,
							'sRegionName');
					if (!angular.element(event.target.parentElement).hasClass('open')) {
						$scope.locationsList.show = false;
						$timeout(function() {
							$scope.locationsList.show = true;
						});
					}
				};

				$scope.addLocation = function(region, event) {
					$scope.locationsList.name = "";
					if ($scope.filterCountryList.indexOf(region.nLocationID) === -1) {
						$scope.filterCountryList.push(region.nLocationID);
						$scope.filteredCountryName.push(region.sRegionName);
					} else {
						$scope.filterCountryList.splice($scope.filterCountryList.indexOf(region.nLocationID), 1);
						$scope.filteredCountryName.splice($scope.filteredCountryName.indexOf(region.sRegionName), 1);
					}
					event.stopPropagation();
				};

				$scope.removeLocation = function(index) {
					$scope.filterCountryList.splice(index, 1);
					$scope.filteredCountryName.splice(index, 1);
				};

				$scope.selectIndividualTimeOffs = function(timeoff) {
					if (timeoff.checked === true) {
						checkedItemsCount++;
						$scope.activateButton = true;
						if (checkedItemsCount === $scope.pendingList.length) {
							$scope.chkbox.approveAllPending = true;
						}
					} else {
						checkedItemsCount--;
						$scope.chkbox.approveAllPending = false;
						timeoff.showError = false;
						timeoff.comments = "";
						if (checkedItemsCount === 0) {
							$scope.activateButton = false;
						}
					}
				};
				$scope.selectAllPendingTimeOffs = function() {
					var key;
					if ($scope.chkbox.approveAllPending === true) {
						$scope.activateButton = true;
						checkedItemsCount = $scope.pendingList.length;
						for (key in $scope.pendingList) {
							if ($scope.pendingList[key].sAction[0] !== 'No Action') {
								$scope.pendingList[key].checked = true;
							}
						}
					} else {
						checkedItemsCount = 0;
						$scope.activateButton = false;
						for (key in $scope.pendingList) {
							if ($scope.pendingList[key].sAction[0] !== 'No Action') {
								$scope.pendingList[key].checked = false;
								$scope.pendingList[key].showError = false;
								$scope.pendingList[key].comments = "";
							}
						}
					}
				};
				$scope.approveConfirmation = function() {
					toggleTimeOffApprovalValidations(false);
					$("#approve_timeoff").modal("show");
				};
				$scope.rejectConfirmation = function() {
					toggleTimeOffApprovalValidations(true);
					$timeout(function() {
						if ($scope.pendingListForm.$valid) {
							$("#reject_timeoff").modal("show");
						}
					});
				};
				function toggleTimeOffApprovalValidations(isApproval) {
					requestBody = [];
					for ( var key in $scope.pendingList) {
						if ($scope.pendingList[key].checked === true) {
							if (isApproval && !$scope.pendingList[key].comments) {
								$scope.pendingList[key].showError = true;
							} else {
								$scope.pendingList[key].showError = false;
								var temp = {};
								temp.nID = $scope.pendingList[key].nID;
								temp.sComment = $scope.pendingList[key].comments ? Utils
										.escapeHtml($scope.pendingList[key].comments) : "";
								requestBody.push(temp);
							}
						}
					}
				}
				$scope.processTimeOffs = function(type) {
					if (requestBody.length > 0) {
						var url;
						if (type === "Email") {
							url = employeeServices.getUrlObj().sendEmail;
						} else if (type === "Approve") {
							url = employeeServices.getUrlObj().approveTimeOff;
						} else if (type === "Reject") {
							url = employeeServices.getUrlObj().rejectTimeOff;
						}
						employeeServices.cudAPI(requestBody, url).then(function() {
							if (type === 'Approve') {
								$scope.alertMessage = i8nConstants.TIME_OFF_APPROVED_SUCCESSFULLY;
							} else {
								$scope.alertMessage = i8nConstants.TIME_OFF_REJECTED_SUCCESSFULLY;
							}
							$scope.activateButton = false;
							$scope.alerts.success = true;
							$anchorScroll();
							$scope.fetchAllList();
							$timeout(function() {
								$scope.alerts.success = false;
							}, 3000);
						},
								function(response) {
									if (response.printError === true) {
										if (type === 'Approve') {
											$scope.alertMessage = i8nConstants.UNABLE_TO_APPROVE_TIME_OFF + ' ' +
													i8nConstants.PLEASE_TRY_AGAIN;
										} else {
											$scope.alertMessage = i8nConstants.UNABLE_TO_REJECT_TIME_OFF + ' ' +
													i8nConstants.PLEASE_TRY_AGAIN;
										}
										$scope.alerts.failure = true;
										$anchorScroll();
										$timeout(function() {
											$scope.alerts.failure = false;
										}, 3000);
									}
								});
					}
				};
				$scope.cancelPopupDisplay = function(id) {
					$scope.cancelReason = "";
					cancelObjId = id;
				};
				$scope.cancelTimeOffs = function() {
					if ($scope.cancelReason === "" || $scope.cancelReason === undefined) {
						$scope.showError = true;
					} else {
						$scope.showError = false;
						$("#cancel_timeoff").modal("hide");
						requestBody = [ {
							"nID" : cancelObjId,
							"sComment" : Utils.escapeHtml($scope.cancelReason)
						} ];
						$scope.cancelReason = "";
						$scope.processTimeOffs('Reject');
					}
				};
			} ]);
})();