'use strict';
/**
 * @ngdoc function
 * @name timeOffCommvaultApp.controller:AboutCtrl
 * @description # applyTimeOffCtrl Controller applying timeoff for employee
 */
(function() {
	app
			.controller('applyTimeoffCtrl',
					[
							"$scope",
							"$anchorScroll",
							"$routeParams",
							"$timeout",
							"$filter",
							"$rootScope",
							"Utils",
							"$location",
							"i8nConstants",
							"TIMEOFF_CONSTANTS",
							"parameterService",
							"employeeServices",
							"timeoffInfoService",
							"msalAuthenticationService",
							function($scope, $anchorScroll, $routeParams, $timeout, $filter, $rootScope, Utils, $location,
									i8nConstants, timeoffConstants, parameterService, employeeServices, timeoffInfoService, msalService) {
								$scope.params = {};
								$scope.showList = {
									showMembersList : false,
									showTimeoffTypeList : false
								};
								$scope.params.officeAuthData = {
									loginSuccess: false,
									accessSuccess: false,
									authToken: null,
									accessToken: null,
									authUsername: null,
									authAccountName: null,
									userInteractionProgress: false,
								}

								$scope.closeAlertMessage = function() {
									$scope.alerts = {
										success : false,
										failure : false
									};
									$scope.auth = {
										success : false,
										failure : false,
										info: false
									};
								};
								$scope.getData = {
									retrieve : false,
									success : false,
									failure : false
								};
								$scope.filteredData = {
									name : [],
									timeoffType : []
								};
								var regionName = employeeServices.getRegionName();
								$scope.availableHolidays = employeeServices.getHolidaysForApplyPage()[regionName];
								$scope.teamMembers = employeeServices.getTeamMembers();
								$scope.loggedInUser = employeeServices.getProdcertName();
								$scope.placeholder = i8nConstants.START_TYPING_MEMBERS_NAME;
								$scope.apply_flag = false;
								$scope.editFlag = false;
								$scope.appliedMemberProdcertname = "";
								$scope.$on('applyDateChanged', function(event, startdate, enddate, daysOfAbsence) {
									$scope.params.startDate = startdate;
									$scope.params.endDate = enddate;
									$scope.params.daysOfAbsence = daysOfAbsence;
								});
								if(employeeServices.isOutOfOfficeEnabled()) {
									$scope.params.enableOutOfOffice = true;
								}
								else {
									$scope.params.enableOutOfOffice = false;
								}
								$scope.getInfo = function() {
									$scope.closeAlertMessage();
									var actualParams = parameterService.getApplyLeaveParams();
									for ( var key in actualParams) {
										$scope.params[key] = actualParams[key];
									}
									$scope.params.deptName = employeeServices.getDepartmentName();
									$scope.leaveTypes = employeeServices.getLeaveTypes();
									employeeServices.setOptionalLeavesArray([]);
									$scope.$broadcast('editApplyDates', $scope.params.startDate, $scope.params.endDate);

									if ($routeParams.requestor !== undefined) {
										$scope.editFlag = true;
										if (($routeParams.requestor).toLowerCase() !== (employeeServices
												.getProdcertName()).toLowerCase()) {
											$scope.availableHolidays = [];
											$scope.leaveTypes = [];
											$scope.apply_flag = true;
											var memberName = employeeServices.valueOfAnotherMember($scope.teamMembers,
													($routeParams.requestor).toLowerCase(),
													"sEmpName",
													"ProdcertName");
											if (!memberName) {
												memberName = employeeServices.valueOfAnotherMember($scope.teamMembers,
														$routeParams.requestor,
														"sEmpName",
														"ProdcertName");
											}
											$scope.getData.retrieve = true;
											var data = {
												alias : $routeParams.requestor
											};
											var url = employeeServices.getUrlObj().getTimeOffsApplicableForOthers;
											employeeServices
													.cudAPI(data, url)
													.then(function(resp) {
														$scope.getData.retrieve = false;
														$scope.getData.success = true;
														$timeout(function() {
															$scope.getData.success = false;
														}, 3000);
														$scope.params.searchName = memberName;
														$scope.appliedMemberProdcertname = $routeParams.requestor;
														$scope['leaveData' + $routeParams.requestor] = resp[0].data[0].empLeaveType;
														$scope.leaveTypes = resp[0].data[0].empLeaveType;
														findApplicableHolidays();
														editLeave();
													},
															function(resp) {
																if (resp.printError === true) {
																	$scope.getData.retrieve = false;
																	$scope.getData.failure = true;
																	$timeout(function() {
																		$scope.getData.failure = false;
																	}, 3000);
																}
															});
										} else {
											editLeave();
										}
									}
								};
								function editLeave() {
									var url = employeeServices.getUrlObj().editTimeOffUrl;
									employeeServices
											.cudAPI({
												id : $routeParams.leaveId
											}, url)
											.then(function(response) {
												var resp = response[0].data[0];
												$scope.params.startDate = new Date(resp.dateStart.replace(/-/g, "/"));
												$scope.params.endDate = new Date(resp.dateEnd.replace(/-/g, "/"));
												$scope.params.reason = resp.sComments;
												$scope.params.leaveType = resp.sRequestType;
												$scope.params.leaveId = resp.nRequestTypeID;
												$scope.params.daysOfAbsence = resp.nWorkDays;
												$scope.params.halfDayFlag = resp.bIsHalfDay;
												$scope.params.secondHalf = resp.bHalfDayType;
												$scope.params.bSendOutlookInvite = false;
												$scope.params.leaveHalf = $scope.params.halfDayFlag ? $scope.params.secondHalf ? "secondHalf"
														: "firstHalf"
														: "fullDay";
												$scope.SelectFullFirstSecondHalfDay();
												var leaveTypeDetails = employeeServices
														.valueOfAnotherMember($scope.leaveTypes,
																$scope.params.leaveId,
																"",
																"nID");
												$scope.params.halfDayAllowed = leaveTypeDetails.bIsHalfDayAllowed;
												$scope.params.outOfOfficeAllowed = leaveTypeDetails.bIsOutOfOfficeAllowed;
												$scope.params.bIsOutlookInviteAllowed = leaveTypeDetails.bIsOutlookInviteAllowed;
												$scope.params.bIsOptionalType = leaveTypeDetails.bIsOptionalType;
												$scope.$broadcast('editApplyDates',
														$scope.params.startDate,
														$scope.params.endDate);
											},
													function(resp) {
														if (resp.printError === true) {
															Utils.displayError();
														}
													});
								}
								$scope.clickonTeamMemberList = function(event) {
									$scope.closeAlertMessage();
									if (!angular.element(event.target.parentElement).hasClass('open')) {
										$scope.showList.showMembersList = false;
										$timeout(function() {
											$scope.showList.showMembersList = true;
										});
									}
									$scope.filteredData.name = $scope.teamMembers;
								};
								$scope.clickonTimeoffsList = function(event) {
									$scope.closeAlertMessage();
									if (!angular.element(event.target.parentElement).hasClass('open')) {
										$scope.showList.showTimeoffTypeList = false;
										$timeout(function() {
											$scope.showList.showTimeoffTypeList = true;
										});
									}
									$scope.filteredData.timeoffType = $scope.leaveTypes;
								};
								$scope.keypressTeamMemberList = function(event) {
									$scope.filteredData.name = $filter('filter')($scope.teamMembers, {
										'sEmpName' : $scope.params.searchName
									});
									$scope.filteredData.name = $filter('orderBy')($scope.filteredData.name, 'sEmpName');
									if (!angular.element(event.target.parentElement).hasClass('open')) {
										$scope.showList.showMembersList = false;
										$timeout(function() {
											$scope.showList.showMembersList = true;
										});
									}
									$scope.appliedMemberProdcertname = "";
									$scope.leaveTypes = [];
									$scope.availableHolidays = [];
								};

								$scope.keypressRequestList = function(event) {
									$scope.filteredData.timeoffType = $filter('filter')($scope.leaveTypes, {
										'sRequestType' : $scope.params.leaveType
									});
									$scope.params.leaveId = "";
									if (!angular.element(event.target.parentElement).hasClass('open')) {
										$scope.showList.showTimeoffTypeList = false;
										$timeout(function() {
											$scope.showList.showTimeoffTypeList = true;
										});
									}
								};
								$scope.clearForm = function() {
									$scope.applyLeave.$setPristine();
									$scope.credentialsForm.$setPristine();
									$scope.appliedMemberProdcertname = "";
									$scope.leaveTypes = [];
									$scope.availableHolidays = [];
									$scope.params.deptName = employeeServices.getDepartmentName();
									var actualParams = parameterService.getApplyLeaveParams();
									for ( var key in actualParams) {
										$scope.params[key] = actualParams[key];
									}
									employeeServices.setOptionalLeavesArray([]);
									$scope.$broadcast('editApplyDates', $scope.params.startDate, $scope.params.endDate);
									$scope.placeholder = i8nConstants.START_TYPING_MEMBERS_NAME;

									if ($scope.apply_flag === false) {
										$scope.leaveTypes = employeeServices.getLeaveTypes();
										regionName = employeeServices.getRegionName();
										$scope.availableHolidays = employeeServices.getHolidaysForApplyPage()[regionName];
									}
								};
								$scope.preventPropagation = function(event) {
									event.stopPropagation();
								};
								$scope.selectRequestType = function(leave) {
									$scope.params.leaveType = leave.sRequestType;
									$scope.params.leaveId = leave.nID;
									$scope.params.halfDayAllowed = leave.bIsHalfDayAllowed;
									$scope.params.halfDayFlag = false;
									$scope.params.outOfOfficeAllowed = leave.bIsOutOfOfficeAllowed;
									$scope.params.bIsOutlookInviteAllowed = leave.bIsOutlookInviteAllowed;
									$scope.showList.showTimeoffTypeList = false;
									$scope.params.bSendOutlookInvite = false;
									$scope.params.markOutOfOffice = false;
									$scope.params.leaveHalf = "fullDay";
									$scope.params.secondHalf = false;
									$scope.params.bIsOptionalType = leave.bIsOptionalType; //Used in datePickerCtrl: to decide whether to show optional holiday div
									$scope.$broadcast('requestTypeChanged');
								};
								// Half day- full day selection
								$scope.SelectFullFirstSecondHalfDay = function() {
									if ($scope.params.leaveHalf === "firstHalf") {
										$scope.params.secondHalf = false;
										$scope.halfDaySection = 'First Half';
										$scope.params.halfDayFlag = true;
										$scope.params.endDate = $scope.params.startDate;
									} else if ($scope.params.leaveHalf === "secondHalf") {
										$scope.params.secondHalf = true;
										$scope.halfDaySection = 'Second Half';
										$scope.params.halfDayFlag = true;
										$scope.params.endDate = $scope.params.startDate;
									} else {
										$scope.params.halfDayFlag = false;
									}
									$scope.$broadcast('editApplyDates', $scope.params.startDate, $scope.params.endDate);
									$scope.params.markOutOfOffice = false;
								};
								$scope.submitForm = function() {
									if ($scope.applyLeave.$valid) {
										if(employeeServices.isOutOfOfficeEnabled() && $scope.params.markOutOfOffice === true && !$scope.apply_flag) {
											$scope.getOfficeAccessToken().then(function(token) {
												$scope.submitFormInternal();
											}, function(error) {
												$scope.params.markOutOfOffice = false;
												$scope.resetOfficeAuth();
												$scope.submitFormInternal();
											});
										}
										else {
											$scope.submitFormInternal();
										}
									}
								};
								$scope.submitFormInternal = function() {
									if ($scope.applyLeave.$valid) {
										if ($scope.apply_flag && $scope.appliedMemberProdcertname === "") {
											return false;
										}
										$scope.alerts.success = false;
										var requestorsArray = [];
										if ($scope.apply_flag === false) {
											requestorsArray.push(employeeServices.getProdcertName());
										} else {
											requestorsArray.push($scope.appliedMemberProdcertname);
										}
										var leaveParams = {
											"bIsHalfDay" : $scope.params.halfDayFlag,
											"bHalfDayType" : $scope.params.secondHalf,
											"dateEnd" : Utils.respDateFormat($scope.params.endDate, true),
											"dateStart" : Utils.respDateFormat($scope.params.startDate, true),
											"nRequestTypeID" : $scope.params.leaveId,
											"nWorkDays" : $scope.params.daysOfAbsence,
											"sComments" : Utils.escapeHtml($scope.params.reason.replace(new RegExp(
													'\r?\n',
													'g'), '')),
											"sOptHolidays" : employeeServices.getOptionalLeavesArray(),
											"sSubmittedBy" : employeeServices.getProdcertName(),
											"requestors" : requestorsArray,
											"user" : null,
											"bSendOutlookInvite" : $scope.params.bSendOutlookInvite,
											"generatedCode" : []
										};
										if ($scope.editFlag === true) {
											leaveParams.dateApproved = null;
											leaveParams.nID = $routeParams.leaveId;
											leaveParams.sApprovedBy = "";
											leaveParams.sApproverComments = "";
											leaveParams.sAttachment = "";
											leaveParams.sAttachmentType = "";
										}
										if ($scope.params.markOutOfOffice === true && !$scope.apply_flag) {
											leaveParams.user = {};
											leaveParams.user.message = Utils.escapeHtml($scope.params.message);
											leaveParams.user.username = $scope.params.officeAuthData.authUsername;
											leaveParams.user.accessToken = $scope.params.officeAuthData.accessToken;
										}
										$scope.leaveDetails = {
											empName : employeeServices.getEmpName(),
											dateStart : Utils.convertDateString($scope.params.startDate),
											dateEnd : Utils.convertDateString($scope.params.endDate),
											nWorkDays : $scope.params.daysOfAbsence,
											leaveType : $scope.params.leaveType,
											halfDay : $scope.params.halfDayFlag,
											sComments : $scope.params.reason,
											appliedOn : Utils.convertDateString(new Date()),
											managerName : employeeServices.getManagerName(),
											teamMates : employeeServices
													.getSelectedTeamMembersManagerName($scope.params.searchName),
											leaveStatus : i8nConstants.TIMEOFF_NOT_SUBMITTED,
											isTeamMembersPTO : $scope.apply_flag
										};
										if ($scope.params.markOutOfOffice === true && !$scope.apply_flag) {
											$scope.leaveDetails.markOutOfOffice = true;
											$scope.leaveDetails.outOfOfficeMsg = $scope.params.message;
										}
										var url = employeeServices.getUrlObj().applyTimeOff;
										if ($scope.editFlag === true) {
											url = employeeServices.getUrlObj().updateTimeOff;
										}
										employeeServices.cudAPI(leaveParams, url).then(function() {
											$scope.apply_flag = false;
											$scope.alerts.success = true;
											$scope.leaveDetails.leaveStatus = i8nConstants.PENDING;
											if ($scope.params.bIsOptionalType === true) {
												$scope.leaveDetails.leaveStatus = i8nConstants.APPROVED;
											}
											$anchorScroll();
											$scope.clearForm();
											if ($scope.editFlag === true) {
												$timeout(function() {
													$scope.editFlag = false;
													//if details modal open, don't change location
													if ($scope.alerts.success === true) {
														$location.path('/applyleave');
													}
												}, 3000);
											}
										}, function(resp) {
											if (resp.printError === true) {
												$scope.alerts.failure = true;
												$anchorScroll();
												$timeout(function() {
													$scope.alerts.failure = false;
												}, 3000);
											}
										});
									}
								};
								// Apply for team Member
								$scope.addMember = function(memberName, prodCertName) {
									$scope.clearForm();
									$scope.params.searchName = memberName;
									$scope.showList.showMembersList = false;
									$scope.getData.retrieve = true;
									var data = {
										alias : prodCertName
									};
									var url = employeeServices.getUrlObj().getTimeOffsApplicableForOthers;
									employeeServices.cudAPI(data, url).then(function(resp) {
										$scope.getData.retrieve = false;
										$scope.getData.success = true;
										$timeout(function() {
											$scope.getData.success = false;
										}, 3000);
										$scope.appliedMemberProdcertname = prodCertName;
										$scope['leaveData' + prodCertName] = resp[0].data[0].empLeaveType;
										$scope.leaveTypes = resp[0].data[0].empLeaveType;
										findApplicableHolidays();
									}, function(resp) {
										if (resp.printError === true) {
											$scope.getData.retrieve = false;
											$scope.getData.failure = true;
											$timeout(function() {
												$scope.getData.failure = false;
											}, 3000);
										}
									});
								};

								$scope.displayLeaveDetails = function() {
									$scope.alerts.success = false;
								};
								$scope.closeLeaveDetailsModal = function() {
									if ($scope.editFlag === false) {
										$timeout(function() {
											$location.path('/applyleave');
										}, 300);
									}
								};
								function findApplicableHolidays() {
									$scope.availableHolidays = [];
									var locationId = employeeServices.valueOfAnotherMember($scope.teamMembers,
											$scope.appliedMemberProdcertname,
											"nLocationID",
											"ProdcertName");
									regionName = employeeServices.getRegionName(locationId);
									$scope.availableHolidays = employeeServices.getHolidaysForApplyPage()[regionName];
								}

								$scope.showCredentialsPopup = function() {
									$scope.applyLeave.$submitted = true;
									if ($scope.params.markOutOfOffice === true && $scope.applyLeave.$valid) {
										$scope.checkingCredential = false;
										$scope.params.message = i8nConstants.HI + ",\n\n" +
												i8nConstants.THANK_YOU_FOR_YOUR_MESSAGE + ". " +
												i8nConstants.OUT_OF_OFFICE_MESSAGE;
										if ($scope.params.startDate.getTime() === $scope.params.endDate.getTime()) {
											$scope.params.message = $scope.params.message + " " + i8nConstants.ON +
													" " + Utils.convertDateString($scope.params.startDate) + ".\n\n";
										} else {
											$scope.params.message = $scope.params.message + " " +
													i8nConstants.SMALL_FROM + " " +
													Utils.convertDateString($scope.params.startDate) + " " +
													i8nConstants.SMALL_TO + " " +
													Utils.convertDateString($scope.params.endDate) + ".\n\n";
										}
										$scope.params.message = $scope.params.message + i8nConstants.THANKS + ",\n" +
												employeeServices.getEmpName();
										angular.element("#officeCredentials").modal("show");
									} else {
										$scope.checkingCredential = false;
										$scope.credentialsForm.$setPristine();
										$scope.params.markOutOfOffice = false;
										$scope.params.message = "";
										$scope.resetOfficeAuth();
									}
								};
								$scope.checkingCredential = false;
								$scope.submitCredentials = function() {
									if($scope.credentialsForm.$valid) {
										$scope.checkingCredential = true;
										if($scope.params.officeAuthData.loginSuccess === true){
											$scope.getOfficeAccessToken().then(function(token){
												if($scope.params.officeAuthData.accessSuccess === true){
													angular.element("#officeCredentials").modal("hide");
													$scope.checkingCredential = false;
												}
												else {
													$scope.checkingCredential = false;
													$scope.handleOfficeAuthError("error");
												}
											}, function(error) {
												// Force Angular to digest changes. Does not work without $apply.
												$scope.$apply(function() {
													$scope.checkingCredential = false;
													$scope.handleOfficeAuthError(error);
												});
												$scope.resetOfficeAuth();
											});
										}
										else{
											$scope.checkingCredential = false;
											$scope.credentialFailMessage = i8nConstants.OUT_OF_OFFICE_AUTH_FAILURE_MESSAGE;
											$scope.auth.failure = true;
											$anchorScroll();
											$timeout(function() {
												$scope.auth.failure = false;
											}, 3000);
										}
									}
								};
								$scope.closeCredentialsModal = function() {
									if ($scope.checkingCredential === true) {
										return false;
									}
									angular.element("#officeCredentials").modal("hide");
									$scope.checkingCredential = false;
									$scope.params.markOutOfOffice = false;
									$scope.credentialsForm.$setPristine();
									$scope.params.message = "";
									$scope.resetOfficeAuth();
								};
								$scope.initOfficeAuth = function() {
									$scope.checkingCredential = true;
									$scope.auth.info = true;
									$scope.credentialInfoMessage = i8nConstants.OUT_OF_OFFICE_POPUP_INFO;
									msalService.loginPopup(timeoffConstants.MSAL_CONFIG.consentScopes).then(function(value) {
										$scope.checkingCredential = false;
										$scope.auth.info = false;
									}, function(error) {
										$scope.checkingCredential = false;
										$scope.auth.info = false;
										$scope.resetOfficeAuth();
										$scope.handleOfficeAuthError(error);
									});
								};
								$scope.$on("msal:loginSuccess", function (event, token) {
									$scope.params.officeAuthData.loginSuccess = true;
									$scope.params.officeAuthData.authToken = token;
									var idToken = msalService.userInfo.idToken;
									if(idToken){
										$scope.params.officeAuthData.authUsername = idToken.preferred_username;
										$scope.params.officeAuthData.authAccountName = idToken.name;
									}
								});
								$scope.$on("msal:loginFailure", function (event, errorDesc, error) {
									// Handled by promise reject function in initOfficeAuth().
								});

								$scope.getOfficeAccessToken = function() {
									return new Promise(function(resolve, reject){
										if($scope.params.officeAuthData.loginSuccess === false){
											return;
										}
										$scope.incrementLoad();
										// Acquire the token
										msalService.acquireTokenSilent(timeoffConstants.MSAL_CONFIG.consentScopes).then(function(token) {
											$scope.decrementLoad();
											resolve(token);
										}, function(error) {
											$scope.decrementLoad();
											// Second attempt: Trigger a popup
											$scope.getOfficeAccessTokenPopup().then(function(token) {
												resolve(token);
											}, function(error) {
												reject(error);
											});
										});
									});
								};
								$scope.getOfficeAccessTokenPopup = function() {
									if(!$scope.params.officeAuthData.userInteractionProgress){
										$scope.params.officeAuthData.userInteractionProgress = true;
										return new Promise(function(resolve, reject) {
											msalService.acquireTokenPopup(timeoffConstants.MSAL_CONFIG.consentScopes).then(function(token) {
												$scope.params.officeAuthData.userInteractionProgress = false;
												resolve(token);
											}, function(error) {
												$scope.params.officeAuthData.userInteractionProgress = false;
												reject(error);
											});
										});
									}
								};
								$scope.$on("msal:acquireTokenSuccess", function (event, tokenOut) {
									$scope.params.officeAuthData.accessSuccess = true;
									$scope.params.officeAuthData.accessToken = tokenOut;
								});
								$scope.$on("msal:acquireTokenFailure", function (event, errorDesc, error) {
									// Handled by callers using handleOfficeAuthError().
								});

								$scope.resetOfficeAuth = function() {
									// Store token to clear cache
									var token = $scope.params.officeAuthData.authToken;
									// Reset $scope.params.officeAuthData object
									for(const prop in $scope.params.officeAuthData){
										if(typeof($scope.params.officeAuthData[prop]) === 'boolean'){
											$scope.params.officeAuthData[prop] = false;
										}
										else {
											$scope.params.officeAuthData[prop] = null;
										}
									}
									if(token) {
										msalService.clearCacheForScope(token);
									}
									// MSAL does not seem to clean up these keys.
									Object.keys(window.localStorage).forEach(function(key) {
										if (key.startsWith('msal.acquireTokenUser') || key.startsWith('msal.token.renew')) {
										  window.localStorage.removeItem(key);
										}
									});
								};

								$scope.handleOfficeAuthError = function(error) {
									if(error.indexOf('user_cancelled') >= 0) {
										// User cancelled flow; do nothing.
									}
									else if(error.indexOf('consent_required') >= 0) {
										$scope.credentialFailMessage = i8nConstants.OUT_OF_OFFICE_CONSENT_ERROR_MESSAGE;
										$scope.auth.failure = true;
										$anchorScroll();
										$timeout(function() {
											$scope.auth.failure = false;
										}, 3000);
									}
									else if(error.indexOf('popup_window_error') >= 0) {
										$scope.credentialFailMessage = i8nConstants.OUT_OF_OFFICE_POPUP_ERROR_MESSAGE;
										$scope.auth.failure = true;
										$anchorScroll();
										$timeout(function() {
											$scope.auth.failure = false;
										}, 5000);
									}
									else if(error.indexOf('timeout') >= 0){
										$scope.credentialFailMessage = i8nConstants.OUT_OF_OFFICE_TOKEN_FAILURE_MESSAGE;
										$scope.auth.failure = true;
										$anchorScroll();
										$timeout(function() {
											$scope.auth.failure = false;
										}, 7000);
									}
									else {
										$scope.credentialFailMessage = i8nConstants.OUT_OF_OFFICE_BACKEND_ERROR_MESSAGE;
										$scope.auth.failure = true;
										$anchorScroll();
										$timeout(function() {
											$scope.auth.failure = false;
										}, 7000);
									}
								};

								$scope.incrementLoad = function() {
									$rootScope.loading += 20;
								};
								$scope.decrementLoad = function() {
									$rootScope.loading -= 20;
								};

								//Not needed: May need later
								$scope.detailsFlag = false;
								$scope.detailsMsg = i8nConstants.SELECT_TIME_OFF_TYPE_TO_GET_DETAILS;
								function displayLeaveHistoryInDiv(leaveType) {
									$scope.leaveHistory = {
										cf : "N/A",
										ac : "N/A",
										used : "N/A",
										applied : "N/A"
									};
									$scope.detailsFlag = false;
									$scope.detailsMsg = i8nConstants.RETREIVING_DETAILS;
									timeoffInfoService.timeOffInfoDetails().then(function() {
										$scope.timeoffDetails = timeoffInfoService.processTimeOffInfo();
										if (!$scope.timeoffDetails || $scope.timeoffDetails.length === 0) {
											$scope.detailsMsg = i8nConstants.NO_INFORMATION_AVAILABLE;
										} else {
											var leaveObj = employeeServices.valueOfAnotherMember($scope.timeoffDetails,
													leaveType,
													"");
											if (leaveObj !== null) {
												$scope.leaveHistory = {
													cf : leaveObj.nOpeningBal,
													ac : leaveObj.nAccrued,
													used : leaveObj.nUsed,
													applied : leaveObj.nAppliedTimeOff
												};
												$scope.detailsFlag = true;
											} else {
												$scope.detailsMsg = i8nConstants.NO_INFORMATION_AVAILABLE;
											}
										}
									},
											function(resp) {
												if (resp.printError === true) {
													Utils.displayError();
												}
												$scope.detailsMsg = i8nConstants.NO_INFORMATION_AVAILABLE;
											});
								}

								//								$scope.alsoNotifyOption = function(optionName, turnOffOption) {
								//									$scope.params[optionName] = true;
								//									$scope.params[turnOffOption] = false;
								//								};

							} ]);
}());
