/**
 * 
 */
(function() {
	app
			.controller('addLeaveTypeCtrl',
					[
							"$scope",
							"$timeout",
							"$location",
							"$anchorScroll",
							"$routeParams",
							"$filter",
							"Utils",
							"i8nConstants",
							"employeeServices",
							"parameterService",
							function($scope, $timeout, $location, $anchorScroll, $routeParams, $filter, Utils,
									i8nConstants, employeeServices, parameterService) {

								// this check is for giving this controller access only to
								// admin  otherwise redirect to apply leave page for manager and employee
								if ($scope.levelFlag !== "Admin") {
									$location.path("/applyleave");
								}

								$scope.params = {};
								$scope.showList = {
									approvalList : false,
									entitlementList : false,
									regionList : false,
									countryList : false,
									deptList : false,
									overlapList : false,
									overrideList : false,
									timeoffTypeList: false,
									entitlementPolicyList: false
								};
								$scope.filteredData = {
									approvalList : false,
									entitlementList : false,
									regionList : false,
									countryList : false,
									deptList : false,
									overlapList : false,
									overrideList : false
								};
								$scope.checkbox = {
									deptSpecific : false,
									regionSpecific : false,
									override : false
								};
								$scope.inputText = {
									nEntitlementPolicy : "",
									nApprovalPolicy : "",
									countryName : "",
									regionName : "",
									overlapTimeoff : "",
									overrideTimeoff : "",
									department : ""
								};
								$scope.overlappedData = [];
								$scope.deptNames = [];
								$scope.editFlag = false;
								$scope.loadingFlag = true;
								$scope.countryID = -1;
								$scope.filteredRegionList = undefined;
								$scope.activeTab = 'timeoff';
								var counter = 0;
								var editLeaveId = "";

								if ($routeParams.leaveId !== undefined) {
									$scope.editFlag = true;
									editLeaveId = parseInt($routeParams.leaveId);
								}
								$scope.closeAlertMessage = function() {
									$scope.alerts = {
										success : false,
										failure : false,
									};
								};

								$scope.listAllPolicies = function() {
									$scope.closeAlertMessage();
									var actualParams = parameterService.getAddLeaveTypeParams();
									for ( var key in actualParams) {
										$scope.params[key] = actualParams[key];
									}
									$scope.LocationList = employeeServices.getLocationList();

									employeeServices.getListingObjArray("Department").then(function(response) {
										$scope.departmentList = response;
										getTimeoff();
									}, function(resp) {
										if (resp.printError === true) {
											Utils.displayError();
										}
									});
									getEntitlementList();
									getApprovalList();
								};

								function getTimeoff() {
									employeeServices.getListingObjArray("ListOfTimeOffs").then(function(response) {
										$scope.timeOffList = response;
										fillTableDropDown();
										$scope.loadingFlag = false;
										counter += 1;
										if ($scope.editFlag && counter === 3) {
											editTimeOff();
										}
									}, function(resp) {
										if (resp.printError === true) {
											Utils.displayError();
											$scope.timeOffList = [];
											$scope.loadingFlag = false;
										}
									});
								}

								function getEntitlementList() {
									employeeServices.getListingObjArray("EntitlementList").then(function(response) {
										$scope.entitlementList = response.reverse();
										fillEntitlementTableDropDown();
										$scope.loadingFlag = false;
										counter += 1;
										if ($scope.editFlag && counter === 3) {
											editTimeOff();
										}
									}, function(resp) {
										if (resp.printError === true) {
											Utils.displayError();
											$scope.entitlementList = [];
											$scope.loadingFlag = false;
										}
									});
								}
								function getApprovalList() {
									employeeServices.getListingObjArray("NotificationPolicy").then(function(response) {
										$scope.approvalList = response;
										$scope.loadingFlag = false;
										counter += 1;
										if ($scope.editFlag && counter === 3) {
											editTimeOff();
										}
									}, function(resp) {
										if (resp.printError === true) {
											Utils.displayError();
											$scope.approvalList = [];
											$scope.loadingFlag = false;
										}
									});
								}

								function editTimeOff() {
									$scope.params = {};
									var timeOffObj = getTimeOffObj(editLeaveId);
									var actualParams = parameterService.getAddLeaveTypeParams();
									for ( var key in actualParams) {
										$scope.params[key] = timeOffObj[key];
									}
									$scope.params.nID = timeOffObj.nID;

									$scope.inputText.nEntitlementPolicy = employeeServices
											.valueOfAnotherMember($scope.entitlementList,
													timeOffObj.nEntitlementPolicyID,
													"sPolicyName",
													"nID");
									$scope.inputText.nApprovalPolicy = employeeServices
											.valueOfAnotherMember($scope.approvalList,
													timeOffObj.nApprovalPolicyID,
													"sPolicyName",
													"nID");

									var parentID = employeeServices.valueOfAnotherMember($scope.LocationList,
											timeOffObj.nLocationID,
											"nParentLocID",
											"nLocationID");
									//if parent is present
									if (parentID !== 0 && parentID !== -1) {
										$scope.inputText.regionName = employeeServices
												.valueOfAnotherMember($scope.LocationList,
														timeOffObj.nLocationID,
														"sRegionName",
														"nLocationID");
										$scope.inputText.countryName = employeeServices
												.valueOfAnotherMember($scope.LocationList,
														parentID,
														"sCountryName",
														"nLocationID");
										$scope.countryID = parentID;
										$scope.timeoffs = getTimeOffList(parentID);
										$scope.checkbox.regionSpecific = true;

										if (timeOffObj.nOverridingReqID) {
											$scope.checkbox.override = true;
											$scope.inputText.overrideTimeoff = getTimeOffObj(timeOffObj.nOverridingReqID).sRequestType;
										} else {
											$scope.checkbox.override = false;
											$scope.inputText.overrideTimeoff = "";
										}

									} else {
										$scope.inputText.countryName = employeeServices
												.valueOfAnotherMember($scope.LocationList,
														timeOffObj.nLocationID,
														"sCountryName",
														"nLocationID");
										$scope.timeoffs = getTimeOffList($scope.params.nLocationID);
										$scope.countryID = $scope.params.nLocationID;
										$scope.checkbox.regionSpecific = false;
										$scope.inputText.regionName = "";

										$scope.checkbox.override = false;
										$scope.inputText.overrideTimeoff = "";
									}
									$scope.filteredRegionList = $filter('getRegion')($scope.LocationList,
											$scope.countryID);
									for (key in $scope.params.OverlapRequestTypeID) {
										$scope.overlappedData
												.push(getTimeOffObj($scope.params.OverlapRequestTypeID[key]).sRequestType);
									}
									for (key in $scope.params.DeptID) {
										$scope.checkbox.deptSpecific = true;
										$scope.deptNames.push(employeeServices
												.valueOfAnotherMember($scope.departmentList,
														$scope.params.DeptID[key],
														"sDeptName",
														"nDeptID"));
									}
								}

								$scope.selectEntitlementPolicy = function(policy) {
									$scope.params.nEntitlementPolicyID = policy.nID;
									$scope.inputText.nEntitlementPolicy = policy.sPolicyName;
									$scope.showList.entitlementList = false;
								};
								$scope.selectNotificationPolicy = function(policy) {
									$scope.params.nApprovalPolicyID = policy.nID;
									$scope.inputText.nApprovalPolicy = policy.sPolicyName;
									$scope.showList.approvalList = false;
								};
								$scope.selectCountry = function(country) {
									$scope.inputText.countryName = country.sCountryName;
									$scope.params.nLocationID = country.nLocationID;
									$scope.countryID = country.nLocationID;
									$scope.showList.countryList = false;
									$scope.timeoffs = getTimeOffList($scope.params.nLocationID);

									$scope.checkbox.regionSpecific = false;
									$scope.inputText.regionName = "";

									$scope.checkbox.override = false;
									$scope.inputText.overrideTimeoff = "";
									$scope.params.nOverridingReqID = 0;

									$scope.params.OverlapRequestTypeID = [];
									$scope.params.bIsOverlapAllowed = false;
									$scope.filteredRegionList = $filter('getRegion')($scope.LocationList,
											$scope.countryID);

								};
								$scope.regionSpecificChkbox = function() {
									$scope.params.nLocationID = $scope.countryID;
									$scope.inputText.regionName = "";
									$scope.inputText.overrideTimeoff = "";
									$scope.params.nOverridingReqID = 0;
									$scope.checkbox.override = false;
								};

								$scope.selectNewRegion = function(region) {
									$scope.inputText.regionName = region.sRegionName;
									$scope.params.nLocationID = region.nLocationID;
									$scope.showList.regionList = false;
								};

								$scope.overrideTimeoffChkbox = function() {
									$scope.inputText.overrideTimeoff = "";
									$scope.params.nOverridingReqID = 0;
								};
								$scope.selectOverrideTimeoff = function(timeOff) {
									$scope.params.nOverridingReqID = timeOff.nID;
									$scope.inputText.overrideTimeoff = timeOff.sRequestType;
									$scope.showList.overrideList = false;
								};
								$scope.overlapAllowed = function() {
									$scope.params.OverlapRequestTypeID = [];
									$scope.overlappedData = [];
								};
								$scope.addOverlapIdToArr = function(overlapId, timeoff, event) {
									$scope.inputText.overlapTimeoff = "";
									if ($scope.params.OverlapRequestTypeID.indexOf(overlapId) === -1) {
										$scope.params.OverlapRequestTypeID.push(overlapId);
										$scope.overlappedData.push(timeoff);
									} else {
										$scope.overlappedData.splice($scope.params.OverlapRequestTypeID
												.indexOf(overlapId), 1);
										$scope.params.OverlapRequestTypeID.splice($scope.params.OverlapRequestTypeID
												.indexOf(overlapId), 1);
									}
									event.stopPropagation();
								};
								$scope.cancelTimeoffData = function(index) {
									$scope.overlappedData.splice(index, 1);
									$scope.params.OverlapRequestTypeID.splice(index, 1);
								};

								$scope.deptSpecificSelect = function() {
									$scope.params.DeptID = [];
									$scope.deptNames = [];
								};
								$scope.addToDeptList = function(deptId, deptName, event) {
									$scope.inputText.department = "";
									if ($scope.params.DeptID.indexOf(deptId) === -1) {
										$scope.params.DeptID.push(deptId);
										$scope.deptNames.push(deptName);
									} else {
										$scope.deptNames.splice($scope.params.DeptID.indexOf(deptId), 1);
										$scope.params.DeptID.splice($scope.params.DeptID.indexOf(deptId), 1);
									}
									event.stopPropagation();
								};

								$scope.cancelDeptData = function(index) {
									$scope.deptNames.splice(index, 1);
									$scope.params.DeptID.splice(index, 1);
								};

								$scope.preventPropagation = function(event) {
									event.stopPropagation();
								};

								$scope.submitForm = function() {
									if ($scope.addTimeoffTypeForm.$valid) {

										if (($scope.countryID === -1) ||
												($scope.checkbox.regionSpecific && ($scope.params.nLocationID === $scope.countryID || $scope.countryID === -1)) ||
												($scope.checkbox.override && $scope.params.nOverridingReqID === 0) ||
												($scope.params.bIsOverlapAllowed && $scope.params.OverlapRequestTypeID.length === 0) ||
												($scope.checkbox.deptSpecific && $scope.params.DeptID.length === 0)) {
											return;
										}
										$scope.params.sRequestType = Utils.escapeHtml($scope.params.sRequestType);
										var url = employeeServices.getUrlObj().addNewTimeOffType;
										var successMessage = i8nConstants.ADDED_TIME_OFF_TYPE_SUCCESSFULLY;
										var failureMessage = i8nConstants.UNABLE_TO_ADD_TIME_OFF_TYPE + ' ' +
												i8nConstants.PLEASE_TRY_AGAIN;

										if ($scope.editFlag === true) {
											url = employeeServices.getUrlObj().editTimeOffType;
											successMessage = i8nConstants.UPDATED_TIME_OFF_TYPE_SUCCESSFULLY;
											failureMessage = i8nConstants.UNABLE_TO_EDIT_TIME_OFF_TYPE + ' ' +
													i8nConstants.PLEASE_TRY_AGAIN;
										}

										employeeServices.cudAPI($scope.params, url).then(function(resp) {
											$anchorScroll();
											$scope.alerts.success = true;
											$scope.alertMessage = successMessage;
											if ($scope.editFlag === true) {
												$anchorScroll();
												$timeout(function() {
													$location.path("/addLeaveType");
												}, 3000);
											} else {
												$timeout(function() {
													$scope.alerts.success = false;
												}, 3000);
												$scope.clearFields();
												$anchorScroll();
												getTimeoff();
											}
										}, function(resp) {
											if (resp.printError === true) {
												$scope.alerts.failure = true;
												$scope.alertMessage = failureMessage;
												$timeout(function() {
													$scope.alerts.failure = false;
												}, 3000);
												$anchorScroll();
											}
										});
									}
								};

								$scope.clearFields = function() {
									$scope.params = {};
									$scope.editFlag = false;
									$scope.addTimeoffTypeForm.$setPristine();
									var actualParams = parameterService.getAddLeaveTypeParams();
									for ( var key in actualParams) {
										$scope.params[key] = actualParams[key];
									}
									$scope.timeoffs = undefined;
									$scope.countryID = -1;
									$scope.checkbox = {
										deptSpecific : false,
										regionSpecific : false,
										override : false
									};

									$scope.inputText = {
										nEntitlementPolicy : "",
										nApprovalPolicy : "",
										countryName : "",
										regionName : "",
										overlapTimeoff : "",
										overrideTimeoff : "",
										department : ""
									};
									$scope.overlappedData = [];
									$scope.deptNames = [];

								};

								function getTimeOffList(locationId) {
									var timeoffs = [];
									if (locationId) {
										if ($scope.timeOffList) {
											for (var i = 0; i < $scope.timeOffList.length; i++) {
												if ($scope.timeOffList[i].nLocationID === locationId) {
													timeoffs.push($scope.timeOffList[i]);
												}
											}
											return timeoffs;
										}
									}
								}

								function getTimeOffObj(timeOffId) {
									var timeOffObj;
									for (var i = 0; i < $scope.timeOffList.length; i++) {
										if (timeOffId === $scope.timeOffList[i].nID) {
											timeOffObj = $scope.timeOffList[i];
										}
									}
									return timeOffObj;
								}

								//policy activities

								//datePicker popup

								$scope.format = 'dd-MMMM-yyyy';
								$scope.dateOptions = {
									showWeeks : false
								};
								$scope.datePicker = {
									opened : false
								};
								$scope.openStartDate = function(event) {
									event.stopPropagation();
									$scope.datePicker.opened = true;
								};
								$scope.editPolicy = false;

								//Add new Entitlement Policy

								$scope.showEntitlementPolicyPopup = function(policyId) {
									$scope.policy = {};
									var actualParams, key;
									if (policyId) {
										$scope.editPolicy = true;
										var params = employeeServices.valueOfAnotherMember($scope.entitlementList,
												policyId,
												"",
												"nID");
										actualParams = parameterService.getEntitlementParams();
										for (key in actualParams) {
											$scope.policy[key] = params[key];
										}
										$scope.policy.nID = policyId;
										$scope.policy.RenewedOn = new Date($scope.policy.RenewedOn);
									} else {
										$scope.editPolicy = false;
										actualParams = parameterService.getEntitlementParams();
										for (key in actualParams) {
											$scope.policy[key] = actualParams[key];
										}
										$scope.addEntitlementForm.$setPristine();
									}
								};

								$scope.addEntitlePolicy = function() {
									if ($scope.addEntitlementForm.$valid) {
										$("#addPolicyModal").modal("hide");
										var url, successMessage, failureMessage;
										$scope.policy.RenewedOn = Utils.respDateFormat($scope.policy.RenewedOn, true);
										$scope.policy.sPolicyName = Utils.escapeHtml($scope.policy.sPolicyName);
										if ($scope.editPolicy === true) {
											url = employeeServices.getUrlObj().updateEntitlementPolicy;
											successMessage = i8nConstants.UPDATED_ENTITLEMENT_POLICY_SUCCESSFULLY;
											failureMessage = i8nConstants.UNABLE_TO_EDIT_ENTITLEMENT_POLICY + ' ' +
													i8nConstants.PLEASE_TRY_AGAIN;
										} else {
											url = employeeServices.getUrlObj().addEntitlementPolicy;
											successMessage = i8nConstants.ADDED_ENTITLEMENT_POLICY_SUCCESSFULLY;
											failureMessage = i8nConstants.UNABLE_TO_ADD_ENTITLEMENT_POLICY + ' ' +
													i8nConstants.PLEASE_TRY_AGAIN;
										}

										employeeServices.cudAPI($scope.policy, url).then(function(resp) {
											getEntitlementList();
											$scope.params.nEntitlementPolicyID = resp[0].data;
											$scope.inputText.nEntitlementPolicy = $scope.policy.sPolicyName;
											$scope.alertMessage = successMessage;
											$scope.alerts.success = true;
											$anchorScroll();
											$timeout(function() {
												$scope.alerts.success = false;
											}, 3000);
										}, function(resp) {
											if (resp.printError === true) {
												$scope.alertMessage = failureMessage;
												$scope.alerts.failure = true;
												$anchorScroll();
												$timeout(function() {
													$scope.alerts.failure = false;
												}, 3000);
											}
										});
									}
								};
								//Add new Approval/Notification Policy
								$scope.showApproveNotifyPolicyPopup = function(policyId) {
									$scope.approveParam = {};
									var actualParams, key;
									if (policyId) {
										$scope.editPolicy = true;
										var params = employeeServices.valueOfAnotherMember($scope.approvalList,
												policyId,
												"",
												"nID");
										actualParams = parameterService.getApproveParams();
										for (key in actualParams) {
											$scope.approveParam[key] = params[key];
										}
										$scope.approveParam.nID = policyId;
									} else {
										$scope.editPolicy = false;
										actualParams = parameterService.getApproveParams();
										for (key in actualParams) {
											$scope.approveParam[key] = actualParams[key];
										}
										$scope.approveParam.nCntCountEscalationList[0] = {
											key : "",
											value : ""
										};
										$scope.approveParam.nTotalCountEscalationList[0] = {
											key : "",
											value : ""
										};
										$scope.addNotificationForm.$setPristine();
									}
								};

								$scope.addEscalateDaysRule = function() {
									$scope.approveParam.nCntCountEscalationList.push({
										key : "",
										value : ""
									});
								};
								$scope.removeEscalateDaysRule = function(index) {
									$scope.approveParam.nCntCountEscalationList.splice(index, 1);
								};
								$scope.addEscalateTotalTimesRule = function() {
									$scope.approveParam.nTotalCountEscalationList.push({
										key : "",
										value : ""
									});
								};
								$scope.removeEscalateTotalTimesRule = function(index) {
									$scope.approveParam.nTotalCountEscalationList.splice(index, 1);
								};

								$scope.addNotifyPolicy = function() {
									if ($scope.addNotificationForm.$valid) {
										var url, successMessage, failureMessage;
										$("#notificationPolicyModal").modal("hide");
										$scope.approveParam.sPolicyName = Utils
												.escapeHtml($scope.approveParam.sPolicyName);

										if ($scope.editPolicy === true) {
											url = employeeServices.getUrlObj().updateNotificationPolicy;
											successMessage = i8nConstants.UPDATED_APPROVAL_NOTIFICATION_POLICY_SUCCESSFULLY;
											failureMessage = i8nConstants.UNABLE_TO_EDIT_APPROVAL_NOTIFICATION_POLICY +
													' ' + i8nConstants.PLEASE_TRY_AGAIN;
										} else {
											url = employeeServices.getUrlObj().addNotificationPolicy;
											successMessage = i8nConstants.ADDED_APPROVAL_NOTIFICATION_POLICY_SUCCESSFULLY;
											failureMessage = i8nConstants.UNABLE_TO_ADD_APPROVAL_NOTIFICATION_POLICY +
													' ' + i8nConstants.PLEASE_TRY_AGAIN;
										}
										employeeServices.cudAPI($scope.approveParam, url).then(function(resp) {
											$scope.alertMessage = successMessage;
											$scope.alerts.success = true;
											$anchorScroll();
											$timeout(function() {
												$scope.alerts.success = false;
											}, 3000);
											getApprovalList();
											$scope.params.nApprovalPolicyID = resp[0].data;
											$scope.inputText.nApprovalPolicy = $scope.approveParam.sPolicyName;
										}, function(resp) {
											if (resp.printError === true) {
												$scope.alertMessage = failureMessage;
												$scope.alerts.failure = true;
												$anchorScroll();
												$timeout(function() {
													$scope.alerts.failure = false;
												}, 3000);
											}
										});
									}
								};

								//delete section
								$scope.deleteConfirmation = function(typePolicy, nid) {
									$scope.clearFields();
									$scope.deleteModule = typePolicy;
									$scope.deleteId = nid;
								};

								$scope.deleteObj = function() {
									var deleteObjParams = {
										"nID" : $scope.deleteId
									};
									employeeServices
											.cudAPI(deleteObjParams,
													employeeServices.getUrlObj()["delete" + $scope.deleteModule])
											.then(function() {
												if ($scope.deleteModule === "EntitlementPolicy") {
													getEntitlementList();
													$scope.alertMessage = i8nConstants.DELETED_ENTITLEMENT_POLICY_SUCCESSFULLY;
												} else if ($scope.deleteModule === "NotificationPolicy") {
													getApprovalList();
													$scope.alertMessage = i8nConstants.DELETED_APPROVAL_NOTIFICATION_POLICY_SUCCESSFULLY;
												} else {
													getTimeoff();
													$scope.alertMessage = i8nConstants.DELETED_TIME_OFF_TYPE_SUCCESSFULLY;
												}
												$scope.alerts.success = true;
												$anchorScroll();
												$timeout(function() {
													$scope.alerts.success = false;
												}, 3000);
												$anchorScroll();
											},
													function(resp) {
														if (resp.printError === true) {
															if ($scope.deleteModule === "EntitlementPolicy") {
																$scope.alertMessage = i8nConstants.UNABLE_TO_DELETE_ENTITLEMENT_POLICY +
																		' ' + i8nConstants.PLEASE_TRY_AGAIN;

															} else if ($scope.deleteModule === "NotificationPolicy") {
																$scope.alertMessage = i8nConstants.UNABLE_TO_DELETE_APPROVAL_NOTIFICATION_POLICY +
																		' ' + i8nConstants.PLEASE_TRY_AGAIN;
															} else {
																$scope.alertMessage = i8nConstants.UNABLE_TO_DELETE_TIME_OFF_TYPE +
																		' ' + i8nConstants.PLEASE_TRY_AGAIN;
															}
															$scope.alerts.failure = true;
															$anchorScroll();
															$timeout(function() {
																$scope.alerts.failure = false;
															}, 3000);
															$anchorScroll();
														}
													});
								};

								//table checkbox

								function fillTableDropDown() {
									$scope.filteredLocation = [];
									$scope.filteredDept = [];
									$scope.selectedDept = [];
									$scope.selectedLocation = [];

									for ( var key in $scope.timeOffList) {
										var location = "";
										var parentID = employeeServices.valueOfAnotherMember($scope.LocationList,
												$scope.timeOffList[key].nLocationID,
												"nParentLocID",
												"nLocationID");
										if (parentID !== 0 && parentID !== -1) {
											location = employeeServices.valueOfAnotherMember($scope.LocationList,
													$scope.timeOffList[key].nLocationID,
													"sRegionName",
													"nLocationID");
										} else {
											location = employeeServices.valueOfAnotherMember($scope.LocationList,
													$scope.timeOffList[key].nLocationID,
													"sCountryName",
													"nLocationID");
											if (location === "") {
												location = employeeServices.valueOfAnotherMember($scope.LocationList,
														$scope.timeOffList[key].nLocationID,
														"sRegionName",
														"nLocationID");
											}
										}
										if ($scope.filteredLocation.indexOf(location) === -1) {
											$scope.filteredLocation.push(location);
											//$scope.selectedLocation.push(location);
										}
										for ( var pos in $scope.timeOffList[key].DeptID) {
											var dept = employeeServices.valueOfAnotherMember($scope.departmentList,
													$scope.timeOffList[key].DeptID[pos],
													"sDeptName",
													"nDeptID");
											if ($scope.filteredDept.indexOf(dept) === -1) {
												$scope.filteredDept.push(dept);
												//$scope.selectedDept.push(dept);
											}
										}
									}
									var currentLocationDetails = employeeServices
											.valueOfAnotherMember($scope.LocationList,
													employeeServices.getLocationId(),
													"",
													"nLocationID");
									$scope.selectedLocation.push(currentLocationDetails.sRegionName);
									if (currentLocationDetails.sRegionName !== currentLocationDetails.sCountryName) {
										$scope.selectedLocation.push(currentLocationDetails.sCountryName);
									}
									$scope.selectedDept.push('All');
									$scope.filteredTimeoff = $filter('timeOffTypeFilter')($scope.timeOffList,
											$scope.LocationList,
											$scope.departmentList,
											$scope.selectedLocation,
											$scope.selectedDept);
								}

								function fillEntitlementTableDropDown() {
									$scope.filteredYear = [];
									$scope.selectedYear = [];
									for ( var key in $scope.entitlementList) {
										var year = new Date($scope.entitlementList[key].RenewedOn).getFullYear();
										if ($scope.filteredYear.indexOf(year) === -1) {
											$scope.filteredYear.push(year);
										}
									}
									$scope.selectedYear[0] = new Date().getFullYear();
									$scope.filteredEntitlements = $filter('entitlementPolicyFilter')
											($scope.entitlementList, $scope.selectedYear);
								}
								$scope.addEntitlementYear = function(year, event) {
									if ($scope.selectedYear.indexOf(year) === -1) {
										$scope.selectedYear.push(year);
									} else {
										$scope.selectedYear.splice($scope.selectedYear.indexOf(year), 1);
									}
									$scope.filteredEntitlements = $filter('entitlementPolicyFilter')
											($scope.entitlementList, $scope.selectedYear);
									event.stopPropagation();
								};

								$scope.timmeoffLocation = function(location, event) {
									if ($scope.selectedLocation.indexOf(location) === -1) {
										$scope.selectedLocation.push(location);
									} else {
										$scope.selectedLocation.splice($scope.selectedLocation.indexOf(location), 1);
									}

									$scope.filteredTimeoff = $filter('timeOffTypeFilter')($scope.timeOffList,
											$scope.LocationList,
											$scope.departmentList,
											$scope.selectedLocation,
											$scope.selectedDept);
									event.stopPropagation();
								};

								$scope.timmeoffDepartment = function(dept, event) {

									if ($scope.selectedDept.indexOf(dept) === -1) {
										//if (dept === "All") {
										//	$scope.selectedDept = angular.copy($scope.filteredDept);
										//	$scope.selectedDept.push('All');
										//}
										$scope.selectedDept.push(dept);
									} else {
										$scope.selectedDept.splice($scope.selectedDept.indexOf(dept), 1);
										//$scope.selectedDept.splice($scope.selectedDept.indexOf("All"), 1);
									}
									$scope.filteredTimeoff = $filter('timeOffTypeFilter')($scope.timeOffList,
											$scope.LocationList,
											$scope.departmentList,
											$scope.selectedLocation,
											$scope.selectedDept);
									event.stopPropagation();
								};

								//Dropdown keydown
								$scope.keypressEntitlementPolicyList = function(event) {
									$scope.filteredData.entitlementList = $filter('filter')($scope.entitlementList, {
										'sPolicyName' : $scope.inputText.nEntitlementPolicy
									});
									$scope.filteredData.entitlementList = $filter('orderBy')
											($scope.filteredData.entitlementList, 'sPolicyName');
									$scope.params.nEntitlementPolicyID = "";
									if (!angular.element(event.target.parentElement).hasClass('open')) {
										$scope.showList.entitlementList = false;
										$timeout(function() {
											$scope.showList.entitlementList = true;
										});
									}
								};
								$scope.keypressApprovalPolicyList = function(event) {
									$scope.filteredData.approvalList = $filter('filter')($scope.approvalList, {
										'sPolicyName' : $scope.inputText.nApprovalPolicy
									});
									$scope.filteredData.approvalList = $filter('orderBy')
											($scope.filteredData.approvalList, 'sPolicyName');
									$scope.params.nApprovalPolicyID = "";
									if (!angular.element(event.target.parentElement).hasClass('open')) {
										$scope.showList.approvalList = false;
										$timeout(function() {
											$scope.showList.approvalList = true;
										});
									}
								};
								$scope.keypressCountryList = function(event) {
									$scope.filteredData.countryList = $filter('filter')($scope.LocationList, {
										'sCountryName' : $scope.inputText.countryName
									});
									$scope.filteredData.countryList = $filter('orderBy')
											($scope.filteredData.countryList, 'sCountryName');
									$scope.params.nLocationID = "";
									$scope.countryID = -1;

									$scope.inputText.regionName = "";
									$scope.filteredRegionList = undefined;
									$scope.inputText.overrideTimeoff = "";
									$scope.params.nOverridingReqID = 0;

									$scope.inputText.overlapTimeoff = "";
									$scope.checkbox.regionSpecific = false;
									$scope.checkbox.override = false;
									$scope.params.bIsOverlapAllowed = false;
									$scope.timeoffs = undefined;
									if (!angular.element(event.target.parentElement).hasClass('open')) {
										$scope.showList.countryList = false;
										$timeout(function() {
											$scope.showList.countryList = true;
										});
									}
								};
								$scope.keypressRegionList = function(event) {
									$scope.filteredData.regionList = $filter('filter')($scope.filteredRegionList, {
										'sRegionName' : $scope.inputText.regionName
									});
									$scope.filteredData.regionList = $filter('orderBy')($scope.filteredData.regionList,
											'sRegionName');
									$scope.params.nLocationID = "";
									if (!angular.element(event.target.parentElement).hasClass('open')) {
										$scope.showList.regionList = false;
										$timeout(function() {
											$scope.showList.regionList = true;
										});
									}
								};
								$scope.keypressOverrideList = function(event) {
									$scope.filteredData.overrideList = $filter('filter')($scope.timeoffs, {
										'sRequestType' : $scope.inputText.overrideTimeoff
									});
									$scope.filteredData.overrideList = $filter('orderBy')
											($scope.filteredData.overrideList, 'sRequestType');
									$scope.params.nOverridingReqID = 0;
									if (!angular.element(event.target.parentElement).hasClass('open')) {
										$scope.showList.overrideList = false;
										$timeout(function() {
											$scope.showList.overrideList = true;
										});
									}
								};
								$scope.keypressOverlapList = function(event) {
									$scope.filteredData.overlapList = $filter('filter')($scope.timeoffs, {
										'sRequestType' : $scope.inputText.overlapTimeoff
									});
									$scope.filteredData.overlapList = $filter('orderBy')
											($scope.filteredData.overlapList, 'sRequestType');
									if (!angular.element(event.target.parentElement).hasClass('open')) {
										$scope.showList.overlapList = false;
										$timeout(function() {
											$scope.showList.overlapList = true;
										});
									}
								};
								$scope.keypressDeptList = function(event) {
									$scope.filteredData.deptList = $filter('filter')($scope.departmentList, {
										'sDeptName' : $scope.inputText.department
									});
									$scope.filteredData.deptList = $filter('orderBy')($scope.filteredData.deptList,
											'sDeptName');
									if (!angular.element(event.target.parentElement).hasClass('open')) {
										$scope.showList.deptList = false;
										$timeout(function() {
											$scope.showList.deptList = true;
										});
									}
								};

								$scope.openList = function(list, listName, event, disabled) {
									if (disabled) {
										if (disabled === true) {
											return false;
										}
									}
									if (!angular.element(event.target.parentElement).hasClass('open')) {
										$scope.showList[list] = false;
										$timeout(function() {
											$scope.showList[list] = true;
										});
									}
									$scope.filteredData[list] = $scope[listName];
								};

							} ]);
}());