/**
 * This controller is used for adding and editing holiday details
 */
(function() {
	app.controller('addHolidayCtrl', [
			"$scope",
			"$location",
			"$anchorScroll",
			"$timeout",
			"$filter",
			"Utils",
			"employeeServices",
			"parameterService",
			"holidayService",
			function($scope, $location, $anchorScroll, $timeout, $filter, Utils, employeeServices, parameterService,
					holidayService) {

				$scope.holidayList = [];
				$scope.countryFilter = [];
				$scope.showHolidayList = false;
				$scope.noHolidayMsg = i8nConstants.LOADING;
				$scope.editFlag = false;
				$scope.monthNames = holidayService.getMonthNames();
				var deleteObjId = "";
				$scope.filteredCountries = [];
				var dateObj = new Date();

				if ($scope.levelFlag !== "Admin") {
					$location.path("/applyleave");
				}

				$scope.$on('startDateChanged', function(event, date) {
					$scope.startDate = date;
				});

				$scope.$on('endDateChanged', function(event, date) {
					$scope.endDate = date;
				});

				$scope.closeAlertMessage = function() {
					$scope.alerts = {
						deleteSuccess : false,
						deleteFailure : false,
						addSuccess : false,
						addFailure : false,
						editSuccess : false,
						editFailure : false
					};
				};
				$scope.filteredData = {
					country : [],
					region : []
				};

				$scope.getLisings = function() {
					$scope.closeAlertMessage();
					$scope.LocationList = employeeServices.getLocationList();
					$scope.multiCountriesHolidayList = holidayService.getHolidaysList();
					$scope.countryFilter = Object.keys($scope.multiCountriesHolidayList).sort();
					$scope.filteredCountries = Object.keys($scope.multiCountriesHolidayList);
					updateRegionHolidays();
				};

				$scope.clickonCountryList = function(event) {
					if (!angular.element(event.target.parentElement).hasClass('open')) {
						$scope.showCountry = false;
						$timeout(function() {
							$scope.showCountry = true;
						});
					}
					$scope.filteredData.country = $scope.LocationList;
				};
				$scope.clickonRegionList = function(event) {
					if (!angular.element(event.target.parentElement).hasClass('open')) {
						$scope.showRegion = false;
						$timeout(function() {
							$scope.showRegion = true;
						});
					}
					$scope.filteredData.region = $scope.filteredList;
				};

				$scope.keypressCountryList = function(event) {
					$scope.filteredData.country = $filter('filter')($scope.LocationList, {
						'sCountryName' : $scope.sCountry
					});
					$scope.filteredData.country = $filter('orderBy')($scope.filteredData.country, 'sCountryName');
					$scope.countryID = "";
					if (!angular.element(event.target.parentElement).hasClass('open')) {
						$scope.showCountry = false;
						$timeout(function() {
							$scope.showCountry = true;
						});
					}
				};

				$scope.keypressRegionList = function(event) {
					$scope.filteredData.region = $filter('filter')($scope.filteredList, {
						'sRegionName' : $scope.sRegion
					});
					$scope.filteredData.region = $filter('orderBy')($scope.filteredData.region, 'sRegionName');
					$scope.nLocationID = "";
					if (!angular.element(event.target.parentElement).hasClass('open')) {
						$scope.showRegion = false;
						$timeout(function() {
							$scope.showRegion = true;
						});
					}
				};

				$scope.selectCountry = function(country) {
					$scope.sCountry = country.sCountryName;
					$scope.countryID = country.nLocationID;
					$scope.sRegion = country.sRegionName;
					$scope.nLocationID = country.nLocationID;
					$scope.showCountry = false;

					$scope.filteredList = $filter('getRegion')($scope.LocationList, $scope.countryID);
					$scope.filteredList.push(country);
					$scope.filteredList.sort();
				};
				$scope.selectRegion = function(location) {
					$scope.sRegion = location.sRegionName;
					$scope.nLocationID = location.nLocationID;
					$scope.showRegion = false;
				};

				$scope.submitForm = function() {
					if ($scope.addItem.$valid) {
						var params = {};
						var url = employeeServices.getUrlObj()["add" + $scope.moduleName];
						if ($scope.editFlag === true) {
							url = employeeServices.getUrlObj()["update" + $scope.moduleName];
						}
						if ($scope.moduleName === "Holiday") {
							params = {
								"startDate" : Utils.respDateFormat($scope.startDate, true),
								"endDate" : Utils.respDateFormat($scope.endDate, true),
								"sRegion" : $scope.sRegion,
								"sCountry" : $scope.sCountry,
								"sName" : Utils.escapeHtml($scope.sName),
								"nIsOptional" : $scope.nIsOptional,
								"nLocationID" : $scope.nLocationID
							};
							if ($scope.editFlag === true) {
								params.nID = $scope.nID;
							}
						}

						employeeServices.cudAPI(params, url).then(function(resp) {
							$scope.holidayList = {};
							$scope.noHolidayMsg = i8nConstants.LOADING;
							$scope.getHolidayList();
							if ($scope.editFlag === false) {
								$scope.alerts.addSuccess = true;
							} else {
								$scope.alerts.editSuccess = true;
							}
							$anchorScroll();
							$scope.clearFields();
							$timeout(function() {
								$scope.alerts.addSuccess = false;
								$scope.alerts.editSuccess = false;
							}, 3000);
						}, function(resp) {
							if (resp.printError === true) {
								if ($scope.editFlag === false) {
									$scope.alerts.addFailure = true;
								} else {
									$scope.alerts.editFailure = true;
								}
								$anchorScroll();
								$timeout(function() {
									$scope.alerts.addFailure = false;
									$scope.alerts.editFailure = false;
								}, 3000);
							}
						});
					}
				};

				$scope.clearFields = function() {
					$scope.editFlag = false;
					$scope.addItem.$setPristine();
					var actualParams = parameterService["get" + $scope.moduleName + "Params"]();
					for ( var key in actualParams) {
						$scope[key] = actualParams[key];
					}
					$scope.countryID = "";
					$scope.$broadcast('editDates', $scope.startDate, $scope.endDate);
				};

				$scope.editRow = function(rowId, country) {
					$scope.addItem.$setPristine();
					$scope.editFlag = true;
					$scope.nID = rowId;
					if (rowId !== "") {
						var formObj = employeeServices.valueOfAnotherMember($scope.multiCountriesHolidayList[country],
								rowId,
								"",
								"nID");
						for ( var key in formObj) {
							$scope[key] = formObj[key];
						}
						var locationObj = employeeServices.valueOfAnotherMember($scope.LocationList,
								$scope.nLocationID,
								"",
								"nLocationID");
						var parentId = locationObj.nParentLocID;
						if (parentId === 0 || parentId === -1) {
							$scope.sCountry = locationObj.sCountryName;
							$scope.countryID = $scope.nLocationID;
						} else {
							locationObj = employeeServices.valueOfAnotherMember($scope.LocationList,
									parentId,
									"",
									"nLocationID");
							$scope.sCountry = locationObj.sCountryName;
							$scope.countryID = parentId;
						}
						$scope.filteredList = $filter('getRegion')($scope.LocationList, $scope.countryID);
						$scope.filteredList.push(locationObj);
						$scope.filteredList.sort();
						$anchorScroll();
						$scope.$broadcast('editDates', $scope.startDate, $scope.endDate);
					}
				};

				$scope.deleteAlert = function(ObjId) {
					$scope.clearFields();
					deleteObjId = ObjId;
				};
				$scope.deleteObj = function() {
					var deleteObjParams = {
						"nID" : deleteObjId
					};
					employeeServices
							.cudAPI(deleteObjParams, employeeServices.getUrlObj()["delete" + $scope.moduleName])
							.then(function(response) {
								$scope.holidayList = {};
								$scope.noHolidayMsg = i8nConstants.LOADING;
								$scope.getHolidayList();
								$scope.alerts.deleteSuccess = true;
								$anchorScroll();
								$timeout(function() {
									$scope.alerts.deleteSuccess = false;
								}, 3000);

							}, function(resp) {
								if (resp.printError === true) {
									$scope.alerts.deleteFailure = true;
									$anchorScroll();
									$timeout(function() {
										$scope.alerts.deleteFailure = false;
									}, 3000);
								}
							});
				};

				$scope.preventPropagation = function(event) {
					event.stopPropagation();
				};

				//can be replaced by holidayCtrl

				//To support holiday list for subsequent year
				//@TODO: Need to acheive this in a better way
				$scope.monthYear = [
						"January-" + dateObj.getFullYear(),
						"February-" + dateObj.getFullYear(),
						"March-" + dateObj.getFullYear(),
						"April-" + dateObj.getFullYear(),
						"May-" + dateObj.getFullYear(),
						"June-" + dateObj.getFullYear(),
						"July-" + dateObj.getFullYear(),
						"August-" + dateObj.getFullYear(),
						"September-" + dateObj.getFullYear(),
						"October-" + dateObj.getFullYear(),
						"November-" + dateObj.getFullYear(),
						"December-" + dateObj.getFullYear(),
						"January-" + (dateObj.getFullYear() + 1),
						"February-" + (dateObj.getFullYear() + 1),
						"March-" + (dateObj.getFullYear() + 1),
						"April-" + (dateObj.getFullYear() + 1),
						"May-" + (dateObj.getFullYear() + 1),
						"June-" + (dateObj.getFullYear() + 1),
						"July-" + (dateObj.getFullYear() + 1),
						"August-" + (dateObj.getFullYear() + 1),
						"September-" + (dateObj.getFullYear() + 1),
						"October-" + (dateObj.getFullYear() + 1),
						"November-" + (dateObj.getFullYear() + 1),
						"December-" + (dateObj.getFullYear() + 1) ];

				$scope.getHolidayList = function() {
					holidayService.getAllHoliday().then(function(resp) {
						$timeout(function() {
							$scope.multiCountriesHolidayList = resp;
							$scope.countryFilter = Object.keys($scope.multiCountriesHolidayList).sort();
							//$scope.filteredCountries = Object.keys($scope.multiCountriesHolidayList);
							var countiesTempList = angular.copy($scope.filteredCountries);
							for (var i = 0; i < countiesTempList.length; i++) {
								if ($scope.countryFilter.indexOf(countiesTempList[i]) === -1) {
									$scope.filteredCountries.splice($scope.filteredCountries
											.indexOf(countiesTempList[i]), 1);
								}
							}
							updateRegionHolidays();
						});

					},
							function(resp) {
								if (resp.printError === true) {
									Utils.displayError();
									$scope.holidayList = {};
								}
							});
				};

				$scope.updateCountry = function(country, event) {
					if ($scope.filteredCountries.indexOf(country) === -1) {
						$scope.filteredCountries.push(country);
					} else {
						$scope.filteredCountries.splice($scope.filteredCountries.indexOf(country), 1);
					}
					updateRegionHolidays();
					event.stopPropagation();
				};

				var updateRegionHolidays = function() {
					$scope.holidayList = {};
					if ($scope.filteredCountries.length === 0) {
						$scope.noHolidayMsg = i8nConstants.NO_LOCATION_IS_SELECTED;
					} else if (Object.keys($scope.multiCountriesHolidayList).length > 0) {
						$scope.noHolidayMsg = i8nConstants.NO_HOLIDAYS_FOUND;
					}
					for (var j = 0; j < $scope.filteredCountries.length; j++) {
						var holidayList = $scope.multiCountriesHolidayList[$scope.filteredCountries[j]];
						if (holidayList) {
							for (var i = 0; i < holidayList.length; i++) {
								var startDate = new Date(holidayList[i].startDate);
								var endDate = new Date(holidayList[i].endDate);
								var daysDiff = Utils.calculateDays(startDate.toDateString(), endDate.toDateString());
								var holidayDate = new Date(holidayList[i].startDate);
								do {
									var date = new Date(holidayDate);
									if ($scope.monthYear.indexOf($scope.monthNames[date.getMonth()] + "-" +
											date.getFullYear()) !== -1) {
										var index = $scope.monthYear.indexOf($scope.monthNames[date.getMonth()] + "-" +
												date.getFullYear());
										if (!$scope.holidayList[$scope.monthYear[index]]) {
											$scope.holidayList[$scope.monthYear[index]] = [];
										}
										var color = "white";
										if (holidayList[i].nIsOptional === true) {
											color = "#344c67";
										}
										var holidayLocation = employeeServices
												.valueOfAnotherMember($scope.LocationList,
														holidayList[i].nLocationID,
														"",
														"nLocationID");
										if (holidayLocation.nParentLocID !== 0) {
											holidayList[i].sCountry = employeeServices
													.valueOfAnotherMember($scope.LocationList,
															holidayLocation.nParentLocID,
															"sCountryName",
															"nLocationID");
										}
										$scope.holidayList[$scope.monthYear[index]].push({
											'month' : $scope.monthNames[date.getMonth()],
											'date' : date,
											'name' : holidayList[i].sName,
											'country' : holidayList[i].sCountry,
											'region' : $scope.filteredCountries[j],
											'color' : color,
											'nID' : holidayList[i].nID
										});
									}
									holidayDate.setDate(holidayDate.getDate() + 1);
									daysDiff -= 1;
								} while (daysDiff > 0);
							}
						}
					}
					for ( var key in $scope.holidayList) {
						$scope.holidayList[key] = Utils.sortArrayBasedOnDates($scope.holidayList[key]);
					}
				};
				$scope.isEmpty = function() {
					if (Object.keys($scope.holidayList).length) {
						return false;
					}
					return true;
				};

			} ]);
}());