/*
 This controller is used for adding and editing employee with details.
 */
(function() {
	app
			.controller('addEmployeeCtrl',
					[
							"$scope",
							"$timeout",
							"$routeParams",
							"$location",
							"$filter",
							"$anchorScroll",
							"Utils",
							"employeeServices",
							"parameterService",
							function($scope, $timeout, $routeParams, $location, $filter, $anchorScroll, Utils,
									employeeServices, parameterService) {

								// this check is for giving this controller access only to
								// admin  otherwise redirect to apply leave page for manager and employee
								if ($scope.levelFlag !== "Admin") {
									$location.path("/applyleave");
								}
								$scope.closeAlertMessage = function() {
									$scope.alerts = {
										success : false,
										failure : false
									};
								};
								$scope.editFlagMode = false;
								var employeeTimeOffsObj = "";

								//for date picker settings
								$scope.format = 'dd-MMMM-yyyy';
								$scope.dateOptions = {
									showWeeks : false
								};
								$scope.datePicker = {
									main_opened : false,
									model_opened : false
								};

								$scope.resetForm = function() {
									$scope.employeeData = {
										sEmpID : "",
										ProdcertName : "",
										sEmpName : "",
										gender : "Male",
										dDateHired : "",
										sMobileNumber : "",
										sPhoneNumber : "",
										sEmail : "",
										sTitleName : "",
										nTitleID : "",
										sDeptName : "",
										nDeptID : "",
										sTeamName : "",
										nTeamID : "",
										firstManager : "",
										firstManagerID : "",
										scndManager : "",
										scndManagerID : "",
										locationName : "",
										nLocationID : "",
										assignFlag : false
									};
									$scope.assignedTimeoff = {
										timeOff : "",
										entitlementPolicy : "",
										notificationPolicy : "",
										timeoffID : "",
										entitlementPolicyID : "",
										notificationPolicyID : ""
									};
									$scope.showLists = {
										title : false,
										dept : false,
										team : false,
										manager : false,
										scndManager : false,
										location : false,
										country : false,
										region : false,
										timeoffs : false,
										notificationPolicy : false,
										entitlementPolicy : false
									};
									$scope.filteredData = {
										title : [],
										dept : [],
										team : [],
										manager : [],
										scndManager : [],
										location : [],
										country : [],
										region : []
									};

									$scope.selectedTimeOffTypes = [];
									$scope.timeOffInfo = [];
									$scope.filteredTimeOff = undefined;
								};

								// to make date field read only
								$scope.datePickerKey = function(event) {
									return Utils.keepDateFieldReadable(event);
								};
								$scope.preventPropagation = function(event) {
									event.stopPropagation();
								};

								$scope.getAllEntities = function() {
									$scope.closeAlertMessage();
									$scope.resetForm();
									// condition for edit employee
									if ($routeParams.employeeId !== undefined) {
										$scope.editFlagMode = true;
										//fetch employee details based on ID
										var params = {
											"searchtoken" : $routeParams.employeeId
										};
										var url = employeeServices.getUrlObj().getEmployeeByToken;
										employeeServices.cudAPI(params, url).then(function(response) {
											$scope.employeeData = response[0].data[0].emp;
											employeeTimeOffsObj = response[0].data[0].emp_map;
											$scope.employeeData.dDateHired = new Date($scope.employeeData.dDateHired);
											$scope.employeeData.assignFlag = false;
											getListData();
										}, function(resp) {
											if (resp.printError === true) {
												Utils.displayError();
											}
										});
									} else {
										getListData();
									}
								};

								function getListData() {
									var counter = 0;
									employeeServices.getListingObjArray("Title").then(function(response) {
										$scope.titleList = response;
										if ($scope.editFlagMode === true) {
											$scope.employeeData.sTitleName = employeeServices
													.valueOfAnotherMember($scope.titleList,
															$scope.employeeData.nTitleID,
															"sTitleName",
															"nTitleID");
										}
									},
											function(resp) {
												if (resp.printError === true) {
													Utils.displayError();
												}
											});
									employeeServices.getListingObjArray("Department").then(function(response) {
										$scope.deptList = response;
										if ($scope.editFlagMode === true) {
											$scope.employeeData.sDeptName = employeeServices
													.valueOfAnotherMember($scope.deptList,
															$scope.employeeData.nDeptID,
															"sDeptName",
															"nDeptID");
										}
									},
											function(resp) {
												if (resp.printError === true) {
													Utils.displayError();
												}
											});
									employeeServices.getListingObjArray("Team").then(function(response) {
										$scope.teamList = response;
										if ($scope.editFlagMode === true) {
											$scope.employeeData.sTeamName = employeeServices
													.valueOfAnotherMember($scope.teamList,
															$scope.employeeData.nTeamID,
															"sTeamName",
															"nTeamID");
										}
									},
											function(resp) {
												if (resp.printError === true) {
													Utils.displayError();
												}
											});
									employeeServices.getListingObjArray("Location").then(function(response) {
										$scope.locationList = response;
										if ($scope.editFlagMode === true) {
											$scope.employeeData.locationName = employeeServices
													.valueOfAnotherMember($scope.locationList,
															$scope.employeeData.nLocationID,
															"sRegionName",
															"nLocationID");
										}
									},
											function(resp) {
												if (resp.printError === true) {
													Utils.displayError();
												}
											});
									employeeServices.getListingObjArray("Manager").then(function(response) {
										$scope.managerList = response;
										if ($scope.editFlagMode === true) {
											var managerArray = [];
											if ($scope.employeeData.Manager.indexOf(",") !== -1) {
												managerArray = $scope.employeeData.Manager.split(",");
												$scope.employeeData.firstManagerID = $.trim(managerArray[0]);
												$scope.employeeData.scndManagerID = $.trim(managerArray[1]);
												$scope.employeeData.scndManager = employeeServices
														.valueOfAnotherMember($scope.managerList,
																$scope.employeeData.scndManagerID,
																"sEmpName",
																"ProdcertName");
											} else {
												$scope.employeeData.firstManagerID = $scope.employeeData.Manager;
												$scope.employeeData.scndManager = "";
												$scope.employeeData.scndManagerID = "";
											}
											$scope.employeeData.firstManager = employeeServices
													.valueOfAnotherMember($scope.managerList,
															$scope.employeeData.firstManagerID,
															"sEmpName",
															"ProdcertName");
										}
									},
											function(resp) {
												if (resp.printError === true) {
													Utils.displayError();
												}
											});

									employeeServices.getListingObjArray("ListOfTimeOffs").then(function(response) {
										$scope.timeOffList = response.sort();
										counter += 1;
										if (counter === 3 && $scope.editFlagMode === true) {
											process();
										}
									}, function(resp) {
										if (resp.printError === true) {
											Utils.displayError();
										}
									});

									employeeServices.getListingObjArray("EntitlementList").then(function(response) {
										$scope.entitlementList = response.reverse();
										$scope.entitlementList = $filter('orderBy')($scope.entitlementList,
												'sPolicyName');
										counter += 1;
										if (counter === 3 && $scope.editFlagMode === true) {
											process();
										}
									},
											function(resp) {
												if (resp.printError === true) {
													Utils.displayError();
												}
											});
									employeeServices.getListingObjArray("ApprovalList").then(function(response) {
										$scope.notificationList = response;
										$scope.notificationList = $filter('orderBy')($scope.notificationList,
												'sPolicyName');
										counter += 1;
										if (counter === 3 && $scope.editFlagMode === true) {
											process();
										}
									},
											function(resp) {
												if (resp.printError === true) {
													Utils.displayError();
												}
											});
								}

								function process() {
									if (employeeTimeOffsObj.length) {
										for (var indexTimeOff = 0; indexTimeOff < employeeTimeOffsObj.length; indexTimeOff += 1) {
											$scope.selectedTimeOffTypes
													.push(employeeTimeOffsObj[indexTimeOff].nRequestType);
											$scope.timeOffInfo
													.push({
														'nID' : employeeTimeOffsObj[indexTimeOff].nRequestType,
														'sRequestType' : employeeServices
																.valueOfAnotherMember($scope.timeOffList,
																		employeeTimeOffsObj[indexTimeOff].nRequestType,
																		"sRequestType",
																		"nID"),
														'nEntitlementPolicyID' : employeeTimeOffsObj[indexTimeOff].nLeaveEntitlementPolicyID,
														'nApprovalPolicyID' : employeeTimeOffsObj[indexTimeOff].nLeaveApprovalPolicyID
													});
										}
										$scope.employeeData.assignFlag = true;
									} else {
										$scope.employeeData.assignFlag = false;
									}
									$scope.filteredTimeOff = $filter('assignTimeoffFilter')($scope.timeOffList,
											$scope.employeeData.nLocationID,
											$scope.locationList);
									$scope.filteredTimeOff = $filter('orderBy')($scope.filteredTimeOff, 'sRequestType');
								}

								$scope.openList = function(listName, event) {
									if (!angular.element(event.target.parentElement).hasClass('open')) {
										$scope.showLists[listName] = false;
										$timeout(function() {
											$scope.showLists[listName] = true;
										});
									}
									if (listName !== "timeoffs" && listName !== "entitlementPolicy" &&
											listName !== "notificationPolicy") {
										if (listName === "scndManager") {
											$scope.filteredData[listName] = $scope.managerList;
										} else {
											$scope.filteredData[listName] = $scope[listName + 'List'];
										}
									}

								};

								$scope.keypressTitle = function(event) {
									$scope.filteredData.title = $filter('filter')($scope.titleList, {
										'sTitleName' : $scope.employeeData.sTitleName
									});
									$scope.filteredData.title = $filter('orderBy')($scope.filteredData.title,
											'sTitleName');
									$scope.employeeData.nTitleID = "";
									if (!angular.element(event.target.parentElement).hasClass('open')) {
										$scope.showLists.title = false;
										$timeout(function() {
											$scope.showLists.title = true;
										});
									}
								};
								$scope.keypressDepartment = function(event) {
									$scope.filteredData.dept = $filter('filter')($scope.deptList, {
										'sDeptName' : $scope.employeeData.sDeptName
									});
									$scope.filteredData.dept = $filter('orderBy')
											($scope.filteredData.dept, 'sDeptName');
									$scope.employeeData.nDeptID = "";
									if (!angular.element(event.target.parentElement).hasClass('open')) {
										$scope.showLists.dept = false;
										$timeout(function() {
											$scope.showLists.dept = true;
										});
									}
								};
								$scope.keypressTeam = function(event) {
									$scope.filteredData.team = $filter('filter')($scope.teamList, {
										'sTeamName' : $scope.employeeData.sTeamName
									});
									$scope.filteredData.team = $filter('orderBy')
											($scope.filteredData.team, 'sTeamName');
									$scope.employeeData.nTeamID = "";
									if (!angular.element(event.target.parentElement).hasClass('open')) {
										$scope.showLists.team = false;
										$timeout(function() {
											$scope.showLists.team = true;
										});
									}
								};
								$scope.keypressManager = function(event) {
									$scope.filteredData.manager = $filter('filter')($scope.managerList, {
										'sEmpName' : $scope.employeeData.firstManager
									});
									$scope.filteredData.manager = $filter('orderBy')($scope.filteredData.manager,
											'sEmpName');
									$scope.employeeData.firstManagerID = "";
									if (!angular.element(event.target.parentElement).hasClass('open')) {
										$scope.showLists.manager = false;
										$timeout(function() {
											$scope.showLists.manager = true;
										});
									}
								};
								$scope.keypressScndManager = function(event) {
									$scope.filteredData.scndManager = $filter('filter')($scope.managerList, {
										'sEmpName' : $scope.employeeData.scndManager
									});
									$scope.filteredData.scndManager = $filter('orderBy')
											($scope.filteredData.scndManager, 'sEmpName');
									$scope.employeeData.scndManagerID = "";
									if (!angular.element(event.target.parentElement).hasClass('open')) {
										$scope.showLists.scndManager = false;
										$timeout(function() {
											$scope.showLists.scndManager = true;
										});
									}
								};
								$scope.keypressLocation = function(event) {
									$scope.filteredData.location = $filter('filter')($scope.locationList, {
										'sRegionName' : $scope.employeeData.locationName
									});
									$scope.filteredData.location = $filter('orderBy')($scope.filteredData.location,
											'sRegionName');
									$scope.employeeData.nLocationID = "";
									$scope.filteredTimeOff = undefined;
									$scope.employeeData.assignFlag = false;
									if (!angular.element(event.target.parentElement).hasClass('open')) {
										$scope.showLists.location = false;
										$timeout(function() {
											$scope.showLists.location = true;
										});
									}
								};

								$scope.openStartDate = function(event, module) {
									event.stopPropagation();
									if (module === "addEmployee") {
										$scope.datePicker.main_opened = true;
									} else if (module === "modalPopup") {
										$scope.datePicker.model_opened = true;
									}
								};

								$scope.addTitle = function(title) {
									$scope.employeeData.nTitleID = title.nTitleID;
									$scope.employeeData.sTitleName = title.sTitleName;
									$scope.showLists.title = false;
								};

								$scope.addDepartment = function(dept) {
									$scope.employeeData.nDeptID = dept.nDeptID;
									$scope.employeeData.sDeptName = dept.sDeptName;
									$scope.showLists.dept = false;
								};
								$scope.addTeam = function(team) {
									$scope.employeeData.nTeamID = team.nTeamID;
									$scope.employeeData.sTeamName = team.sTeamName;
									$scope.showLists.team = false;
								};
								$scope.addManager = function(manager) {
									$scope.employeeData.firstManagerID = manager.ProdcertName;
									$scope.employeeData.firstManager = manager.sEmpName;
									$scope.showLists.manager = false;
								};
								$scope.addScndMngr = function(manager) {
									$scope.employeeData.scndManagerID = manager.ProdcertName;
									$scope.employeeData.scndManager = manager.sEmpName;
									$scope.showLists.scndManager = false;
								};
								$scope.addLocation = function(location) {
									$scope.employeeData.nLocationID = location.nLocationID;
									$scope.employeeData.locationName = location.sRegionName;
									$scope.showLists.location = false;
									$scope.employeeData.assignFlag = false;
									$scope.addTimeoffType();
								};
								$scope.addTimeoffType = function() {
									$timeout(function() {
										if ($scope.employeeForm.nLocationID.$valid) {
											$scope.filteredTimeOff = $filter('assignTimeoffFilter')($scope.timeOffList,
													$scope.employeeData.nLocationID,
													$scope.locationList);
											$scope.filteredTimeOff = $filter('orderBy')($scope.filteredTimeOff,
													'sRequestType');
											$scope.assignedTimeoff = {
												timeOff : "",
												entitlementPolicy : "",
												notificationPolicy : "",
												timeoffID : "",
												entitlementPolicyID : "",
												notificationPolicyID : ""
											};
											$scope.selectedTimeOffTypes = [];
											$scope.timeOffInfo = [];
											$scope.addTimeOffFormSubmitted = false;
										}
									});
								};

								//Assigning timeoffs
								$scope.displayTimeOff = function(timeOff) {
									$scope.showLists.timeoffs = false;
									$scope.assignedTimeoff.timeoffID = timeOff.nID;
									$scope.assignedTimeoff.timeOff = timeOff.sRequestType;

									//assign corresponding entitlement and notification policies
									var policyObj = employeeServices.valueOfAnotherMember($scope.entitlementList,
											timeOff.nEntitlementPolicyID,
											"",
											"nID");
									$scope.displayEntitlement(policyObj);
									policyObj = employeeServices.valueOfAnotherMember($scope.notificationList,
											timeOff.nApprovalPolicyID,
											"",
											"nID");
									$scope.displayNotification(policyObj);
								};
								$scope.displayEntitlement = function(policy) {
									$scope.showLists.entitlementPolicy = false;
									$scope.assignedTimeoff.entitlementPolicyID = policy.nID;
									$scope.assignedTimeoff.entitlementPolicy = policy.sPolicyName;
								};
								$scope.displayNotification = function(notification) {
									$scope.showLists.notificationPolicy = false;
									$scope.assignedTimeoff.notificationPolicyID = notification.nID;
									$scope.assignedTimeoff.notificationPolicy = notification.sPolicyName;
								};

								//click event after submitting assign time off form
								$scope.submitAssignTimeOffForm = function() {
									$scope.addTimeOffFormSubmitted = true;
									if ($scope.assignedTimeoff.timeoffID !== "") {
										if ($scope.selectedTimeOffTypes.indexOf($scope.assignedTimeoff.timeoffID) === -1) {
											$scope.selectedTimeOffTypes.push($scope.assignedTimeoff.timeoffID);
											$scope.timeOffInfo.push({
												'nID' : $scope.assignedTimeoff.timeoffID,
												'sRequestType' : $scope.assignedTimeoff.timeOff,
												'nEntitlementPolicyID' : $scope.assignedTimeoff.entitlementPolicyID,
												'nApprovalPolicyID' : $scope.assignedTimeoff.notificationPolicyID
											});
										} else {
											var index = $scope.selectedTimeOffTypes
													.indexOf($scope.assignedTimeoff.timeoffID);
											$scope.timeOffInfo[index].nEntitlementPolicyID = $scope.assignedTimeoff.entitlementPolicyID;
											$scope.timeOffInfo[index].nApprovalPolicyID = $scope.assignedTimeoff.notificationPolicyID;
										}
										$scope.clearAssignTimeOffForm();
									}
								};

								$scope.cancelAssignedTimeOff = function(index, event) {
									$scope.selectedTimeOffTypes.splice(index, 1);
									$scope.timeOffInfo.splice(index, 1);
									angular.element(event.target).parent().remove();
									event.stopPropagation();
								};
								$scope.clearAssignTimeOffForm = function() {
									$scope.assignedTimeoff = {
										timeOff : "",
										entitlementPolicy : "",
										notificationPolicy : "",
										timeoffID : "",
										entitlementPolicyID : "",
										notificationPolicyID : ""
									};
									$scope.addTimeOffFormSubmitted = false;
								};

								$scope.submitForm = function() {
									if ($scope.employeeForm.$valid) {
										var param = {
											emp : {},
											emp_map : []
										};
										var url = "";

										var manager = $scope.employeeData.firstManagerID;
										if ($scope.employeeData.scndManagerID !== "") {
											manager = $scope.employeeData.firstManagerID + "," +
													$scope.employeeData.scndManagerID;
										}
										param.emp = {
											"Manager" : manager,
											"ProdcertName" : Utils.escapeHtml($scope.employeeData.ProdcertName),
											"bIsDeleted" : false,
											"dDateHired" : Utils.respDateFormat($scope.employeeData.dDateHired, true),
											"dDateTerminated" : "",
											"gender" : $scope.employeeData.gender,
											"nDeptID" : $scope.employeeData.nDeptID,
											"nLocationID" : $scope.employeeData.nLocationID,
											"nTeamID" : $scope.employeeData.nTeamID,
											"nTitleID" : $scope.employeeData.nTitleID,
											"sEmail" : Utils.escapeHtml($scope.employeeData.sEmail),
											"sEmpID" : Utils.escapeHtml($scope.employeeData.sEmpID),
											"sEmpName" : Utils.escapeHtml($scope.employeeData.sEmpName),
											"sMobileNumber" : Utils.escapeHtml($scope.employeeData.sMobileNumber),
											"sPhoneNumber" : Utils.escapeHtml($scope.employeeData.sPhoneNumber),
											"sRole" : "Employee"
										};
										if ($scope.editFlagMode === true) {
											param.emp.nID = parseInt(1);
										}
										if ($scope.employeeData.assignFlag && $scope.employeeForm.nLocationID.$valid) {
											//Clear off any timeoff not assigned
											$scope.clearAssignTimeOffForm();

											if ($scope.timeOffInfo.length === 0) {
												$scope.addTimeOffFormSubmitted = true;
												return false;
											}
											for (var key = 0; key < $scope.timeOffInfo.length; key += 1) {
												param.emp_map
														.push({
															"nLeaveApprovalPolicyID" : $scope.timeOffInfo[key].nApprovalPolicyID,
															"nLeaveEntitlementPolicyID" : $scope.timeOffInfo[key].nEntitlementPolicyID,
															"nRequestType" : $scope.timeOffInfo[key].nID,
															"sEmpAlias" : $scope.employeeData.ProdcertName
														});
											}
										}
										if ($scope.editFlagMode === false) {
											url = employeeServices.getUrlObj().addEmployee;
										} else {
											url = employeeServices.getUrlObj().updateEmployee;
										}
										employeeServices.cudAPI(param, url).then(function(resp) {
											$scope.alerts.success = true;
											$anchorScroll();
											if ($scope.editFlagMode === false) {
												$scope.alertMessage = i8nConstants.ADDED_EMPLOYEE_SUCCESSFULLY;
												$scope.resetForm();
												$scope.employeeForm.$setPristine();
												$timeout(function() {
													$scope.alerts.success = false;
												}, 3000);
											} else {
												$scope.alertMessage = i8nConstants.UPDATED_EMPLOYEE_SUCCESSFULLY;
												$timeout(function() {
													$location.path('/employee');
												}, 3000);
											}

										},
												function(resp) {
													if (resp.printError === true) {
														$scope.alerts.failure = true;
														if ($scope.editFlagMode === false) {
															$scope.alertMessage = i8nConstants.UNABLE_TO_ADD_EMPLOYEE +
																	' ' + i8nConstants.PLEASE_TRY_AGAIN;
														} else {
															$scope.alertMessage = i8nConstants.UNABLE_TO_EDIT_EMPLOYEE +
																	' ' + i8nConstants.PLEASE_TRY_AGAIN;
														}
														$anchorScroll();
														$timeout(function() {
															$scope.alerts.failure = false;
														}, 3000);
													}
												});

									}

								};

								//Add new Entitlement Policy
								$scope.openEntitlementModal = function() {
									$scope.policy = {};
									var actualParams = parameterService.getEntitlementParams();
									for ( var key in actualParams) {
										$scope.policy[key] = actualParams[key];
									}
									$scope.addEntitlementForm.$setPristine();
								};
								$scope.addEntitlePolicy = function() {
									if ($scope.addEntitlementForm.$valid) {
										$("#addPolicyModal").modal("hide");
										var url = employeeServices.getUrlObj().addEntitlementPolicy;
										$scope.policy.RenewedOn = Utils.respDateFormat($scope.policy.RenewedOn, true);
										$scope.policy.sPolicyName = Utils.escapeHtml($scope.policy.sPolicyName);
										employeeServices
												.cudAPI($scope.policy, url)
												.then(function(resp) {
													$scope.alerts.success = true;
													$scope.alertMessage = i8nConstants.ADDED_ENTITLEMENT_POLICY_SUCCESSFULLY;
													$anchorScroll();
													$timeout(function() {
														$scope.alerts.success = false;
													}, 3000);
													$scope.assignedTimeoff.entitlementPolicyID = parseInt(resp[0].data);
													$scope.assignedTimeoff.entitlementPolicy = Utils
															.escapeHtml($scope.policy.sPolicyName);
													employeeServices.getListingObjArray("EntitlementList")
															.then(function(response) {
																$scope.entitlementList = response.reverse();
																$scope.entitlementList = $filter('orderBy')
																		($scope.entitlementList, 'sPolicyName');
															},
																	function(resp) {
																		if (resp.printError === true) {
																			Utils.displayError();
																		}
																	});
												},
														function(resp) {
															if (resp.printError === true) {
																$scope.alerts.failure = true;
																$scope.alertMessage = i8nConstants.UNABLE_TO_ADD_ENTITLEMENT_POLICY +
																		' ' + i8nConstants.PLEASE_TRY_AGAIN;
																$anchorScroll();
																$timeout(function() {
																	$scope.alerts.failure = false;
																}, 3000);
															}
														});
									}
								};

								//Add new Approval/Notification Policy

								$scope.openApprovalModal = function() {
									$scope.notificationParams = {};
									var actualParams = parameterService.getApproveParams();
									for ( var key in actualParams) {
										$scope.notificationParams[key] = actualParams[key];
									}
									$scope.notificationParams.nCntCountEscalationList[0] = {
										key : "",
										value : ""
									};
									$scope.notificationParams.nTotalCountEscalationList[0] = {
										key : "",
										value : ""
									};
									$scope.addNotificationForm.$setPristine();
								};
								$scope.addEscalateDaysRule = function() {
									$scope.notificationParams.nCntCountEscalationList.push({
										key : "",
										value : ""
									});
								};
								$scope.removeEscalateDaysRule = function(index) {
									$scope.notificationParams.nCntCountEscalationList.splice(index, 1);
								};
								$scope.addEscalateTotalTimesRule = function() {
									$scope.notificationParams.nTotalCountEscalationList.push({
										key : "",
										value : ""
									});
								};
								$scope.removeEscalateTotalTimesRule = function(index) {
									$scope.notificationParams.nTotalCountEscalationList.splice(index, 1);
								};
								$scope.addNotifyPolicy = function() {
									if ($scope.addNotificationForm.$valid) {
										var params = {};
										var url = employeeServices.getUrlObj().addNotificationPolicy;
										$("#notificationPolicyModal").modal("hide");
										$scope.notificationParams.sPolicyName = Utils
												.escapeHtml($scope.notificationParams.sPolicyName);

										employeeServices
												.cudAPI($scope.notificationParams, url)
												.then(function(resp) {
													$scope.alerts.success = true;
													$scope.alertMessage = i8nConstants.ADDED_APPROVAL_NOTIFICATION_POLICY_SUCCESSFULLY;
													$anchorScroll();
													$timeout(function() {
														$scope.alerts.success = false;
													}, 3000);
													$scope.assignedTimeoff.notificationPolicyID = parseInt(resp[0].data);
													$scope.assignedTimeoff.notificationPolicy = Utils
															.escapeHtml($scope.notificationParams.sPolicyName);
													employeeServices.getListingObjArray("NotificationPolicy")
															.then(function(response) {
																$scope.notificationList = response;
																$scope.notificationList = $filter('orderBy')
																		($scope.notificationList, 'sPolicyName');
															},
																	function(resp) {
																		if (resp.printError === true) {
																			Utils.displayError();
																		}
																	});
												},
														function(resp) {
															if (resp.printError === true) {
																$scope.alerts.failure = true;
																$scope.alertMessage = i8nConstants.UNABLE_TO_ADD_APPROVAL_NOTIFICATION_POLICY +
																		' ' + i8nConstants.PLEASE_TRY_AGAIN;
																$anchorScroll();
																$timeout(function() {
																	$scope.alerts.failure = false;
																}, 3000);
															}
														});
									}
								};

							} ]);
})();