'use strict';
/**
 * @ngdoc overview
 * @name timeOffCommvaultApp
 * @description # timeOffCommvaultApp
 * 
 * Main module of the application.
 */

// Create Msal object so that popup/iframe can close.
// See https://github.com/AzureAD/microsoft-authentication-library-for-js/issues/174
if (location.hash.includes("id_token") || location.hash.includes("access_token")) {
	new Msal.UserAgentApplication(null, null, null);
}

var app = angular.module('timeOffCommvaultApp',
		[
				'ngCookies',
				'ngResource',
				'ngAnimate',
				'ngRoute',
				'ngSanitize',
				'ngTouch',
				'ui.bootstrap',
				'ui.sortable',
				'ui.calendar',
				'restangular',
				'angularUtils.directives.dirPagination',
				'MsalAngular',
				'timeOffCommvaultApp.calendarServices',
				'timeOffCommvaultApp.employeeServices',
				'timeOffCommvaultApp.services',
				'timeOffCommvaultApp.holidayServices',
				'timeOffCommvaultApp.timeoffinfoService',
				'timeOffCommvaultApp.urlsServices',
				'timeOffCommvaultApp.parameterServices',
				'timeOffCommvaultApp.unescapeFilter',
				'timeOffCommvaultApp.i8n' ]).run([
		"$rootScope",
		"$location",
		"employeeServices",
		"Restangular",
		"$window",
		"Utils",
		"i8nConstants",
		function($rootScope, $location, employeeServices, Restangular, $window, Utils, i8nConstants) {
			$rootScope.$location = $location;
			$rootScope.contentLoaded = false;
			$rootScope.initialLoading = true;
			$rootScope.i8nConstants = i8nConstants;
			$rootScope.title = i8nConstants.DASHBOARD_TITLE;
			$rootScope.appRoot = appUtil.appRoot;

			$rootScope.errorMsg = i8nConstants.SOMETHING_WENT_WRONG;
			$rootScope.showError = false;
			$rootScope.loading = 0;

			function incrementLoad() {
				$rootScope.loading += 20;
			}
			function decrementLoad() {
				$rootScope.loading -= 20;
			}

			$window.onload = function() {
				$rootScope.$apply(function() {
					$rootScope.contentLoaded = true;
				});
				$(".wrapper").removeClass("hide");
			};

			if ($window.location.host === "localhost:9000") {
				employeeServices.setEnvironment("dev"); // dev , prod
			} else {
				employeeServices.setEnvironment("prod"); // dev , prod
			}

			if (employeeServices.getEnvironment() === "prod") {
				Restangular.setBaseUrl($window.location.protocol + "//" + $window.location.host + appUtil.appRoot);
				$rootScope.$on('$routeChangeStart', function(event, next) {
					if (Utils.getCsrfToken() === null) {
						$rootScope.errorMsg = i8nConstants.REDIRECTING_TO_LOGIN_PAGE;
						$rootScope.showError = true;
						$window.location.reload();
					}
				});
				Restangular.addRequestInterceptor(function(element) {
					var csrfToken = Utils.getCsrfToken();

					if (csrfToken !== null) {
						Restangular.setDefaultHeaders({
							"X-CSRF-Token" : csrfToken
						});
					}
					incrementLoad();
					if (Utils.getCsrfToken() === null) {
						$rootScope.errorMsg = i8nConstants.REDIRECTING_TO_LOGIN_PAGE;
						$rootScope.showError = true;
						$window.location.reload();
					}
					return element;
				});
				Restangular.addResponseInterceptor(function(data, operation, what, url, response, deferred) {
					decrementLoad();
					if (angular.isArray(data) || angular.isObject(data)) {
						if ((response.config.headers["X-CSRF-Token"] === null) && (response.config.method !== "GET")) {
							$rootScope.errorMsg = i8nConstants.REDIRECTING_TO_LOGIN_PAGE;
							$rootScope.showError = true;
							$window.location.reload();
						}
					} else {
						$rootScope.errorMsg = i8nConstants.SOMETHING_WENT_WRONG;
						$rootScope.showError = true;
						$window.location.reload();
					}
					return data;
				});
				Restangular.setErrorInterceptor(function(response, deferred, responseHandler) {
					decrementLoad();
					$rootScope.errorMsg = i8nConstants.SOMETHING_WENT_WRONG;
					$rootScope.showError = true;
					$window.location.reload();
				});
			} else {
				Restangular.setBaseUrl("http://localhost:9000");
				Restangular.addRequestInterceptor(function(element) {
					incrementLoad();
					return element;
				});
				Restangular.addResponseInterceptor(function(data, operation, what, url, response, deferred) {
					decrementLoad();
					return data;
				});
				Restangular.setErrorInterceptor(function(response, deferred, responseHandler) {
					decrementLoad();
				});
			}
		} ]).config([
		"$routeProvider",
		"$locationProvider",
		"$httpProvider",
		"paginationTemplateProvider",
		"msalAuthenticationServiceProvider",
		function($routeProvider, $locationProvider, $httpProvider, paginationTemplateProvider, msalProvider) {
			paginationTemplateProvider.setPath('js/views/dirPagination.tpl.html');
			$routeProvider.when('/applyleave',
					{
						templateUrl : 'js/views/apply_time_off.html',
						controller : 'applyTimeoffCtrl',
						resolve : {
							data : [
									"employeeServices",
									"$q",
									"$rootScope",
									"i8nConstants",
									function(employeeServices, $q, $rootScope, i8nConstants) {
										var deferred = $q.defer();
										employeeServices.preserveData().then(function(resp) {
											$rootScope.initialLoading = false;
											$rootScope.empName = resp.empName;
											$rootScope.levelFlag = resp.levelFlag;
											$rootScope.reportsURL = resp.reportsURL;
											$rootScope.title = i8nConstants.APPLY_TIMEOFF_TITLE;
											initMsalProvider(employeeServices.getMicrosoftAuthData(), employeeServices.isOutOfOfficeEnabled());
											deferred.resolve(resp);
										}, function(resp) {
											deferred.reject(resp);
										});
										return deferred.promise;
									} ]
						}
					}).when('/editleave/:leaveId/:requestor/:startDate/:endDate',
					{
						templateUrl : 'js/views/apply_time_off.html',
						controller : 'applyTimeoffCtrl',
						resolve : {
							data : [
									"employeeServices",
									"$q",
									"$rootScope",
									"i8nConstants",
									function(employeeServices, $q, $rootScope, i8nConstants) {
										var deferred = $q.defer();
										employeeServices.preserveData().then(function(resp) {
											$rootScope.initialLoading = false;
											$rootScope.empName = resp.empName;
											$rootScope.levelFlag = resp.levelFlag;
											$rootScope.reportsURL = resp.reportsURL;
											$rootScope.title = i8nConstants.EDIT_TIMEOFF_TITLE;
											initMsalProvider(employeeServices.getMicrosoftAuthData(), employeeServices.isOutOfOfficeEnabled());
											deferred.resolve(resp);
										}, function(resp) {
											deferred.reject(resp);
										});
										return deferred.promise;
									} ]
						}
					}).when("/calendar",
					{
						templateUrl : "js/views/calendar.html",
						controller : 'calendarCtrl',
						resolve : {
							data : [
									"employeeServices",
									"$q",
									"$rootScope",
									"i8nConstants",
									function(employeeServices, $q, $rootScope, i8nConstants) {
										var deferred = $q.defer();
										employeeServices.preserveData().then(function(resp) {
											$rootScope.initialLoading = false;
											$rootScope.empName = resp.empName;
											$rootScope.levelFlag = resp.levelFlag;
											$rootScope.reportsURL = resp.reportsURL;
											$rootScope.title = i8nConstants.CALENDAR_TITLE;
											deferred.resolve(resp);
										}, function(resp) {
											deferred.reject(resp);
										});
										return deferred.promise;
									} ]
						}
					}).when("/timeinfo",
					{
						templateUrl : "js/views/timeoff_info.html",
						controller : 'timeoffInfoCtrl',
						resolve : {
							data : [
									"employeeServices",
									"$q",
									"$rootScope",
									"i8nConstants",
									function(employeeServices, $q, $rootScope, i8nConstants) {
										var deferred = $q.defer();
										employeeServices.preserveData().then(function(resp) {
											$rootScope.initialLoading = false;
											$rootScope.empName = resp.empName;
											$rootScope.levelFlag = resp.levelFlag;
											$rootScope.reportsURL = resp.reportsURL;
											$rootScope.title = i8nConstants.INFO_TIMEOFF_TITLE;
											deferred.resolve(resp);
										}, function(resp) {
											deferred.reject(resp);
										});
										return deferred.promise;
									} ]
						}
					}).when("/holiday",
					{
						templateUrl : "js/views/holiday.html",
						controller : 'holidayCtrl',
						resolve : {
							data : [
									"employeeServices",
									"$q",
									"$rootScope",
									"i8nConstants",
									function(employeeServices, $q, $rootScope, i8nConstants) {
										var deferred = $q.defer();
										employeeServices.preserveData().then(function(resp) {
											$rootScope.initialLoading = false;
											$rootScope.empName = resp.empName;
											$rootScope.levelFlag = resp.levelFlag;
											$rootScope.reportsURL = resp.reportsURL;
											$rootScope.title = i8nConstants.HOLIDAY_TITLE;
											deferred.resolve(resp);
										}, function(resp) {
											deferred.reject(resp);
										});
										return deferred.promise;
									} ]
						}
					}).when("/approveTimeOff",
					{
						templateUrl : "js/views/approve_timeoff.html",
						controller : "approvalCtrl",
						resolve : {
							data : [
									"employeeServices",
									"$q",
									"$rootScope",
									"i8nConstants",
									function(employeeServices, $q, $rootScope, i8nConstants) {
										var deferred = $q.defer();
										employeeServices.preserveData().then(function(resp) {
											$rootScope.initialLoading = false;
											$rootScope.empName = resp.empName;
											$rootScope.levelFlag = resp.levelFlag;
											$rootScope.reportsURL = resp.reportsURL;
											$rootScope.title = i8nConstants.APPROVAL_TITLE;
											deferred.resolve(resp);
										}, function(resp) {
											deferred.reject(resp);
										});
										return deferred.promise;
									} ]
						}
					}).when("/assignManagersProxy",
					{
						templateUrl : "js/views/manager_proxy.html",
						controller : 'assignProxyCtrl',
						resolve : {
							data : [
									"employeeServices",
									"$q",
									"$rootScope",
									"i8nConstants",
									function(employeeServices, $q, $rootScope, i8nConstants) {
										var deferred = $q.defer();
										employeeServices.preserveData().then(function(resp) {
											$rootScope.initialLoading = false;
											$rootScope.empName = resp.empName;
											$rootScope.levelFlag = resp.levelFlag;
											$rootScope.reportsURL = resp.reportsURL;
											$rootScope.startdate = undefined;
											$rootScope.enddate = undefined;
											$rootScope.title = i8nConstants.ASSIGN_PROXY_TITLE;
											deferred.resolve(resp);
										}, function(resp) {
											deferred.reject(resp);
										});
										return deferred.promise;
									} ]
						}
					}).when("/dashboard",
					{
						templateUrl : "js/views/dashboard.html",
						controller : 'dashboardCtrl',
						resolve : {
							data : [
									"employeeServices",
									"$q",
									"$rootScope",
									"i8nConstants",
									function(employeeServices, $q, $rootScope, i8nConstants) {
										var deferred = $q.defer();
										employeeServices.preserveData().then(function(resp) {
											$rootScope.initialLoading = false;
											$rootScope.empName = resp.empName;
											$rootScope.levelFlag = resp.levelFlag;
											$rootScope.reportsURL = resp.reportsURL;
											$rootScope.title = i8nConstants.DASHBOARD_TITLE;
											deferred.resolve(resp);
										}, function(resp) {
											deferred.reject(resp);
										});
										return deferred.promise;
									} ]
						}
					}).when("/addLeaveType",
					{
						templateUrl : "js/views/admin_add_leave_type.html",
						controller : 'addLeaveTypeCtrl',
						resolve : {
							data : [
									"employeeServices",
									"$q",
									"$rootScope",
									"i8nConstants",
									function(employeeServices, $q, $rootScope, i8nConstants) {
										var deferred = $q.defer();
										employeeServices.preserveData().then(function(resp) {
											$rootScope.initialLoading = false;
											$rootScope.empName = resp.empName;
											$rootScope.levelFlag = resp.levelFlag;
											$rootScope.reportsURL = resp.reportsURL;
											$rootScope.title = i8nConstants.ADD_LEAVE_TITLE;
											deferred.resolve(resp);
										}, function(resp) {
											deferred.reject(resp);
										});
										return deferred.promise;
									} ]
						}
					}).when("/editLeaveType/:leaveId",
					{
						templateUrl : "js/views/admin_add_leave_type.html",
						controller : 'addLeaveTypeCtrl',
						resolve : {
							data : [
									"employeeServices",
									"$q",
									"$rootScope",
									"i8nConstants",
									function(employeeServices, $q, $rootScope, i8nConstants) {
										var deferred = $q.defer();
										employeeServices.preserveData().then(function(resp) {
											$rootScope.initialLoading = false;
											$rootScope.empName = resp.empName;
											$rootScope.levelFlag = resp.levelFlag;
											$rootScope.reportsURL = resp.reportsURL;
											$rootScope.title = i8nConstants.EDIT_LEAVE_TYPE_TITLE;
											deferred.resolve(resp);
										}, function(resp) {
											deferred.reject(resp);
										});
										return deferred.promise;
									} ]
						}
					}).when("/employee",
					{
						templateUrl : "js/views/employee.html",
						controller : 'employeeCtrl',
						resolve : {
							data : [
									"employeeServices",
									"$q",
									"$rootScope",
									"i8nConstants",
									function(employeeServices, $q, $rootScope, i8nConstants) {
										var deferred = $q.defer();
										employeeServices.preserveData().then(function(resp) {
											$rootScope.initialLoading = false;
											$rootScope.empName = resp.empName;
											$rootScope.levelFlag = resp.levelFlag;
											$rootScope.reportsURL = resp.reportsURL;
											$rootScope.title = i8nConstants.EMPLOYEE_TITLE;
											deferred.resolve(resp);
										}, function(resp) {
											deferred.reject(resp);
										});
										return deferred.promise;
									} ]
						}
					}).when("/addEmployee",
					{
						templateUrl : "js/views/addEmployee.html",
						controller : 'addEmployeeCtrl',
						resolve : {
							data : [
									"employeeServices",
									"$q",
									"$rootScope",
									"i8nConstants",
									function(employeeServices, $q, $rootScope, i8nConstants) {
										var deferred = $q.defer();
										employeeServices.preserveData().then(function(resp) {
											$rootScope.initialLoading = false;
											$rootScope.empName = resp.empName;
											$rootScope.levelFlag = resp.levelFlag;
											$rootScope.reportsURL = resp.reportsURL;
											$rootScope.title = i8nConstants.ADD_EMPLOYEE_TITLE;
											deferred.resolve(resp);
										}, function(resp) {
											deferred.reject(resp);
										});
										return deferred.promise;
									} ]
						}
					}).when("/editEmployee/:employeeId",
					{
						templateUrl : "js/views/addEmployee.html",
						controller : 'addEmployeeCtrl',
						resolve : {
							data : [
									"employeeServices",
									"$q",
									"$rootScope",
									"i8nConstants",
									function(employeeServices, $q, $rootScope, i8nConstants) {
										var deferred = $q.defer();
										employeeServices.preserveData().then(function(resp) {
											$rootScope.initialLoading = false;
											$rootScope.empName = resp.empName;
											$rootScope.levelFlag = resp.levelFlag;
											$rootScope.reportsURL = resp.reportsURL;
											$rootScope.title = i8nConstants.EDIT_EMPLOYEE_TITLE;
											deferred.resolve(resp);
										}, function(resp) {
											deferred.reject(resp);
										});
										return deferred.promise;
									} ]
						}
					}).when("/assignProxy",
					{
						templateUrl : "js/views/assign_proxy.html",
						controller : 'assignProxyCtrl',
						resolve : {
							data : [
									"employeeServices",
									"$q",
									"$rootScope",
									"i8nConstants",
									function(employeeServices, $q, $rootScope, i8nConstants) {
										var deferred = $q.defer();
										employeeServices.preserveData($rootScope).then(function(resp) {
											$rootScope.initialLoading = false;
											$rootScope.empName = resp.empName;
											$rootScope.levelFlag = resp.levelFlag;
											$rootScope.reportsURL = resp.reportsURL;
											$rootScope.startdate = undefined;
											$rootScope.enddate = undefined;
											$rootScope.title = i8nConstants.ASSIGN_PROXY_TITLE;
											deferred.resolve(resp);
										}, function(resp) {
											deferred.reject(resp);
										});
										return deferred.promise;
									} ]
						}
					}).when("/addHoliday",
					{
						templateUrl : "js/views/addHoliday.html",
						controller : "addHolidayCtrl",
						resolve : {
							data : [
									"employeeServices",
									"$q",
									"$rootScope",
									"i8nConstants",
									function(employeeServices, $q, $rootScope, i8nConstants) {
										var deferred = $q.defer();
										employeeServices.preserveData().then(function(resp) {
											$rootScope.initialLoading = false;
											$rootScope.empName = resp.empName;
											$rootScope.levelFlag = resp.levelFlag;
											$rootScope.reportsURL = resp.reportsURL;
											$rootScope.startdate = undefined;
											$rootScope.enddate = undefined;
											$rootScope.title = i8nConstants.ADD_HOLIDAY_TITLE;
											deferred.resolve(resp);
										}, function(resp) {
											deferred.reject(resp);
										});
										return deferred.promise;
									} ]
						}
					}).when("/events",
					{
						templateUrl : "js/views/events.html",
						controller : "eventCtrl",
						resolve : {
							data : [
									"employeeServices",
									"$q",
									"$rootScope",
									"i8nConstants",
									function(employeeServices, $q, $rootScope, i8nConstants) {
										var deferred = $q.defer();
										employeeServices.preserveData().then(function(resp) {
											$rootScope.initialLoading = false;
											$rootScope.empName = resp.empName;
											$rootScope.levelFlag = resp.levelFlag;
											$rootScope.reportsURL = resp.reportsURL;
											$rootScope.startdate = undefined;
											$rootScope.enddate = undefined;
											$rootScope.title = i8nConstants.EVENTS_TITLE;
											deferred.resolve(resp);
										}, function(resp) {
											deferred.reject(resp);
										});
										return deferred.promise;
									} ]
						}
					}).when("/department",
					{
						templateUrl : "js/views/department.html",
						controller : "preRequisitesCtrl",
						resolve : {
							data : [
									"employeeServices",
									"$q",
									"$rootScope",
									"i8nConstants",
									function(employeeServices, $q, $rootScope, i8nConstants) {
										var deferred = $q.defer();
										employeeServices.preserveData($rootScope).then(function(resp) {
											$rootScope.initialLoading = false;
											$rootScope.empName = resp.empName;
											$rootScope.levelFlag = resp.levelFlag;
											$rootScope.reportsURL = resp.reportsURL;
											$rootScope.title = i8nConstants.DEPARTMENT_TITLE;
											deferred.resolve(resp);
										}, function(resp) {
											deferred.reject(resp);
										});
										return deferred.promise;
									} ]
						}
					}).when("/team",
					{
						templateUrl : "js/views/team.html",
						controller : "preRequisitesCtrl",
						resolve : {
							data : [
									"employeeServices",
									"$q",
									"$rootScope",
									"i8nConstants",
									function(employeeServices, $q, $rootScope, i8nConstants) {
										var deferred = $q.defer();
										employeeServices.preserveData().then(function(resp) {
											$rootScope.initialLoading = false;
											$rootScope.empName = resp.empName;
											$rootScope.levelFlag = resp.levelFlag;
											$rootScope.reportsURL = resp.reportsURL;
											$rootScope.title = i8nConstants.TEAM_TITLE;
											deferred.resolve(resp);
										}, function(resp) {
											deferred.reject(resp);
										});
										return deferred.promise;
									} ]
						}
					}).when("/title",
					{
						templateUrl : "js/views/title.html",
						controller : "preRequisitesCtrl",
						resolve : {
							data : [
									"employeeServices",
									"$q",
									"$rootScope",
									"i8nConstants",
									function(employeeServices, $q, $rootScope, i8nConstants) {
										var deferred = $q.defer();
										employeeServices.preserveData().then(function(resp) {
											$rootScope.initialLoading = false;
											$rootScope.empName = resp.empName;
											$rootScope.levelFlag = resp.levelFlag;
											$rootScope.reportsURL = resp.reportsURL;
											$rootScope.title = i8nConstants.TITLE_ADD_TITLE;
											deferred.resolve(resp);
										}, function(resp) {
											deferred.reject(resp);
										});
										return deferred.promise;
									} ]
						}
					}).when("/location",
					{
						templateUrl : "js/views/locations.html",
						controller : "preRequisitesCtrl",
						resolve : {
							data : [
									"employeeServices",
									"$q",
									"$rootScope",
									"i8nConstants",
									function(employeeServices, $q, $rootScope, i8nConstants) {
										var deferred = $q.defer();
										employeeServices.preserveData().then(function(resp) {
											$rootScope.empName = resp.empName;
											$rootScope.initialLoading = false;
											$rootScope.levelFlag = resp.levelFlag;
											$rootScope.reportsURL = resp.reportsURL;
											$rootScope.title = i8nConstants.LOCATION_TITLE;
											deferred.resolve(resp);
										}, function(resp) {
											deferred.reject(resp);
										});
										return deferred.promise;
									} ]
						}
					}).otherwise({
				//redirectTo: '/applyleave'
				resolve : {
					data : [
							"employeeServices",
							"$q",
							"$rootScope",
							"$location",
							"i8nConstants",
							function(employeeServices, $q, $rootScope, $location, i8nConstants) {
								var deferred = $q.defer();
								employeeServices.preserveData().then(function(resp) {
									$rootScope.empName = resp.empName;
									$rootScope.levelFlag = resp.levelFlag;
									$rootScope.reportsURL = resp.reportsURL;
									if ($rootScope.levelFlag === "Admin") {
										$location.path("/dashboard");
									} else {
										$location.path("/applyleave");
									}
									$rootScope.title = i8nConstants.OTHERWISE_TITLE;
									deferred.resolve(resp);
								}, function(resp) {
									deferred.reject(resp);
								});
								return deferred.promise;
							} ]
				}
			});

			var initMsalProvider = function(microsoftAuthData, isEnabled){
				if(isEnabled) {
						msalProvider.init({
							clientID: microsoftAuthData.AzureADClientID,
							authority: microsoftAuthData.AzureLoginEndpoint + "/" + microsoftAuthData.AzureADTenantID,
							tokenReceivedCallback: function (errorDesc, token, error, tokenType) {
							},
							optionalParams: {
								cacheLocation: 'localStorage',
								storeAuthStateInCookie: true,
								redirectUri: window.location.origin + window.location.pathname,
								navigateToLoginRequestUrl: false
							}
						});
				}
				else {
					// We need to initialize a dummy provider otherwise Msal errors out.
					initDummyMsalProvider();
				}
			};

			var initDummyMsalProvider = function() {
				msalProvider.init({
					clientID: null,
					tokenReceivedCallback: null
				});
			}

			$locationProvider.html5Mode(false).hashPrefix('');

		} ]);
