<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<fmt:message key="Storage_Replication" var="pageTitle" />
<fmt:bundle basename="localization.StorageReplicationMessages">
	<fmt:message key="sr.name" var="srname" />
	<fmt:message key="sr.src.filer" var="srSrcFiler" />
	<fmt:message key="sr.dest.filer" var="srDestFiler" />
	<fmt:message key="sr.noData" var="noSrData" />
	<fmt:message key="sr.wfJobId" var="srWfJobId" />
	<fmt:message key="sr.job.status" var="srJobStatus" />
	<fmt:message key="sr.job.progress" var="srJobProgress" />
	<fmt:message key="sr.job.scheduledAt" var="srScheduledAt" />
	<fmt:message key="sr.run.job" var="srRunJob" />
	<fmt:message key="sr.na" var="srNa" />
	<fmt:message key="Job_Running" var="jobRunning"/>
	<fmt:message key="sr.delete" var="srDelete"/>
	<fmt:message key="sr.job.startTime" var="srStartTime"/>
	<fmt:message key="sr.job.endTime" var="srEndTime"/>
	<fmt:message key="sr.clone" var="srClone"/>
	<fmt:message key="sr.conf.Yes" var="srConfYes"/>
	<fmt:message key="sr.conf.No" var="srConfNo"/>
	<fmt:message key="sr.confirm.delete" var="srConfDelete"/>
	<fmt:message key="sr.confirm.delete.title" var="srConfDeleteTitle"/>
	<fmt:message key="sr.deleteOperationFailed" var="deleteOperationFailed"/>
	<fmt:message key="sr.schedule.deleteOperationFailed" var="deleteScheduleFailed"/>
	<fmt:message key="sr.delete.schedule.manually" var="deleteScheduleManually"/>
	<fmt:message key="sr.ok.text" var="srOkText"/>
	<fmt:message key="sr.deleteFailed" var="deleteFailed"/>

	<jsp:include page="../common/header.jsp">
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="../common/css/headerstyles.css" name="css" />
		<jsp:param value="../common/dynatree/ui.dynatree.css" name="css" />
		<jsp:param value="../summary/css/summarystyles.css" name="css" />
		<jsp:param value="../common/css/table.css" name="css" />
		<jsp:param value="../common/css/ui.spinner.css" name="css" />
		<jsp:param value="../common/css/jquery.loadmask.css" name="css" />
		<jsp:param value="../common/css/custom-cb.css" name="css" />
		<jsp:param value="true" name="includeJqueryUI" />
		<jsp:param value="true" name="includeTableSupport" />
		<jsp:param value="true" name="includeLatestDatatable" />
		<jsp:param value="../common/css/templatestyles.css" name="css" />
		<jsp:param value="${pageTitle}" name="titleLocalized" />
		<jsp:param value="${pageTitle}" name="headerTitleLocalized" />
		<jsp:param value="true" name="includeCustomSelect" />
		<jsp:param value="css/sr.css" name="css" />
	</jsp:include>

	<jsp:include page="../common/mask.jsp" />
	<jsp:include page="../jobs/JobManager.jsp" />
	<!-- <link rel="stylesheet" href="${pageContext.request.contextPath}/database/css/database.css" /> -->

	<div class="addNewRep">
		<a class="someLink" href="sr.do"><span class="sprite icon-plus" style="vertical-align:bottom;"></span> <fmt:message key="storage.replication.new" /></a>
	</div>

	<div id="srList" class="srList">
		<table id="srListTable" class="display tablesorter">

		</table>
	</div>
</fmt:bundle>

<script nonce="${sessionScope.cspNonce}" >
	var noSrData='${noSrData}';
	var srName='${srname}';
	var srSrcFiler='${srSrcFiler}';
	var srDestFiler ='${srDestFiler}';
	var srJobStatus ='${srJobStatus}';
	var srJobProgress ='${srJobProgress}';
	var srWfJobId = '${srWfJobId}';
	var srScheduledAt = '${srScheduledAt}';
	var srRunJob = '${srRunJob}';
	var jobRunning = '${jobRunning}';
	var srNa = '${srNa}';
	var srDelete = '${srDelete}';
	var srStartTime = '${srStartTime}';
	var srEndTime = '${srEndTime}';
	var srClone = '${srClone}';
	var srConfYes='${srConfYes}';
	var srConfNo='${srConfNo}';
	var srConfDelete='${srConfDelete}';
	var srConfDeleteTitle='${srConfDeleteTitle}';
	var deleteOperationFailed = '${deleteOperationFailed}';
	var deleteScheduleFailed = '${deleteScheduleFailed}';
	var deleteScheduleManually = '${deleteScheduleManually}';
	var srOkText = '${srOkText}';
	var deleteOperationFailed = '${deleteOperationFailed}';
	var deleteFailed = '${deleteFailed}';

</script>
<jsp:include page="../common/footer.jsp">
	<jsp:param value="js/storageReplicationList.js" name="js" />
</jsp:include>
