<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<fmt:message key="Storage_Replication" var="pageTitle" />
<fmt:bundle basename="localization.StorageReplicationMessages">
	<fmt:message key="sr.replications" var="replications" />
	<fmt:message key="sr.dupl.srName" var="srDuplSrName"/>
	<c:set var="breadCrumbValues"
		value="${replications}:./storagereplication" />

	<jsp:include page="../common/header.jsp">
		<jsp:param value="true" name="includeSecHeader" />
		<jsp:param value="../common/css/headerstyles.css" name="css" />
		<jsp:param value="../common/dynatree/ui.dynatree.css" name="css" />
		<jsp:param value="../common/css/ui.spinner.css" name="css" />
		<jsp:param value="../common/css/jquery.loadmask.css" name="css" />
		<jsp:param value="../common/css/custom-cb.css" name="css" />
		<jsp:param value="true" name="includeJqueryUI" />
		<jsp:param value="true" name="includeTableSupport" />

		<jsp:param value="../common/css/templatestyles.css" name="css" />
		<jsp:param value="${pageTitle}" name="titleLocalized" />
		<jsp:param value="${pageTitle}" name="headerTitleLocalized" />
		<jsp:param value="${breadCrumbValues}" name="breadCrumbValues" />
		<jsp:param value="true" name="includeCustomSelect" />
		<jsp:param value="css/sr.css" name="css" />
	</jsp:include>

	<div class="srcontainerDiv">

		<form method="post" id="storageReplForm" action="saveSr.do">

			<div class="header detailsHeader">
				<h2 class="mainHeader">
					<c:choose>
						<c:when test="${requestScope.SR_SAVE_ERROR_FLAG}">
							<em> <font color="#cc3333">${requestScope.SR_SAVE_ERROR}</font></em>
						</c:when>
					</c:choose>
				</h2>
			</div>
			<div id="srnamediv" class="srnameDiv">
			<table id="strrepNameDescTbl" class="srschDets">
				<tr>
					<td>
						<label for="Name"><fmt:message key="sr.name" /><em><font
							color="#cc3333">*</font></em> </label>
					</td>
					<td align="center">
						<input type="text" id="srName"
						name="srName" class="inputTextField inputFieldStyle"
						value="${requestScope.STR_REP.replicationName}" tabindex="1"/> <span
						id="nameFieldInfo" class="errorMsg noDisplay"><fmt:message
							key="sr.srname.field.is.mandatory" /></span>
						<span
						id="duplNameInfo" class="errorMsg noDisplay"><fmt:message
							key="sr.dupl.srName" /></span>

						<input type="hidden"
						id="srId" name="srId" class="inputTextField inputFieldStyle"
						value="${requestScope.STR_REP.srId}" />
						<input type="hidden"
						id="isCloned" name="isCloned" class="inputTextField inputFieldStyle"
						value="${requestScope.IS_CLONE}" />
					</td>
				</tr>
				<tr>
					<td >
						<label for="Description" class="textAreaLabel"><fmt:message key="sr.desc" /></label>
					</td>
					<td align="left">
						<textarea id="srDesc"
						name="srDesc" class="inputTextField inputTextAreaFieldStyle" tabindex="2">${requestScope.STR_REP.description}</textarea>
					</td>
				</tr>
			</table>
			</div>

			<div id="strrepdetails">
				<table id="strrepdetailsTbl" class="strrepdets">
					<tr>
						<th></th>
						<th class="srcTd"><fmt:message key="sr.source" /></th>
						<th class="dstTd"><fmt:message key="sr.destination" /></th>

					</tr>
					<!-- ARRAY DETAILS : path/usercreds -->
					<tr>
						<td><fmt:message key="sr.filer.loc" /><em><font
								color="#cc3333">*</font></em></td>
						<td class="srcTd"><input type="text" id="srcVolLocation"
							name="srcVolLocation" class="inputTextField inputFieldStyle"
							value="${requestScope.STR_REP.srcFiler.filerName}"
							placeholder="\\SourceFiler\Vol1" tabindex="3"/></td>
						<td class="dstTd"><input type="text" id="destVolLocation"
							name="destVolLocation" class="inputTextField inputFieldStyle"
							value="${requestScope.STR_REP.destFiler.filerName}"
							placeholder="\\DestFiler\Vol1" tabindex="7"/></td>
					</tr>
					<tr>
						<td></td>
						<td class="errTd srcTd"><span id="srcFilerFieldInfo"
							class="errorMsg noDisplay"><fmt:message
									key="sr.srcfiler.field.is.mandatory" /></span></td>
						<td class="errTd dstTd"><span id="destFilerFieldInfo"
							class="errorMsg noDisplay"><fmt:message
									key="sr.destfiler.field.is.mandatory" /></span> <span
							id="destFilerDuplicateFieldInfo" class="errorMsg noDisplay"></span>
						</td>
					</tr>
					<!-- <tr>
							<td></td>
							<td><span id="destFilerDuplicateFieldInfo" class="errorMsg noDisplay"></span></td>
						</tr> -->

					<tr>
						<!-- USERNAME-->
						<td><fmt:message key="sr.filer.username" /><em><font
								color="#cc3333">*</font></em></td>
						<td class="srcTd"><input type="text" id="srcVolUser"
							name="srcVolUser" class="inputTextField inputFieldStyle"
							value="${requestScope.STR_REP.srcFiler.arrayCredentials.userName}" tabindex="4" />
						</td>
						<td class="dstTd"><input type="text" id="destVolUser"
							name="destVolUser" class="inputTextField inputFieldStyle"
							value="${requestScope.STR_REP.destFiler.arrayCredentials.userName}" tabindex="8" />
						</td>
					</tr>
					<tr>
						<td></td>
						<td class="errTd srcTd"><span id="srcFilerUserNameFieldInfo"
							class="errorMsg noDisplay"><fmt:message
									key="sr.srcusername.field.is.mandatory" /></span></td>
						<td class="errTd dstTd"><span id="destFilerUserNameFieldInfo"
							class="errorMsg noDisplay"><fmt:message
									key="sr.destusername.field.is.mandatory" /></span></td>
					</tr>

					<tr>
						<!-- PASSWORD-->
						<td><fmt:message key="sr.filer.password" /><em><font
								color="#cc3333">*</font></em></td>
						<c:choose>
							<c:when test="${requestScope.STR_REP.srId > 0}">
								<td class="srcTd"><input type="password" id="srcVolPassword"
								name="srcVolPassword" class="inputTextField inputFieldStyle"
								value="*dummy*" tabindex="5" autocomplete="off" />
								</td>
								<td class="dstTd"><input type="password" id="destVolPassword"
									name="destVolPassword" class="inputTextField inputFieldStyle"
									value="*dummy*" tabindex="9" autocomplete="off" />
								</td>
							</c:when>
							<c:otherwise>
								<td class="srcTd"><input type="password" id="srcVolPassword"
								name="srcVolPassword" class="inputTextField inputFieldStyle"
								value="${requestScope.STR_REP.srcFiler.arrayCredentials.password}" tabindex="5"/>
								</td>
								<td class="dstTd"><input type="password" id="destVolPassword"
									name="destVolPassword" class="inputTextField inputFieldStyle"
									value="${requestScope.STR_REP.destFiler.arrayCredentials.password}" tabindex="9" autocomplete="off" />
								</td>
							</c:otherwise>
						</c:choose>
					</tr>
					<tr>
						<td></td>
						<td class="errTd srcTd"><span id="srcFilerPwdFieldInfo"
							class="errorMsg noDisplay"><fmt:message
									key="sr.srcpwd.field.is.mandatory" /></span></td>
						<td class="errTd dstTd"><span id="destFilerPwdFieldInfo"
							class="errorMsg noDisplay"><fmt:message
									key="sr.destpwd.field.is.mandatory" /></span></td>
					</tr>

					<tr>
						<!-- MEDIAAGENT -->
						<td><fmt:message key="sr.media.agent" /><em><font
								color="#cc3333">*</font></em> <!-- <span id="nameFieldInfo" class="errorMsg noDisplay"><fmt:message key="sr.this.field.is.mandatory" /></span>-->
						</td>
						<td class="srcTd"><select id="srcMa" name="srcMa"
							class="inputDDField inputFieldStyle" tabindex="6">
								<option id="-1" value="0"><fmt:message
										key="sr.please.select" /></option>
								<c:set var="chosenSrcMa"
									value="${requestScope.STR_REP.srcMediaAgent}" />
								<c:forEach items="${requestScope.MA_LIST}" var="srcMa">
									<c:choose>
										<c:when
											test="${chosenSrcMa.mediaAgentId == srcMa.mediaAgentId}">
											<option id="${srcMa.mediaAgentId}"
												value="${srcMa.mediaAgentId}" selected="selected">${srcMa.mediaAgentName}</option>
										</c:when>
										<c:otherwise>
											<option id="${srcMa.mediaAgentId}"
												value="${srcMa.mediaAgentId}">${srcMa.mediaAgentName}</option>
										</c:otherwise>
									</c:choose>
								</c:forEach>
						</select></td>
						<td class="dstTd"><select id="destMa" name="destMa"
							class="inputDDField inputFieldStyle" tabindex="10">
								<option id="-1" value="0"><fmt:message
										key="sr.please.select" /></option>
								<c:set var="chosenDestMa"
									value="${requestScope.STR_REP.destMediaAgent}" />
								<c:forEach items="${requestScope.MA_LIST}" var="destMa">
									<c:choose>
										<c:when
											test="${chosenDestMa.mediaAgentId == destMa.mediaAgentId}">
											<option id="${destMa.mediaAgentId}"
												value="${destMa.mediaAgentId}" selected="selected">${destMa.mediaAgentName}</option>
										</c:when>
										<c:otherwise>
											<option id="${destMa.mediaAgentId}"
												value="${destMa.mediaAgentId}">${destMa.mediaAgentName}</option>
										</c:otherwise>
									</c:choose>
								</c:forEach>
						</select></td>
					</tr>
					<tr>
						<td></td>
						<td class="errTd srcTd"><span id="srcMaFieldInfo"
							class="errorMsg noDisplay"><fmt:message
									key="sr.srcMa.field.is.mandatory" /></span></td>
						<td class="errTd dstTd"><span id="destMaFieldInfo"
							class="errorMsg noDisplay"><fmt:message
									key="sr.destMa.field.is.mandatory" /></span></td>

					</tr>
					<!-- Client List -->
				    	<tr>
					       <td>
								<fmt:message key="sr.client" /><em><font color="#cc3333">*</font></em>
                           </td>
                           <td class="srcTd">
							<select id="srcClient" name="srcClient" class="inputDDField inputFieldStyle">
								<option id="-1" value="0"><fmt:message key="sr.please.select" /></option>
								<c:set var="chosenSrcClient" value="${requestScope.STR_REP.srcClient}" />
								<c:forEach items="${requestScope.CLIENT_LIST}"	var="srcClient">
									<c:choose>
										<c:when test="${chosenSrcClient.clientId == srcClient.clientId}">
										<option id="${srcClient.clientId}" value="${srcClient.clientId}"
												selected="selected">${srcClient.clientName}</option>
										</c:when>
										<c:otherwise>
											<option id="${srcClient.clientId}" value="${srcClient.clientId}">${srcClient.clientName}</option>
										</c:otherwise>
									</c:choose>
								</c:forEach>
							</select>
                           </td>
                           <td class="dstTd">
							<select id="destClient" name="destClient" class="inputDDField inputFieldStyle">
								<option id="-1" value="0"><fmt:message key="sr.please.select" /></option>
								<c:set var="chosenDestClient" value="${requestScope.STR_REP.destClient}" />
								<c:forEach items="${requestScope.CLIENT_LIST}"	var="destClient">
									<c:choose>
										<c:when test="${chosenDestClient.clientId == destClient.clientId}">
											<option id="${destClient.clientId}" value="${destClient.clientId}"
												selected="selected">${destClient.clientName}</option>
										</c:when>
										<c:otherwise>
											<option id="${destClient.clientId}" value="${destClient.clientId}">${destClient.clientName}</option>
										</c:otherwise>
									</c:choose>
								</c:forEach>
							</select>
                           </td>
					    </tr>
					    <tr>
						<td></td>
						<td class="errTd srcTd"><span id="srcClientFieldInfo"
							class="errorMsg noDisplay"><fmt:message
									key="sr.srcClient.field.is.mandatory" /></span></td>
						<td class="errTd dstTd"><span id="destClientFieldInfo"
							class="errorMsg noDisplay"><fmt:message
									key="sr.destClient.field.is.mandatory" /></span></td>
					</tr> <!-- end of client-->

					     <tr>
					    	<td>
					    	<!--  </td>
					    	<td colspan=2 class="chaindesc">
					    	The source filer & source MediaAgent have been configured as the destination of other storage replications.<p>
					    	Do you wish to 'chain' along with the selected replication?<p>
							Chaining will skip backup for this replication, but use the parent replication's backup and destination storage policy copy.<p>
							This replication cannot be scheduled individually. It will be executed once the parent replication job completes.
					    	</td>-->
					    </tr>

				</table>
				<!-- Enable this if Parent Chain list is present or parent fork list is present -->

				<table id="chainForkSection" class="srschDets">
					<tr class="chainforkdesc" id="chaindesc">
						<td colspan="4">
						<p><fmt:message key="sr.chain.desc"/></p>
					    </td>
					</tr>
					<tr id="doChaining" class="srgap">
						<td><c:set var="chosenParentChainRep"
								value="${requestScope.STR_REP.chainedRep}" /> <c:choose>
								<c:when test="${chosenParentChainRep.id > 0}">
									<!-- there is some chain -->
									<input type="checkbox" name="chainForkRB" value="chain"
										checked="checked" tabindex="11">
								</c:when>
								<c:otherwise>
									<input type="checkbox" name="chainForkRB" value="chain">
								</c:otherwise>
							</c:choose>
							</td>
							<td>
								<fmt:message key="sr.chain.rep"/>
							</td>
						<td><select id="parentChainReps" name="parentChainReps"
							class="inputCFField inputFieldStyle" tabindex="12">
								<c:set var="chosenParentChainRep"
									value="${requestScope.STR_REP.chainedRep}" />
									<c:set var="srRep"
									value="${requestScope.STR_REP}" />
								<c:choose>

									<c:when test="${fn:length(requestScope.CHAIN_REP_LIST) gt 0}">
										<c:forEach items="${requestScope.CHAIN_REP_LIST}"
											var="parentChainRep">
											<c:choose>
												<c:when
													test="${chosenParentChainRep.id == parentChainRep.sre.srId}">
													<option id="${parentChainRep.sre.srId}"
														value="${parentChainRep.sre.srId}" selected="selected"
														data-sp='{"spId":"${parentChainRep.sre.storagePolicy.storagePolicyId}","spName":"${parentChainRep.sre.storagePolicy.storagePolicyName}"}'>${parentChainRep.sre.replicationName}</option>
												</c:when>
												<c:otherwise>
													<option id="${parentChainRep.sre.srId}"
														value="${parentChainRep.sre.srId}"
														data-sp='{"spId":"${parentChainRep.sre.storagePolicy.storagePolicyId}","spName":"${parentChainRep.sre.storagePolicy.storagePolicyName}"}'>${parentChainRep.sre.replicationName}</option>
												</c:otherwise>
											</c:choose>
										</c:forEach>
									</c:when>
									<c:otherwise>
										<option id="${chosenParentChainRep.id}"
											value="${chosenParentChainRep.id}" selected="selected"
											data-sp='{"spId":"${srRep.storagePolicy.storagePolicyId}","spName":"${srRep.storagePolicy.storagePolicyName}"}'>${chosenParentChainRep.name}</option>
									</c:otherwise>
								</c:choose>
						</select>
						</td>
						<td>
							<a id="chainHelp" class="sprite icon-info"></a>
						</td>
					</tr>
					<tr class="chainforkdesc" id="forkdesc">
						<td colspan="4">
						<p><fmt:message key="sr.fork.desc"/></p>
					    </td>
					</tr>
					<tr id="doForking" class="srgap">
						<td><c:set var="chosenParentForkedRep"
								value="${requestScope.STR_REP.forkedRep}" /> <c:choose>
								<c:when test="${chosenParentForkedRep.id > 0}">
									<!-- there is some chain -->
									<input type="checkbox" name="chainForkRB" value="fork"
										checked="checked" tabindex="11">
								</c:when>
								<c:otherwise>
									<input type="checkbox" name="chainForkRB" value="fork">
								</c:otherwise>
							</c:choose>
							</td>
							<td>
								<fmt:message key="sr.fork.rep" />
							</td>
						<td><select id="parentForkReps" name="parentForkReps"
							class="inputCFField inputFieldStyle" tabindex="12">
								<c:set var="chosenParentForkedRep"
									value="${requestScope.STR_REP.forkedRep}" />
								<c:set var="srRep"
									value="${requestScope.STR_REP}" />
								<c:choose>
									<c:when test="${fn:length(requestScope.FORK_REP_LIST) gt 0}">
										<c:forEach items="${requestScope.FORK_REP_LIST}"
											var="parentForkRep">
											<c:choose>
												<c:when
													test="${chosenParentForkedRep.id == parentForkRep.sre.srId}">
													<option id="${parentForkRep.sre.srId}"
														value="${parentForkRep.sre.srId}" selected="selected"
														data-sp='{"spId":"${parentForkRep.sre.storagePolicy.storagePolicyId}","spName":"${parentForkRep.sre.storagePolicy.storagePolicyName}"}'>${parentForkRep.sre.replicationName}</option>
												</c:when>
												<c:otherwise>
													<option id="${parentForkRep.sre.srId}"
														value="${parentForkRep.sre.srId}"
														data-sp='{"spId":"${parentForkRep.sre.storagePolicy.storagePolicyId}","spName":"${parentForkRep.sre.storagePolicy.storagePolicyName}"}'>${parentForkRep.sre.replicationName}</option>
												</c:otherwise>
											</c:choose>
										</c:forEach>
									</c:when>
									<c:otherwise>
										<option id="${chosenParentForkedRep.id}"
											value="${chosenParentForkedRep.id}" selected="selected"
											data-sp='{"spId":"${srRep.storagePolicy.storagePolicyId}","spName":"${srRep.storagePolicy.storagePolicyName}"}'>${chosenParentForkedRep.name}</option>
									</c:otherwise>
								</c:choose>
						</select>
						</td>
						<td>
							<a id="forkHelp" class="sprite icon-info"></a>
						</td>
					</tr>
				</table>
				<table id="srSPScheduleDetails" class="srschDets">
					<tr>
						<td><fmt:message key="sr.storage.policy" /><em><font
								color="#cc3333">*</font></em> <!-- <span id="nameFieldInfo" class="errorMsg noDisplay"><fmt:message key="sr.this.field.is.mandatory" /></span>-->
						</td>
						<td><select id="storagePolicy" name="storagePolicy"
							class="inputDDField inputFieldStyle" tabindex="13">
								<c:set var="chosenParentChainRep"
									value="${requestScope.STR_REP.chainedRep}" />
								<c:set var="chosenParentForkedRep"
									value="${requestScope.STR_REP.forkedRep}" />
								<c:set var="chosenSP"
									value="${requestScope.STR_REP.storagePolicy}" />
								<c:choose>
									<c:when
										test="${chosenParentChainRep.id > 0 || chosenParentForkedRep.id > 0}">
										<option id="${chosenSP.storagePolicyId}"
											value="${chosenSP.storagePolicyId}" selected="selected"
											readOnly="readOnly">${chosenSP.storagePolicyName}</option>
									</c:when>
									<c:otherwise>
										<option id="-1" value="0"><fmt:message
												key="sr.please.select" /></option>
										<c:set var="chosenSP"
											value="${requestScope.STR_REP.storagePolicy}" />
										<c:choose>
											<c:when test="${fn:length(requestScope.SP_LIST) gt 0}">
												<c:forEach items="${requestScope.SP_LIST}" var="sp">
														chosenSP.storagePolicyId= ${chosenSP.storagePolicyId}
														sp.storagePolicyId= ${sp.storagePolicyId}
														<c:choose>
														<c:when
															test="${chosenSP.storagePolicyId == sp.storagePolicyId}">
															<option id="${sp.storagePolicyId}"
																value="${sp.storagePolicyId}" selected="selected">${sp.storagePolicyName}</option>
														</c:when>
														<c:otherwise>
															<option id="${sp.storagePolicyId}"
																value="${sp.storagePolicyId}">${sp.storagePolicyName}</option>
														</c:otherwise>
													</c:choose>
												</c:forEach>
											</c:when>
											<c:otherwise>
												<option id="${chosenSP.storagePolicyId}"
													value="${chosenSP.storagePolicyId}" selected="selected">${chosenSP.storagePolicyName}</option>
											</c:otherwise>
										</c:choose>
									</c:otherwise>
								</c:choose>
						</select></td>

						<td><span id="spFieldInfo" class="errorMsg noDisplay"><fmt:message
									key="sr.sp.field.is.mandatory" /></span> <span id="NoSpConfInfo"
							class="errorMsg noDisplay"><fmt:message
									key="sr.no.sp.conf" /></span></td>

					</tr>
					<tr class="has-checkbox">
						<td><fmt:message key="sr.restore.from.primary.copy" /><em><font
								color="#cc3333"></font></em>
						</td>
						<td align="left"><input type="checkbox" id="restoreFromPrimary" name="restoreFromPrimary" value="primary">
				        </td>
				        <td><span id="spPrimaryCopyFieldInfo1" class="errorMsg noDisplay"><fmt:message
							      key="sr.restore.primary.has.copy" /></span><span id="spPrimaryCopyFieldInfo2" class="errorMsg noDisplay"><fmt:message
							      key="sr.restore.primary.no.copy" /></span></td>
					</tr>
					<tr>
						<td><fmt:message key="sr.storage.policy.copy.name" /><em><font
								color="#cc3333">*</font></em> <!-- <span id="nameFieldInfo" class="errorMsg noDisplay"><fmt:message key="sr.this.field.is.mandatory" /></span> -->
						</td>
						<td><select id="storagePolicyCopy" name="storagePolicyCopy"
							class="inputDDField inputFieldStyle" tabindex="14">
								<option id="-1" value="0"><fmt:message
										key="sr.please.select" /></option>
								<c:set var="chosenSPCopy"
									value="${requestScope.STR_REP.storagePolicyCopy}" />
								<c:choose>
									<c:when test="${fn:length(requestScope.SP_COPY_LIST) gt 0}">
										<c:forEach items="${requestScope.SP_COPY_LIST}" var="spCopy">
											<c:choose>
												<c:when test="${chosenSPCopy.copyId == spCopy.copyId}">
													<option id="${spCopy.copyId}" value="${spCopy.copyId}"
														selected="selected">${spCopy.copyName}</option>
												</c:when>
												<c:otherwise>
													<option id="${spCopy.copyId}" value="${spCopy.copyId}">${spCopy.copyName}</option>
												</c:otherwise>
											</c:choose>
										</c:forEach>
									</c:when>
									<c:otherwise>
										<option id="${chosenSPCopy.copyId}"
											value="${chosenSPCopy.copyId}" selected="selected">${chosenSPCopy.copyName}</option>
									</c:otherwise>
								</c:choose>

						</select></td>
						<td><span id="spCopyFieldInfo" class="errorMsg noDisplay"><fmt:message
									key="sr.spcopy.field.is.mandatory" /></span></td>
					</tr>
					<tr>
						<td><fmt:message key="sr.schedule" /><em><font
								color="#cc3333">*</font></em></td>
						<td><select id="schTimeStr" name="schTimeStr"
							class="inputDDField inputFieldStyle" tabindex="16">
								<option id="schTimeStr0" value="0"><fmt:message
										key="sr.schAt.please.select" /></option>
								<c:set var="chosenSchTime"
									value="${requestScope.STR_REP.replicationScheduledAt}" />
								<c:forEach items="${requestScope.SCHEDULE_LIST}" var="sch">
									<c:choose>
										<c:when test="${chosenSchTime == sch}">
											<option id="${sch}" value="${sch}" selected="selected">${sch}</option>
										</c:when>
										<c:otherwise>
											<option id="${sch}" value="${sch}">${sch}</option>
										</c:otherwise>
									</c:choose>
								</c:forEach>
						</select></td>
						<td><span id="schFieldInfo" class="errorMsg noDisplay"><fmt:message
									key="sr.sch.field.is.mandatory" /></span></td>
					</tr>
					<tr>
					   <td><fmt:message key="sr.force.sync" /><em><font
							color="#cc3333"></font></em> </td>
					   <td><input type="checkbox" id="forceSync" name="forceSync" value="true" class="inputFieldStyle"
						<c:if test="${requestScope.STR_REP.forceSync == '1'}">checked="checked"</c:if>   	                                                             style="margin-bottom:0px; height: 16px;"></td>
			                </tr>
				</table>

			</div>
			<div class="buttonsDiv">
				<ul>
					<li class="inputtext">
						<div id="wfJobRunning">
							<c:choose>
								<c:when test="${requestScope.SR_WF_JOB_RUNNING}">
									<em> <font color="#cc3333"><fmt:message
												key="sr.wf.job.running" />${requestScope.STR_REP.wfJobId}</font></em>
								</c:when>
							</c:choose>
						</div>
						<div id="formButtonsDiv" class="buttonsDiv">
							<button type="reset" name="cancelBtn" class="grayBtn"
								onclick="document.location='index.jsp'">
								<fmt:message key="sr.cancel.button.text" />
							</button>
							<button type="submit" name="submitBtn" class="dcBlueBtn"
								id="submitBtn" value="SubBtn">
								<fmt:message key="sr.apply.button.text" />
							</button>
							<c:choose>
								<c:when test="${requestScope.SR_WF_JOB_RUNNING == false}">
									<button type="submit" name="submitAndRunBtn"
										class="dcBlueBtnWide" id="submitAndRunBtn"
										value="SubAndRunBtn">
										<fmt:message key="sr.apply.and.run.button.text" />
									</button>
								</c:when>
								<c:otherwise>
									<button type="button" name="submitAndRunBtn" class="grayBtn"
										id="submitAndRunBtn" value="SubAndRunBtn" disabled="disabled">
										<fmt:message key="sr.apply.and.run.button.text" />
									</button>
								</c:otherwise>
							</c:choose>
						</div>
					</li>
				</ul>
			</div>
		</form>
		<div class="clrFloat"></div>
	</div>

</fmt:bundle>
<script nonce="${sessionScope.cspNonce}" >
	var srDuplSrName='${srDuplSrName}';
</script>
<jsp:include page="../common/footer.jsp">
	<jsp:param value="js/sr.js" name="js" />
</jsp:include>
