<jsp:include page="../common/header.jsp">
	<jsp:param value="Storage_Details" name="title" />
	<jsp:param value="../common/css/headerstyles.css" name="css" />
	<jsp:param value="../common/css/jquery.loadmask.css" name="css"/>
	<jsp:param value="css/applicationstyles.css" name="css" />	
	<jsp:param value="../common/css/table.css" name="css" />	
	<jsp:param value="../common/smartwizard/css/smart_wizard_vertical.css" name="css" />
	<jsp:param value="../common/css/custom-cb.css" name="css"/>
	<jsp:param value="../common/css/ui.spinner.css" name="css"/>
	<jsp:param value="css/storageprov.css" name="css" />	
	<jsp:param value="true" name="includeSecHeader" />
	<jsp:param value="Storage_Details" name="headerTitle" />
	<jsp:param value="true" name="includeTableSupport" />
	<jsp:param value="true" name="includeCustomSelect"/>
	<jsp:param value="true" name="includeHistory"/>
	<jsp:param value="My Storage:storageprovisioning/index.jsp" name="breadCrumbValues" />
</jsp:include>

<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>

<fmt:bundle basename="localization.StorageProvisioningMessages">
	<div id=storageDetails style="width:100%;" class="container">
		<div id="storDetails">
			<div id="toolbarStorageDetails">
				<ul id="storagelistactions" class="storageactions">					
	                <li id="DELETE_ACTION_LUNDETS_PAGE" class="sprovaction dummyicon" title="<fmt:message key="storageDetails.actions.delete" />"><span class="sprite icon-delete"></span></li>
	                <li id="RENEW_ACTION_LUNDETS_PAGE" class="sprovaction dummyicon" title="<fmt:message key="storageDetails.actions.renew" />"><span class="sprite icon-renew"></span></li>
	                <li id="MAP_ACTION_LUNDETS_PAGE" class="sprovaction dummyicon" title="<fmt:message key="storageDetails.actions.mount" />"><span class="sprite storageprovisioning-sprovmount"></span></li>
	                <li id="UNMAP_ACTION_LUNDETS_PAGE" class="sprovaction dummyicon" title="<fmt:message key="storageDetails.actions.unmount" />"><span class="sprite storageprovisioning-sprovunmount"></span></li>			                
	                <li id="EDIT_ACTION_LUNDETS_PAGE" class="sprovaction dummyicon" title="<fmt:message key="storageDetails.actions.editLun" />"><span class="sprite icon-edit"></span></li>
	                <li id="REASSIGN_ACTION_LUNDETS_PAGE" class="sprovaction dummyicon" title="<fmt:message key="storageDetails.actions.reassign" />"><span class="sprite icon-share"></span></li>		                
        		</ul>
			</div>
			<br/>						
			<br/>						
			<span style="font-weight:bold">General</span>						
			<hr size="1">	
			<ul class="blockrows">		
				<li class="infotype"><fmt:message key="storageDetails.label.name" /></li>
				<li class="infodesc">${storageDetails.lunList[0].lunName}</li>		
				
				<li class="infotype"><fmt:message key="storageDetails.label.volume" /></li>
				<li class="infodesc">${storageDetails.lunList[0].reserve.reserveString}</li>
				
				<li class="infotype"><fmt:message key="storageDetails.label.array" /></li>
				<li class="infodesc">${storageDetails.lunList[0].reserve.reserveString2}</li>
		
				<li class="infotype"><fmt:message key="storageDetails.label.usedSpace" /></li>
				<li id="usedSpace" class="infodesc"></li>
				
				<li class="infotype"><fmt:message key="storageDetails.label.freeSpace" /></li>
				<li id="freeSpace" class="infodesc"></li>		
				
				<li class="infotype"><fmt:message key="storageDetails.label.path" /></li>
				<li class="infodesc">${storageDetails.lunList[0].lunPath}</li>		
				
				<li class="infotype"><fmt:message key="storageDetails.label.ostype" /></li>
				<li class="infodesc">${storageDetails.lunList[0].osTypeName}</li>	
			</ul>
		</div>
		<div id="storMapInfo">
			<br>
			<span style="font-weight:bold">Storage Map Information</span>
			<hr size="1">
			<table id="storageMountInfo" class="clearFloat tablesorter">
				<thead>
					<tr>
						<th style="font-weight: bold">Host</th>
						<th style="font-weight: bold">End Point</th>
						<th style="font-weight: bold">Protocol</th>
					</tr>
				</thead>
				<tbody>
					<c:forEach items="${storageDetails.endPointList}" var="row">
						<tr>
							<td>${row.client.clientName}</td>
							<td>${row.address}</td>
							<c:if test="${row.addressType == 3}">
								<td>ISCSI</td>
							</c:if>							
							<c:if test="${row.addressType == 4}">
								<td>FC</td>
							</c:if>
						</tr>
					</c:forEach>
				</tbody>
			</table>
		</div>	
		<br>
	</div>
	
	<script type="text/javascript" nonce="${sessionScope.cspNonce}" >
		$(document).ready(function() {
			var freeSpace = ${storageDetails.lunList[0].totalSpace} - ${storageDetails.lunList[0].usedSpace};
			freeSpace = freeSpace/(1024*1024*1024);
			var usedSpace = ${storageDetails.lunList[0].usedSpace};
			usedSpace = usedSpace/(1024*1024*1024);
			
			$("#usedSpace").text(Math.round(usedSpace) + " GB");
			$("#freeSpace").text(Math.round(freeSpace) + " GB");
		});
	</script>	
</fmt:bundle>

<jsp:include page="../common/footer.jsp">
	<jsp:param value="../reports/js/tablebase.js" name="js" />
	<jsp:param value="js/sprovBase.js" name="js" />
	<jsp:param value="../common/smartwizard/js/jquery.smartWizard.js" name="js" />
	<jsp:param value="../common/js/ui.spinner.min.js" name="js"/>
	<jsp:param value="../common/js/jquery.loadmask.min.js" name="js"/> 
	<jsp:param value="../common/js/custom-cb.js" name="js"/>
	<jsp:param value="../common/js/encoder.js" name="js" />
</jsp:include>		